/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.items;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ToolItem;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import vectorwing.farmersdelight.registry.ModBlocks;
import vectorwing.farmersdelight.utils.MathUtils;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class KnifeItem
extends ToolItem {
    private static final Set<Block> EFFECTIVE_ON = Sets.newHashSet((Object[])new Block[]{Blocks.field_150407_cf, (Block)ModBlocks.RICE_BALE.get()});

    public KnifeItem(IItemTier tier, float attackDamageIn, float attackSpeedIn, Item.Properties builder) {
        super(attackDamageIn, attackSpeedIn, tier, EFFECTIVE_ON, builder);
    }

    public float func_150893_a(ItemStack stack, BlockState state) {
        Material material = state.func_185904_a();
        if (EFFECTIVE_ON.contains(state.func_177230_c())) {
            return this.field_77864_a;
        }
        return material != Material.field_151580_n && material != Material.field_151593_r && material != Material.field_151568_F && material != Material.field_151569_G && material != Material.field_151584_j ? super.func_150893_a(stack, state) : this.field_77864_a;
    }

    public boolean func_195938_a(BlockState state, World worldIn, BlockPos pos, PlayerEntity player) {
        return !player.func_184812_l_();
    }

    public boolean func_77644_a(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        stack.func_222118_a(1, attacker, user -> user.func_213361_c(EquipmentSlotType.MAINHAND));
        return true;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        HashSet ALLOWED_ENCHANTMENTS = Sets.newHashSet((Object[])new Enchantment[]{Enchantments.field_185302_k, Enchantments.field_185303_l, Enchantments.field_180312_n, Enchantments.field_180313_o, Enchantments.field_77334_n, Enchantments.field_185304_p});
        if (ALLOWED_ENCHANTMENTS.contains(enchantment)) {
            return true;
        }
        HashSet DENIED_ENCHANTMENTS = Sets.newHashSet((Object[])new Enchantment[]{Enchantments.field_185308_t});
        if (DENIED_ENCHANTMENTS.contains(enchantment)) {
            return false;
        }
        return enchantment.field_77351_y.func_77557_a(stack.func_77973_b());
    }

    @Nonnull
    public ItemStack getContainerItem(@Nonnull ItemStack stack) {
        ItemStack container = stack.func_77946_l();
        if (container.func_96631_a(1, MathUtils.RAND, null)) {
            return ItemStack.field_190927_a;
        }
        return container;
    }

    public boolean hasContainerItem(@Nonnull ItemStack stack) {
        return true;
    }

    public boolean isRepairable(@Nonnull ItemStack stack) {
        return false;
    }

    public boolean isCustomRepairable(@Nonnull ItemStack stack) {
        return super.isRepairable(stack);
    }
}

