/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.tile;

import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.ChestContainer;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.tileentity.LockableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import vectorwing.farmersdelight.blocks.PantryBlock;
import vectorwing.farmersdelight.registry.ModTileEntityTypes;
import vectorwing.farmersdelight.utils.TextUtils;

public class PantryTileEntity
extends LockableLootTileEntity {
    private NonNullList<ItemStack> pantryContents = NonNullList.func_191197_a((int)27, (Object)ItemStack.field_190927_a);
    private int numPlayersUsing;

    private PantryTileEntity(TileEntityType<?> type) {
        super(type);
    }

    public PantryTileEntity() {
        this((TileEntityType)ModTileEntityTypes.PANTRY_TILE.get());
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        if (!this.func_184282_c(compound)) {
            ItemStackHelper.func_191282_a((CompoundNBT)compound, this.pantryContents);
        }
        return compound;
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.pantryContents = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        if (!this.func_184283_b(compound)) {
            ItemStackHelper.func_191283_b((CompoundNBT)compound, this.pantryContents);
        }
    }

    public int func_70302_i_() {
        return 27;
    }

    protected NonNullList<ItemStack> func_190576_q() {
        return this.pantryContents;
    }

    protected void func_199721_a(NonNullList<ItemStack> itemsIn) {
        this.pantryContents = itemsIn;
    }

    protected ITextComponent func_213907_g() {
        return TextUtils.getTranslation("container.pantry", new Object[0]);
    }

    protected Container func_213906_a(int id, PlayerInventory player) {
        return ChestContainer.func_216992_a((int)id, (PlayerInventory)player, (IInventory)this);
    }

    public void func_174889_b(PlayerEntity player) {
        if (!player.func_175149_v()) {
            if (this.numPlayersUsing < 0) {
                this.numPlayersUsing = 0;
            }
            ++this.numPlayersUsing;
            BlockState blockstate = this.func_195044_w();
            boolean flag = (Boolean)blockstate.func_177229_b((Property)PantryBlock.OPEN);
            if (!flag) {
                this.playSound(blockstate, SoundEvents.field_219602_O);
                this.setOpenProperty(blockstate, true);
            }
            this.scheduleTick();
        }
    }

    private void scheduleTick() {
        this.field_145850_b.func_205220_G_().func_205360_a(this.func_174877_v(), (Object)this.func_195044_w().func_177230_c(), 5);
    }

    public void pantryTick() {
        int i = this.field_174879_c.func_177958_n();
        int j = this.field_174879_c.func_177956_o();
        int k = this.field_174879_c.func_177952_p();
        this.numPlayersUsing = ChestTileEntity.func_213976_a((World)this.field_145850_b, (LockableTileEntity)this, (int)i, (int)j, (int)k);
        if (this.numPlayersUsing > 0) {
            this.scheduleTick();
        } else {
            BlockState blockstate = this.func_195044_w();
            if (!(blockstate.func_177230_c() instanceof PantryBlock)) {
                this.func_145843_s();
                return;
            }
            boolean flag = (Boolean)blockstate.func_177229_b((Property)PantryBlock.OPEN);
            if (flag) {
                this.playSound(blockstate, SoundEvents.field_219601_N);
                this.setOpenProperty(blockstate, false);
            }
        }
    }

    public void func_174886_c(PlayerEntity player) {
        if (!player.func_175149_v()) {
            --this.numPlayersUsing;
        }
    }

    private void setOpenProperty(BlockState state, boolean open) {
        this.field_145850_b.func_180501_a(this.func_174877_v(), (BlockState)state.func_206870_a((Property)PantryBlock.OPEN, (Comparable)Boolean.valueOf(open)), 3);
    }

    private void playSound(BlockState state, SoundEvent sound) {
        Vector3i vec3i = ((Direction)state.func_177229_b((Property)PantryBlock.FACING)).func_176730_m();
        double d0 = (double)this.field_174879_c.func_177958_n() + 0.5 + (double)vec3i.func_177958_n() / 2.0;
        double d1 = (double)this.field_174879_c.func_177956_o() + 0.5 + (double)vec3i.func_177956_o() / 2.0;
        double d2 = (double)this.field_174879_c.func_177952_p() + 0.5 + (double)vec3i.func_177952_p() / 2.0;
        this.field_145850_b.func_184148_a((PlayerEntity)null, d0, d1, d2, sound, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
    }
}

