/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.buzzier_bees.common.blocks;

import com.minecraftabnormals.buzzier_bees.core.registry.BBItems;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class HoneyPotBlock
extends Block {
    public static final IntegerProperty HONEY_LEVEL = IntegerProperty.func_177719_a((String)"honey_level", (int)0, (int)4);
    private static final VoxelShape[] SHAPES = (VoxelShape[])Util.func_200696_a((Object)new VoxelShape[5], levels -> {
        for (int i = 0; i < 5; ++i) {
            int level = i >= 1 ? i + 1 : i;
            levels[i] = VoxelShapes.func_197878_a((VoxelShape)VoxelShapes.func_197868_b(), (VoxelShape)Block.func_208617_a((double)3.0, (double)Math.max(2, level * 3), (double)3.0, (double)13.0, (double)16.0, (double)13.0), (IBooleanFunction)IBooleanFunction.field_223234_e_);
        }
    });

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        ItemStack itemstack = player.func_184586_b(handIn);
        Item item = itemstack.func_77973_b();
        int honeyLevel = (Integer)state.func_177229_b((Property)HONEY_LEVEL);
        if (item == Items.field_151069_bo && honeyLevel > 0) {
            this.decreaseHoney(Items.field_226638_pX_, honeyLevel, itemstack, state, worldIn, pos, player, handIn, SoundEvents.field_187615_H);
        } else if (item == Items.field_151025_P && honeyLevel > 0) {
            this.decreaseHoney((Item)BBItems.HONEY_BREAD.get(), honeyLevel, itemstack, state, worldIn, pos, player, handIn, SoundEvents.field_226138_eS_);
        } else if (item == Items.field_151034_e && honeyLevel > 0) {
            this.decreaseHoney((Item)BBItems.HONEY_APPLE.get(), honeyLevel, itemstack, state, worldIn, pos, player, handIn, SoundEvents.field_226138_eS_);
        } else if (item == Items.field_151157_am && honeyLevel > 0) {
            this.decreaseHoney((Item)BBItems.GLAZED_PORKCHOP.get(), honeyLevel, itemstack, state, worldIn, pos, player, handIn, SoundEvents.field_226138_eS_);
        } else if (item == Items.field_226638_pX_ && honeyLevel < 4) {
            this.increaseHoney(Items.field_151069_bo, honeyLevel, itemstack, state, worldIn, pos, player, handIn, SoundEvents.field_191241_J);
        } else {
            if (item == BBItems.HONEY_WAND.get() && honeyLevel > 0) {
                worldIn.func_175656_a(pos, (BlockState)state.func_206870_a((Property)HONEY_LEVEL, (Comparable)Integer.valueOf(honeyLevel - 1)));
                worldIn.func_184148_a(player, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_226135_eP_, SoundCategory.NEUTRAL, 1.0f, 1.0f);
                if (!player.field_71075_bZ.field_75098_d) {
                    player.func_184611_a(handIn, new ItemStack((IItemProvider)BBItems.STICKY_HONEY_WAND.get()));
                }
                return ActionResultType.SUCCESS;
            }
            if (item == BBItems.STICKY_HONEY_WAND.get() && honeyLevel < 4) {
                worldIn.func_175656_a(pos, (BlockState)state.func_206870_a((Property)HONEY_LEVEL, (Comparable)Integer.valueOf(honeyLevel + 1)));
                worldIn.func_184148_a(player, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_226135_eP_, SoundCategory.NEUTRAL, 1.0f, 1.0f);
                if (!player.field_71075_bZ.field_75098_d) {
                    player.func_184611_a(handIn, new ItemStack((IItemProvider)BBItems.HONEY_WAND.get()));
                }
                return ActionResultType.SUCCESS;
            }
            if (item == Items.field_226635_pU_ && honeyLevel < 4) {
                worldIn.func_175656_a(pos, (BlockState)state.func_206870_a((Property)HONEY_LEVEL, (Comparable)Integer.valueOf(honeyLevel + 1)));
                worldIn.func_184148_a(player, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_226138_eS_, SoundCategory.NEUTRAL, 1.0f, 1.0f);
                itemstack.func_190918_g(1);
                return ActionResultType.SUCCESS;
            }
            if (item == Items.field_226639_pY_ && honeyLevel == 0) {
                worldIn.func_175656_a(pos, (BlockState)state.func_206870_a((Property)HONEY_LEVEL, (Comparable)Integer.valueOf(4)));
                worldIn.func_184148_a(player, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_226138_eS_, SoundCategory.NEUTRAL, 1.0f, 1.0f);
                if (!player.field_71075_bZ.field_75098_d) {
                    itemstack.func_190918_g(1);
                }
                return ActionResultType.SUCCESS;
            }
            if (honeyLevel == 4) {
                worldIn.func_175656_a(pos, (BlockState)state.func_206870_a((Property)HONEY_LEVEL, (Comparable)Integer.valueOf(0)));
                worldIn.func_184148_a(player, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_226138_eS_, SoundCategory.NEUTRAL, 1.0f, 1.0f);
                if (!player.field_71075_bZ.field_75098_d) {
                    if (itemstack.func_190926_b()) {
                        player.func_184611_a(handIn, new ItemStack((IItemProvider)Items.field_226639_pY_));
                    } else if (!player.field_71071_by.func_70441_a(new ItemStack((IItemProvider)Items.field_226639_pY_))) {
                        player.func_71019_a(new ItemStack((IItemProvider)Items.field_226639_pY_), false);
                    }
                }
                return ActionResultType.SUCCESS;
            }
        }
        return ActionResultType.FAIL;
    }

    public ActionResultType decreaseHoney(Item output, int honeyLevel, ItemStack itemstack, BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, SoundEvent soundEvent) {
        worldIn.func_175656_a(pos, (BlockState)state.func_206870_a((Property)HONEY_LEVEL, (Comparable)Integer.valueOf(honeyLevel - 1)));
        worldIn.func_184148_a(player, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), soundEvent, SoundCategory.NEUTRAL, 1.0f, 1.0f);
        if (!player.field_71075_bZ.field_75098_d) {
            itemstack.func_190918_g(1);
            if (itemstack.func_190926_b()) {
                player.func_184611_a(handIn, new ItemStack((IItemProvider)output));
            } else if (!player.field_71071_by.func_70441_a(new ItemStack((IItemProvider)output))) {
                player.func_71019_a(new ItemStack((IItemProvider)output), false);
            }
        }
        return ActionResultType.SUCCESS;
    }

    public ActionResultType increaseHoney(Item output, int honeyLevel, ItemStack itemstack, BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, SoundEvent soundEvent) {
        worldIn.func_175656_a(pos, (BlockState)state.func_206870_a((Property)HONEY_LEVEL, (Comparable)Integer.valueOf(honeyLevel + 1)));
        worldIn.func_184148_a(player, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), soundEvent, SoundCategory.NEUTRAL, 1.0f, 1.0f);
        if (!player.field_71075_bZ.field_75098_d) {
            itemstack.func_190918_g(1);
            if (itemstack.func_190926_b()) {
                player.func_184611_a(handIn, new ItemStack((IItemProvider)output));
            } else if (!player.field_71071_by.func_70441_a(new ItemStack((IItemProvider)output))) {
                player.func_71019_a(new ItemStack((IItemProvider)output), false);
            }
        }
        return ActionResultType.SUCCESS;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{HONEY_LEVEL});
    }

    public HoneyPotBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((Property)HONEY_LEVEL, (Comparable)Integer.valueOf(0)));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPES[(Integer)state.func_177229_b((Property)HONEY_LEVEL)];
    }

    public VoxelShape func_199600_g(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return VoxelShapes.func_197868_b();
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPES[(Integer)state.func_177229_b((Property)HONEY_LEVEL)];
    }
}

