/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.block;

import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import slimeknights.mantle.item.RetexturedBlockItem;
import slimeknights.mantle.tileentity.IRetexturedTileEntity;
import slimeknights.mantle.util.TileEntityHelper;

public abstract class RetexturedBlock
extends Block {
    public RetexturedBlock(AbstractBlock.Properties properties) {
        super(properties);
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public abstract TileEntity createTileEntity(BlockState var1, IBlockReader var2);

    public void func_180633_a(World world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.func_180633_a(world, pos, state, placer, stack);
        RetexturedBlock.updateTextureBlock(world, pos, stack);
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        return RetexturedBlock.getPickBlock(world, pos, state);
    }

    public static void updateTextureBlock(World world, BlockPos pos, ItemStack stack) {
        IRetexturedTileEntity te;
        if (stack.func_77942_o() && (te = TileEntityHelper.getTileEntity(IRetexturedTileEntity.class, (IBlockReader)world, pos)) != null) {
            te.updateTexture(RetexturedBlockItem.getTextureName(stack));
        }
    }

    public static ItemStack getPickBlock(IBlockReader world, BlockPos pos, BlockState state) {
        Block block = state.func_177230_c();
        ItemStack stack = new ItemStack((IItemProvider)block);
        IRetexturedTileEntity te = TileEntityHelper.getTileEntity(IRetexturedTileEntity.class, world, pos);
        if (te != null) {
            RetexturedBlockItem.setTexture(stack, te.getTextureName());
        }
        return stack;
    }
}

