/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.model.connected;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.BlockFaceUV;
import net.minecraft.client.renderer.model.BlockPart;
import net.minecraft.client.renderer.model.BlockPartFace;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.IResourceManager;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.TransformationMatrix;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.client.model.geometry.IModelGeometry;
import slimeknights.mantle.block.IMultipartConnectedBlock;
import slimeknights.mantle.client.model.connected.ConnectedModelRegistry;
import slimeknights.mantle.client.model.data.SinglePropertyData;
import slimeknights.mantle.client.model.util.DynamicBakedWrapper;
import slimeknights.mantle.client.model.util.ExtraTextureConfiguration;
import slimeknights.mantle.client.model.util.ModelTextureIteratable;
import slimeknights.mantle.client.model.util.SimpleBlockModel;

public class ConnectedModel
implements IModelGeometry<ConnectedModel> {
    private static final ModelProperty<Byte> CONNECTIONS = new ModelProperty();
    private final SimpleBlockModel model;
    private final Map<String, String[]> connectedTextures;
    private final BiPredicate<BlockState, BlockState> connectionPredicate;
    private final Set<Direction> sides;
    private Map<String, RenderMaterial> extraTextures;

    public Collection<RenderMaterial> getTextures(IModelConfiguration owner, Function<ResourceLocation, IUnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        Collection<RenderMaterial> textures = this.model.getTextures(owner, modelGetter, missingTextureErrors);
        HashMap<String, RenderMaterial> extraTextures = new HashMap<String, RenderMaterial>();
        for (Map.Entry<String, String[]> entry : this.connectedTextures.entrySet()) {
            String[] suffixes;
            String name = entry.getKey();
            if (!owner.isTexturePresent(name)) continue;
            RenderMaterial base = owner.resolveTexture(name);
            ResourceLocation atlas = base.func_229310_a_();
            ResourceLocation texture = base.func_229313_b_();
            String namespace = texture.func_110624_b();
            String path = texture.func_110623_a();
            for (String suffix : suffixes = entry.getValue()) {
                String suffixedName;
                if (suffix.isEmpty() || extraTextures.containsKey(suffixedName = name + "_" + suffix)) continue;
                RenderMaterial mat = owner.isTexturePresent(suffixedName) ? owner.resolveTexture(suffixedName) : new RenderMaterial(atlas, new ResourceLocation(namespace, path + "/" + suffix));
                textures.add(mat);
                extraTextures.put(suffixedName, mat);
            }
        }
        this.extraTextures = ImmutableMap.copyOf(extraTextures);
        return textures;
    }

    public IBakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<RenderMaterial, TextureAtlasSprite> spriteGetter, IModelTransform transform, ItemOverrideList overrides, ResourceLocation location) {
        IBakedModel baked = this.model.bakeModel(owner, transform, overrides, spriteGetter, location);
        return new BakedModel(this, new ExtraTextureConfiguration(owner, this.extraTextures), transform, baked);
    }

    protected ConnectedModel(SimpleBlockModel model, Map<String, String[]> connectedTextures, BiPredicate<BlockState, BlockState> connectionPredicate, Set<Direction> sides) {
        this.model = model;
        this.connectedTextures = connectedTextures;
        this.connectionPredicate = connectionPredicate;
        this.sides = sides;
    }

    public static class Loader
    implements IModelLoader<ConnectedModel> {
        public static final Loader INSTANCE = new Loader();

        public void func_195410_a(IResourceManager resourceManager) {
        }

        public ConnectedModel read(JsonDeserializationContext context, JsonObject json) {
            EnumSet<Direction> sides;
            SimpleBlockModel model = SimpleBlockModel.deserialize(context, json);
            JsonObject data = JSONUtils.func_152754_s((JsonObject)json, (String)"connection");
            JsonObject connected = JSONUtils.func_152754_s((JsonObject)data, (String)"textures");
            if (connected.size() == 0) {
                throw new JsonSyntaxException("Must have at least one texture in connected");
            }
            ImmutableMap.Builder connectedTextures = new ImmutableMap.Builder();
            for (Map.Entry entry : connected.entrySet()) {
                String name = (String)entry.getKey();
                connectedTextures.put((Object)name, (Object)ConnectedModelRegistry.deserializeType((JsonElement)entry.getValue(), "textures[" + name + "]"));
            }
            if (data.has("sides")) {
                JsonArray array = JSONUtils.func_151214_t((JsonObject)data, (String)"sides");
                sides = EnumSet.noneOf(Direction.class);
                for (int i = 0; i < array.size(); ++i) {
                    String side = JSONUtils.func_151206_a((JsonElement)array.get(i), (String)("sides[" + i + "]"));
                    Direction dir = Direction.func_176739_a((String)side);
                    if (dir == null) {
                        throw new JsonParseException("Invalid side " + side);
                    }
                    sides.add(dir);
                }
            } else {
                sides = EnumSet.allOf(Direction.class);
            }
            BiPredicate<BlockState, BlockState> predicate = ConnectedModelRegistry.deserializePredicate(data, "predicate");
            return new ConnectedModel(model, (Map<String, String[]>)connectedTextures.build(), predicate, sides);
        }
    }

    protected static class BakedModel
    extends DynamicBakedWrapper<IBakedModel> {
        private final ConnectedModel parent;
        private final IModelConfiguration owner;
        private final IModelTransform transforms;
        private final IBakedModel[] cache = new IBakedModel[64];
        private final Map<String, String> nameMappingCache = new HashMap<String, String>();
        private final ModelTextureIteratable modelTextures;

        protected BakedModel(ConnectedModel parent, IModelConfiguration owner, IModelTransform transforms, IBakedModel baked) {
            super(baked);
            this.parent = parent;
            this.owner = owner;
            this.transforms = transforms;
            this.modelTextures = ModelTextureIteratable.of(owner, parent.model);
            this.cache[0] = baked;
        }

        private static Direction rotateDirection(Direction direction, Direction rotation) {
            if (rotation == Direction.UP) {
                return direction;
            }
            if (rotation == Direction.DOWN) {
                if (direction.func_176740_k() == Direction.Axis.Z) {
                    return direction.func_176734_d();
                }
                return direction;
            }
            switch (direction) {
                case NORTH: {
                    return Direction.UP;
                }
                case SOUTH: {
                    return Direction.DOWN;
                }
                case EAST: {
                    return rotation.func_176735_f();
                }
                case WEST: {
                    return rotation.func_176746_e();
                }
            }
            throw new IllegalArgumentException("Direction must be horizontal axis");
        }

        private static Function<Direction, Direction> getTransform(Direction face, BlockFaceUV uv) {
            boolean flipV;
            Function<Direction, Direction> transform = d -> BakedModel.rotateDirection(d, face);
            boolean bl = flipV = uv.field_178351_a[1] > uv.field_178351_a[3];
            if (uv.field_178351_a[0] > uv.field_178351_a[2]) {
                transform = flipV ? transform.compose(Direction::func_176734_d) : transform.compose(d -> {
                    if (d.func_176740_k() == Direction.Axis.X) {
                        return d.func_176734_d();
                    }
                    return d;
                });
            } else if (flipV) {
                transform = transform.compose(d -> {
                    if (d.func_176740_k() == Direction.Axis.Z) {
                        return d.func_176734_d();
                    }
                    return d;
                });
            }
            switch (uv.field_178350_b) {
                case 90: {
                    transform = transform.compose(Direction::func_176746_e);
                    break;
                }
                case 180: {
                    transform = transform.compose(Direction::func_176734_d);
                    break;
                }
                case 270: {
                    transform = transform.compose(Direction::func_176735_f);
                }
            }
            return transform;
        }

        private String getConnectedName(String key) {
            if (key.charAt(0) == '#') {
                key = key.substring(1);
            }
            if (this.parent.connectedTextures.containsKey(key)) {
                return key;
            }
            if (this.nameMappingCache.containsKey(key)) {
                return this.nameMappingCache.get(key);
            }
            String check = key;
            String found = "";
            for (Map textures : this.modelTextures) {
                Either either = (Either)textures.get(check);
                if (either == null) continue;
                Optional newName = either.right();
                if (!newName.isPresent()) break;
                check = (String)newName.get();
                if (!this.parent.connectedTextures.containsKey(check)) continue;
                found = check;
                break;
            }
            this.nameMappingCache.put(key, found);
            return found;
        }

        private String getTextureSuffix(String texture, byte connections, Function<Direction, Direction> transform) {
            int key = 0;
            for (Direction dir : Direction.Plane.HORIZONTAL) {
                int flag = 1 << transform.apply(dir).func_176745_a();
                if ((connections & flag) != flag) continue;
                key |= 1 << dir.func_176736_b();
            }
            String[] suffixes = (String[])this.parent.connectedTextures.get(texture);
            assert (suffixes != null);
            String suffix = suffixes[key];
            if (suffix.isEmpty()) {
                return suffix;
            }
            return "_" + suffix;
        }

        private IBakedModel applyConnections(byte connections) {
            ArrayList elements = Lists.newArrayList();
            for (BlockPart part : this.parent.model.getElements()) {
                EnumMap<Direction, BlockPartFace> partFaces = new EnumMap<Direction, BlockPartFace>(Direction.class);
                for (Map.Entry entry : part.field_178240_c.entrySet()) {
                    String suffix;
                    BlockPartFace original;
                    Direction dir = (Direction)entry.getKey();
                    BlockPartFace face = original = (BlockPartFace)entry.getValue();
                    String connectedTexture = this.getConnectedName(original.field_178242_d);
                    if (!connectedTexture.isEmpty() && !(suffix = this.getTextureSuffix(connectedTexture, connections, BakedModel.getTransform(dir, original.field_178243_e))).isEmpty()) {
                        String fullTexture = connectedTexture + suffix;
                        face = new BlockPartFace(original.field_178244_b, original.field_178245_c, "#" + fullTexture, original.field_178243_e);
                    }
                    partFaces.put(dir, face);
                }
                elements.add(new BlockPart(part.field_178241_a, part.field_178239_b, partFaces, part.field_178237_d, part.field_178238_e));
            }
            return SimpleBlockModel.bakeDynamic(this.owner, elements, this.transforms);
        }

        private static byte getConnections(Predicate<Direction> predicate) {
            byte connections = 0;
            for (Direction dir : Direction.values()) {
                if (!predicate.test(dir)) continue;
                connections = (byte)(connections | 1 << dir.func_176745_a());
            }
            return connections;
        }

        public IModelData getModelData(IBlockDisplayReader world, BlockPos pos, BlockState state, IModelData tileData) {
            if (tileData.getData(CONNECTIONS) != null) {
                return tileData;
            }
            SinglePropertyData data = tileData;
            if (!data.hasProperty(CONNECTIONS)) {
                data = new SinglePropertyData(CONNECTIONS);
            }
            TransformationMatrix rotation = this.transforms.func_225615_b_();
            data.setData(CONNECTIONS, BakedModel.getConnections(dir -> this.parent.sides.contains(dir) && this.parent.connectionPredicate.test(state, world.func_180495_p(pos.func_177972_a(rotation.rotateTransform(dir))))));
            return data;
        }

        protected List<BakedQuad> getCachedQuads(byte connections, @Nullable BlockState state, @Nullable Direction side, Random rand, IModelData data) {
            if (this.cache[connections] == null) {
                this.cache[connections] = this.applyConnections(connections);
            }
            return this.cache[connections].getQuads(state, side, rand, data);
        }

        @Override
        public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, Random rand, IModelData data) {
            Byte connections = (Byte)data.getData(CONNECTIONS);
            if (connections == null) {
                if (state == null) {
                    return this.originalModel.getQuads(null, side, rand, data);
                }
                TransformationMatrix rotation = this.transforms.func_225615_b_();
                connections = BakedModel.getConnections(dir -> {
                    if (!this.parent.sides.contains(dir)) {
                        return false;
                    }
                    BooleanProperty prop = IMultipartConnectedBlock.CONNECTED_DIRECTIONS.get(rotation.rotateTransform(dir));
                    return state.func_235901_b_((Property)prop) && (Boolean)state.func_177229_b((Property)prop) != false;
                });
            }
            return this.getCachedQuads(connections, state, side, rand, data);
        }
    }
}

