/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.model.inventory;

import com.google.gson.JsonObject;
import java.util.List;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.math.vector.Vector3f;
import slimeknights.mantle.client.model.util.ModelHelper;
import slimeknights.mantle.util.JsonHelper;

public class ModelItem {
    private static final ModelItem EMPTY = new ModelItem(new Vector3f(0.0f, 0.0f, 0.0f), 0.0f, 0.0f, 0.0f);
    private final Vector3f center;
    private final float size;
    private final float x;
    private final float y;
    private Vector3f centerScaled;
    private Float sizeScaled;

    public ModelItem(Vector3f center, float size, float x, float y) {
        this.center = center;
        this.size = size;
        this.x = x;
        this.y = y;
    }

    public Vector3f getCenterScaled() {
        if (this.centerScaled == null) {
            this.centerScaled = this.center.func_229195_e_();
            this.centerScaled.func_195898_a(0.0625f);
        }
        return this.centerScaled;
    }

    public float getSizeScaled() {
        if (this.sizeScaled == null) {
            this.sizeScaled = Float.valueOf(this.size / 16.0f);
        }
        return this.sizeScaled.floatValue();
    }

    public boolean isEmpty() {
        return this.size == 0.0f;
    }

    public static ModelItem fromJson(JsonObject json) {
        float size = JSONUtils.func_151217_k((JsonObject)json, (String)"size");
        if (size == 0.0f) {
            return EMPTY;
        }
        Vector3f center = ModelHelper.arrayToVector(json, "center");
        float x = ModelHelper.getRotation(json, "x");
        float y = ModelHelper.getRotation(json, "y");
        return new ModelItem(center, size, x, y);
    }

    public static List<ModelItem> listFromJson(JsonObject parent, String key) {
        return JsonHelper.parseList(parent, key, JSONUtils::func_151210_l, ModelItem::fromJson);
    }

    public Vector3f getCenter() {
        return this.center;
    }

    public float getSize() {
        return this.size;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }
}

