/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.client.model.fluid.FluidCuboid;

public class FluidRenderer {
    public static final RenderType RENDER_TYPE = RenderType.func_228633_a_((String)"mantle:block_render_type", (VertexFormat)DefaultVertexFormats.field_227852_q_, (int)7, (int)256, (boolean)true, (boolean)false, (RenderType.State)RenderType.State.func_228694_a_().func_228724_a_(new RenderState.TextureState(PlayerContainer.field_226615_c_, false, false)).func_228723_a_(RenderType.field_228520_l_).func_228719_a_(RenderType.field_228528_t_).func_228724_a_(RenderType.field_228521_m_).func_228726_a_(RenderType.field_228515_g_).func_228728_a_(false));

    public static TextureAtlasSprite getBlockSprite(ResourceLocation sprite) {
        return Minecraft.func_71410_x().func_209506_al().func_229356_a_(PlayerContainer.field_226615_c_).func_195424_a(sprite);
    }

    public static void putTexturedQuad(IVertexBuilder renderer, Matrix4f matrix, TextureAtlasSprite sprite, Vector3f from, Vector3f to, Direction face, int color, int brightness, int rotation, boolean flowing) {
        float v4;
        float u4;
        float v3;
        float u3;
        float maxV;
        float minV;
        float maxU;
        float minU;
        double size;
        float temp;
        float v2;
        float v1;
        float u2;
        float u1;
        float x1 = from.func_195899_a();
        float y1 = from.func_195900_b();
        float z1 = from.func_195902_c();
        float x2 = to.func_195899_a();
        float y2 = to.func_195900_b();
        float z2 = to.func_195902_c();
        switch (face.func_176740_k()) {
            default: {
                u1 = x1;
                u2 = x2;
                v1 = z2;
                v2 = z1;
                break;
            }
            case Z: {
                u1 = x2;
                u2 = x1;
                v1 = y1;
                v2 = y2;
                break;
            }
            case X: {
                u1 = z2;
                u2 = z1;
                v1 = y1;
                v2 = y2;
            }
        }
        if (rotation == 0 || rotation == 270) {
            temp = v1;
            v1 = 1.0f - v2;
            v2 = 1.0f - temp;
        }
        if (rotation >= 180) {
            temp = u1;
            u1 = 1.0f - u2;
            u2 = 1.0f - temp;
        }
        double d = size = flowing ? 8.0 : 16.0;
        if (rotation % 180 == 90) {
            minU = sprite.func_94214_a((double)v1 * size);
            maxU = sprite.func_94214_a((double)v2 * size);
            minV = sprite.func_94207_b((double)u1 * size);
            maxV = sprite.func_94207_b((double)u2 * size);
        } else {
            minU = sprite.func_94214_a((double)u1 * size);
            maxU = sprite.func_94214_a((double)u2 * size);
            minV = sprite.func_94207_b((double)v1 * size);
            maxV = sprite.func_94207_b((double)v2 * size);
        }
        switch (rotation) {
            default: {
                u1 = minU;
                v1 = maxV;
                u2 = minU;
                v2 = minV;
                u3 = maxU;
                v3 = minV;
                u4 = maxU;
                v4 = maxV;
                break;
            }
            case 90: {
                u1 = minU;
                v1 = minV;
                u2 = maxU;
                v2 = minV;
                u3 = maxU;
                v3 = maxV;
                u4 = minU;
                v4 = maxV;
                break;
            }
            case 180: {
                u1 = maxU;
                v1 = minV;
                u2 = maxU;
                v2 = maxV;
                u3 = minU;
                v3 = maxV;
                u4 = minU;
                v4 = minV;
                break;
            }
            case 270: {
                u1 = maxU;
                v1 = maxV;
                u2 = minU;
                v2 = maxV;
                u3 = minU;
                v3 = minV;
                u4 = maxU;
                v4 = minV;
            }
        }
        int light1 = brightness >> 16 & 0xFFFF;
        int light2 = brightness & 0xFFFF;
        int a = color >> 24 & 0xFF;
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        switch (face) {
            case DOWN: {
                renderer.func_227888_a_(matrix, x1, y1, z2).func_225586_a_(r, g, b, a).func_225583_a_(u1, v1).func_225587_b_(light1, light2).func_181675_d();
                renderer.func_227888_a_(matrix, x1, y1, z1).func_225586_a_(r, g, b, a).func_225583_a_(u2, v2).func_225587_b_(light1, light2).func_181675_d();
                renderer.func_227888_a_(matrix, x2, y1, z1).func_225586_a_(r, g, b, a).func_225583_a_(u3, v3).func_225587_b_(light1, light2).func_181675_d();
                renderer.func_227888_a_(matrix, x2, y1, z2).func_225586_a_(r, g, b, a).func_225583_a_(u4, v4).func_225587_b_(light1, light2).func_181675_d();
                break;
            }
            case UP: {
                renderer.func_227888_a_(matrix, x1, y2, z1).func_225586_a_(r, g, b, a).func_225583_a_(u1, v1).func_225587_b_(light1, light2).func_181675_d();
                renderer.func_227888_a_(matrix, x1, y2, z2).func_225586_a_(r, g, b, a).func_225583_a_(u2, v2).func_225587_b_(light1, light2).func_181675_d();
                renderer.func_227888_a_(matrix, x2, y2, z2).func_225586_a_(r, g, b, a).func_225583_a_(u3, v3).func_225587_b_(light1, light2).func_181675_d();
                renderer.func_227888_a_(matrix, x2, y2, z1).func_225586_a_(r, g, b, a).func_225583_a_(u4, v4).func_225587_b_(light1, light2).func_181675_d();
                break;
            }
            case NORTH: {
                renderer.func_227888_a_(matrix, x1, y1, z1).func_225586_a_(r, g, b, a).func_225583_a_(u1, v1).func_225587_b_(light1, light2).func_181675_d();
                renderer.func_227888_a_(matrix, x1, y2, z1).func_225586_a_(r, g, b, a).func_225583_a_(u2, v2).func_225587_b_(light1, light2).func_181675_d();
                renderer.func_227888_a_(matrix, x2, y2, z1).func_225586_a_(r, g, b, a).func_225583_a_(u3, v3).func_225587_b_(light1, light2).func_181675_d();
                renderer.func_227888_a_(matrix, x2, y1, z1).func_225586_a_(r, g, b, a).func_225583_a_(u4, v4).func_225587_b_(light1, light2).func_181675_d();
                break;
            }
            case SOUTH: {
                renderer.func_227888_a_(matrix, x2, y1, z2).func_225586_a_(r, g, b, a).func_225583_a_(u1, v1).func_225587_b_(light1, light2).func_181675_d();
                renderer.func_227888_a_(matrix, x2, y2, z2).func_225586_a_(r, g, b, a).func_225583_a_(u2, v2).func_225587_b_(light1, light2).func_181675_d();
                renderer.func_227888_a_(matrix, x1, y2, z2).func_225586_a_(r, g, b, a).func_225583_a_(u3, v3).func_225587_b_(light1, light2).func_181675_d();
                renderer.func_227888_a_(matrix, x1, y1, z2).func_225586_a_(r, g, b, a).func_225583_a_(u4, v4).func_225587_b_(light1, light2).func_181675_d();
                break;
            }
            case WEST: {
                renderer.func_227888_a_(matrix, x1, y1, z2).func_225586_a_(r, g, b, a).func_225583_a_(u1, v1).func_225587_b_(light1, light2).func_181675_d();
                renderer.func_227888_a_(matrix, x1, y2, z2).func_225586_a_(r, g, b, a).func_225583_a_(u2, v2).func_225587_b_(light1, light2).func_181675_d();
                renderer.func_227888_a_(matrix, x1, y2, z1).func_225586_a_(r, g, b, a).func_225583_a_(u3, v3).func_225587_b_(light1, light2).func_181675_d();
                renderer.func_227888_a_(matrix, x1, y1, z1).func_225586_a_(r, g, b, a).func_225583_a_(u4, v4).func_225587_b_(light1, light2).func_181675_d();
                break;
            }
            case EAST: {
                renderer.func_227888_a_(matrix, x2, y1, z1).func_225586_a_(r, g, b, a).func_225583_a_(u1, v1).func_225587_b_(light1, light2).func_181675_d();
                renderer.func_227888_a_(matrix, x2, y2, z1).func_225586_a_(r, g, b, a).func_225583_a_(u2, v2).func_225587_b_(light1, light2).func_181675_d();
                renderer.func_227888_a_(matrix, x2, y2, z2).func_225586_a_(r, g, b, a).func_225583_a_(u3, v3).func_225587_b_(light1, light2).func_181675_d();
                renderer.func_227888_a_(matrix, x2, y1, z2).func_225586_a_(r, g, b, a).func_225583_a_(u4, v4).func_225587_b_(light1, light2).func_181675_d();
            }
        }
    }

    public static void renderCuboid(MatrixStack matrices, IVertexBuilder buffer, FluidCuboid cube, TextureAtlasSprite still, TextureAtlasSprite flowing, Vector3f from, Vector3f to, int color, int light, boolean isGas) {
        Matrix4f matrix = matrices.func_227866_c_().func_227870_a_();
        int rotation = isGas ? 180 : 0;
        for (Direction dir : Direction.values()) {
            FluidCuboid.FluidFace face = cube.getFace(dir);
            if (face == null) continue;
            boolean isFlowing = face.isFlowing();
            int faceRot = (rotation + face.getRotation()) % 360;
            FluidRenderer.putTexturedQuad(buffer, matrix, isFlowing ? flowing : still, from, to, dir, color, light, faceRot, isFlowing);
        }
    }

    public static void renderCuboids(MatrixStack matrices, IVertexBuilder buffer, List<FluidCuboid> cubes, FluidStack fluid, int light) {
        if (fluid.isEmpty()) {
            return;
        }
        FluidAttributes attributes = fluid.getFluid().getAttributes();
        TextureAtlasSprite still = FluidRenderer.getBlockSprite(attributes.getStillTexture(fluid));
        TextureAtlasSprite flowing = FluidRenderer.getBlockSprite(attributes.getFlowingTexture(fluid));
        int color = attributes.getColor(fluid);
        boolean isGas = attributes.isGaseous(fluid);
        for (FluidCuboid cube : cubes) {
            FluidRenderer.renderCuboid(matrices, buffer, cube, still, flowing, cube.getFromScaled(), cube.getToScaled(), color, light, isGas);
        }
    }

    public static void renderCuboid(MatrixStack matrices, IVertexBuilder buffer, FluidCuboid cube, float yOffset, TextureAtlasSprite still, TextureAtlasSprite flowing, int color, int light, boolean isGas) {
        if (yOffset != 0.0f) {
            matrices.func_227860_a_();
            matrices.func_227861_a_(0.0, (double)yOffset, 0.0);
        }
        FluidRenderer.renderCuboid(matrices, buffer, cube, still, flowing, cube.getFromScaled(), cube.getToScaled(), color, light, isGas);
        if (yOffset != 0.0f) {
            matrices.func_227865_b_();
        }
    }

    public static void renderScaledCuboid(MatrixStack matrices, IRenderTypeBuffer buffer, FluidCuboid cube, FluidStack fluid, float offset, int capacity, int light, boolean flipGas) {
        if (fluid.isEmpty() || capacity <= 0) {
            return;
        }
        FluidAttributes attributes = fluid.getFluid().getAttributes();
        TextureAtlasSprite still = FluidRenderer.getBlockSprite(attributes.getStillTexture(fluid));
        TextureAtlasSprite flowing = FluidRenderer.getBlockSprite(attributes.getFlowingTexture(fluid));
        boolean isGas = attributes.isGaseous(fluid);
        Vector3f from = cube.getFromScaled();
        Vector3f to = cube.getToScaled();
        float minY = from.func_195900_b();
        float maxY = to.func_195900_b();
        float height = ((float)fluid.getAmount() - offset) / (float)capacity;
        if (isGas && flipGas) {
            from = from.func_229195_e_();
            from.setY(maxY + height * (minY - maxY));
        } else {
            to = to.func_229195_e_();
            to.setY(minY + height * (maxY - minY));
        }
        FluidRenderer.renderCuboid(matrices, buffer.getBuffer(RENDER_TYPE), cube, still, flowing, from, to, attributes.getColor(fluid), light, isGas);
    }
}

