/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.recipe.match;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;

@Deprecated
public abstract class RecipeMatch {
    private final int amountNeeded;
    private final int amountMatched;

    public abstract List<ItemStack> getInputs();

    public abstract Optional<Match> matches(NonNullList<ItemStack> var1);

    public static RecipeMatch of(net.minecraft.item.Item item) {
        return RecipeMatch.of(item, 1);
    }

    public static RecipeMatch of(net.minecraft.item.Item item, int matched) {
        return RecipeMatch.of(item, 1, matched);
    }

    public static RecipeMatch of(net.minecraft.item.Item item, int amount, int matched) {
        return new Item(new ItemStack((IItemProvider)item), amount, matched);
    }

    public static RecipeMatch of(Block block) {
        return RecipeMatch.of(block, 1);
    }

    public static RecipeMatch of(Block block, int matched) {
        return RecipeMatch.of(block, 1, matched);
    }

    public static RecipeMatch of(Block block, int amount, int matched) {
        return new Item(new ItemStack((IItemProvider)block), amount, matched);
    }

    public static RecipeMatch of(ItemStack stack) {
        return RecipeMatch.of(stack, 1);
    }

    public static RecipeMatch of(ItemStack stack, int matched) {
        return RecipeMatch.of(stack, 1, matched);
    }

    public static RecipeMatch of(ItemStack stack, int amount, int matched) {
        return new Item(stack.func_77946_l(), amount, matched);
    }

    public static RecipeMatch ofNBT(ItemStack stack) {
        return RecipeMatch.ofNBT(stack, 1);
    }

    public static RecipeMatch ofNBT(ItemStack stack, int matched) {
        return new ItemCombination(matched, stack);
    }

    public static void removeMatch(NonNullList<ItemStack> stacks, Match match) {
        int[] amountsRemoved = new int[match.stacks.size()];
        RecipeMatch.removeOrder(stacks, match.stacks, amountsRemoved);
        RecipeMatch.removeRemaining(stacks, match.stacks, amountsRemoved);
    }

    private static void removeOrder(NonNullList<ItemStack> stacks, List<ItemStack> toRemove, int[] amountsRemoved) {
        int i = 0;
        block0: for (int j = 0; j < amountsRemoved.length; ++j) {
            ItemStack stack = toRemove.get(j);
            while (i < stacks.size()) {
                if (ItemStack.func_179545_c((ItemStack)stack, (ItemStack)((ItemStack)stacks.get(i))) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)((ItemStack)stacks.get(i)))) {
                    if (((ItemStack)stacks.get(i)).func_190916_E() >= stack.func_190916_E()) {
                        ((ItemStack)stacks.get(i)).func_190918_g(stack.func_190916_E());
                        if (((ItemStack)stacks.get(i)).func_190916_E() == 0) {
                            stacks.set(i, (Object)ItemStack.field_190927_a);
                        }
                        int n = j;
                        amountsRemoved[n] = amountsRemoved[n] + stack.func_190916_E();
                    }
                    ++i;
                    continue block0;
                }
                ++i;
            }
        }
    }

    private static void removeRemaining(NonNullList<ItemStack> stacks, List<ItemStack> toRemove, int[] amountsRemoved) {
        for (int j = 0; j < amountsRemoved.length; ++j) {
            ItemStack stack = toRemove.get(j);
            int needed = stack.func_190916_E() - amountsRemoved[j];
            for (int i = 0; i < stacks.size() && needed > 0; ++i) {
                if (!ItemStack.func_179545_c((ItemStack)stack, (ItemStack)((ItemStack)stacks.get(i))) || !ItemStack.func_77970_a((ItemStack)stack, (ItemStack)((ItemStack)stacks.get(i)))) continue;
                int change = Math.min(((ItemStack)stacks.get(i)).func_190916_E(), needed);
                ((ItemStack)stacks.get(i)).func_190918_g(change);
                if (((ItemStack)stacks.get(i)).func_190916_E() == 0) {
                    stacks.set(i, (Object)ItemStack.field_190927_a);
                }
                needed -= change;
            }
        }
    }

    public RecipeMatch(int amountNeeded, int amountMatched) {
        this.amountNeeded = amountNeeded;
        this.amountMatched = amountMatched;
    }

    public int getAmountNeeded() {
        return this.amountNeeded;
    }

    public int getAmountMatched() {
        return this.amountMatched;
    }

    public static class Match {
        public List<ItemStack> stacks;
        public int amount;

        public Match(List<ItemStack> stacks, int amount) {
            this.stacks = stacks;
            this.amount = amount;
        }
    }

    public static class ItemCombination
    extends RecipeMatch {
        protected final NonNullList<ItemStack> itemStacks;

        public ItemCombination(int amountMatched, ItemStack ... stacks) {
            super(amountMatched, 0);
            NonNullList nonNullStacks = NonNullList.func_191197_a((int)stacks.length, (Object)ItemStack.field_190927_a);
            for (int i = 0; i < stacks.length; ++i) {
                if (stacks[i].func_190926_b()) continue;
                nonNullStacks.set(i, (Object)stacks[i].func_77946_l());
            }
            this.itemStacks = nonNullStacks;
        }

        @Override
        public List<ItemStack> getInputs() {
            return ImmutableList.copyOf(this.itemStacks);
        }

        @Override
        public Optional<Match> matches(NonNullList<ItemStack> stacks) {
            LinkedList found = Lists.newLinkedList();
            HashSet needed = Sets.newHashSet();
            for (int i = 0; i < this.itemStacks.size(); ++i) {
                if (((ItemStack)this.itemStacks.get(i)).func_190926_b()) continue;
                needed.add(i);
            }
            block1: for (ItemStack stack : stacks) {
                Iterator iter = needed.iterator();
                while (iter.hasNext()) {
                    int index = (Integer)iter.next();
                    ItemStack template = (ItemStack)this.itemStacks.get(index);
                    if (!ItemStack.func_179545_c((ItemStack)template, (ItemStack)stack) || !ItemStack.func_77970_a((ItemStack)template, (ItemStack)stack)) continue;
                    ItemStack copy = stack.func_77946_l();
                    copy.func_190920_e(1);
                    found.add(copy);
                    iter.remove();
                    continue block1;
                }
            }
            if (needed.isEmpty()) {
                return Optional.of(new Match(found, this.getAmountMatched()));
            }
            return Optional.empty();
        }
    }

    public static class Item
    extends RecipeMatch {
        private final ItemStack template;

        public Item(ItemStack template, int amountNeeded) {
            this(template, amountNeeded, 1);
        }

        public Item(ItemStack template, int amountNeeded, int amountMatched) {
            super(amountMatched, amountNeeded);
            this.template = template;
        }

        @Override
        public List<ItemStack> getInputs() {
            return ImmutableList.of((Object)this.template);
        }

        @Override
        public Optional<Match> matches(NonNullList<ItemStack> stacks) {
            LinkedList found = Lists.newLinkedList();
            int stillNeeded = this.getAmountNeeded();
            for (ItemStack stack : stacks) {
                if (this.template.func_77973_b() != stack.func_77973_b()) continue;
                ItemStack copy = stack.func_77946_l();
                copy.func_190920_e(Math.min(copy.func_190916_E(), stillNeeded));
                found.add(copy);
                if ((stillNeeded -= copy.func_190916_E()) > 0) continue;
                return Optional.of(new Match(found, this.getAmountMatched()));
            }
            return Optional.empty();
        }
    }
}

