/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.registration.adapter;

import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityType;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BucketItem;
import net.minecraft.item.Item;
import net.minecraft.item.SpawnEggItem;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import slimeknights.mantle.item.BlockTooltipItem;
import slimeknights.mantle.item.TooltipItem;
import slimeknights.mantle.registration.ItemProperties;
import slimeknights.mantle.registration.adapter.EnumRegistryAdapter;
import slimeknights.mantle.registration.object.BuildingBlockObject;
import slimeknights.mantle.registration.object.EnumObject;
import slimeknights.mantle.registration.object.FenceBuildingBlockObject;
import slimeknights.mantle.registration.object.WallBuildingBlockObject;

public class ItemRegistryAdapter
extends EnumRegistryAdapter<Item> {
    private final Item.Properties defaultProps;

    public ItemRegistryAdapter(IForgeRegistry<Item> registry) {
        this(registry, (Item.Properties)null);
    }

    public ItemRegistryAdapter(IForgeRegistry<Item> registry, @Nullable Item.Properties defaultProps) {
        super(registry);
        this.defaultProps = defaultProps == null ? new Item.Properties() : defaultProps;
    }

    public ItemRegistryAdapter(IForgeRegistry<Item> registry, String modid, @Nullable Item.Properties defaultProps) {
        super(registry, modid);
        this.defaultProps = defaultProps == null ? new Item.Properties() : defaultProps;
    }

    public TooltipItem register(String name) {
        return this.register(this.defaultProps, name);
    }

    @Override
    public TooltipItem register(Item.Properties props, String name) {
        return this.register(new TooltipItem(props), name);
    }

    @Override
    public <T extends Item> T register(Function<Item.Properties, T> constructor, String name) {
        return (T)((Item)this.register((IForgeRegistryEntry)constructor.apply(this.defaultProps), name));
    }

    public BlockItem registerBlockItem(Block block) {
        return this.registerBlockItem(block, this.defaultProps);
    }

    public <T extends BlockItem> T registerBlockItem(Block block, BiFunction<Block, Item.Properties, T> constructor) {
        return (T)((BlockItem)this.register((IForgeRegistryEntry)constructor.apply(block, this.defaultProps), (IForgeRegistryEntry<?>)block));
    }

    public BlockItem registerBlockItem(Block block, Item.Properties props) {
        return this.register(new BlockTooltipItem(block, props), (IForgeRegistryEntry<?>)block);
    }

    public <T extends BlockItem> T registerBlockItem(T blockItem) {
        return this.register(blockItem, (IForgeRegistryEntry<?>)blockItem.func_179223_d());
    }

    public void registerBlockItem(BuildingBlockObject object) {
        this.registerBlockItem((Block)object.get());
        this.registerBlockItem((Block)object.getSlab());
        this.registerBlockItem((Block)object.getStairs());
    }

    public void registerBlockItem(WallBuildingBlockObject object) {
        this.registerBlockItem((BuildingBlockObject)object);
        this.registerBlockItem((Block)object.getWall());
    }

    public void registerBlockItem(FenceBuildingBlockObject object) {
        this.registerBlockItem((BuildingBlockObject)object);
        this.registerBlockItem((Block)object.getFence());
    }

    public void registerBlockItem(EnumObject<?, ? extends Block> enumObject) {
        enumObject.values().forEach(this::registerBlockItem);
    }

    public <B extends Block> void registerBlockItem(EnumObject<?, B> enumObject, Item.Properties props) {
        enumObject.values().forEach(block -> this.registerBlockItem((Block)block, props));
    }

    public <B extends Block> void registerBlockItem(EnumObject<?, B> enumObject, Function<B, ? extends BlockItem> blockItem) {
        enumObject.values().forEach(block -> this.registerBlockItem((BlockItem)blockItem.apply(block)));
    }

    public BucketItem registerBucket(Supplier<? extends Fluid> fluid, String baseName) {
        return this.register(new BucketItem(fluid, ItemProperties.BUCKET_PROPS), baseName + "_bucket");
    }

    public SpawnEggItem registerSpawnEgg(EntityType<?> entity, int primary, int secondary, String baseName) {
        return this.register(new SpawnEggItem(entity, primary, secondary, ItemProperties.EGG_PROPS), baseName + "_spawn_egg");
    }
}

