/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.util;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.util.JSONUtils;

public class JsonHelper {
    public static JsonElement getElement(JsonObject json, String memberName) {
        if (json.has(memberName)) {
            return json.get(memberName);
        }
        throw new JsonSyntaxException("Missing " + memberName + "");
    }

    public static <R, T> List<T> parseList(JsonArray array, String name, BiFunction<JsonElement, String, R> parser, Function<R, T> mapper) {
        if (array.size() == 0) {
            throw new JsonSyntaxException(name + " must have at least 1 element");
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < array.size(); ++i) {
            builder.add(mapper.apply(parser.apply(array.get(i), name + "[" + i + "]")));
        }
        return builder.build();
    }

    public static <R, T> List<T> parseList(JsonObject object, String name, BiFunction<JsonElement, String, R> parser, Function<R, T> mapper) {
        return JsonHelper.parseList(JSONUtils.func_151214_t((JsonObject)object, (String)name), name, parser, mapper);
    }

    private JsonHelper() {
    }
}

