/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures;

import com.telepathicgrunt.repurposedstructures.RSFeatures;
import com.telepathicgrunt.repurposedstructures.RepurposedStructures;
import com.telepathicgrunt.repurposedstructures.world.placements.RSPlacements;
import net.minecraft.block.Blocks;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.biome.DefaultBiomeFeatures;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.BlockBlobConfig;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.DecoratedFeatureConfig;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.placement.AtSurfaceWithExtraConfig;
import net.minecraft.world.gen.placement.ChanceConfig;
import net.minecraft.world.gen.placement.ChanceRangeConfig;
import net.minecraft.world.gen.placement.CountRangeConfig;
import net.minecraft.world.gen.placement.FrequencyConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;

public class RSAddFeatures {
    private static final ConfiguredFeature<?, ?> VANILLA_SWAMP_TREE = Feature.field_236291_c_.func_225566_b_((IFeatureConfig)DefaultBiomeFeatures.field_226814_i_).func_227228_a_(Placement.field_215027_m.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(2, 0.1f, 1)));
    private static final ConfiguredFeature<?, ?> VANILLA_BOULDER = Feature.field_202283_ac.func_225566_b_((IFeatureConfig)new BlockBlobConfig(Blocks.field_150341_Y.func_176223_P(), 0)).func_227228_a_(Placement.field_215040_z.func_227446_a_((IPlacementConfig)new FrequencyConfig(3)));

    public static void addMineshafts(Biome biome, String biomeNamespace, String biomePath) {
        if (RepurposedStructures.RSMineshaftsConfig.birchMineshaftSpawnrate.get() != 0 && biomePath.contains("birch") && (biomeNamespace.equals("minecraft") || RepurposedStructures.RSMineshaftsConfig.addMineshaftsToModdedBiomes.get().booleanValue())) {
            if (biome.func_201858_a(Structure.field_236367_c_)) {
                biome.field_201874_aj.remove(Structure.field_236367_c_);
                biome.func_235063_a_(RSFeatures.BIRCH_MINESHAFT.func_236391_a_((IFeatureConfig)IFeatureConfig.field_202429_e));
            }
        } else if (RepurposedStructures.RSMineshaftsConfig.jungleMineshaftSpawnrate.get() != 0 && biome.func_201856_r() == Biome.Category.JUNGLE && (biomeNamespace.equals("minecraft") || RepurposedStructures.RSMineshaftsConfig.addMineshaftsToModdedBiomes.get().booleanValue())) {
            if (biome.func_201858_a(Structure.field_236367_c_)) {
                biome.field_201874_aj.remove(Structure.field_236367_c_);
                biome.func_235063_a_(RSFeatures.JUNGLE_MINESHAFT.func_236391_a_((IFeatureConfig)IFeatureConfig.field_202429_e));
            }
        } else if (RepurposedStructures.RSMineshaftsConfig.desertMineshaftSpawnrate.get() != 0 && biome.func_201856_r() == Biome.Category.DESERT && (biomeNamespace.equals("minecraft") || RepurposedStructures.RSMineshaftsConfig.addMineshaftsToModdedBiomes.get().booleanValue())) {
            if (biome.func_201858_a(Structure.field_236367_c_)) {
                biome.field_201874_aj.remove(Structure.field_236367_c_);
                biome.func_235063_a_(RSFeatures.DESERT_MINESHAFT.func_236391_a_((IFeatureConfig)IFeatureConfig.field_202429_e));
            }
        } else if (RepurposedStructures.RSMineshaftsConfig.stoneMineshaftSpawnrate.get() != 0 && biome.func_201856_r() == Biome.Category.EXTREME_HILLS && (biomeNamespace.equals("minecraft") || RepurposedStructures.RSMineshaftsConfig.addMineshaftsToModdedBiomes.get().booleanValue())) {
            if (biome.func_201858_a(Structure.field_236367_c_)) {
                biome.field_201874_aj.remove(Structure.field_236367_c_);
                biome.func_235063_a_(RSFeatures.STONE_MINESHAFT.func_236391_a_((IFeatureConfig)IFeatureConfig.field_202429_e));
            }
        } else if (RepurposedStructures.RSMineshaftsConfig.savannaMineshaftSpawnrate.get() != 0 && biome.func_201856_r() == Biome.Category.SAVANNA && (biomeNamespace.equals("minecraft") || RepurposedStructures.RSMineshaftsConfig.addMineshaftsToModdedBiomes.get().booleanValue())) {
            if (biome.func_201858_a(Structure.field_236367_c_)) {
                biome.field_201874_aj.remove(Structure.field_236367_c_);
                biome.func_235063_a_(RSFeatures.SAVANNA_MINESHAFT.func_236391_a_((IFeatureConfig)IFeatureConfig.field_202429_e));
            }
        } else if (RepurposedStructures.RSMineshaftsConfig.icyMineshaftSpawnrate.get() != 0 && (biome.func_201856_r() == Biome.Category.ICY || biomePath.contains("snowy")) && (biomeNamespace.equals("minecraft") || RepurposedStructures.RSMineshaftsConfig.addMineshaftsToModdedBiomes.get().booleanValue())) {
            if (biome.func_201858_a(Structure.field_236367_c_)) {
                biome.field_201874_aj.remove(Structure.field_236367_c_);
                biome.func_235063_a_(RSFeatures.ICY_MINESHAFT.func_236391_a_((IFeatureConfig)IFeatureConfig.field_202429_e));
            }
        } else if (RepurposedStructures.RSMineshaftsConfig.oceanMineshaftSpawnrate.get() != 0 && biome.func_201856_r() == Biome.Category.OCEAN && (biomeNamespace.equals("minecraft") || RepurposedStructures.RSMineshaftsConfig.addMineshaftsToModdedBiomes.get().booleanValue())) {
            if (biome.func_201858_a(Structure.field_236367_c_)) {
                biome.field_201874_aj.remove(Structure.field_236367_c_);
                biome.func_235063_a_(RSFeatures.OCEAN_MINESHAFT.func_236391_a_((IFeatureConfig)IFeatureConfig.field_202429_e));
            }
        } else if (RepurposedStructures.RSMineshaftsConfig.taigaMineshaftSpawnrate.get() != 0 && biome.func_201856_r() == Biome.Category.TAIGA && (biomeNamespace.equals("minecraft") || RepurposedStructures.RSMineshaftsConfig.addMineshaftsToModdedBiomes.get().booleanValue())) {
            if (biome.func_201858_a(Structure.field_236367_c_)) {
                biome.field_201874_aj.remove(Structure.field_236367_c_);
                biome.func_235063_a_(RSFeatures.TAIGA_MINESHAFT.func_236391_a_((IFeatureConfig)IFeatureConfig.field_202429_e));
            }
        } else if (RepurposedStructures.RSMineshaftsConfig.swampAndDarkForestMineshaftSpawnrate.get() != 0 && (biome.func_201856_r() == Biome.Category.SWAMP || biomePath.contains("dark_forest") || biomePath.contains("dark_oak")) && (biomeNamespace.equals("minecraft") || RepurposedStructures.RSMineshaftsConfig.addMineshaftsToModdedBiomes.get().booleanValue())) {
            if (biome.func_201858_a(Structure.field_236367_c_)) {
                biome.field_201874_aj.remove(Structure.field_236367_c_);
                biome.func_235063_a_(RSFeatures.SWAMP_OR_DARK_FOREST_MINESHAFT.func_236391_a_((IFeatureConfig)IFeatureConfig.field_202429_e));
            }
        } else if (RepurposedStructures.RSMineshaftsConfig.endMineshaftSpawnrate.get() != 0 && biome.func_201856_r() == Biome.Category.THEEND && biome != Biomes.field_76779_k && (RepurposedStructures.RSMineshaftsConfig.barrensIslandsEndMineshafts.get().booleanValue() || biome != Biomes.field_201939_S && biome != Biomes.field_201936_P) && (biomeNamespace.equals("minecraft") || RepurposedStructures.RSMineshaftsConfig.addMineshaftsToModdedBiomes.get().booleanValue())) {
            biome.func_235063_a_(RSFeatures.END_MINESHAFT.func_236391_a_((IFeatureConfig)IFeatureConfig.field_202429_e));
        } else if (RepurposedStructures.RSMineshaftsConfig.netherMineshaftSpawnrate.get() != 0 && biome.func_201856_r() == Biome.Category.NETHER && (biomeNamespace.equals("minecraft") || RepurposedStructures.RSMineshaftsConfig.addMineshaftsToModdedBiomes.get().booleanValue())) {
            biome.func_235063_a_(RSFeatures.NETHER_MINESHAFT.func_236391_a_((IFeatureConfig)IFeatureConfig.field_202429_e));
        }
    }

    public static void addDungeons(Biome biome, String biomeNamespace, String biomePath) {
        if (RepurposedStructures.RSDungeonsConfig.jungleDungeonSpawnrate.get() != 0 && biome.func_201856_r() == Biome.Category.JUNGLE && RSAddFeatures.dungeonAllowedByNamespaceAndConfigUA(biomeNamespace)) {
            RSAddFeatures.replaceOrAddDungeon(true, biome, RSFeatures.JUNGLE_DUNGEONS, RepurposedStructures.RSDungeonsConfig.jungleDungeonSpawnrate.get(), RepurposedStructures.RSDungeonsConfig.jungleDungeonMinHeight.get(), RepurposedStructures.RSDungeonsConfig.jungleDungeonMaxHeight.get());
        } else if (RepurposedStructures.RSDungeonsConfig.badlandsDungeonSpawnrate.get() != 0 && biome.func_201856_r() == Biome.Category.MESA && RSAddFeatures.dungeonAllowedByNamespaceAndConfigUA(biomeNamespace)) {
            RSAddFeatures.replaceOrAddDungeon(true, biome, RSFeatures.BADLANDS_DUNGEONS, RepurposedStructures.RSDungeonsConfig.badlandsDungeonSpawnrate.get(), RepurposedStructures.RSDungeonsConfig.badlandsDungeonMinHeight.get(), RepurposedStructures.RSDungeonsConfig.badlandsDungeonMaxHeight.get());
        } else if (RepurposedStructures.RSDungeonsConfig.darkForestDungeonSpawnrate.get() != 0 && biomePath.contains("dark_forest") && RSAddFeatures.dungeonAllowedByNamespaceAndConfigUA(biomeNamespace)) {
            RSAddFeatures.replaceOrAddDungeon(true, biome, RSFeatures.DARK_FOREST_DUNGEONS, RepurposedStructures.RSDungeonsConfig.darkForestDungeonSpawnrate.get(), RepurposedStructures.RSDungeonsConfig.darkForestDungeonMinHeight.get(), RepurposedStructures.RSDungeonsConfig.darkForestDungeonMaxHeight.get());
        } else if (RepurposedStructures.RSDungeonsConfig.desertDungeonSpawnrate.get() != 0 && biome.func_201856_r() == Biome.Category.DESERT && RSAddFeatures.dungeonAllowedByNamespaceAndConfigUA(biomeNamespace)) {
            RSAddFeatures.replaceOrAddDungeon(true, biome, RSFeatures.DESERT_DUNGEONS, RepurposedStructures.RSDungeonsConfig.desertDungeonSpawnrate.get(), RepurposedStructures.RSDungeonsConfig.desertDungeonMinHeight.get(), RepurposedStructures.RSDungeonsConfig.desertDungeonMaxHeight.get());
        } else if (RepurposedStructures.RSDungeonsConfig.mushroomDungeonSpawnrate.get() != 0 && biome.func_201856_r() == Biome.Category.MUSHROOM && RSAddFeatures.dungeonAllowedByNamespaceAndConfigUA(biomeNamespace)) {
            RSAddFeatures.replaceOrAddDungeon(true, biome, RSFeatures.MUSHROOM_DUNGEONS, RepurposedStructures.RSDungeonsConfig.mushroomDungeonSpawnrate.get(), RepurposedStructures.RSDungeonsConfig.mushroomDungeonMinHeight.get(), RepurposedStructures.RSDungeonsConfig.mushroomDungeonMaxHeight.get());
        } else if (RepurposedStructures.RSDungeonsConfig.swampDungeonSpawnrate.get() != 0 && biome.func_201856_r() == Biome.Category.SWAMP && RSAddFeatures.dungeonAllowedByNamespaceAndConfigUA(biomeNamespace)) {
            RSAddFeatures.replaceOrAddDungeon(true, biome, RSFeatures.SWAMP_DUNGEONS, RepurposedStructures.RSDungeonsConfig.swampDungeonSpawnrate.get(), RepurposedStructures.RSDungeonsConfig.swampDungeonMinHeight.get(), RepurposedStructures.RSDungeonsConfig.swampDungeonMaxHeight.get());
        } else if (RepurposedStructures.RSDungeonsConfig.snowDungeonSpawnrate.get() != 0 && biome.func_201856_r() == Biome.Category.ICY && RSAddFeatures.dungeonAllowedByNamespaceAndConfigUA(biomeNamespace)) {
            RSAddFeatures.replaceOrAddDungeon(true, biome, RSFeatures.SNOW_DUNGEONS, RepurposedStructures.RSDungeonsConfig.snowDungeonSpawnrate.get(), RepurposedStructures.RSDungeonsConfig.snowDungeonMinHeight.get(), RepurposedStructures.RSDungeonsConfig.snowDungeonMaxHeight.get());
        } else if (RepurposedStructures.RSDungeonsConfig.netherDungeonSpawnrate.get() != 0 && biome.func_201856_r() == Biome.Category.NETHER && RSAddFeatures.dungeonAllowedByNamespaceAndConfigUA(biomeNamespace)) {
            RSAddFeatures.replaceOrAddDungeon(false, biome, RSFeatures.NETHER_DUNGEONS, RepurposedStructures.RSDungeonsConfig.netherDungeonSpawnrate.get(), RepurposedStructures.RSDungeonsConfig.netherDungeonMinHeight.get(), RepurposedStructures.RSDungeonsConfig.netherDungeonMaxHeight.get());
        } else if (RepurposedStructures.RSDungeonsConfig.endDungeonSpawnrate.get() != 0 && biome.func_201856_r() == Biome.Category.THEEND && biome != Biomes.field_76779_k && biome != Biomes.field_201936_P && RSAddFeatures.dungeonAllowedByNamespaceAndConfigUA(biomeNamespace)) {
            RSAddFeatures.replaceOrAddDungeon(false, biome, RSFeatures.END_DUNGEONS, RepurposedStructures.RSDungeonsConfig.endDungeonSpawnrate.get(), RepurposedStructures.RSDungeonsConfig.endDungeonMinHeight.get(), RepurposedStructures.RSDungeonsConfig.endDungeonMaxHeight.get());
        } else if (RepurposedStructures.RSDungeonsConfig.oceanDungeonSpawnrate.get() != 0 && biome.func_201856_r() == Biome.Category.OCEAN && RSAddFeatures.dungeonAllowedByNamespaceAndConfig(biomeNamespace)) {
            RSAddFeatures.replaceOrAddDungeon(false, biome, RSFeatures.OCEAN_DUNGEONS, RepurposedStructures.RSDungeonsConfig.oceanDungeonSpawnrate.get(), RepurposedStructures.RSDungeonsConfig.oceanDungeonMinHeight.get(), RepurposedStructures.RSDungeonsConfig.oceanDungeonMaxHeight.get());
        }
    }

    private static void replaceOrAddDungeon(boolean replacing, Biome biome, Feature<NoFeatureConfig> rsDungeon, int spawnrate, int minHeight, int maxheight) {
        if (replacing) {
            biome.func_203607_a(GenerationStage.Decoration.UNDERGROUND_STRUCTURES).removeIf(configuredFeature -> configuredFeature.field_222738_b instanceof DecoratedFeatureConfig && ((DecoratedFeatureConfig)configuredFeature.field_222738_b).field_214689_a.field_222737_a == Feature.field_202282_ab);
        }
        biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_STRUCTURES, rsDungeon.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(RSPlacements.RS_DUNGEON_PLACEMENT.func_227446_a_((IPlacementConfig)new CountRangeConfig(spawnrate, minHeight, 0, maxheight))));
    }

    private static boolean dungeonAllowedByNamespaceAndConfigUA(String biomeNamespace) {
        if (!biomeNamespace.equals("ultra_amplified_dimension")) {
            return RSAddFeatures.dungeonAllowedByNamespaceAndConfig(biomeNamespace);
        }
        return false;
    }

    private static boolean dungeonAllowedByNamespaceAndConfig(String biomeNamespace) {
        return biomeNamespace.equals("minecraft") || RepurposedStructures.RSDungeonsConfig.addDungeonsToModdedBiomes.get() != false;
    }

    public static void addWells(Biome biome, String biomeNamespace, String biomePath) {
        if (RepurposedStructures.RSWellsConfig.badlandsWellSpawnrate.get() != 10000 && biome.func_201856_r() == Biome.Category.MESA && RSAddFeatures.wellAllowedByNamespaceAndConfig(biomeNamespace)) {
            biome.func_203611_a(GenerationStage.Decoration.SURFACE_STRUCTURES, RSFeatures.BADLANDS_WELL.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215023_i.func_227446_a_((IPlacementConfig)new ChanceConfig(RepurposedStructures.RSWellsConfig.badlandsWellSpawnrate.get().intValue()))));
        } else if (RepurposedStructures.RSWellsConfig.netherWellSpawnrate.get() != 10000 && biome.func_201856_r() == Biome.Category.NETHER && RSAddFeatures.wellAllowedByNamespaceAndConfig(biomeNamespace)) {
            biome.func_203611_a(GenerationStage.Decoration.SURFACE_STRUCTURES, RSFeatures.NETHER_WELL.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215032_r.func_227446_a_((IPlacementConfig)new ChanceRangeConfig(1.0f / (float)RepurposedStructures.RSWellsConfig.netherWellSpawnrate.get().intValue(), 30, 0, 98))));
        } else if (RepurposedStructures.RSWellsConfig.snowWellSpawnrate.get() != 10000 && (biome.func_201856_r() == Biome.Category.ICY || biomePath.contains("snow")) && RSAddFeatures.wellAllowedByNamespaceAndConfig(biomeNamespace)) {
            biome.func_203611_a(GenerationStage.Decoration.SURFACE_STRUCTURES, RSFeatures.SNOW_WELL.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215023_i.func_227446_a_((IPlacementConfig)new ChanceConfig(RepurposedStructures.RSWellsConfig.snowWellSpawnrate.get().intValue()))));
        } else if (RepurposedStructures.RSWellsConfig.mossyStoneWellSpawnrate.get() != 10000 && (biome.func_201856_r() == Biome.Category.SWAMP || biome.func_201856_r() == Biome.Category.JUNGLE || biomePath.contains("dark_forest") || biomePath.contains("dark_oak")) && RSAddFeatures.wellAllowedByNamespaceAndConfig(biomeNamespace)) {
            biome.func_203611_a(GenerationStage.Decoration.SURFACE_STRUCTURES, RSFeatures.MOSSY_STONE_WELL.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215023_i.func_227446_a_((IPlacementConfig)new ChanceConfig(RepurposedStructures.RSWellsConfig.mossyStoneWellSpawnrate.get().intValue()))));
        } else if (RepurposedStructures.RSWellsConfig.forestWellSpawnrate.get() != 10000 && biome.func_201856_r() == Biome.Category.FOREST && !biomePath.contains("dark_forest") && !biomePath.contains("dark_oak") && RSAddFeatures.wellAllowedByNamespaceAndConfig(biomeNamespace)) {
            biome.func_203611_a(GenerationStage.Decoration.SURFACE_STRUCTURES, RSFeatures.FOREST_WELL.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215023_i.func_227446_a_((IPlacementConfig)new ChanceConfig(RepurposedStructures.RSWellsConfig.forestWellSpawnrate.get().intValue()))));
        }
    }

    private static boolean wellAllowedByNamespaceAndConfig(String biomeNamespace) {
        return biomeNamespace.equals("minecraft") || RepurposedStructures.RSWellsConfig.addWellsToModdedBiomes.get() != false;
    }

    public static void addSwampTreeFeatures(Biome biome, String biomeNamespace, String biomePath) {
        if (RepurposedStructures.RSMainConfig.hornedSwampTree.get().booleanValue() && !biomeNamespace.equals("ultra_amplified_dimension") && biome == Biomes.field_76780_h) {
            biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, RSFeatures.HORNED_SWAMP_TREE.func_225566_b_((IFeatureConfig)DefaultBiomeFeatures.field_226814_i_).func_227228_a_(Placement.field_215027_m.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(0, 0.7f, 1))));
        } else if (RepurposedStructures.RSMainConfig.hornedSwampTree.get().booleanValue() && (biome == Biomes.field_150599_m || RepurposedStructures.RSMainConfig.addLargeSwampTreeModdedBiomes.get().booleanValue() && biome.func_201856_r() == Biome.Category.SWAMP && !biomeNamespace.equals("ultra_amplified_dimension") && !biomeNamespace.equals("minecraft"))) {
            biome.func_203607_a(GenerationStage.Decoration.VEGETAL_DECORATION).removeIf(configuredFeature -> configuredFeature.field_222738_b instanceof DecoratedFeatureConfig && RSAddFeatures.serializeAndCompareFeature(configuredFeature, VANILLA_SWAMP_TREE));
            biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, RSFeatures.HORNED_SWAMP_TREE.func_225566_b_((IFeatureConfig)DefaultBiomeFeatures.field_226814_i_).func_227228_a_(Placement.field_215027_m.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(2, 0.8f, 1))));
        }
    }

    public static void addBoulderFeatures(Biome biome, String biomeNamespace, String biomePath) {
        if (RepurposedStructures.RSMainConfig.boulderGiant.get().booleanValue() && !biomeNamespace.equals("ultra_amplified_dimension") && (biome == Biomes.field_185433_ae || biome == Biomes.field_150581_V || RepurposedStructures.RSMainConfig.addGiantBouldersModdedBiomes.get().booleanValue() && !biomeNamespace.equals("minecraft") && (biomePath.contains("giant") && biomePath.contains("taiga") || biomePath.contains("redwood")))) {
            biome.func_203607_a(GenerationStage.Decoration.LOCAL_MODIFICATIONS).removeIf(configuredFeature -> configuredFeature.field_222738_b instanceof DecoratedFeatureConfig && RSAddFeatures.serializeAndCompareFeature(configuredFeature, VANILLA_BOULDER));
            biome.func_203611_a(GenerationStage.Decoration.LOCAL_MODIFICATIONS, RSFeatures.BOULDER_GIANT.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215027_m.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig((int)RepurposedStructures.RSMainConfig.giantBouldersPerChunk.get().doubleValue(), (float)(RepurposedStructures.RSMainConfig.giantBouldersPerChunk.get() - (double)((int)RepurposedStructures.RSMainConfig.giantBouldersPerChunk.get().doubleValue())), 1))));
        } else if (RepurposedStructures.RSMainConfig.boulderTiny.get().booleanValue() && !biomeNamespace.equals("ultra_amplified_dimension") && (biome == Biomes.field_185431_ac || biome == Biomes.field_150590_f || RepurposedStructures.RSMainConfig.addTinyBouldersModdedBiomes.get().booleanValue() && !biomeNamespace.equals("minecraft") && biomePath.contains("taiga") && (biomePath.contains("mountain") || biomePath.contains("hill")))) {
            biome.func_203611_a(GenerationStage.Decoration.LOCAL_MODIFICATIONS, RSFeatures.BOULDER_TINY.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215016_b.func_227446_a_((IPlacementConfig)new FrequencyConfig(2))));
        }
    }

    public static void addStrongholds(Biome biome, String biomeNamespace, String biomePath) {
        if (RepurposedStructures.RSStrongholdsConfig.allowStonebrickStronghold.get().booleanValue() && RepurposedStructures.RSStrongholdsConfig.stonebrickStrongholdSpawnrate.get() != 1001 && biome.func_201856_r() != Biome.Category.NETHER && (biome.func_201858_a(Structure.field_236375_k_) || !biomeNamespace.equals("minecraft") && RepurposedStructures.RSStrongholdsConfig.addStonebrickStrongholdToModdedBiomes.get().booleanValue())) {
            biome.field_201874_aj.remove(Structure.field_236375_k_);
            biome.func_235063_a_(RSFeatures.STONEBRICK_STRONGHOLD.func_236391_a_((IFeatureConfig)IFeatureConfig.field_202429_e));
            biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, RSFeatures.STRONGHOLD_CHAINS.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(RSPlacements.RS_DUNGEON_PLACEMENT.func_227446_a_((IPlacementConfig)new CountRangeConfig(RepurposedStructures.RSStrongholdsConfig.stonebrickStrongholdChainSpawnrate.get().intValue(), 5, 0, Math.max(RepurposedStructures.RSStrongholdsConfig.stonebrickStrongholdMaxHeight.get(), RepurposedStructures.RSStrongholdsConfig.stonebrickStrongholdMinHeight.get() + 1) + 15))));
        } else if (RepurposedStructures.RSStrongholdsConfig.netherStrongholdSpawnrate.get() != 1001 && biome.func_201856_r() == Biome.Category.NETHER && (biomeNamespace.equals("minecraft") || RepurposedStructures.RSStrongholdsConfig.addNetherStrongholdToModdedBiomes.get().booleanValue())) {
            biome.func_235063_a_(RSFeatures.NETHER_STRONGHOLD.func_236391_a_((IFeatureConfig)IFeatureConfig.field_202429_e));
            biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, RSFeatures.STRONGHOLD_CHAINS.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(RSPlacements.RS_DUNGEON_PLACEMENT.func_227446_a_((IPlacementConfig)new CountRangeConfig(RepurposedStructures.RSStrongholdsConfig.netherStrongholdChainSpawnrate.get().intValue(), 5, 0, Math.max(RepurposedStructures.RSStrongholdsConfig.netherStrongholdMaxHeight.get(), RepurposedStructures.RSStrongholdsConfig.netherStrongholdMinHeight.get() + 1) + 15))));
        }
    }

    public static void addOutposts(Biome biome, String biomeNamespace, String biomePath) {
        if (biome.func_201856_r() == Biome.Category.NETHER) {
            if (RepurposedStructures.RSOutpostsConfig.crimsonOutpostSpawnrate.get() != 1001 && biomePath.contains("crimson") && (biomeNamespace.equals("minecraft") || RepurposedStructures.RSOutpostsConfig.addCrimsonOutpostToModdedBiomes.get().booleanValue())) {
                biome.func_235063_a_(RSFeatures.CRIMSON_OUTPOST.func_236391_a_((IFeatureConfig)IFeatureConfig.field_202429_e));
            } else if (RepurposedStructures.RSOutpostsConfig.warpedOutpostSpawnrate.get() != 1001 && biomePath.contains("warped") && (biomeNamespace.equals("minecraft") || RepurposedStructures.RSOutpostsConfig.addWarpedOutpostToModdedBiomes.get().booleanValue())) {
                biome.func_235063_a_(RSFeatures.WARPED_OUTPOST.func_236391_a_((IFeatureConfig)IFeatureConfig.field_202429_e));
            } else if (RepurposedStructures.RSOutpostsConfig.netherBrickOutpostSpawnrate.get() != 1001 && (biomeNamespace.equals("minecraft") || RepurposedStructures.RSOutpostsConfig.addNetherBrickOutpostToModdedBiomes.get().booleanValue())) {
                biome.func_235063_a_(RSFeatures.NETHER_BRICK_OUTPOST.func_236391_a_((IFeatureConfig)IFeatureConfig.field_202429_e));
            }
        }
    }

    public static void addShipwrecks(Biome biome, String biomeNamespace, String biomePath) {
        if (RepurposedStructures.RSShipwrecksConfig.endShipwreckSpawnrate.get() != 1001 && (biome == Biomes.field_201938_R || !biomeNamespace.equals("minecraft") && biome.func_201856_r() == Biome.Category.THEEND && RepurposedStructures.RSShipwrecksConfig.addEndShipwreckToModdedBiomes.get().booleanValue())) {
            biome.func_235063_a_(RSFeatures.END_SHIPWRECK.func_236391_a_((IFeatureConfig)IFeatureConfig.field_202429_e));
        }
    }

    public static void addJungleFortress(Biome biome, String biomeNamespace, String biomePath) {
        if (RepurposedStructures.RSMainConfig.jungleFortressSpawnrate.get() != 1001) {
            if (biome.func_201856_r() == Biome.Category.JUNGLE && (biomeNamespace.equals("minecraft") || RepurposedStructures.RSMainConfig.addJungleFortressToModdedBiomes.get().booleanValue())) {
                biome.func_235063_a_(RSFeatures.JUNGLE_FORTRESS.func_236391_a_((IFeatureConfig)IFeatureConfig.field_202429_e));
            }
            biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, RSFeatures.JUNGLE_STRUCTURES_VINES.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(RSPlacements.RS_VINE_PLACEMENT.func_227446_a_((IPlacementConfig)new CountRangeConfig(40, 0, 2, 20))));
            biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, RSFeatures.FORTRESS_BREAKAGE.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215027_m.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(1, 0.2f, 1))));
        }
    }

    public static void addTemples(Biome biome, String biomeNamespace, String biomePath) {
        if (RepurposedStructures.RSTemplesConfig.netherBasaltTempleSpawnrate.get() != 1001 && biome.func_201856_r() == Biome.Category.NETHER && (biomePath.contains("basalt") || biomePath.contains("blackstone")) && (biomeNamespace.equals("minecraft") || RepurposedStructures.RSTemplesConfig.addNetherBasaltTempleToModdedBiomes.get().booleanValue())) {
            biome.func_235063_a_(RSFeatures.NETHER_BASALT_TEMPLE.func_236391_a_((IFeatureConfig)IFeatureConfig.field_202429_e));
        } else if (RepurposedStructures.RSTemplesConfig.netherCrimsonTempleSpawnrate.get() != 1001 && biome.func_201856_r() == Biome.Category.NETHER && biomePath.contains("crimson") && (biomeNamespace.equals("minecraft") || RepurposedStructures.RSTemplesConfig.addNetherCrimsonTempleToModdedBiomes.get().booleanValue())) {
            biome.func_235063_a_(RSFeatures.NETHER_CRIMSON_TEMPLE.func_236391_a_((IFeatureConfig)IFeatureConfig.field_202429_e));
        } else if (RepurposedStructures.RSTemplesConfig.netherWarpedTempleSpawnrate.get() != 1001 && biome.func_201856_r() == Biome.Category.NETHER && biomePath.contains("warped") && (biomeNamespace.equals("minecraft") || RepurposedStructures.RSTemplesConfig.addNetherWarpedTempleToModdedBiomes.get().booleanValue())) {
            biome.func_235063_a_(RSFeatures.NETHER_WARPED_TEMPLE.func_236391_a_((IFeatureConfig)IFeatureConfig.field_202429_e));
        } else if (RepurposedStructures.RSTemplesConfig.netherSoulTempleSpawnrate.get() != 1001 && biome.func_201856_r() == Biome.Category.NETHER && biomePath.contains("soul") && (biomeNamespace.equals("minecraft") || RepurposedStructures.RSTemplesConfig.addNetherSoulTempleToModdedBiomes.get().booleanValue())) {
            biome.func_235063_a_(RSFeatures.NETHER_SOUL_TEMPLE.func_236391_a_((IFeatureConfig)IFeatureConfig.field_202429_e));
        } else if (RepurposedStructures.RSTemplesConfig.netherWastelandTempleSpawnrate.get() != 1001 && biome.func_201856_r() == Biome.Category.NETHER && (biomeNamespace.equals("minecraft") || RepurposedStructures.RSTemplesConfig.addNetherWastelandTempleToModdedBiomes.get().booleanValue())) {
            biome.func_235063_a_(RSFeatures.NETHER_WASTELAND_TEMPLE.func_236391_a_((IFeatureConfig)IFeatureConfig.field_202429_e));
        }
    }

    public static void addPyramids(Biome biome, String biomeNamespace, String biomePath) {
        if (RepurposedStructures.RSTemplesConfig.netherPyramidSpawnrate.get() != 1001 && biome.func_201856_r() == Biome.Category.NETHER && (biomeNamespace.equals("minecraft") || RepurposedStructures.RSTemplesConfig.addNetherPyramidToModdedBiomes.get().booleanValue())) {
            biome.func_235063_a_(RSFeatures.NETHER_PYRAMID.func_236391_a_((IFeatureConfig)IFeatureConfig.field_202429_e));
        }
        if (RepurposedStructures.RSTemplesConfig.badlandsPyramidSpawnrate.get() != 1001 && biome.func_201856_r() == Biome.Category.MESA && (biomeNamespace.equals("minecraft") || RepurposedStructures.RSTemplesConfig.addBadlandsPyramidToModdedBiomes.get().booleanValue())) {
            biome.func_235063_a_(RSFeatures.BADLANDS_TEMPLE.func_236391_a_((IFeatureConfig)IFeatureConfig.field_202429_e));
        }
    }

    public static void addIgloos(Biome biome, String biomeNamespace, String biomePath) {
        if (RepurposedStructures.RSMainConfig.grassyIglooSpawnrate.get() != 1001 && (biome.func_201856_r() == Biome.Category.FOREST || biome.func_201856_r() == Biome.Category.PLAINS) && (biomeNamespace.equals("minecraft") || RepurposedStructures.RSMainConfig.addGrassyIglooToModdedBiomes.get().booleanValue())) {
            biome.func_235063_a_(RSFeatures.GRASSY_IGLOO.func_236391_a_((IFeatureConfig)IFeatureConfig.field_202429_e));
        }
        if (RepurposedStructures.RSMainConfig.stoneIglooSpawnrate.get() != 1001) {
            String BiomeName = Registry.field_212624_m.func_177774_c((Object)biome).func_110623_a();
            if (biome.func_201856_r() == Biome.Category.TAIGA && BiomeName.contains("giant") && (biomeNamespace.equals("minecraft") || RepurposedStructures.RSMainConfig.addStoneIglooToModdedBiomes.get().booleanValue())) {
                biome.func_235063_a_(RSFeatures.STONE_IGLOO.func_236391_a_((IFeatureConfig)IFeatureConfig.field_202429_e));
            }
        }
    }

    public static void addVillages(Biome biome, String biomeNamespace, String biomePath) {
        if (biome.func_201856_r() == Biome.Category.MESA && !biomePath.contains("plateau") && (biomeNamespace.equals("minecraft") || RepurposedStructures.RSVillagesConfig.addVillagesToModdedBiomes.get().booleanValue())) {
            if (RepurposedStructures.RSVillagesConfig.badlandsVillageSpawnrate.get() != 1001) {
                biome.func_235063_a_(RSFeatures.BADLANDS_VILLAGE.func_236391_a_((IFeatureConfig)IFeatureConfig.field_202429_e));
            }
        } else if (biomePath.contains("birch") && (biomeNamespace.equals("minecraft") || RepurposedStructures.RSVillagesConfig.addVillagesToModdedBiomes.get().booleanValue())) {
            if (RepurposedStructures.RSVillagesConfig.birchVillageSpawnrate.get() != 1001) {
                biome.func_235063_a_(RSFeatures.BIRCH_VILLAGE.func_236391_a_((IFeatureConfig)IFeatureConfig.field_202429_e));
            }
        } else if (biomePath.contains("dark_forest") && (biomeNamespace.equals("minecraft") || RepurposedStructures.RSVillagesConfig.addVillagesToModdedBiomes.get().booleanValue())) {
            if (RepurposedStructures.RSVillagesConfig.darkForestVillageSpawnrate.get() != 1001) {
                biome.func_235063_a_(RSFeatures.DARK_FOREST_VILLAGE.func_236391_a_((IFeatureConfig)IFeatureConfig.field_202429_e));
            }
        } else if (biome.func_201856_r() == Biome.Category.JUNGLE && (biomeNamespace.equals("minecraft") || RepurposedStructures.RSVillagesConfig.addVillagesToModdedBiomes.get().booleanValue())) {
            if (RepurposedStructures.RSVillagesConfig.jungleVillageSpawnrate.get() != 1001) {
                biome.func_235063_a_(RSFeatures.JUNGLE_VILLAGE.func_236391_a_((IFeatureConfig)IFeatureConfig.field_202429_e));
                biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, RSFeatures.JUNGLE_STRUCTURES_VINES.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(RSPlacements.RS_VINE_PLACEMENT.func_227446_a_((IPlacementConfig)new CountRangeConfig(30, 0, 8, 16))));
            }
        } else if (biome.func_201856_r() == Biome.Category.SWAMP && (biomeNamespace.equals("minecraft") || RepurposedStructures.RSVillagesConfig.addVillagesToModdedBiomes.get().booleanValue())) {
            if (RepurposedStructures.RSVillagesConfig.swampVillageSpawnrate.get() != 1001) {
                biome.func_235063_a_(RSFeatures.SWAMP_VILLAGE.func_236391_a_((IFeatureConfig)IFeatureConfig.field_202429_e));
                biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, RSFeatures.SWAMP_VILLAGE_VINES.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(RSPlacements.RS_VINE_PLACEMENT.func_227446_a_((IPlacementConfig)new CountRangeConfig(30, 0, 8, 16))));
            }
        } else if (biome.func_201856_r() == Biome.Category.EXTREME_HILLS && (biomeNamespace.equals("minecraft") || RepurposedStructures.RSVillagesConfig.addVillagesToModdedBiomes.get().booleanValue())) {
            if (RepurposedStructures.RSVillagesConfig.mountainsVillageSpawnrate.get() != 1001) {
                biome.func_235063_a_(RSFeatures.MOUNTAINS_VILLAGE.func_236391_a_((IFeatureConfig)IFeatureConfig.field_202429_e));
            }
        } else if (biome == Biomes.field_185432_ad || biome == Biomes.field_150578_U || !biomeNamespace.equals("minecraft") && RepurposedStructures.RSVillagesConfig.addVillagesToModdedBiomes.get().booleanValue() && (biomePath.contains("giant") && biomePath.contains("taiga") || biomePath.contains("redwood"))) {
            if (RepurposedStructures.RSVillagesConfig.giantTaigaVillageSpawnrate.get() != 1001) {
                biome.func_235063_a_(RSFeatures.GIANT_TAIGA_VILLAGE.func_236391_a_((IFeatureConfig)IFeatureConfig.field_202429_e));
            }
        } else if (RepurposedStructures.RSVillagesConfig.crimsonVillageSpawnrate.get() != 1001 && biome.func_201856_r() == Biome.Category.NETHER && biomePath.contains("crimson") && (biomeNamespace.equals("minecraft") || RepurposedStructures.RSVillagesConfig.addVillagesToModdedBiomes.get().booleanValue())) {
            biome.func_235063_a_(RSFeatures.CRIMSON_VILLAGE.func_236391_a_((IFeatureConfig)IFeatureConfig.field_202429_e));
        } else if (RepurposedStructures.RSVillagesConfig.warpedVillageSpawnrate.get() != 1001 && biome.func_201856_r() == Biome.Category.NETHER && biomePath.contains("warped") && (biomeNamespace.equals("minecraft") || RepurposedStructures.RSVillagesConfig.addVillagesToModdedBiomes.get().booleanValue())) {
            biome.func_235063_a_(RSFeatures.WARPED_VILLAGE.func_236391_a_((IFeatureConfig)IFeatureConfig.field_202429_e));
        }
    }

    private static boolean serializeAndCompareFeature(ConfiguredFeature<?, ?> feature1, ConfiguredFeature<?, ?> feature2) {
        return feature1.field_222738_b instanceof DecoratedFeatureConfig && feature2.field_222738_b instanceof DecoratedFeatureConfig && ((DecoratedFeatureConfig)feature1.field_222738_b).field_214689_a.field_222737_a == ((DecoratedFeatureConfig)feature2.field_222738_b).field_214689_a.field_222737_a;
    }
}

