/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.configs;

import com.telepathicgrunt.repurposedstructures.utils.ConfigHelper;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class RSMainConfig {

    public static class RSConfigValues {
        public ConfigHelper.ConfigValueListener<Boolean> addLargeSwampTreeModdedBiomes;
        public ConfigHelper.ConfigValueListener<Boolean> addGiantBouldersModdedBiomes;
        public ConfigHelper.ConfigValueListener<Double> giantBouldersPerChunk;
        public ConfigHelper.ConfigValueListener<Integer> diamondChanceInGiantBoulders;
        public ConfigHelper.ConfigValueListener<Boolean> addTinyBouldersModdedBiomes;
        public ConfigHelper.ConfigValueListener<Boolean> boulderTiny;
        public ConfigHelper.ConfigValueListener<Boolean> boulderGiant;
        public ConfigHelper.ConfigValueListener<Boolean> hornedSwampTree;
        public ConfigHelper.ConfigValueListener<Integer> jungleFortressSpawnrate;
        public ConfigHelper.ConfigValueListener<Double> silverfishSpawnrateJF;
        public ConfigHelper.ConfigValueListener<Boolean> allowSilverfishSpawnerJF;
        public ConfigHelper.ConfigValueListener<Boolean> lootChestsJF;
        public ConfigHelper.ConfigValueListener<Boolean> addJungleFortressToModdedBiomes;
        public ConfigHelper.ConfigValueListener<Integer> grassyIglooSpawnrate;
        public ConfigHelper.ConfigValueListener<Boolean> addGrassyIglooToModdedBiomes;
        public ConfigHelper.ConfigValueListener<Integer> stoneIglooSpawnrate;
        public ConfigHelper.ConfigValueListener<Boolean> addStoneIglooToModdedBiomes;
        public ConfigHelper.ConfigValueListener<String> blacklistedSwampTreeBiomes;
        public ConfigHelper.ConfigValueListener<String> blacklistedBoulderBiomes;
        public ConfigHelper.ConfigValueListener<String> blacklistedFortressBiomes;
        public ConfigHelper.ConfigValueListener<String> blacklistedIglooBiomes;

        public RSConfigValues(ForgeConfigSpec.Builder builder, ConfigHelper.Subscriber subscriber) {
            builder.push("Feature Options");
            builder.push("Misc");
            this.addLargeSwampTreeModdedBiomes = subscriber.subscribe(builder.comment("\r\n Add 2x2 Swamp Trees to modded swamp biomes.").translation("repurposedstructures.config.misc.addlargeswamptreemoddedbiomes").define("addLargeSwampTreeModdedBiomes", true));
            this.addGiantBouldersModdedBiomes = subscriber.subscribe(builder.comment("\r\n Adds giant boulders to modded Giant Tree Taiga (or Redwood) biomes.").translation("repurposedstructures.config.misc.addgiantbouldersmoddedbiomes").define("addGiantBouldersModdedBiomes", false));
            this.blacklistedSwampTreeBiomes = subscriber.subscribe(builder.comment("\r\n Add the ID/resource location of the biome you don't want\r\n RS's 2x2 Swamp trees to spawn in. Separate each ID with a comma ,\r\n\r\nExample: \"minecraft:ice_spikes,awesome_mod:awesome_biome\"").translation("repurposedstructures.config.misc.blacklistedswamptreebiomes").define("blacklistedSwampTreeBiomes", (Object)""));
            this.blacklistedBoulderBiomes = subscriber.subscribe(builder.comment("\r\n Add the ID/resource location of the biome you don't want\r\n RS's boulders to spawn in. Separate each ID with a comma ,\r\n\r\nExample: \"minecraft:ice_spikes,awesome_mod:awesome_biome\"").translation("repurposedstructures.config.misc.blacklistedboulderbiomes").define("blacklistedBoulderBiomes", (Object)""));
            this.giantBouldersPerChunk = subscriber.subscribe(builder.comment("\r\n How many Giant Boulders per chunk. (Can be decimal too)").translation("repurposedstructures.config.misc.giantbouldersperchunk").defineInRange("giantBouldersPerChunk", 1.0, 0.0, 100.0));
            this.diamondChanceInGiantBoulders = subscriber.subscribe(builder.comment("\r\n 1 out of ___ chance of Diamond Ore when placing\n a block in giant Boulders. Lower number = more common.\n Enter 0 to disable Diamond Ores completely.").translation("repurposedstructures.config.misc.diamondchanceingiantboulders").defineInRange("diamondChanceInGiantBoulders", 7000, 0, 1000000));
            this.addTinyBouldersModdedBiomes = subscriber.subscribe(builder.comment("\r\n Adds tiny boulders to modded Taiga biomes.").translation("repurposedstructures.config.misc.addtinybouldersmoddedbiomes").define("addTinyBouldersModdedBiomes", false));
            this.boulderTiny = subscriber.subscribe(builder.comment("\r\n Adds tiny boulders to Taiga Mountains and Snowy Taiga Mountains biomes \r\n that can contain small amounts of Coal and Iron ores.").translation("repurposedstructures.config.misc.bouldertiny").define("boulderTiny", true));
            this.boulderGiant = subscriber.subscribe(builder.comment("\r\n Replaces boulders in Giant Tree Taiga Hills and Giant Spruce Taiga Hills\r\n biomes with a larger boulder that can contain Coal, Iron, and extremely\r\n rarely, can also have Diamond Ores.").translation("repurposedstructures.config.misc.netherdungeons").define("boulderGiant", true));
            this.hornedSwampTree = subscriber.subscribe(builder.comment("\r\n Adds a large tree somewhat uncommonly to Swamp biome and replaces\r\n all vanilla trees in Swamp Hills biome with the larger tree.").translation("repurposedstructures.config.misc.hornedswamptree").define("hornedSwampTree", true));
            builder.pop();
            builder.pop();
            builder.push("Structure Options");
            builder.push("Jungle Fortress");
            this.jungleFortressSpawnrate = subscriber.subscribe(builder.comment("\r\n How rare are Jungle Fortresses.\r\n \r\n 1 for spawning in most chunks and 1001 for no spawn.").translation("repurposedstructures.config.junglefortress.junglefortressspawnrate").defineInRange("jungleFortressSpawnrate", 32, 1, 1001));
            this.addJungleFortressToModdedBiomes = subscriber.subscribe(builder.comment("\r\n Add Jungle Fortress to modded jungle biomes.").translation("repurposedstructures.config.junglefortress.addjunglefortresstomoddedbiomes").define("addJungleFortressToModdedBiomes", true));
            this.blacklistedFortressBiomes = subscriber.subscribe(builder.comment("\r\n Add the ID/resource location of the biome you don't want\r\n RS's Jungle Fortresses to spawn in. Separate each ID with a comma ,\r\n\r\nExample: \"minecraft:ice_spikes,awesome_mod:awesome_biome\"").translation("repurposedstructures.config.junglefortress.blacklistedfortressbiomes").define("blacklistedFortressBiomes", (Object)""));
            this.silverfishSpawnrateJF = subscriber.subscribe(builder.comment("\r\n How often Silverfish Blocks will generate in Jungle Fortress as a percentage.\r\n Note: Mossy Stone Bricks block cannot be infected by Silverfish\n \r\n 0 for no Silverfish Blocks and 100 for max spawnrate.").translation("repurposedstructures.config.junglefortress.silverfishspawnratejf").defineInRange("silverfishSpawnrateJF", 0.5, 0.0, 100.0));
            this.allowSilverfishSpawnerJF = subscriber.subscribe(builder.comment("\r\n Silverfish Mob Spawners generate in Stone Fortresses.\r\n If turned off, the spawners will become Skeleton spawners.").translation("repurposedstructures.config.junglefortress.allowsilverfishspawnerjf").define("allowSilverfishSpawnerJF", true));
            this.lootChestsJF = subscriber.subscribe(builder.comment("\r\n Controls whether loot chests spawn or not in Jungle Fortresses.").translation("repurposedstructures.config.junglefortress.lootchestsjf").define("lootChestsJF", true));
            builder.pop();
            builder.push("Igloos");
            this.blacklistedIglooBiomes = subscriber.subscribe(builder.comment("\r\n Add the ID/resource location of the biome you don't want\r\n RS's Igloos to spawn in. Separate each ID with a comma ,\r\n\r\nExample: \"minecraft:ice_spikes,awesome_mod:awesome_biome\"").translation("repurposedstructures.config.igloo.blacklistedigloobiomes").define("blacklistedIglooBiomes", (Object)""));
            this.grassyIglooSpawnrate = subscriber.subscribe(builder.comment("\r\n How rare are Grassy Igloos in Plains and Forests.\n \r\n 1 for spawning in most chunks and 1001 for no spawn.").translation("repurposedstructures.config.igloo.grassyigloospawnrate").defineInRange("grassyIglooSpawnrate", 20, 1, 1001));
            this.addGrassyIglooToModdedBiomes = subscriber.subscribe(builder.comment("\r\n Add Grassy Igloos to modded biomes that are\r\n most likely grassy fields or temperate forests.").translation("repurposedstructures.config.igloo.addgrassyiglootomoddedbiomes").define("addGrassyIglooToModdedBiomes", true));
            this.stoneIglooSpawnrate = subscriber.subscribe(builder.comment("\r\n How rare are Stone Igloos in Giant Tree Taiga biomes.\n \r\n 1 for spawning in most chunks and 1001 for no spawn.").translation("repurposedstructures.config.igloo.stoneigloospawnrate").defineInRange("stoneIglooSpawnrate", 20, 1, 1001));
            this.addStoneIglooToModdedBiomes = subscriber.subscribe(builder.comment("\r\n Add Stone Igloos to modded biomes that are\r\n most likely Giant Tree Taiga variants.").translation("repurposedstructures.config.igloo.addstoneiglootomoddedbiomes").define("addStoneIglooToModdedBiomes", true));
            builder.pop();
            builder.pop();
        }
    }
}

