/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.features;

import com.mojang.serialization.Codec;
import com.telepathicgrunt.repurposedstructures.RepurposedStructures;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.StairsBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityType;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.tileentity.MobSpawnerTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DungeonOcean
extends Feature<NoFeatureConfig> {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final BlockState WATER = Blocks.field_150355_j.func_176223_P();
    private static final BlockState PRISMARINE = Blocks.field_180397_cI.func_176223_P();
    private static final BlockState PRISMARINE_BRICKS = Blocks.field_196779_gQ.func_176223_P();
    private static final BlockState PRISMARINE_WALL = Blocks.field_222460_lx.func_176223_P();
    private static final BlockState DARK_PRISMARINE_STAIRS = Blocks.field_203212_hg.func_176223_P();
    private static final BlockState DARK_PRISMARINE = Blocks.field_196781_gR.func_176223_P();
    private static final BlockState MAGMA_BLOCK = Blocks.field_196814_hQ.func_176223_P();
    private static final ResourceLocation CHEST_LOOT = new ResourceLocation("repurposed_structures:chests/dungeon_ocean");
    private static final ResourceLocation FROZEN_SPAWNER_ID = new ResourceLocation("repurposed_structures:dungeon_ocean_frozen");
    private static final ResourceLocation COLD_SPAWNER_ID = new ResourceLocation("repurposed_structures:dungeon_ocean_cold");
    private static final ResourceLocation NEUTRAL_SPAWNER_ID = new ResourceLocation("repurposed_structures:dungeon_ocean_neutral");
    private static final ResourceLocation LUKEWARM_SPAWNER_ID = new ResourceLocation("repurposed_structures:dungeon_ocean_lukewarm");
    private static final ResourceLocation WARM_SPAWNER_ID = new ResourceLocation("repurposed_structures:dungeon_ocean_warm");
    private static final ResourceLocation MISC_SPAWNER_ID = new ResourceLocation("repurposed_structures:dungeon_ocean_misc");

    public DungeonOcean(Codec<NoFeatureConfig> configFactory) {
        super(configFactory);
    }

    public boolean generate(ISeedReader world, StructureManager structureAccessor, ChunkGenerator chunkGenerator, Random random, BlockPos position, NoFeatureConfig config) {
        int z;
        int randXRange = random.nextInt(2) + 2;
        int xMin = -randXRange - 1;
        int xMax = randXRange + 1;
        int randZRange = random.nextInt(2) + 2;
        int zMin = -randZRange - 1;
        int zMax = randZRange + 1;
        int validOpenings = 0;
        int ceilingOpenings = 0;
        boolean validSpot = false;
        boolean oceanFloor = false;
        BlockPos.Mutable blockpos$Mutable = new BlockPos.Mutable().func_189533_g((Vector3i)position);
        int terrainHeight = world.func_201676_a(Heightmap.Type.OCEAN_FLOOR_WG, blockpos$Mutable.func_177958_n(), blockpos$Mutable.func_177952_p());
        if (terrainHeight - blockpos$Mutable.func_177956_o() > 1 && terrainHeight - blockpos$Mutable.func_177956_o() < 5) {
            oceanFloor = true;
        }
        for (int x = xMin; x <= xMax; ++x) {
            for (int y = -1; y <= 4; ++y) {
                for (z = zMin; z <= zMax; ++z) {
                    boolean flag;
                    blockpos$Mutable.func_189533_g((Vector3i)position).func_196234_d(x, y, z);
                    Material material = world.func_180495_p((BlockPos)blockpos$Mutable).func_185904_a();
                    boolean bl = flag = material.func_76220_a() || material == Material.field_151586_h;
                    if (y == -1 && !flag) {
                        return false;
                    }
                    if (y == 4 && !flag) {
                        ++ceilingOpenings;
                    }
                    if (x != xMin && x != xMax && z != zMin && z != zMax || y != 0 || world.func_180495_p((BlockPos)blockpos$Mutable).func_185904_a() != Material.field_151586_h || world.func_180495_p(blockpos$Mutable.func_177984_a()).func_185904_a() != Material.field_151586_h) continue;
                    ++validOpenings;
                }
            }
        }
        boolean bl = oceanFloor ? random.nextFloat() < 0.1f : (validSpot = validOpenings >= 2 && validOpenings <= 6 && ceilingOpenings < 2);
        if (validSpot) {
            int x;
            for (x = xMin; x <= xMax; ++x) {
                for (int y = 4; y >= -1; --y) {
                    for (int z2 = zMin; z2 <= zMax; ++z2) {
                        blockpos$Mutable.func_189533_g((Vector3i)position).func_196234_d(x, y, z2);
                        BlockState currentBlock = world.func_180495_p((BlockPos)blockpos$Mutable);
                        if (x != xMin && y != -1 && z2 != zMin && x != xMax && y != 5 && z2 != zMax) {
                            if (y == 4) {
                                if (!currentBlock.func_200132_m()) continue;
                                if (random.nextInt(3) < 2) {
                                    world.func_180501_a((BlockPos)blockpos$Mutable, PRISMARINE, 2);
                                    continue;
                                }
                                world.func_180501_a((BlockPos)blockpos$Mutable, PRISMARINE_BRICKS, 2);
                                continue;
                            }
                            if (currentBlock.func_177230_c() != Blocks.field_150486_ae && currentBlock.func_177230_c() != Blocks.field_150474_ac && currentBlock.func_177230_c() != Blocks.field_196781_gR && currentBlock.func_177230_c() != Blocks.field_203212_hg) {
                                if (blockpos$Mutable.func_177956_o() < world.func_181545_F()) {
                                    world.func_180501_a((BlockPos)blockpos$Mutable, WATER, 2);
                                } else {
                                    world.func_180501_a((BlockPos)blockpos$Mutable, Blocks.field_150350_a.func_176223_P(), 2);
                                }
                            }
                            if ((currentBlock = world.func_180495_p(blockpos$Mutable.func_177984_a())).func_185904_a() != Material.field_203243_f) continue;
                            if (blockpos$Mutable.func_177956_o() + 1 < world.func_181545_F()) {
                                world.func_180501_a((BlockPos)blockpos$Mutable, WATER, 2);
                                continue;
                            }
                            world.func_180501_a((BlockPos)blockpos$Mutable, Blocks.field_150350_a.func_176223_P(), 2);
                            continue;
                        }
                        if (blockpos$Mutable.func_177956_o() >= 0 && !world.func_180495_p(blockpos$Mutable.func_177977_b()).func_185904_a().func_76220_a()) {
                            if (currentBlock.func_177230_c() == Blocks.field_150486_ae || currentBlock.func_177230_c() == Blocks.field_150474_ac || currentBlock.func_177230_c() == Blocks.field_196781_gR || currentBlock.func_177230_c() == Blocks.field_203212_hg) continue;
                            if (blockpos$Mutable.func_177956_o() < world.func_181545_F()) {
                                world.func_180501_a((BlockPos)blockpos$Mutable, WATER, 2);
                                continue;
                            }
                            world.func_180501_a((BlockPos)blockpos$Mutable, Blocks.field_150350_a.func_176223_P(), 2);
                            continue;
                        }
                        if (!currentBlock.func_185904_a().func_76220_a() || currentBlock.func_177230_c() == Blocks.field_150486_ae || currentBlock.func_177230_c() == Blocks.field_150474_ac) continue;
                        if (y == -1) {
                            if (random.nextInt(10) == 0) {
                                world.func_180501_a((BlockPos)blockpos$Mutable, MAGMA_BLOCK, 2);
                                continue;
                            }
                            if (random.nextInt(2) == 0) {
                                world.func_180501_a((BlockPos)blockpos$Mutable, PRISMARINE, 2);
                                continue;
                            }
                            world.func_180501_a((BlockPos)blockpos$Mutable, PRISMARINE_BRICKS, 2);
                            continue;
                        }
                        if (random.nextInt(3) <= 1) {
                            world.func_180501_a((BlockPos)blockpos$Mutable, PRISMARINE, 2);
                            continue;
                        }
                        currentBlock = world.func_180495_p((BlockPos)blockpos$Mutable);
                        world.func_180501_a((BlockPos)blockpos$Mutable, (BlockState)PRISMARINE_WALL.func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(blockpos$Mutable.func_177956_o() < world.func_181545_F())), 3);
                    }
                }
            }
            block6: for (int l3 = 0; l3 < 2; ++l3) {
                for (int j4 = 0; j4 < 3; ++j4) {
                    int x2 = position.func_177958_n() + random.nextInt(randXRange * 2 + 1) - randXRange;
                    int y = position.func_177956_o();
                    int z3 = position.func_177952_p() + random.nextInt(randZRange * 2 + 1) - randZRange;
                    blockpos$Mutable.func_181079_c(x2, y, z3);
                    BlockState currentBlock = world.func_180495_p((BlockPos)blockpos$Mutable);
                    if (currentBlock.func_185904_a() != Material.field_151586_h && currentBlock.func_185904_a() != Material.field_151579_a) continue;
                    int j3 = 0;
                    for (Direction direction : Direction.Plane.HORIZONTAL) {
                        Material neighboringMaterial = world.func_180495_p(blockpos$Mutable.func_177972_a(direction)).func_185904_a();
                        if (!neighboringMaterial.func_76220_a()) continue;
                        ++j3;
                    }
                    if (j3 != true) continue;
                    world.func_180501_a((BlockPos)blockpos$Mutable, StructurePiece.func_197528_a((IBlockReader)world, (BlockPos)blockpos$Mutable, (BlockState)((BlockState)Blocks.field_150486_ae.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(blockpos$Mutable.func_177956_o() < world.func_181545_F())))), 3);
                    LockableLootTileEntity.func_195479_a((IBlockReader)world, (Random)random, (BlockPos)blockpos$Mutable, (ResourceLocation)CHEST_LOOT);
                    continue block6;
                }
            }
            for (x = -1; x <= 1; ++x) {
                for (z = -1; z <= 1; ++z) {
                    blockpos$Mutable.func_189533_g((Vector3i)position).func_196234_d(x, -1, z);
                    BlockState currentBlock = world.func_180495_p((BlockPos)blockpos$Mutable);
                    if (currentBlock.func_177230_c() != Blocks.field_150486_ae && currentBlock.func_177230_c() != Blocks.field_150474_ac) {
                        world.func_180501_a((BlockPos)blockpos$Mutable, DARK_PRISMARINE, 2);
                    }
                    blockpos$Mutable.func_189536_c(Direction.DOWN);
                    currentBlock = world.func_180495_p((BlockPos)blockpos$Mutable);
                    if (currentBlock.func_177230_c() == Blocks.field_150486_ae || currentBlock.func_177230_c() == Blocks.field_150474_ac) continue;
                    world.func_180501_a((BlockPos)blockpos$Mutable, DARK_PRISMARINE, 2);
                }
            }
            blockpos$Mutable.func_189533_g((Vector3i)position).func_189536_c(Direction.DOWN);
            if (blockpos$Mutable.func_177956_o() < world.func_181545_F()) {
                world.func_180501_a((BlockPos)blockpos$Mutable, WATER, 2);
            }
            world.func_180501_a((BlockPos)blockpos$Mutable, Blocks.field_150350_a.func_176223_P(), 2);
            world.func_180501_a((BlockPos)blockpos$Mutable, Blocks.field_150474_ac.func_176223_P(), 2);
            TileEntity tileentity = world.func_175625_s((BlockPos)blockpos$Mutable);
            if (tileentity instanceof MobSpawnerTileEntity) {
                ((MobSpawnerTileEntity)tileentity).func_145881_a().func_200876_a(DungeonOcean.pickMobSpawner(world, random, (BlockPos)blockpos$Mutable));
            } else {
                LOGGER.error("Failed to fetch mob spawner entity at ({}, {}, {})", new Object[]{blockpos$Mutable.func_177958_n(), blockpos$Mutable.func_177956_o(), blockpos$Mutable.func_177952_p()});
            }
            BlockState currentBlock = world.func_180495_p((BlockPos)blockpos$Mutable.func_189536_c(Direction.UP));
            if (currentBlock.func_177230_c() != Blocks.field_150486_ae && currentBlock.func_177230_c() != Blocks.field_150474_ac) {
                world.func_180501_a((BlockPos)blockpos$Mutable, (BlockState)PRISMARINE_WALL.func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(blockpos$Mutable.func_177956_o() < world.func_181545_F())), 2);
            }
            if ((currentBlock = world.func_180495_p((BlockPos)blockpos$Mutable.func_189536_c(Direction.UP))).func_177230_c() != Blocks.field_150486_ae && currentBlock.func_177230_c() != Blocks.field_150474_ac) {
                world.func_180501_a((BlockPos)blockpos$Mutable, (BlockState)PRISMARINE_WALL.func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(blockpos$Mutable.func_177956_o() < world.func_181545_F())), 2);
            }
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                blockpos$Mutable.func_189533_g((Vector3i)position).func_189536_c(direction);
                currentBlock = world.func_180495_p((BlockPos)blockpos$Mutable);
                if (currentBlock.func_177230_c() == Blocks.field_150486_ae || currentBlock.func_177230_c() == Blocks.field_150474_ac) continue;
                world.func_180501_a((BlockPos)blockpos$Mutable, (BlockState)((BlockState)DARK_PRISMARINE_STAIRS.func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(blockpos$Mutable.func_177956_o() < world.func_181545_F()))).func_206870_a((Property)StairsBlock.field_176309_a, (Comparable)direction.func_176734_d()), 2);
            }
            return true;
        }
        return false;
    }

    private static EntityType<?> pickMobSpawner(ISeedReader world, Random random, BlockPos position) {
        Biome biome = world.func_226691_t_(position);
        if (biome.func_201856_r() == Biome.Category.OCEAN) {
            String biomeName = Registry.field_212624_m.func_177774_c((Object)biome).func_110623_a();
            float biomeTemp = biome.func_185353_n();
            if ((double)biomeTemp < 0.0 || biomeName.contains("frozen") || biomeName.contains("snow") || biomeName.contains("ice")) {
                return RepurposedStructures.mobSpawnerManager.getSpawnerMob(FROZEN_SPAWNER_ID, random);
            }
            if ((double)biomeTemp < 0.5 || biomeName.contains("cold")) {
                return RepurposedStructures.mobSpawnerManager.getSpawnerMob(COLD_SPAWNER_ID, random);
            }
            if ((double)biomeTemp > 0.5 || biomeName.equals("ocean") || biomeName.equals("deep_ocean")) {
                return RepurposedStructures.mobSpawnerManager.getSpawnerMob(NEUTRAL_SPAWNER_ID, random);
            }
            if ((double)biomeTemp >= 0.9 || biomeName.contains("lukewarm")) {
                return RepurposedStructures.mobSpawnerManager.getSpawnerMob(LUKEWARM_SPAWNER_ID, random);
            }
            if ((double)biomeTemp >= 1.5 || biomeName.contains("warm") || biomeName.contains("hot") || biomeName.contains("tropic")) {
                return RepurposedStructures.mobSpawnerManager.getSpawnerMob(WARM_SPAWNER_ID, random);
            }
        }
        return RepurposedStructures.mobSpawnerManager.getSpawnerMob(MISC_SPAWNER_ID, random);
    }
}

