/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.structures;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import com.telepathicgrunt.repurposedstructures.RSFeatures;
import com.telepathicgrunt.repurposedstructures.world.structures.AbstractBaseStructure;
import com.telepathicgrunt.repurposedstructures.world.structures.pieces.FortressJunglePieces;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.EntityType;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class FortressJungleStructure
extends AbstractBaseStructure {
    private static final List<Biome.SpawnListEntry> MONSTER_SPAWNS = Lists.newArrayList((Object[])new Biome.SpawnListEntry[]{new Biome.SpawnListEntry(EntityType.field_200722_aA, 27, 1, 1)});

    public FortressJungleStructure(Codec<NoFeatureConfig> codec) {
        super(codec);
    }

    protected boolean shouldStartAt(ChunkGenerator chunkGenerator, BiomeProvider biomeSource, long l, SharedSeedRandom chunkRandom, int chunkX, int chunkZ, Biome biome, ChunkPos chunkPos, NoFeatureConfig NoFeatureConfig2) {
        for (int curChunkX = chunkX - 2; curChunkX <= chunkX + 2; curChunkX += 2) {
            for (int curChunkZ = chunkZ - 2; curChunkZ <= chunkZ + 2; curChunkZ += 2) {
                if (biomeSource.func_225526_b_(curChunkX << 2, 60, curChunkZ << 2).func_201858_a(RSFeatures.JUNGLE_FORTRESS)) continue;
                return false;
            }
        }
        return true;
    }

    public Structure.IStartFactory<NoFeatureConfig> func_214557_a() {
        return Start::new;
    }

    public List<Biome.SpawnListEntry> func_202279_e() {
        return MONSTER_SPAWNS;
    }

    public static class Start
    extends StructureStart<NoFeatureConfig> {
        public Start(Structure<NoFeatureConfig> structureIn, int chunkX, int chunkZ, MutableBoundingBox mutableBoundingBox, int referenceIn, long seedIn) {
            super(structureIn, chunkX, chunkZ, mutableBoundingBox, referenceIn, seedIn);
        }

        public void init(ChunkGenerator chunkGenerator, TemplateManager structureManager, int chunkX, int chunkZ, Biome biome, NoFeatureConfig NoFeatureConfig2) {
            FortressJunglePieces.Start fortresspieces$start = new FortressJunglePieces.Start((Random)this.field_214631_d, (chunkX << 4) + 2, (chunkZ << 4) + 2);
            this.field_75075_a.add(fortresspieces$start);
            fortresspieces$start.func_74861_a(fortresspieces$start, this.field_75075_a, (Random)this.field_214631_d);
            List<StructurePiece> list = fortresspieces$start.pendingChildren;
            while (!list.isEmpty()) {
                int i = this.field_214631_d.nextInt(list.size());
                StructurePiece structurepiece = list.remove(i);
                structurepiece.func_74861_a((StructurePiece)fortresspieces$start, this.field_75075_a, (Random)this.field_214631_d);
            }
            this.func_202500_a();
            this.func_214626_a((Random)this.field_214631_d, 55, 60);
        }
    }
}

