/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.structures;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.telepathicgrunt.repurposedstructures.world.structures.pieces.GeneralJigsawGenerator;
import com.telepathicgrunt.repurposedstructures.world.structures.pieces.PyramidFloorPiece;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.jigsaw.JigsawManager;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.jigsaw.SingleJigsawPiece;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class PyramidBadlandsStructure
extends Structure<NoFeatureConfig> {
    private static boolean INITIALIZED_POOLS = false;

    private static void initPools() {
        JigsawManager.field_214891_a.func_214932_a(new JigsawPattern(new ResourceLocation("repurposed_structures", "temples/pyramid_badlands"), new ResourceLocation("empty"), (List)ImmutableList.of((Object)Pair.of((Object)new SingleJigsawPiece("repurposed_structures:temples/pyramid_badlands_body", new ArrayList()), (Object)1)), JigsawPattern.PlacementBehaviour.RIGID));
        JigsawManager.field_214891_a.func_214932_a(new JigsawPattern(new ResourceLocation("repurposed_structures", "temples/pyramid_badlands_pit"), new ResourceLocation("empty"), (List)ImmutableList.of((Object)Pair.of((Object)new SingleJigsawPiece("repurposed_structures:temples/pyramid_badlands_pit", new ArrayList()), (Object)1)), JigsawPattern.PlacementBehaviour.RIGID));
    }

    public PyramidBadlandsStructure(Codec<NoFeatureConfig> config) {
        super(config);
    }

    public Structure.IStartFactory<NoFeatureConfig> func_214557_a() {
        return Start::new;
    }

    public static class Start
    extends StructureStart<NoFeatureConfig> {
        private static final ResourceLocation BADLANDS_PYRAMID_POOL = new ResourceLocation("repurposed_structures", "temples/pyramid_badlands");

        public Start(Structure<NoFeatureConfig> structureIn, int chunkX, int chunkZ, MutableBoundingBox mutableBoundingBox, int referenceIn, long seedIn) {
            super(structureIn, chunkX, chunkZ, mutableBoundingBox, referenceIn, seedIn);
        }

        public void init(ChunkGenerator chunkGenerator, TemplateManager structureManager, int chunkX, int chunkZ, Biome biome, NoFeatureConfig NoFeatureConfig2) {
            if (!INITIALIZED_POOLS) {
                PyramidBadlandsStructure.initPools();
                INITIALIZED_POOLS = true;
            }
            BlockPos blockpos = new BlockPos(chunkX * 16, 62, chunkZ * 16);
            GeneralJigsawGenerator.addPieces(chunkGenerator, structureManager, blockpos, this.field_75075_a, this.field_214631_d, BADLANDS_PYRAMID_POOL, 1);
            PyramidFloorPiece.func_207617_a(structureManager, blockpos, ((StructurePiece)this.field_75075_a.get(0)).func_214809_Y_(), this.field_75075_a, (Random)this.field_214631_d, Blocks.field_180395_cM, NoFeatureConfig2);
            StructurePiece temp = (StructurePiece)this.field_75075_a.get(1);
            this.field_75075_a.remove(1);
            this.field_75075_a.add(temp);
            ((StructurePiece)this.field_75075_a.get(1)).func_74874_b().func_78888_b(((StructurePiece)this.field_75075_a.get(0)).func_74874_b());
            this.func_202500_a();
            Rotation rotation = ((StructurePiece)this.field_75075_a.get(0)).func_214809_Y_();
            BlockPos maxCorner = new BlockPos(((StructurePiece)this.field_75075_a.get(0)).func_74874_b().func_78883_b(), 0, ((StructurePiece)this.field_75075_a.get(0)).func_74874_b().func_78880_d()).func_190942_a(rotation);
            int highestLandPos = chunkGenerator.func_222529_a(blockpos.func_177958_n() + maxCorner.func_177958_n(), blockpos.func_177952_p() + maxCorner.func_177952_p(), Heightmap.Type.WORLD_SURFACE_WG);
            highestLandPos = Math.min(highestLandPos, chunkGenerator.func_222529_a(blockpos.func_177958_n(), blockpos.func_177952_p() + maxCorner.func_177952_p(), Heightmap.Type.WORLD_SURFACE_WG));
            highestLandPos = Math.min(highestLandPos, chunkGenerator.func_222529_a(blockpos.func_177958_n() + maxCorner.func_177958_n(), blockpos.func_177952_p(), Heightmap.Type.WORLD_SURFACE_WG));
            highestLandPos = Math.min(highestLandPos, chunkGenerator.func_222529_a(blockpos.func_177958_n(), blockpos.func_177952_p(), Heightmap.Type.WORLD_SURFACE_WG));
            this.func_214626_a((Random)this.field_214631_d, highestLandPos - 15, highestLandPos - 14);
        }
    }
}

