/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.structures;

import com.mojang.serialization.Codec;
import com.telepathicgrunt.repurposedstructures.world.structures.AbstractNetherStructure;
import com.telepathicgrunt.repurposedstructures.world.structures.pieces.GeneralJigsawGenerator;
import com.telepathicgrunt.repurposedstructures.world.structures.pieces.TempleNetherPools;
import java.util.Random;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class TempleNetherStructure
extends Structure<NoFeatureConfig> {
    private final ResourceLocation PIECE_RL;
    private static boolean INITIALIZED_POOLS = false;

    public TempleNetherStructure(Codec<NoFeatureConfig> config, ResourceLocation pieceRL) {
        super(config);
        this.PIECE_RL = pieceRL;
    }

    public Structure.IStartFactory<NoFeatureConfig> func_214557_a() {
        return (x$0, x$1, x$2, x$3, x$4, x$5) -> new Start((Structure<NoFeatureConfig>)x$0, x$1, x$2, x$3, x$4, x$5);
    }

    public class Start
    extends AbstractNetherStructure.AbstractStart {
        public Start(Structure<NoFeatureConfig> structureFeature, int x, int z, MutableBoundingBox blockBox, int referenceIn, long seed) {
            super(structureFeature, x, z, blockBox, referenceIn, seed);
        }

        public void init(ChunkGenerator chunkGenerator, TemplateManager structureManager, int x, int z, Biome biome, NoFeatureConfig NoFeatureConfig2) {
            if (!INITIALIZED_POOLS) {
                TempleNetherPools.initPools();
                INITIALIZED_POOLS = true;
            }
            BlockPos blockPos = new BlockPos(x * 16, 35, z * 16);
            GeneralJigsawGenerator.addPieces(chunkGenerator, structureManager, blockPos, this.field_75075_a, this.field_214631_d, TempleNetherStructure.this.PIECE_RL, 1);
            this.func_202500_a();
            BlockPos lowestLandPos = this.getLowestLand(chunkGenerator);
            if (lowestLandPos.func_177956_o() >= 108 || lowestLandPos.func_177956_o() <= 33) {
                this.func_214626_a((Random)this.field_214631_d, 16, 17);
            } else {
                this.func_214626_a((Random)this.field_214631_d, lowestLandPos.func_177956_o() - 16, lowestLandPos.func_177956_o() - 15);
            }
        }
    }
}

