/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.structures;

import com.mojang.serialization.Codec;
import com.telepathicgrunt.repurposedstructures.RSFeatures;
import com.telepathicgrunt.repurposedstructures.world.structures.AbstractBaseStructure;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.MarginedStructureStart;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.structure.VillageConfig;
import net.minecraft.world.gen.feature.structure.VillagePieces;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.gen.settings.StructureSeparationSettings;

public class VillageBaseStructure
extends Structure<NoFeatureConfig> {
    private static boolean INITIALIZED_POOLS = false;
    private final ResourceLocation POOL_RL;
    private final int STRUCTURE_SIZE;

    public VillageBaseStructure(Codec<NoFeatureConfig> config, ResourceLocation poolRL, int structureSize) {
        super(config);
        this.POOL_RL = poolRL;
        this.STRUCTURE_SIZE = structureSize;
    }

    protected boolean shouldStartAt(ChunkGenerator chunkGenerator, BiomeProvider biomeSource, long seed, SharedSeedRandom chunkRandom, int chunkX, int chunkZ, Biome biome, ChunkPos chunkPos, NoFeatureConfig NoFeatureConfig2) {
        for (int curChunkX = chunkX - 1; curChunkX <= chunkX + 1; ++curChunkX) {
            for (int curChunkZ = chunkZ - 1; curChunkZ <= chunkZ + 1; ++curChunkZ) {
                if (biomeSource.func_225526_b_(curChunkX << 2, 60, curChunkZ << 2).func_201858_a((Structure)this)) continue;
                return false;
            }
        }
        return true;
    }

    public Structure.IStartFactory<NoFeatureConfig> func_214557_a() {
        return (x$0, x$1, x$2, x$3, x$4, x$5) -> new MainStart((Structure<NoFeatureConfig>)x$0, x$1, x$2, x$3, x$4, x$5);
    }

    public BlockPos func_236388_a_(IWorldReader worldView, StructureManager structureAccessor, BlockPos blockPos, int radius, boolean skipExistingChunks, long seed, StructureSeparationSettings structureConfig) {
        return AbstractBaseStructure.locateStructureFast(worldView, structureAccessor, blockPos, radius, skipExistingChunks, seed, structureConfig, this);
    }

    public class MainStart
    extends MarginedStructureStart<NoFeatureConfig> {
        public MainStart(Structure<NoFeatureConfig> structureIn, int chunkX, int chunkZ, MutableBoundingBox mutableBoundingBox, int referenceIn, long seedIn) {
            super(structureIn, chunkX, chunkZ, mutableBoundingBox, referenceIn, seedIn);
        }

        public void init(ChunkGenerator chunkGenerator, TemplateManager structureManager, int chunkX, int chunkZ, Biome biome, NoFeatureConfig NoFeatureConfig2) {
            if (!INITIALIZED_POOLS) {
                RSFeatures.registerVillagePools();
                INITIALIZED_POOLS = true;
            }
            BlockPos blockpos = new BlockPos(chunkX * 16, 0, chunkZ * 16);
            VillagePieces.func_214838_a((ChunkGenerator)chunkGenerator, (TemplateManager)structureManager, (BlockPos)blockpos, (List)this.field_75075_a, (SharedSeedRandom)this.field_214631_d, (VillageConfig)new VillageConfig(VillageBaseStructure.this.POOL_RL, VillageBaseStructure.this.STRUCTURE_SIZE));
            this.func_202500_a();
        }
    }
}

