/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.structures.pieces;

import com.google.common.collect.Lists;
import com.telepathicgrunt.repurposedstructures.RepurposedStructures;
import com.telepathicgrunt.repurposedstructures.world.structures.pieces.StructurePieces;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FourWayBlock;
import net.minecraft.block.StairsBlock;
import net.minecraft.block.material.Material;
import net.minecraft.fluid.Fluids;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.MobSpawnerTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class FortressJunglePieces {
    private static final ResourceLocation JF_HALLWAY_CHEST_RL = new ResourceLocation("repurposed_structures:chests/fortress_jungle_hallway_chest");
    private static final ResourceLocation JF_SHRINE_CHEST_RL = new ResourceLocation("repurposed_structures:chests/fortress_jungle_shrine_chest");
    private static final ResourceLocation JF_CENTER_CHEST_RL = new ResourceLocation("repurposed_structures:chests/fortress_jungle_center_chest");
    private static final ResourceLocation JF_PLANT_TAG_RL = new ResourceLocation("repurposed_structures:jungle_fortress_staircase_plants");
    private static final ResourceLocation JF_SOIL_TAG_RL = new ResourceLocation("repurposed_structures:jungle_fortress_staircase_soils");
    private static final ResourceLocation SPAWNER_ID = new ResourceLocation("repurposed_structures:fortress_jungle");
    private static final Map<BlockState, BlockState> INFESTED_STONE_LOOKUP = new HashMap<BlockState, BlockState>();
    private static final PieceWeight[] PRIMARY_COMPONENTS;
    private static final PieceWeight[] SECONDARY_COMPONENTS;

    private static Piece findAndCreateBridgePieceFactory(PieceWeight p_175887_0_, List<StructurePiece> structurePieceList, Random random, int x, int y, int z, Direction direction, int depth) {
        Class<? extends Piece> oclass = p_175887_0_.weightClass;
        Piece structurenetherbridgepieces$piece = null;
        if (oclass == Straight.class) {
            structurenetherbridgepieces$piece = Straight.createPiece(structurePieceList, random, x, y, z, direction, depth);
        } else if (oclass == Crossing3.class) {
            structurenetherbridgepieces$piece = Crossing3.createPiece(structurePieceList, random, x, y, z, direction, depth);
        } else if (oclass == Crossing.class) {
            structurenetherbridgepieces$piece = Crossing.createPiece(structurePieceList, random, x, y, z, direction, depth);
        } else if (oclass == Stairs.class) {
            structurenetherbridgepieces$piece = Stairs.createPiece(structurePieceList, random, x, y, z, depth, direction);
        } else if (oclass == Throne.class) {
            structurenetherbridgepieces$piece = Throne.createPiece(structurePieceList, random, x, y, z, depth, direction);
        } else if (oclass == Entrance.class) {
            structurenetherbridgepieces$piece = Entrance.createPiece(structurePieceList, random, x, y, z, direction, depth);
        } else if (oclass == Corridor5.class) {
            structurenetherbridgepieces$piece = Corridor5.createPiece(structurePieceList, random, x, y, z, direction, depth);
        } else if (oclass == Corridor2.class) {
            structurenetherbridgepieces$piece = Corridor2.createPiece(structurePieceList, random, x, y, z, direction, depth);
        } else if (oclass == Corridor.class) {
            structurenetherbridgepieces$piece = Corridor.createPiece(structurePieceList, random, x, y, z, direction, depth);
        } else if (oclass == Corridor3.class) {
            structurenetherbridgepieces$piece = Corridor3.createPiece(structurePieceList, random, x, y, z, direction, depth);
        } else if (oclass == Corridor4.class) {
            structurenetherbridgepieces$piece = Corridor4.createPiece(structurePieceList, random, x, y, z, direction, depth);
        } else if (oclass == Crossing2.class) {
            structurenetherbridgepieces$piece = Crossing2.createPiece(structurePieceList, random, x, y, z, direction, depth);
        } else if (oclass == MushroomRoom.class) {
            structurenetherbridgepieces$piece = MushroomRoom.createPiece(structurePieceList, random, x, y, z, direction, depth);
        }
        return structurenetherbridgepieces$piece;
    }

    static {
        INFESTED_STONE_LOOKUP.put(Blocks.field_196696_di.func_176223_P(), Blocks.field_196688_de.func_176223_P());
        INFESTED_STONE_LOOKUP.put(Blocks.field_150348_b.func_176223_P(), Blocks.field_196686_dc.func_176223_P());
        INFESTED_STONE_LOOKUP.put(Blocks.field_150341_Y.func_176223_P(), Blocks.field_196690_df.func_176223_P());
        INFESTED_STONE_LOOKUP.put(Blocks.field_196700_dk.func_176223_P(), Blocks.field_196692_dg.func_176223_P());
        INFESTED_STONE_LOOKUP.put(Blocks.field_150347_e.func_176223_P(), Blocks.field_196687_dd.func_176223_P());
        INFESTED_STONE_LOOKUP.put(Blocks.field_196702_dl.func_176223_P(), Blocks.field_196694_dh.func_176223_P());
        INFESTED_STONE_LOOKUP.put(Blocks.field_196698_dj.func_176223_P(), Blocks.field_196698_dj.func_176223_P());
        PRIMARY_COMPONENTS = new PieceWeight[]{new PieceWeight(Straight.class, 30, 0, true), new PieceWeight(Crossing3.class, 10, 4), new PieceWeight(Crossing.class, 10, 4), new PieceWeight(Stairs.class, 10, 3), new PieceWeight(Throne.class, 5, 2), new PieceWeight(Entrance.class, 5, 1)};
        SECONDARY_COMPONENTS = new PieceWeight[]{new PieceWeight(Corridor5.class, 25, 0, true), new PieceWeight(Crossing2.class, 15, 5), new PieceWeight(Corridor2.class, 5, 10), new PieceWeight(Corridor.class, 5, 10), new PieceWeight(Corridor3.class, 10, 3, true), new PieceWeight(Corridor4.class, 7, 2), new PieceWeight(MushroomRoom.class, 5, 2)};
    }

    static class PieceWeight {
        public Class<? extends Piece> weightClass;
        public final int weight;
        public int placeCount;
        public int maxPlaceCount;
        public boolean allowInRow;

        public PieceWeight(Class<? extends Piece> weightClass, int weight, int maximumCount, boolean allowMultipleInRow) {
            this.weightClass = weightClass;
            this.weight = weight;
            this.maxPlaceCount = maximumCount;
            this.allowInRow = allowMultipleInRow;
        }

        public PieceWeight(Class<? extends Piece> weightClass, int weight, int maximumCount) {
            this(weightClass, weight, maximumCount, false);
        }

        public boolean doPlace(int p_78822_1_) {
            return this.maxPlaceCount == 0 || this.placeCount < this.maxPlaceCount;
        }

        public boolean isValid() {
            return this.maxPlaceCount == 0 || this.placeCount < this.maxPlaceCount;
        }
    }

    static abstract class Piece
    extends StructurePiece {
        protected Piece(IStructurePieceType p_i50260_1_, int p_i50260_2_) {
            super(p_i50260_1_, p_i50260_2_);
        }

        public Piece(IStructurePieceType p_i50261_1_, CompoundNBT p_i50261_2_) {
            super(p_i50261_1_, p_i50261_2_);
        }

        protected void func_143011_b(CompoundNBT tagCompound) {
        }

        private int getTotalWeight(List<PieceWeight> p_74960_1_) {
            boolean flag = false;
            int i = 0;
            for (PieceWeight structurenetherbridgepieces$pieceweight : p_74960_1_) {
                if (structurenetherbridgepieces$pieceweight.maxPlaceCount > 0 && structurenetherbridgepieces$pieceweight.placeCount < structurenetherbridgepieces$pieceweight.maxPlaceCount) {
                    flag = true;
                }
                i += structurenetherbridgepieces$pieceweight.weight;
            }
            return flag ? i : -1;
        }

        private Piece generatePiece(Start startPiece, List<PieceWeight> pieceWeights, List<StructurePiece> structurePieceList, Random random, int x, int y, int z, Direction direction, int depth) {
            int i = this.getTotalWeight(pieceWeights);
            boolean flag = i > 0 && depth <= 30;
            int j = 0;
            block0: while (j < 5 && flag) {
                ++j;
                int k = random.nextInt(i);
                for (PieceWeight structurenetherbridgepieces$pieceweight : pieceWeights) {
                    if ((k -= structurenetherbridgepieces$pieceweight.weight) >= 0) continue;
                    if (!structurenetherbridgepieces$pieceweight.doPlace(depth) || structurenetherbridgepieces$pieceweight == startPiece.fortressPieceWeight && !structurenetherbridgepieces$pieceweight.allowInRow) continue block0;
                    Piece structurenetherbridgepieces$piece = FortressJunglePieces.findAndCreateBridgePieceFactory(structurenetherbridgepieces$pieceweight, structurePieceList, random, x, y, z, direction, depth);
                    if (structurenetherbridgepieces$piece == null) continue;
                    ++structurenetherbridgepieces$pieceweight.placeCount;
                    startPiece.fortressPieceWeight = structurenetherbridgepieces$pieceweight;
                    if (!structurenetherbridgepieces$pieceweight.isValid()) {
                        pieceWeights.remove(structurenetherbridgepieces$pieceweight);
                    }
                    return structurenetherbridgepieces$piece;
                }
            }
            return End.createPiece(structurePieceList, random, x, y, z, direction, depth);
        }

        private StructurePiece generateAndAddPiece(Start startPiece, List<StructurePiece> structurePieces, Random random, int x, int y, int z, Direction direction, int depth, boolean secondaryList) {
            if (Math.abs(x - startPiece.func_74874_b().field_78897_a) <= 112 && Math.abs(z - startPiece.func_74874_b().field_78896_c) <= 112) {
                Piece StructurePiece2;
                List<PieceWeight> list = startPiece.primaryWeights;
                if (secondaryList) {
                    list = startPiece.secondaryWeights;
                }
                if ((StructurePiece2 = this.generatePiece(startPiece, list, structurePieces, random, x, y, z, direction, depth + 1)) != null) {
                    structurePieces.add(StructurePiece2);
                    startPiece.pendingChildren.add(StructurePiece2);
                }
                return StructurePiece2;
            }
            return End.createPiece(structurePieces, random, x, y, z, direction, depth);
        }

        protected StructurePiece getNextComponentNormal(Start structurePiece, List<StructurePiece> structurePieceList, Random random, int x, int z, boolean useSecondaryList) {
            Direction enumfacing = this.func_186165_e();
            if (enumfacing != null) {
                switch (enumfacing) {
                    case NORTH: {
                        return this.generateAndAddPiece(structurePiece, structurePieceList, random, this.field_74887_e.field_78897_a + x, this.field_74887_e.field_78895_b + z, this.field_74887_e.field_78896_c - 1, enumfacing, this.func_74877_c(), useSecondaryList);
                    }
                    case SOUTH: {
                        return this.generateAndAddPiece(structurePiece, structurePieceList, random, this.field_74887_e.field_78897_a + x, this.field_74887_e.field_78895_b + z, this.field_74887_e.field_78892_f + 1, enumfacing, this.func_74877_c(), useSecondaryList);
                    }
                    case WEST: {
                        return this.generateAndAddPiece(structurePiece, structurePieceList, random, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b + z, this.field_74887_e.field_78896_c + x, enumfacing, this.func_74877_c(), useSecondaryList);
                    }
                    case EAST: {
                        return this.generateAndAddPiece(structurePiece, structurePieceList, random, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b + z, this.field_74887_e.field_78896_c + x, enumfacing, this.func_74877_c(), useSecondaryList);
                    }
                }
            }
            return null;
        }

        protected StructurePiece getNextComponentX(Start piece, List<StructurePiece> structurePieces, Random random, int x, int z, boolean useSecondaryList) {
            Direction enumfacing = this.func_186165_e();
            if (enumfacing != null) {
                switch (enumfacing) {
                    case NORTH: 
                    case SOUTH: {
                        return this.generateAndAddPiece(piece, structurePieces, random, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b + x, this.field_74887_e.field_78896_c + z, Direction.WEST, this.func_74877_c(), useSecondaryList);
                    }
                    case WEST: 
                    case EAST: {
                        return this.generateAndAddPiece(piece, structurePieces, random, this.field_74887_e.field_78897_a + z, this.field_74887_e.field_78895_b + x, this.field_74887_e.field_78896_c - 1, Direction.NORTH, this.func_74877_c(), useSecondaryList);
                    }
                }
            }
            return null;
        }

        protected StructurePiece getNextComponentZ(Start start, List<StructurePiece> structurePieces, Random random, int x, int z, boolean useSecondaryList) {
            Direction enumfacing = this.func_186165_e();
            if (enumfacing != null) {
                switch (enumfacing) {
                    case NORTH: 
                    case SOUTH: {
                        return this.generateAndAddPiece(start, structurePieces, random, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b + x, this.field_74887_e.field_78896_c + z, Direction.EAST, this.func_74877_c(), useSecondaryList);
                    }
                    case WEST: 
                    case EAST: {
                        return this.generateAndAddPiece(start, structurePieces, random, this.field_74887_e.field_78897_a + z, this.field_74887_e.field_78895_b + x, this.field_74887_e.field_78892_f + 1, Direction.SOUTH, this.func_74877_c(), useSecondaryList);
                    }
                }
            }
            return null;
        }

        protected static boolean isAboveGround(MutableBoundingBox p_74964_0_) {
            return p_74964_0_ != null && p_74964_0_.field_78895_b > 10;
        }

        protected BlockState getStoneVariantBlockState(BlockState blockstateIn, Random rand) {
            Block block = blockstateIn.func_177230_c();
            if (blockstateIn.func_203425_a(Blocks.field_196653_dH)) {
                float silverfishThreshold;
                float chance = rand.nextFloat();
                BlockState newBlockState = chance < 0.5f ? Blocks.field_196698_dj.func_176223_P() : (chance < 0.75f ? Blocks.field_196700_dk.func_176223_P() : (chance < 0.95f ? Blocks.field_196696_di.func_176223_P() : Blocks.field_196702_dl.func_176223_P()));
                chance = rand.nextFloat();
                if (chance < (silverfishThreshold = (float)(RepurposedStructures.RSMainConfig.silverfishSpawnrateJF.get() / 100.0))) {
                    newBlockState = (BlockState)INFESTED_STONE_LOOKUP.get(newBlockState);
                }
                return newBlockState;
            }
            if (blockstateIn.func_203425_a(Blocks.field_150386_bk)) {
                return (BlockState)((BlockState)((BlockState)((BlockState)Blocks.field_150411_aY.func_176223_P().func_206870_a((Property)FourWayBlock.field_196409_a, (Comparable)((Boolean)blockstateIn.func_177229_b((Property)FourWayBlock.field_196409_a)))).func_206870_a((Property)FourWayBlock.field_196411_b, (Comparable)((Boolean)blockstateIn.func_177229_b((Property)FourWayBlock.field_196411_b)))).func_206870_a((Property)FourWayBlock.field_196413_c, (Comparable)((Boolean)blockstateIn.func_177229_b((Property)FourWayBlock.field_196413_c)))).func_206870_a((Property)FourWayBlock.field_196414_y, (Comparable)((Boolean)blockstateIn.func_177229_b((Property)FourWayBlock.field_196414_y)));
            }
            if (blockstateIn.func_203425_a(Blocks.field_150387_bl)) {
                float chance = rand.nextFloat();
                if (chance < 0.8f) {
                    return (BlockState)Blocks.field_150390_bg.func_176223_P().func_206870_a((Property)StairsBlock.field_176309_a, (Comparable)((Direction)blockstateIn.func_177229_b((Property)StairsBlock.field_176309_a)));
                }
                return (BlockState)Blocks.field_222409_kX.func_176223_P().func_206870_a((Property)StairsBlock.field_176309_a, (Comparable)((Direction)blockstateIn.func_177229_b((Property)StairsBlock.field_176309_a)));
            }
            if (blockstateIn.func_203425_a(Blocks.field_150425_aM)) {
                ITag ORE_TAG = BlockTags.func_199896_a().func_199915_b(JF_SOIL_TAG_RL);
                List allSoilBlocks = ORE_TAG.func_230236_b_();
                BlockState soilBlock = null;
                if (!allSoilBlocks.isEmpty()) {
                    soilBlock = ((Block)allSoilBlocks.toArray()[rand.nextInt(allSoilBlocks.size())]).func_176223_P();
                }
                if (soilBlock != null && soilBlock.func_235901_b_((Property)BlockStateProperties.field_208133_ah)) {
                    soilBlock = (BlockState)soilBlock.func_206870_a((Property)BlockStateProperties.field_208133_ah, (Comparable)Integer.valueOf(rand.nextInt(8)));
                }
                return soilBlock != null ? soilBlock : Blocks.field_196660_k.func_176223_P();
            }
            if (blockstateIn.func_203425_a(Blocks.field_150388_bm)) {
                ITag ORE_TAG = BlockTags.func_199896_a().func_199915_b(JF_PLANT_TAG_RL);
                List allPlantBlocks = ORE_TAG.func_230236_b_();
                float chance = rand.nextFloat();
                if (!allPlantBlocks.isEmpty() && chance < 0.4f) {
                    BlockState plantBlock = ((Block)allPlantBlocks.toArray()[rand.nextInt(allPlantBlocks.size())]).func_176223_P();
                    if (plantBlock.func_235901_b_((Property)BlockStateProperties.field_208172_Y)) {
                        plantBlock = (BlockState)plantBlock.func_206870_a((Property)BlockStateProperties.field_208172_Y, (Comparable)Integer.valueOf(rand.nextInt(26)));
                    } else if (plantBlock.func_235901_b_((Property)BlockStateProperties.field_208171_X)) {
                        plantBlock = (BlockState)plantBlock.func_206870_a((Property)BlockStateProperties.field_208171_X, (Comparable)Integer.valueOf(rand.nextInt(16)));
                    } else if (plantBlock.func_235901_b_((Property)BlockStateProperties.field_208170_W)) {
                        plantBlock = (BlockState)plantBlock.func_206870_a((Property)BlockStateProperties.field_208170_W, (Comparable)Integer.valueOf(rand.nextInt(8)));
                    } else if (plantBlock.func_235901_b_((Property)BlockStateProperties.field_208169_V)) {
                        plantBlock = (BlockState)plantBlock.func_206870_a((Property)BlockStateProperties.field_208169_V, (Comparable)Integer.valueOf(rand.nextInt(6)));
                    } else if (plantBlock.func_235901_b_((Property)BlockStateProperties.field_208168_U)) {
                        plantBlock = (BlockState)plantBlock.func_206870_a((Property)BlockStateProperties.field_208168_U, (Comparable)Integer.valueOf(rand.nextInt(4)));
                    } else if (plantBlock.func_235901_b_((Property)BlockStateProperties.field_208167_T)) {
                        plantBlock = (BlockState)plantBlock.func_206870_a((Property)BlockStateProperties.field_208167_T, (Comparable)Integer.valueOf(rand.nextInt(3)));
                    } else if (plantBlock.func_235901_b_((Property)BlockStateProperties.field_222512_Y)) {
                        plantBlock = (BlockState)plantBlock.func_206870_a((Property)BlockStateProperties.field_222512_Y, (Comparable)Integer.valueOf(rand.nextInt(2)));
                    }
                    return plantBlock;
                }
                return Blocks.field_201941_jj.func_176223_P();
            }
            if (blockstateIn.func_203425_a(Blocks.field_150353_l)) {
                return Blocks.field_150355_j.func_176223_P();
            }
            return block.func_176223_P();
        }

        protected void fillWithRandomBlocks(ISeedReader world, MutableBoundingBox boundingboxIn, int xMin, int yMin, int zMin, int xMax, int yMax, int zMax, BlockState boundaryBlockState, BlockState insideBlockState, boolean existingOnly, Random rand) {
            for (int y = yMin; y <= yMax; ++y) {
                for (int x = xMin; x <= xMax; ++x) {
                    for (int z = zMin; z <= zMax; ++z) {
                        if (existingOnly && this.func_175807_a((IBlockReader)world, x, y, z, boundingboxIn).func_185904_a() == Material.field_151579_a) continue;
                        if (y != yMin && y != yMax && x != xMin && x != xMax && z != zMin && z != zMax) {
                            this.func_175811_a((IWorld)world, insideBlockState, x, y, z, boundingboxIn);
                            continue;
                        }
                        this.func_175811_a((IWorld)world, this.getStoneVariantBlockState(boundaryBlockState.func_177230_c().func_176223_P(), rand), x, y, z, boundingboxIn);
                    }
                }
            }
        }

        protected void fillWithWater(ISeedReader world, MutableBoundingBox boundingboxIn, int xMin, int yMin, int zMin, int xMax, int yMax, int zMax) {
            for (int y = yMin; y <= yMax; ++y) {
                for (int x = xMin; x <= xMax; ++x) {
                    for (int z = zMin; z <= zMax; ++z) {
                        BlockPos.Mutable blockPos = new BlockPos.Mutable(this.func_74865_a(x, z), this.func_74862_a(y), this.func_74873_b(x, z));
                        if (blockPos.func_177956_o() >= world.func_181545_F()) continue;
                        if (world.func_180495_p((BlockPos)blockPos).func_185904_a() == Material.field_151579_a) {
                            this.func_175811_a((IWorld)world, Blocks.field_150355_j.func_176223_P(), x, y, z, boundingboxIn);
                            world.func_205219_F_().func_205360_a((BlockPos)blockPos, (Object)Fluids.field_204546_a, 0);
                            continue;
                        }
                        if (!world.func_180495_p((BlockPos)blockPos).func_235904_r_().contains(BlockStateProperties.field_208198_y)) continue;
                        world.func_180501_a((BlockPos)blockPos, (BlockState)world.func_180495_p((BlockPos)blockPos).func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(true)), 3);
                        world.func_205219_F_().func_205360_a((BlockPos)blockPos, (Object)Fluids.field_204546_a, 0);
                    }
                }
            }
        }

        protected void replaceAirAndLiquidDownwardsRandomBlocks(ISeedReader world, BlockState blockstateIn, int x, int y, int z, MutableBoundingBox boundingboxIn, Random rand) {
            int k;
            int j;
            int i = this.func_74865_a(x, z);
            if (boundingboxIn.func_175898_b((Vector3i)new BlockPos(i, j = this.func_74862_a(y), k = this.func_74873_b(x, z)))) {
                while ((world.func_175623_d(new BlockPos(i, j, k)) || world.func_180495_p(new BlockPos(i, j, k)).func_185904_a().func_76224_d()) && j > 1) {
                    world.func_180501_a(new BlockPos(i, j, k), this.getStoneVariantBlockState(blockstateIn.func_177230_c().func_176223_P(), rand), 2);
                    --j;
                }
            }
        }
    }

    public static class Straight
    extends Piece {
        public Straight(int p_i45620_1_, Random p_i45620_2_, MutableBoundingBox p_i45620_3_, Direction p_i45620_4_) {
            super(StructurePieces.JUNGLE_FORTRESS_STRAIGHT, p_i45620_1_);
            this.func_186164_a(p_i45620_4_);
            this.field_74887_e = p_i45620_3_;
        }

        public Straight(TemplateManager p_i50283_1_, CompoundNBT p_i50283_2_) {
            super(StructurePieces.JUNGLE_FORTRESS_STRAIGHT, p_i50283_2_);
        }

        public void func_74861_a(StructurePiece componentIn, List<StructurePiece> listIn, Random rand) {
            this.getNextComponentNormal((Start)componentIn, listIn, rand, 1, 3, false);
        }

        public static Straight createPiece(List<StructurePiece> structurePieceList, Random random, int x, int y, int z, Direction direction, int depth) {
            MutableBoundingBox mutableBoundingBox = MutableBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)-1, (int)-3, (int)0, (int)5, (int)10, (int)19, (Direction)direction);
            return Straight.isAboveGround(mutableBoundingBox) && StructurePiece.func_74883_a(structurePieceList, (MutableBoundingBox)mutableBoundingBox) == null ? new Straight(depth, random, mutableBoundingBox, direction) : null;
        }

        public boolean func_230383_a_(ISeedReader world, StructureManager structureAccessor, ChunkGenerator generator, Random random, MutableBoundingBox boundingBox, ChunkPos chunkPos, BlockPos blockPos) {
            this.fillWithRandomBlocks(world, boundingBox, 0, 3, 0, 4, 4, 18, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, boundingBox, 1, 5, 0, 3, 7, 18, Blocks.field_201941_jj.func_176223_P(), Blocks.field_201941_jj.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, boundingBox, 0, 5, 0, 0, 5, 18, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, boundingBox, 4, 5, 0, 4, 5, 18, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, boundingBox, 0, 2, 0, 4, 2, 5, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, boundingBox, 0, 2, 13, 4, 2, 18, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, boundingBox, 0, 0, 0, 4, 1, 3, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, boundingBox, 0, 0, 15, 4, 1, 18, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            for (int i = 0; i <= 4; ++i) {
                for (int j = 0; j <= 2; ++j) {
                    this.replaceAirAndLiquidDownwardsRandomBlocks(world, Blocks.field_196653_dH.func_176223_P(), i, -1, j, boundingBox, random);
                    this.replaceAirAndLiquidDownwardsRandomBlocks(world, Blocks.field_196653_dH.func_176223_P(), i, -1, 18 - j, boundingBox, random);
                }
            }
            BlockState iblockstate1 = this.getStoneVariantBlockState((BlockState)((BlockState)Blocks.field_150386_bk.func_176223_P().func_206870_a((Property)FourWayBlock.field_196409_a, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)FourWayBlock.field_196413_c, (Comparable)Boolean.valueOf(true)), random);
            BlockState iblockstate2 = (BlockState)iblockstate1.func_206870_a((Property)FourWayBlock.field_196411_b, (Comparable)Boolean.valueOf(true));
            BlockState iblockstate3 = (BlockState)iblockstate1.func_206870_a((Property)FourWayBlock.field_196414_y, (Comparable)Boolean.valueOf(true));
            this.fillWithRandomBlocks(world, boundingBox, 0, 1, 1, 0, 4, 1, iblockstate2, iblockstate2, false, random);
            this.fillWithRandomBlocks(world, boundingBox, 0, 3, 4, 0, 4, 4, iblockstate2, iblockstate2, false, random);
            this.fillWithRandomBlocks(world, boundingBox, 0, 3, 14, 0, 4, 14, iblockstate2, iblockstate2, false, random);
            this.fillWithRandomBlocks(world, boundingBox, 0, 1, 17, 0, 4, 17, iblockstate2, iblockstate2, false, random);
            this.fillWithRandomBlocks(world, boundingBox, 4, 1, 1, 4, 4, 1, iblockstate3, iblockstate3, false, random);
            this.fillWithRandomBlocks(world, boundingBox, 4, 3, 4, 4, 4, 4, iblockstate3, iblockstate3, false, random);
            this.fillWithRandomBlocks(world, boundingBox, 4, 3, 14, 4, 4, 14, iblockstate3, iblockstate3, false, random);
            this.fillWithRandomBlocks(world, boundingBox, 4, 1, 17, 4, 4, 17, iblockstate3, iblockstate3, false, random);
            this.fillWithWater(world, boundingBox, 0, 0, 0, 4, 7, 18);
            return true;
        }
    }

    public static class Crossing3
    extends Piece {
        protected Crossing3(IStructurePieceType p_i50287_1_, CompoundNBT p_i50287_2_) {
            super(p_i50287_1_, p_i50287_2_);
        }

        public Crossing3(TemplateManager p_i50288_1_, CompoundNBT p_i50288_2_) {
            this(StructurePieces.JUNGLE_FORTRESS_CROSSING_3, p_i50288_2_);
        }

        public Crossing3(int p_i50286_1_, MutableBoundingBox p_i50286_2_, Direction p_i50286_3_) {
            super(StructurePieces.JUNGLE_FORTRESS_CROSSING_3, p_i50286_1_);
            this.func_186164_a(p_i50286_3_);
            this.field_74887_e = p_i50286_2_;
        }

        protected Crossing3(Random p_i2042_1_, int p_i2042_2_, int p_i2042_3_) {
            super(StructurePieces.JUNGLE_FORTRESS_CROSSING_3, 0);
            this.func_186164_a(Direction.Plane.HORIZONTAL.func_179518_a(p_i2042_1_));
            this.field_74887_e = this.func_186165_e().func_176740_k() == Direction.Axis.Z ? new MutableBoundingBox(p_i2042_2_, 64, p_i2042_3_, p_i2042_2_ + 19 - 1, 73, p_i2042_3_ + 19 - 1) : new MutableBoundingBox(p_i2042_2_, 64, p_i2042_3_, p_i2042_2_ + 19 - 1, 73, p_i2042_3_ + 19 - 1);
        }

        public void func_74861_a(StructurePiece componentIn, List<StructurePiece> listIn, Random rand) {
            this.getNextComponentNormal((Start)componentIn, listIn, rand, 8, 3, false);
            this.getNextComponentX((Start)componentIn, listIn, rand, 3, 8, false);
            this.getNextComponentZ((Start)componentIn, listIn, rand, 3, 8, false);
        }

        public static Crossing3 createPiece(List<StructurePiece> structurePieceList, Random random, int x, int y, int z, Direction direction, int depth) {
            MutableBoundingBox mutableBoundingBox = MutableBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)-8, (int)-3, (int)0, (int)19, (int)10, (int)19, (Direction)direction);
            return Crossing3.isAboveGround(mutableBoundingBox) && StructurePiece.func_74883_a(structurePieceList, (MutableBoundingBox)mutableBoundingBox) == null ? new Crossing3(depth, mutableBoundingBox, direction) : null;
        }

        public boolean func_230383_a_(ISeedReader world, StructureManager structureAccessor, ChunkGenerator generator, Random random, MutableBoundingBox boundingBox, ChunkPos chunkPos, BlockPos blockPos) {
            this.fillWithRandomBlocks(world, boundingBox, 7, 3, 0, 11, 4, 18, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, boundingBox, 0, 3, 7, 18, 4, 11, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, boundingBox, 8, 5, 0, 10, 7, 18, Blocks.field_201941_jj.func_176223_P(), Blocks.field_201941_jj.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, boundingBox, 0, 5, 8, 18, 7, 10, Blocks.field_201941_jj.func_176223_P(), Blocks.field_201941_jj.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, boundingBox, 7, 5, 0, 7, 5, 7, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, boundingBox, 7, 5, 11, 7, 5, 18, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, boundingBox, 11, 5, 0, 11, 5, 7, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, boundingBox, 11, 5, 11, 11, 5, 18, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, boundingBox, 0, 5, 7, 7, 5, 7, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, boundingBox, 11, 5, 7, 18, 5, 7, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, boundingBox, 0, 5, 11, 7, 5, 11, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, boundingBox, 11, 5, 11, 18, 5, 11, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, boundingBox, 7, 2, 0, 11, 2, 5, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, boundingBox, 7, 2, 13, 11, 2, 18, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, boundingBox, 7, 0, 0, 11, 1, 3, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, boundingBox, 7, 0, 15, 11, 1, 18, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            for (int i = 7; i <= 11; ++i) {
                for (int j = 0; j <= 2; ++j) {
                    this.replaceAirAndLiquidDownwardsRandomBlocks(world, Blocks.field_196653_dH.func_176223_P(), i, -1, j, boundingBox, random);
                    this.replaceAirAndLiquidDownwardsRandomBlocks(world, Blocks.field_196653_dH.func_176223_P(), i, -1, 18 - j, boundingBox, random);
                }
            }
            this.fillWithRandomBlocks(world, boundingBox, 0, 2, 7, 5, 2, 11, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, boundingBox, 13, 2, 7, 18, 2, 11, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, boundingBox, 0, 0, 7, 3, 1, 11, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, boundingBox, 15, 0, 7, 18, 1, 11, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            for (int k = 0; k <= 2; ++k) {
                for (int l = 7; l <= 11; ++l) {
                    this.replaceAirAndLiquidDownwardsRandomBlocks(world, Blocks.field_196653_dH.func_176223_P(), k, -1, l, boundingBox, random);
                    this.replaceAirAndLiquidDownwardsRandomBlocks(world, Blocks.field_196653_dH.func_176223_P(), 18 - k, -1, l, boundingBox, random);
                }
            }
            this.fillWithWater(world, boundingBox, 0, 0, 0, 18, 5, 11);
            return true;
        }
    }

    public static class Crossing
    extends Piece {
        public Crossing(int p_i50258_1_, MutableBoundingBox p_i50258_2_, Direction p_i50258_3_) {
            super(StructurePieces.JUNGLE_FORTRESS_CROSSING_1, p_i50258_1_);
            this.func_186164_a(p_i50258_3_);
            this.field_74887_e = p_i50258_2_;
        }

        public Crossing(TemplateManager p_i50259_1_, CompoundNBT p_i50259_2_) {
            super(StructurePieces.JUNGLE_FORTRESS_CROSSING_1, p_i50259_2_);
        }

        public void func_74861_a(StructurePiece componentIn, List<StructurePiece> listIn, Random rand) {
            this.getNextComponentNormal((Start)componentIn, listIn, rand, 2, 0, false);
            this.getNextComponentX((Start)componentIn, listIn, rand, 0, 2, false);
            this.getNextComponentZ((Start)componentIn, listIn, rand, 0, 2, false);
        }

        public static Crossing createPiece(List<StructurePiece> structurePieceList, Random random, int x, int y, int z, Direction direction, int depth) {
            MutableBoundingBox mutableBoundingBox = MutableBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)-2, (int)0, (int)0, (int)7, (int)9, (int)7, (Direction)direction);
            return Crossing.isAboveGround(mutableBoundingBox) && StructurePiece.func_74883_a(structurePieceList, (MutableBoundingBox)mutableBoundingBox) == null ? new Crossing(depth, mutableBoundingBox, direction) : null;
        }

        public boolean func_230383_a_(ISeedReader world, StructureManager structureAccessor, ChunkGenerator generator, Random random, MutableBoundingBox boundingBox, ChunkPos chunkPos, BlockPos blockPos) {
            this.fillWithRandomBlocks(world, boundingBox, 0, 0, 0, 6, 1, 6, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, boundingBox, 0, 2, 0, 6, 7, 6, Blocks.field_201941_jj.func_176223_P(), Blocks.field_201941_jj.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, boundingBox, 0, 2, 0, 1, 6, 0, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, boundingBox, 0, 2, 6, 1, 6, 6, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, boundingBox, 5, 2, 0, 6, 6, 0, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, boundingBox, 5, 2, 6, 6, 6, 6, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, boundingBox, 0, 2, 0, 0, 6, 1, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, boundingBox, 0, 2, 5, 0, 6, 6, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, boundingBox, 6, 2, 0, 6, 6, 1, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, boundingBox, 6, 2, 5, 6, 6, 6, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            BlockState iblockstate = this.getStoneVariantBlockState((BlockState)((BlockState)Blocks.field_150386_bk.func_176223_P().func_206870_a((Property)FourWayBlock.field_196414_y, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)FourWayBlock.field_196411_b, (Comparable)Boolean.valueOf(true)), random);
            BlockState iblockstate1 = this.getStoneVariantBlockState((BlockState)((BlockState)Blocks.field_150386_bk.func_176223_P().func_206870_a((Property)FourWayBlock.field_196409_a, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)FourWayBlock.field_196413_c, (Comparable)Boolean.valueOf(true)), random);
            this.fillWithRandomBlocks(world, boundingBox, 2, 6, 0, 4, 6, 0, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, boundingBox, 2, 5, 0, 4, 5, 0, iblockstate, iblockstate, false, random);
            this.fillWithRandomBlocks(world, boundingBox, 2, 6, 6, 4, 6, 6, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, boundingBox, 2, 5, 6, 4, 5, 6, iblockstate, iblockstate, false, random);
            this.fillWithRandomBlocks(world, boundingBox, 0, 6, 2, 0, 6, 4, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, boundingBox, 0, 5, 2, 0, 5, 4, iblockstate1, iblockstate1, false, random);
            this.fillWithRandomBlocks(world, boundingBox, 6, 6, 2, 6, 6, 4, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, boundingBox, 6, 5, 2, 6, 5, 4, iblockstate1, iblockstate1, false, random);
            for (int i = 0; i <= 6; ++i) {
                for (int j = 0; j <= 6; ++j) {
                    this.replaceAirAndLiquidDownwardsRandomBlocks(world, Blocks.field_196653_dH.func_176223_P(), i, -1, j, boundingBox, random);
                }
            }
            this.fillWithWater(world, boundingBox, 0, 0, 0, 6, 6, 6);
            return true;
        }
    }

    public static class Stairs
    extends Piece {
        public Stairs(int p_i50255_1_, MutableBoundingBox p_i50255_2_, Direction p_i50255_3_) {
            super(StructurePieces.JUNGLE_FORTRESS_STAIRS, p_i50255_1_);
            this.func_186164_a(p_i50255_3_);
            this.field_74887_e = p_i50255_2_;
        }

        public Stairs(TemplateManager p_i50256_1_, CompoundNBT p_i50256_2_) {
            super(StructurePieces.JUNGLE_FORTRESS_STAIRS, p_i50256_2_);
        }

        public void func_74861_a(StructurePiece componentIn, List<StructurePiece> listIn, Random rand) {
            this.getNextComponentZ((Start)componentIn, listIn, rand, 6, 2, false);
        }

        public static Stairs createPiece(List<StructurePiece> structurePieceList, Random random, int x, int y, int z, int depth, Direction direction) {
            MutableBoundingBox mutableBoundingBox = MutableBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)-2, (int)0, (int)0, (int)7, (int)11, (int)7, (Direction)direction);
            return Stairs.isAboveGround(mutableBoundingBox) && StructurePiece.func_74883_a(structurePieceList, (MutableBoundingBox)mutableBoundingBox) == null ? new Stairs(depth, mutableBoundingBox, direction) : null;
        }

        public boolean func_230383_a_(ISeedReader world, StructureManager structureAccessor, ChunkGenerator generator, Random random, MutableBoundingBox boundingBox, ChunkPos chunkPos, BlockPos blockPos) {
            this.fillWithRandomBlocks(world, boundingBox, 0, 0, 0, 6, 1, 6, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, boundingBox, 0, 2, 0, 6, 10, 6, Blocks.field_201941_jj.func_176223_P(), Blocks.field_201941_jj.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, boundingBox, 0, 2, 0, 1, 8, 0, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, boundingBox, 5, 2, 0, 6, 8, 0, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, boundingBox, 0, 2, 1, 0, 8, 6, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, boundingBox, 6, 2, 1, 6, 8, 6, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, boundingBox, 1, 2, 6, 5, 8, 6, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            BlockState iblockstate = this.getStoneVariantBlockState((BlockState)((BlockState)Blocks.field_150386_bk.func_176223_P().func_206870_a((Property)FourWayBlock.field_196414_y, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)FourWayBlock.field_196411_b, (Comparable)Boolean.valueOf(true)), random);
            BlockState iblockstate1 = this.getStoneVariantBlockState((BlockState)((BlockState)Blocks.field_150386_bk.func_176223_P().func_206870_a((Property)FourWayBlock.field_196409_a, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)FourWayBlock.field_196413_c, (Comparable)Boolean.valueOf(true)), random);
            this.fillWithRandomBlocks(world, boundingBox, 0, 3, 2, 0, 5, 4, iblockstate1, iblockstate1, false, random);
            this.fillWithRandomBlocks(world, boundingBox, 6, 3, 2, 6, 5, 2, iblockstate1, iblockstate1, false, random);
            this.fillWithRandomBlocks(world, boundingBox, 6, 3, 4, 6, 5, 4, iblockstate1, iblockstate1, false, random);
            this.func_175811_a((IWorld)world, this.getStoneVariantBlockState(Blocks.field_196653_dH.func_176223_P(), random), 5, 2, 5, boundingBox);
            this.fillWithRandomBlocks(world, boundingBox, 4, 2, 5, 4, 3, 5, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, boundingBox, 3, 2, 5, 3, 4, 5, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, boundingBox, 2, 2, 5, 2, 5, 5, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, boundingBox, 1, 2, 5, 1, 6, 5, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, boundingBox, 1, 7, 1, 5, 7, 4, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, boundingBox, 6, 8, 2, 6, 8, 4, Blocks.field_201941_jj.func_176223_P(), Blocks.field_201941_jj.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, boundingBox, 2, 6, 0, 4, 8, 0, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, boundingBox, 2, 5, 0, 4, 5, 0, iblockstate, iblockstate, false, random);
            for (int i = 0; i <= 6; ++i) {
                for (int j = 0; j <= 6; ++j) {
                    this.replaceAirAndLiquidDownwardsRandomBlocks(world, Blocks.field_196653_dH.func_176223_P(), i, -1, j, boundingBox, random);
                }
            }
            this.fillWithWater(world, boundingBox, 0, 0, 0, 6, 10, 6);
            return true;
        }
    }

    public static class Throne
    extends Piece {
        private boolean hasSpawner;

        public Throne(int p_i50262_1_, Random rand, MutableBoundingBox p_i50262_2_, Direction p_i50262_3_) {
            super(StructurePieces.JUNGLE_FORTRESS_THRONE, p_i50262_1_);
            this.func_186164_a(p_i50262_3_);
            this.field_74887_e = p_i50262_2_;
        }

        public Throne(TemplateManager p_i50263_1_, CompoundNBT p_i50263_2_) {
            super(StructurePieces.JUNGLE_FORTRESS_THRONE, p_i50263_2_);
            this.hasSpawner = p_i50263_2_.func_74767_n("Mob");
        }

        @Override
        protected void func_143011_b(CompoundNBT tagCompound) {
            super.func_143011_b(tagCompound);
            tagCompound.func_74757_a("Mob", this.hasSpawner);
        }

        public static Throne createPiece(List<StructurePiece> structurePieceList, Random random, int x, int y, int z, int depth, Direction direction) {
            MutableBoundingBox mutableBoundingBox = MutableBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)-2, (int)0, (int)0, (int)7, (int)8, (int)9, (Direction)direction);
            return Throne.isAboveGround(mutableBoundingBox) && StructurePiece.func_74883_a(structurePieceList, (MutableBoundingBox)mutableBoundingBox) == null ? new Throne(depth, random, mutableBoundingBox, direction) : null;
        }

        public boolean func_230383_a_(ISeedReader world, StructureManager structureAccessor, ChunkGenerator generator, Random random, MutableBoundingBox boundingBox, ChunkPos chunkPos, BlockPos blockPos) {
            BlockPos blockpos;
            this.fillWithRandomBlocks(world, boundingBox, 0, 2, 0, 6, 7, 7, Blocks.field_201941_jj.func_176223_P(), Blocks.field_201941_jj.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, boundingBox, 1, 0, 0, 5, 1, 7, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, boundingBox, 1, 2, 1, 5, 2, 7, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, boundingBox, 1, 3, 2, 5, 3, 7, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, boundingBox, 1, 4, 3, 5, 4, 7, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, boundingBox, 1, 2, 0, 1, 4, 2, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, boundingBox, 5, 2, 0, 5, 4, 2, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, boundingBox, 1, 5, 2, 1, 5, 3, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, boundingBox, 5, 5, 2, 5, 5, 3, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, boundingBox, 0, 5, 3, 0, 5, 8, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, boundingBox, 6, 5, 3, 6, 5, 8, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, boundingBox, 1, 5, 8, 5, 5, 8, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            BlockState iblockstate = this.getStoneVariantBlockState((BlockState)((BlockState)Blocks.field_150386_bk.func_176223_P().func_206870_a((Property)FourWayBlock.field_196414_y, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)FourWayBlock.field_196411_b, (Comparable)Boolean.valueOf(true)), random);
            BlockState iblockstate1 = this.getStoneVariantBlockState((BlockState)((BlockState)Blocks.field_150386_bk.func_176223_P().func_206870_a((Property)FourWayBlock.field_196409_a, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)FourWayBlock.field_196413_c, (Comparable)Boolean.valueOf(true)), random);
            this.func_175811_a((IWorld)world, this.getStoneVariantBlockState((BlockState)Blocks.field_150386_bk.func_176223_P().func_206870_a((Property)FourWayBlock.field_196414_y, (Comparable)Boolean.valueOf(true)), random), 1, 6, 3, boundingBox);
            this.func_175811_a((IWorld)world, this.getStoneVariantBlockState((BlockState)Blocks.field_150386_bk.func_176223_P().func_206870_a((Property)FourWayBlock.field_196411_b, (Comparable)Boolean.valueOf(true)), random), 5, 6, 3, boundingBox);
            this.func_175811_a((IWorld)world, this.getStoneVariantBlockState((BlockState)((BlockState)Blocks.field_150386_bk.func_176223_P().func_206870_a((Property)FourWayBlock.field_196411_b, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)FourWayBlock.field_196409_a, (Comparable)Boolean.valueOf(true)), random), 0, 6, 3, boundingBox);
            this.func_175811_a((IWorld)world, this.getStoneVariantBlockState((BlockState)((BlockState)Blocks.field_150386_bk.func_176223_P().func_206870_a((Property)FourWayBlock.field_196414_y, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)FourWayBlock.field_196409_a, (Comparable)Boolean.valueOf(true)), random), 6, 6, 3, boundingBox);
            this.fillWithRandomBlocks(world, boundingBox, 0, 6, 4, 0, 6, 7, iblockstate1, iblockstate1, false, random);
            this.fillWithRandomBlocks(world, boundingBox, 6, 6, 4, 6, 6, 7, iblockstate1, iblockstate1, false, random);
            this.func_175811_a((IWorld)world, this.getStoneVariantBlockState((BlockState)((BlockState)Blocks.field_150386_bk.func_176223_P().func_206870_a((Property)FourWayBlock.field_196411_b, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)FourWayBlock.field_196413_c, (Comparable)Boolean.valueOf(true)), random), 0, 6, 8, boundingBox);
            this.func_175811_a((IWorld)world, this.getStoneVariantBlockState((BlockState)((BlockState)Blocks.field_150386_bk.func_176223_P().func_206870_a((Property)FourWayBlock.field_196414_y, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)FourWayBlock.field_196413_c, (Comparable)Boolean.valueOf(true)), random), 6, 6, 8, boundingBox);
            this.fillWithRandomBlocks(world, boundingBox, 1, 6, 8, 5, 6, 8, iblockstate, iblockstate, false, random);
            this.func_175811_a((IWorld)world, this.getStoneVariantBlockState((BlockState)Blocks.field_150386_bk.func_176223_P().func_206870_a((Property)FourWayBlock.field_196411_b, (Comparable)Boolean.valueOf(true)), random), 1, 7, 8, boundingBox);
            this.fillWithRandomBlocks(world, boundingBox, 2, 7, 8, 4, 7, 8, iblockstate, iblockstate, false, random);
            this.func_175811_a((IWorld)world, this.getStoneVariantBlockState((BlockState)Blocks.field_150386_bk.func_176223_P().func_206870_a((Property)FourWayBlock.field_196414_y, (Comparable)Boolean.valueOf(true)), random), 5, 7, 8, boundingBox);
            this.func_175811_a((IWorld)world, this.getStoneVariantBlockState((BlockState)Blocks.field_150386_bk.func_176223_P().func_206870_a((Property)FourWayBlock.field_196411_b, (Comparable)Boolean.valueOf(true)), random), 2, 8, 8, boundingBox);
            this.func_175811_a((IWorld)world, iblockstate, 3, 8, 8, boundingBox);
            this.func_175811_a((IWorld)world, this.getStoneVariantBlockState((BlockState)Blocks.field_150386_bk.func_176223_P().func_206870_a((Property)FourWayBlock.field_196414_y, (Comparable)Boolean.valueOf(true)), random), 4, 8, 8, boundingBox);
            if (!this.hasSpawner && boundingBox.func_175898_b((Vector3i)(blockpos = new BlockPos(this.func_74865_a(3, 5), this.func_74862_a(5), this.func_74873_b(3, 5))))) {
                this.hasSpawner = true;
                world.func_180501_a(blockpos.func_177979_c(2), Blocks.field_150474_ac.func_176223_P(), 2);
                TileEntity tileentity2 = world.func_175625_s(blockpos.func_177979_c(2));
                if (tileentity2 instanceof MobSpawnerTileEntity) {
                    ((MobSpawnerTileEntity)tileentity2).func_145881_a().func_200876_a(RepurposedStructures.mobSpawnerManager.getSpawnerMob(SPAWNER_ID, random));
                }
            }
            for (int i = 0; i <= 6; ++i) {
                for (int j = 0; j <= 6; ++j) {
                    this.replaceAirAndLiquidDownwardsRandomBlocks(world, Blocks.field_196653_dH.func_176223_P(), i, -1, j, boundingBox, random);
                }
            }
            if (RepurposedStructures.RSMainConfig.lootChestsJF.get().booleanValue()) {
                this.func_186167_a((IWorld)world, boundingBox, random, 3, 5, 7, JF_SHRINE_CHEST_RL);
            }
            this.fillWithWater(world, boundingBox, 0, 0, 0, 6, 7, 8);
            return true;
        }
    }

    public static class Entrance
    extends Piece {
        public Entrance(int p_i45617_1_, Random rand, MutableBoundingBox p_i45617_3_, Direction p_i45617_4_) {
            super(StructurePieces.JUNGLE_FORTRESS_ENTRANCE, p_i45617_1_);
            this.func_186164_a(p_i45617_4_);
            this.field_74887_e = p_i45617_3_;
        }

        public Entrance(TemplateManager p_i50276_1_, CompoundNBT p_i50276_2_) {
            super(StructurePieces.JUNGLE_FORTRESS_ENTRANCE, p_i50276_2_);
        }

        public void func_74861_a(StructurePiece componentIn, List<StructurePiece> listIn, Random rand) {
            this.getNextComponentNormal((Start)componentIn, listIn, rand, 5, 3, true);
        }

        public static Entrance createPiece(List<StructurePiece> structurePieceList, Random random, int x, int y, int z, Direction direction, int depth) {
            MutableBoundingBox mutableBoundingBox = MutableBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)-5, (int)-3, (int)0, (int)13, (int)14, (int)13, (Direction)direction);
            return Entrance.isAboveGround(mutableBoundingBox) && StructurePiece.func_74883_a(structurePieceList, (MutableBoundingBox)mutableBoundingBox) == null ? new Entrance(depth, random, mutableBoundingBox, direction) : null;
        }

        public boolean func_230383_a_(ISeedReader world, StructureManager structureAccessor, ChunkGenerator generator, Random random, MutableBoundingBox boundingBox, ChunkPos chunkPos, BlockPos blockPos) {
            this.fillWithRandomBlocks(world, boundingBox, 0, 3, 0, 12, 4, 12, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, boundingBox, 0, 5, 0, 12, 13, 12, Blocks.field_201941_jj.func_176223_P(), Blocks.field_201941_jj.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, boundingBox, 0, 5, 0, 1, 12, 12, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, boundingBox, 11, 5, 0, 12, 12, 12, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, boundingBox, 2, 5, 11, 4, 12, 12, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, boundingBox, 8, 5, 11, 10, 12, 12, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, boundingBox, 5, 9, 11, 7, 12, 12, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, boundingBox, 2, 5, 0, 4, 12, 1, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, boundingBox, 8, 5, 0, 10, 12, 1, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, boundingBox, 5, 9, 0, 7, 12, 1, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, boundingBox, 2, 11, 2, 10, 12, 10, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, boundingBox, 5, 8, 0, 7, 8, 0, this.getStoneVariantBlockState(Blocks.field_150386_bk.func_176223_P(), random), this.getStoneVariantBlockState(Blocks.field_150386_bk.func_176223_P(), random), false, random);
            BlockState iblockstate = this.getStoneVariantBlockState((BlockState)((BlockState)Blocks.field_150386_bk.func_176223_P().func_206870_a((Property)FourWayBlock.field_196414_y, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)FourWayBlock.field_196411_b, (Comparable)Boolean.valueOf(true)), random);
            BlockState iblockstate1 = this.getStoneVariantBlockState((BlockState)((BlockState)Blocks.field_150386_bk.func_176223_P().func_206870_a((Property)FourWayBlock.field_196409_a, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)FourWayBlock.field_196413_c, (Comparable)Boolean.valueOf(true)), random);
            for (int i = 1; i <= 11; i += 2) {
                this.fillWithRandomBlocks(world, boundingBox, i, 10, 0, i, 11, 0, iblockstate, iblockstate, false, random);
                this.fillWithRandomBlocks(world, boundingBox, i, 10, 12, i, 11, 12, iblockstate, iblockstate, false, random);
                this.fillWithRandomBlocks(world, boundingBox, 0, 10, i, 0, 11, i, iblockstate1, iblockstate1, false, random);
                this.fillWithRandomBlocks(world, boundingBox, 12, 10, i, 12, 11, i, iblockstate1, iblockstate1, false, random);
                this.func_175811_a((IWorld)world, this.getStoneVariantBlockState(Blocks.field_196653_dH.func_176223_P(), random), i, 13, 0, boundingBox);
                this.func_175811_a((IWorld)world, this.getStoneVariantBlockState(Blocks.field_196653_dH.func_176223_P(), random), i, 13, 12, boundingBox);
                this.func_175811_a((IWorld)world, this.getStoneVariantBlockState(Blocks.field_196653_dH.func_176223_P(), random), 0, 13, i, boundingBox);
                this.func_175811_a((IWorld)world, this.getStoneVariantBlockState(Blocks.field_196653_dH.func_176223_P(), random), 12, 13, i, boundingBox);
                this.func_175811_a((IWorld)world, iblockstate, i + 1, 13, 0, boundingBox);
                this.func_175811_a((IWorld)world, iblockstate, i + 1, 13, 12, boundingBox);
                this.func_175811_a((IWorld)world, iblockstate1, 0, 13, i + 1, boundingBox);
                this.func_175811_a((IWorld)world, iblockstate1, 12, 13, i + 1, boundingBox);
            }
            this.func_175811_a((IWorld)world, this.getStoneVariantBlockState((BlockState)((BlockState)Blocks.field_150386_bk.func_176223_P().func_206870_a((Property)FourWayBlock.field_196409_a, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)FourWayBlock.field_196411_b, (Comparable)Boolean.valueOf(true)), random), 0, 13, 0, boundingBox);
            this.func_175811_a((IWorld)world, this.getStoneVariantBlockState((BlockState)((BlockState)Blocks.field_150386_bk.func_176223_P().func_206870_a((Property)FourWayBlock.field_196413_c, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)FourWayBlock.field_196411_b, (Comparable)Boolean.valueOf(true)), random), 0, 13, 12, boundingBox);
            this.func_175811_a((IWorld)world, this.getStoneVariantBlockState((BlockState)((BlockState)Blocks.field_150386_bk.func_176223_P().func_206870_a((Property)FourWayBlock.field_196413_c, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)FourWayBlock.field_196414_y, (Comparable)Boolean.valueOf(true)), random), 12, 13, 12, boundingBox);
            this.func_175811_a((IWorld)world, this.getStoneVariantBlockState((BlockState)((BlockState)Blocks.field_150386_bk.func_176223_P().func_206870_a((Property)FourWayBlock.field_196409_a, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)FourWayBlock.field_196414_y, (Comparable)Boolean.valueOf(true)), random), 12, 13, 0, boundingBox);
            for (int k = 3; k <= 9; k += 2) {
                this.fillWithRandomBlocks(world, boundingBox, 1, 7, k, 1, 8, k, (BlockState)iblockstate.func_206870_a((Property)FourWayBlock.field_196414_y, (Comparable)Boolean.valueOf(true)), (BlockState)iblockstate.func_206870_a((Property)FourWayBlock.field_196414_y, (Comparable)Boolean.valueOf(true)), false, random);
                this.fillWithRandomBlocks(world, boundingBox, 11, 7, k, 11, 8, k, (BlockState)iblockstate.func_206870_a((Property)FourWayBlock.field_196411_b, (Comparable)Boolean.valueOf(true)), (BlockState)iblockstate.func_206870_a((Property)FourWayBlock.field_196411_b, (Comparable)Boolean.valueOf(true)), false, random);
            }
            this.fillWithRandomBlocks(world, boundingBox, 4, 2, 0, 8, 2, 12, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, boundingBox, 0, 2, 4, 12, 2, 8, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, boundingBox, 4, 0, 0, 8, 1, 3, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, boundingBox, 4, 0, 9, 8, 1, 12, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, boundingBox, 0, 0, 4, 3, 1, 8, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, boundingBox, 9, 0, 4, 12, 1, 8, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            for (int l = 4; l <= 8; ++l) {
                for (int j = 0; j <= 2; ++j) {
                    this.replaceAirAndLiquidDownwardsRandomBlocks(world, Blocks.field_196653_dH.func_176223_P(), l, -1, j, boundingBox, random);
                    this.replaceAirAndLiquidDownwardsRandomBlocks(world, Blocks.field_196653_dH.func_176223_P(), l, -1, 12 - j, boundingBox, random);
                }
            }
            for (int i1 = 0; i1 <= 2; ++i1) {
                for (int j1 = 4; j1 <= 8; ++j1) {
                    this.replaceAirAndLiquidDownwardsRandomBlocks(world, Blocks.field_196653_dH.func_176223_P(), i1, -1, j1, boundingBox, random);
                    this.replaceAirAndLiquidDownwardsRandomBlocks(world, Blocks.field_196653_dH.func_176223_P(), 12 - i1, -1, j1, boundingBox, random);
                }
            }
            this.fillWithRandomBlocks(world, boundingBox, 5, 5, 5, 7, 5, 7, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, boundingBox, 6, 1, 6, 6, 4, 6, Blocks.field_201941_jj.func_176223_P(), Blocks.field_201941_jj.func_176223_P(), false, random);
            this.func_175811_a((IWorld)world, this.getStoneVariantBlockState(Blocks.field_196653_dH.func_176223_P(), random), 6, 0, 6, boundingBox);
            this.func_175811_a((IWorld)world, this.getStoneVariantBlockState(Blocks.field_150353_l.func_176223_P(), random), 6, 5, 6, boundingBox);
            BlockPos blockpos = new BlockPos(this.func_74865_a(6, 6), this.func_74862_a(5), this.func_74873_b(6, 6));
            if (RepurposedStructures.RSMainConfig.lootChestsJF.get().booleanValue()) {
                this.func_186167_a((IWorld)world, boundingBox, random, 6, 5, 8, JF_CENTER_CHEST_RL);
            }
            if (boundingBox.func_175898_b((Vector3i)blockpos)) {
                world.func_205219_F_().func_205360_a(blockpos, (Object)Fluids.field_204547_b, 0);
            }
            this.fillWithWater(world, boundingBox, 0, 0, 0, 12, 13, 12);
            return true;
        }
    }

    public static class Corridor5
    extends Piece {
        public Corridor5(int p_i50268_1_, MutableBoundingBox p_i50268_2_, Direction p_i50268_3_) {
            super(StructurePieces.JUNGLE_FORTRESS_CORRIDOR_5, p_i50268_1_);
            this.func_186164_a(p_i50268_3_);
            this.field_74887_e = p_i50268_2_;
        }

        public Corridor5(TemplateManager p_i50269_1_, CompoundNBT p_i50269_2_) {
            super(StructurePieces.JUNGLE_FORTRESS_CORRIDOR_5, p_i50269_2_);
        }

        public void func_74861_a(StructurePiece componentIn, List<StructurePiece> listIn, Random rand) {
            this.getNextComponentNormal((Start)componentIn, listIn, rand, 1, 0, true);
        }

        public static Corridor5 createPiece(List<StructurePiece> structurePieceList, Random random, int x, int y, int z, Direction direction, int depth) {
            MutableBoundingBox mutableBoundingBox = MutableBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)-1, (int)0, (int)0, (int)5, (int)7, (int)5, (Direction)direction);
            return Corridor5.isAboveGround(mutableBoundingBox) && StructurePiece.func_74883_a(structurePieceList, (MutableBoundingBox)mutableBoundingBox) == null ? new Corridor5(depth, mutableBoundingBox, direction) : null;
        }

        public boolean func_230383_a_(ISeedReader world, StructureManager structureAccessor, ChunkGenerator generator, Random random, MutableBoundingBox boundingBox, ChunkPos chunkPos, BlockPos blockPos) {
            this.fillWithRandomBlocks(world, boundingBox, 0, 0, 0, 4, 1, 4, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, boundingBox, 0, 2, 0, 4, 5, 4, Blocks.field_201941_jj.func_176223_P(), Blocks.field_201941_jj.func_176223_P(), false, random);
            BlockState iblockstate = this.getStoneVariantBlockState((BlockState)((BlockState)Blocks.field_150386_bk.func_176223_P().func_206870_a((Property)FourWayBlock.field_196409_a, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)FourWayBlock.field_196413_c, (Comparable)Boolean.valueOf(true)), random);
            this.fillWithRandomBlocks(world, boundingBox, 0, 2, 0, 0, 5, 4, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, boundingBox, 4, 2, 0, 4, 5, 4, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, boundingBox, 0, 3, 1, 0, 4, 1, iblockstate, iblockstate, false, random);
            this.fillWithRandomBlocks(world, boundingBox, 0, 3, 3, 0, 4, 3, iblockstate, iblockstate, false, random);
            this.fillWithRandomBlocks(world, boundingBox, 4, 3, 1, 4, 4, 1, iblockstate, iblockstate, false, random);
            this.fillWithRandomBlocks(world, boundingBox, 4, 3, 3, 4, 4, 3, iblockstate, iblockstate, false, random);
            this.fillWithRandomBlocks(world, boundingBox, 0, 6, 0, 4, 6, 4, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            for (int i = 0; i <= 4; ++i) {
                for (int j = 0; j <= 4; ++j) {
                    this.replaceAirAndLiquidDownwardsRandomBlocks(world, Blocks.field_196653_dH.func_176223_P(), i, -1, j, boundingBox, random);
                }
            }
            this.fillWithWater(world, boundingBox, 0, 0, 0, 4, 6, 4);
            return true;
        }
    }

    public static class Corridor2
    extends Piece {
        public Corridor2(int p_i45613_1_, Random rand, MutableBoundingBox p_i45613_3_, Direction p_i45613_4_) {
            super(StructurePieces.JUNGLE_FORTRESS_CORRIDOR_2, p_i45613_1_);
            this.func_186164_a(p_i45613_4_);
            this.field_74887_e = p_i45613_3_;
        }

        public Corridor2(TemplateManager p_i50266_1_, CompoundNBT p_i50266_2_) {
            super(StructurePieces.JUNGLE_FORTRESS_CORRIDOR_2, p_i50266_2_);
        }

        @Override
        protected void func_143011_b(CompoundNBT tagCompound) {
            super.func_143011_b(tagCompound);
        }

        public void func_74861_a(StructurePiece componentIn, List<StructurePiece> listIn, Random rand) {
            this.getNextComponentZ((Start)componentIn, listIn, rand, 0, 1, true);
        }

        public static Corridor2 createPiece(List<StructurePiece> structurePieceList, Random random, int x, int y, int z, Direction direction, int depth) {
            MutableBoundingBox mutableBoundingBox = MutableBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)-1, (int)0, (int)0, (int)5, (int)7, (int)5, (Direction)direction);
            return Corridor2.isAboveGround(mutableBoundingBox) && StructurePiece.func_74883_a(structurePieceList, (MutableBoundingBox)mutableBoundingBox) == null ? new Corridor2(depth, random, mutableBoundingBox, direction) : null;
        }

        public boolean func_230383_a_(ISeedReader world, StructureManager structureAccessor, ChunkGenerator generator, Random random, MutableBoundingBox boundingBox, ChunkPos chunkPos, BlockPos blockPos) {
            this.fillWithRandomBlocks(world, boundingBox, 0, 0, 0, 4, 1, 4, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, boundingBox, 0, 2, 0, 4, 5, 4, Blocks.field_201941_jj.func_176223_P(), Blocks.field_201941_jj.func_176223_P(), false, random);
            BlockState iblockstate = (BlockState)((BlockState)this.getStoneVariantBlockState(Blocks.field_150386_bk.func_176223_P(), random).func_206870_a((Property)FourWayBlock.field_196414_y, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)FourWayBlock.field_196411_b, (Comparable)Boolean.valueOf(true));
            BlockState iblockstate1 = (BlockState)((BlockState)this.getStoneVariantBlockState(Blocks.field_150386_bk.func_176223_P(), random).func_206870_a((Property)FourWayBlock.field_196409_a, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)FourWayBlock.field_196413_c, (Comparable)Boolean.valueOf(true));
            this.fillWithRandomBlocks(world, boundingBox, 0, 2, 0, 0, 5, 4, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, boundingBox, 0, 3, 1, 0, 4, 1, iblockstate1, iblockstate1, false, random);
            this.fillWithRandomBlocks(world, boundingBox, 0, 3, 3, 0, 4, 3, iblockstate1, iblockstate1, false, random);
            this.fillWithRandomBlocks(world, boundingBox, 4, 2, 0, 4, 5, 0, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, boundingBox, 1, 2, 4, 4, 5, 4, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, boundingBox, 1, 3, 4, 1, 4, 4, iblockstate, iblockstate, false, random);
            this.fillWithRandomBlocks(world, boundingBox, 3, 3, 4, 3, 4, 4, iblockstate, iblockstate, false, random);
            if (RepurposedStructures.RSMainConfig.lootChestsJF.get().booleanValue() && random.nextInt(9) == 0 && boundingBox.func_175898_b((Vector3i)new BlockPos(this.func_74865_a(1, 3), this.func_74862_a(2), this.func_74873_b(1, 3)))) {
                this.func_186167_a((IWorld)world, boundingBox, random, 1, 2, 3, JF_HALLWAY_CHEST_RL);
            }
            this.fillWithRandomBlocks(world, boundingBox, 0, 6, 0, 4, 6, 4, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            for (int i = 0; i <= 4; ++i) {
                for (int j = 0; j <= 4; ++j) {
                    this.replaceAirAndLiquidDownwardsRandomBlocks(world, Blocks.field_196653_dH.func_176223_P(), i, -1, j, boundingBox, random);
                }
            }
            this.fillWithWater(world, boundingBox, 0, 0, 0, 4, 6, 4);
            return true;
        }
    }

    public static class Corridor
    extends Piece {
        public Corridor(int p_i45615_1_, Random rand, MutableBoundingBox p_i45615_3_, Direction p_i45615_4_) {
            super(StructurePieces.JUNGLE_FORTRESS_CORRIDOR_1, p_i45615_1_);
            this.func_186164_a(p_i45615_4_);
            this.field_74887_e = p_i45615_3_;
        }

        public Corridor(TemplateManager p_i50272_1_, CompoundNBT p_i50272_2_) {
            super(StructurePieces.JUNGLE_FORTRESS_CORRIDOR_1, p_i50272_2_);
        }

        public void func_74861_a(StructurePiece componentIn, List<StructurePiece> listIn, Random rand) {
            this.getNextComponentX((Start)componentIn, listIn, rand, 0, 1, true);
        }

        public static Corridor createPiece(List<StructurePiece> structurePieceList, Random random, int x, int y, int z, Direction direction, int depth) {
            MutableBoundingBox mutableBoundingBox = MutableBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)-1, (int)0, (int)0, (int)5, (int)7, (int)5, (Direction)direction);
            return Corridor.isAboveGround(mutableBoundingBox) && StructurePiece.func_74883_a(structurePieceList, (MutableBoundingBox)mutableBoundingBox) == null ? new Corridor(depth, random, mutableBoundingBox, direction) : null;
        }

        public boolean func_230383_a_(ISeedReader world, StructureManager structureAccessor, ChunkGenerator generator, Random random, MutableBoundingBox boundingBox, ChunkPos chunkPos, BlockPos blockPos) {
            this.fillWithRandomBlocks(world, boundingBox, 0, 0, 0, 4, 1, 4, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, boundingBox, 0, 2, 0, 4, 5, 4, Blocks.field_201941_jj.func_176223_P(), Blocks.field_201941_jj.func_176223_P(), false, random);
            BlockState iblockstate = this.getStoneVariantBlockState((BlockState)((BlockState)Blocks.field_150386_bk.func_176223_P().func_206870_a((Property)FourWayBlock.field_196414_y, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)FourWayBlock.field_196411_b, (Comparable)Boolean.valueOf(true)), random);
            BlockState iblockstate1 = this.getStoneVariantBlockState((BlockState)((BlockState)Blocks.field_150386_bk.func_176223_P().func_206870_a((Property)FourWayBlock.field_196409_a, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)FourWayBlock.field_196413_c, (Comparable)Boolean.valueOf(true)), random);
            this.fillWithRandomBlocks(world, boundingBox, 4, 2, 0, 4, 5, 4, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, boundingBox, 4, 3, 1, 4, 4, 1, iblockstate1, iblockstate1, false, random);
            this.fillWithRandomBlocks(world, boundingBox, 4, 3, 3, 4, 4, 3, iblockstate1, iblockstate1, false, random);
            this.fillWithRandomBlocks(world, boundingBox, 0, 2, 0, 0, 5, 0, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, boundingBox, 0, 2, 4, 3, 5, 4, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, boundingBox, 1, 3, 4, 1, 4, 4, iblockstate, iblockstate, false, random);
            this.fillWithRandomBlocks(world, boundingBox, 3, 3, 4, 3, 4, 4, iblockstate, iblockstate, false, random);
            if (RepurposedStructures.RSMainConfig.lootChestsJF.get().booleanValue() && random.nextInt(9) == 0 && boundingBox.func_175898_b((Vector3i)new BlockPos(this.func_74865_a(3, 3), this.func_74862_a(2), this.func_74873_b(3, 3)))) {
                this.func_186167_a((IWorld)world, boundingBox, random, 3, 2, 3, JF_HALLWAY_CHEST_RL);
            }
            this.fillWithRandomBlocks(world, boundingBox, 0, 6, 0, 4, 6, 4, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            for (int i = 0; i <= 4; ++i) {
                for (int j = 0; j <= 4; ++j) {
                    this.replaceAirAndLiquidDownwardsRandomBlocks(world, Blocks.field_196653_dH.func_176223_P(), i, -1, j, boundingBox, random);
                }
            }
            this.fillWithWater(world, boundingBox, 0, 0, 0, 4, 5, 4);
            return true;
        }
    }

    public static class Corridor3
    extends Piece {
        public Corridor3(int p_i50280_1_, MutableBoundingBox p_i50280_2_, Direction p_i50280_3_) {
            super(StructurePieces.JUNGLE_FORTRESS_CORRIDOR_3, p_i50280_1_);
            this.func_186164_a(p_i50280_3_);
            this.field_74887_e = p_i50280_2_;
        }

        public Corridor3(TemplateManager p_i50281_1_, CompoundNBT p_i50281_2_) {
            super(StructurePieces.JUNGLE_FORTRESS_CORRIDOR_3, p_i50281_2_);
        }

        public void func_74861_a(StructurePiece componentIn, List<StructurePiece> listIn, Random rand) {
            this.getNextComponentNormal((Start)componentIn, listIn, rand, 1, 0, true);
        }

        public static Corridor3 createPiece(List<StructurePiece> structurePieceList, Random random, int x, int y, int z, Direction direction, int depth) {
            MutableBoundingBox mutableBoundingBox = MutableBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)-1, (int)-7, (int)0, (int)5, (int)14, (int)10, (Direction)direction);
            return Corridor3.isAboveGround(mutableBoundingBox) && StructurePiece.func_74883_a(structurePieceList, (MutableBoundingBox)mutableBoundingBox) == null ? new Corridor3(depth, mutableBoundingBox, direction) : null;
        }

        public boolean func_230383_a_(ISeedReader world, StructureManager structureAccessor, ChunkGenerator generator, Random random, MutableBoundingBox boundingBox, ChunkPos chunkPos, BlockPos blockPos) {
            BlockState iblockstate = this.getStoneVariantBlockState((BlockState)Blocks.field_150387_bl.func_176223_P().func_206870_a((Property)StairsBlock.field_176309_a, (Comparable)Direction.SOUTH), random);
            BlockState iblockstate1 = this.getStoneVariantBlockState((BlockState)((BlockState)Blocks.field_150386_bk.func_176223_P().func_206870_a((Property)FourWayBlock.field_196409_a, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)FourWayBlock.field_196413_c, (Comparable)Boolean.valueOf(true)), random);
            for (int i = 0; i <= 9; ++i) {
                int j = Math.max(1, 7 - i);
                int k = Math.min(Math.max(j + 5, 14 - i), 13);
                this.fillWithRandomBlocks(world, boundingBox, 0, 0, i, 4, j, i, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
                this.fillWithRandomBlocks(world, boundingBox, 1, j + 1, i, 3, k - 1, i, Blocks.field_201941_jj.func_176223_P(), Blocks.field_201941_jj.func_176223_P(), false, random);
                if (i <= 6) {
                    this.func_175811_a((IWorld)world, iblockstate, 1, j + 1, i, boundingBox);
                    this.func_175811_a((IWorld)world, iblockstate, 2, j + 1, i, boundingBox);
                    this.func_175811_a((IWorld)world, iblockstate, 3, j + 1, i, boundingBox);
                }
                this.fillWithRandomBlocks(world, boundingBox, 0, k, i, 4, k, i, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
                this.fillWithRandomBlocks(world, boundingBox, 0, j + 1, i, 0, k - 1, i, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
                this.fillWithRandomBlocks(world, boundingBox, 4, j + 1, i, 4, k - 1, i, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
                if ((i & 1) == 0) {
                    this.fillWithRandomBlocks(world, boundingBox, 0, j + 2, i, 0, j + 3, i, iblockstate1, iblockstate1, false, random);
                    this.fillWithRandomBlocks(world, boundingBox, 4, j + 2, i, 4, j + 3, i, iblockstate1, iblockstate1, false, random);
                }
                for (int i1 = 0; i1 <= 4; ++i1) {
                    this.replaceAirAndLiquidDownwardsRandomBlocks(world, Blocks.field_196653_dH.func_176223_P(), i1, -1, i, boundingBox, random);
                }
            }
            this.fillWithWater(world, boundingBox, 0, 0, 0, 4, 9, 9);
            return true;
        }
    }

    public static class Corridor4
    extends Piece {
        public Corridor4(int p_i50277_1_, MutableBoundingBox p_i50277_2_, Direction p_i50277_3_) {
            super(StructurePieces.JUNGLE_FORTRESS_CORRIDOR_4, p_i50277_1_);
            this.func_186164_a(p_i50277_3_);
            this.field_74887_e = p_i50277_2_;
        }

        public Corridor4(TemplateManager p_i50278_1_, CompoundNBT p_i50278_2_) {
            super(StructurePieces.JUNGLE_FORTRESS_CORRIDOR_4, p_i50278_2_);
        }

        public void func_74861_a(StructurePiece componentIn, List<StructurePiece> listIn, Random rand) {
            int i = 1;
            Direction enumfacing = this.func_186165_e();
            if (enumfacing == Direction.WEST || enumfacing == Direction.NORTH) {
                i = 5;
            }
            this.getNextComponentX((Start)componentIn, listIn, rand, 0, i, rand.nextInt(8) > 0);
            this.getNextComponentZ((Start)componentIn, listIn, rand, 0, i, rand.nextInt(8) > 0);
        }

        public static Corridor4 createPiece(List<StructurePiece> p_175880_0_, Random p_175880_1_, int p_175880_2_, int p_175880_3_, int p_175880_4_, Direction p_175880_5_, int p_175880_6_) {
            MutableBoundingBox mutableBoundingBox = MutableBoundingBox.func_175897_a((int)p_175880_2_, (int)p_175880_3_, (int)p_175880_4_, (int)-3, (int)0, (int)0, (int)9, (int)7, (int)9, (Direction)p_175880_5_);
            return Corridor4.isAboveGround(mutableBoundingBox) && StructurePiece.func_74883_a(p_175880_0_, (MutableBoundingBox)mutableBoundingBox) == null ? new Corridor4(p_175880_6_, mutableBoundingBox, p_175880_5_) : null;
        }

        public boolean func_230383_a_(ISeedReader world, StructureManager structureAccessor, ChunkGenerator generator, Random random, MutableBoundingBox boundingBox, ChunkPos chunkPos, BlockPos blockPos) {
            BlockState iblockstate = this.getStoneVariantBlockState((BlockState)((BlockState)Blocks.field_150386_bk.func_176223_P().func_206870_a((Property)FourWayBlock.field_196409_a, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)FourWayBlock.field_196413_c, (Comparable)Boolean.valueOf(true)), random);
            BlockState iblockstate1 = this.getStoneVariantBlockState((BlockState)((BlockState)Blocks.field_150386_bk.func_176223_P().func_206870_a((Property)FourWayBlock.field_196414_y, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)FourWayBlock.field_196411_b, (Comparable)Boolean.valueOf(true)), random);
            this.fillWithRandomBlocks(world, boundingBox, 0, 0, 0, 8, 1, 8, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, boundingBox, 0, 2, 0, 8, 5, 8, Blocks.field_201941_jj.func_176223_P(), Blocks.field_201941_jj.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, boundingBox, 0, 6, 0, 8, 6, 5, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, boundingBox, 0, 2, 0, 2, 5, 0, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, boundingBox, 6, 2, 0, 8, 5, 0, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, boundingBox, 1, 3, 0, 1, 4, 0, iblockstate1, iblockstate1, false, random);
            this.fillWithRandomBlocks(world, boundingBox, 7, 3, 0, 7, 4, 0, iblockstate1, iblockstate1, false, random);
            this.fillWithRandomBlocks(world, boundingBox, 0, 2, 4, 8, 2, 8, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, boundingBox, 1, 1, 4, 2, 2, 4, Blocks.field_201941_jj.func_176223_P(), Blocks.field_201941_jj.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, boundingBox, 6, 1, 4, 7, 2, 4, Blocks.field_201941_jj.func_176223_P(), Blocks.field_201941_jj.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, boundingBox, 1, 3, 8, 7, 3, 8, iblockstate1, iblockstate1, false, random);
            this.func_175811_a((IWorld)world, this.getStoneVariantBlockState((BlockState)((BlockState)Blocks.field_150386_bk.func_176223_P().func_206870_a((Property)FourWayBlock.field_196411_b, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)FourWayBlock.field_196413_c, (Comparable)Boolean.valueOf(true)), random), 0, 3, 8, boundingBox);
            this.func_175811_a((IWorld)world, this.getStoneVariantBlockState((BlockState)((BlockState)Blocks.field_150386_bk.func_176223_P().func_206870_a((Property)FourWayBlock.field_196414_y, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)FourWayBlock.field_196413_c, (Comparable)Boolean.valueOf(true)), random), 8, 3, 8, boundingBox);
            this.fillWithRandomBlocks(world, boundingBox, 0, 3, 6, 0, 3, 7, iblockstate, iblockstate, false, random);
            this.fillWithRandomBlocks(world, boundingBox, 8, 3, 6, 8, 3, 7, iblockstate, iblockstate, false, random);
            this.fillWithRandomBlocks(world, boundingBox, 0, 3, 4, 0, 5, 5, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, boundingBox, 8, 3, 4, 8, 5, 5, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, boundingBox, 1, 3, 5, 2, 5, 5, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, boundingBox, 6, 3, 5, 7, 5, 5, Blocks.field_196653_dH.func_176223_P(), this.getStoneVariantBlockState(Blocks.field_196653_dH.func_176223_P(), random), false, random);
            this.fillWithRandomBlocks(world, boundingBox, 1, 4, 5, 1, 5, 5, iblockstate1, iblockstate1, false, random);
            this.fillWithRandomBlocks(world, boundingBox, 7, 4, 5, 7, 5, 5, iblockstate1, iblockstate1, false, random);
            for (int i = 0; i <= 5; ++i) {
                for (int j = 0; j <= 8; ++j) {
                    this.replaceAirAndLiquidDownwardsRandomBlocks(world, Blocks.field_196653_dH.func_176223_P(), j, -1, i, boundingBox, random);
                }
            }
            this.fillWithWater(world, boundingBox, 0, 0, 0, 8, 5, 8);
            return true;
        }
    }

    public static class Crossing2
    extends Piece {
        public Crossing2(int p_i50273_1_, MutableBoundingBox p_i50273_2_, Direction p_i50273_3_) {
            super(StructurePieces.JUNGLE_FORTRESS_CROSSING_2, p_i50273_1_);
            this.func_186164_a(p_i50273_3_);
            this.field_74887_e = p_i50273_2_;
        }

        public Crossing2(TemplateManager p_i50274_1_, CompoundNBT p_i50274_2_) {
            super(StructurePieces.JUNGLE_FORTRESS_CROSSING_2, p_i50274_2_);
        }

        public void func_74861_a(StructurePiece componentIn, List<StructurePiece> listIn, Random rand) {
            this.getNextComponentNormal((Start)componentIn, listIn, rand, 1, 0, true);
            this.getNextComponentX((Start)componentIn, listIn, rand, 0, 1, true);
            this.getNextComponentZ((Start)componentIn, listIn, rand, 0, 1, true);
        }

        public static Crossing2 createPiece(List<StructurePiece> structurePieceList, Random random, int x, int y, int z, Direction direction, int depth) {
            MutableBoundingBox mutableBoundingBox = MutableBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)-1, (int)0, (int)0, (int)5, (int)7, (int)5, (Direction)direction);
            return Crossing2.isAboveGround(mutableBoundingBox) && StructurePiece.func_74883_a(structurePieceList, (MutableBoundingBox)mutableBoundingBox) == null ? new Crossing2(depth, mutableBoundingBox, direction) : null;
        }

        public boolean func_230383_a_(ISeedReader world, StructureManager structureAccessor, ChunkGenerator generator, Random random, MutableBoundingBox boundingBox, ChunkPos chunkPos, BlockPos blockPos) {
            this.fillWithRandomBlocks(world, boundingBox, 0, 0, 0, 4, 1, 4, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, boundingBox, 0, 2, 0, 4, 5, 4, Blocks.field_201941_jj.func_176223_P(), Blocks.field_201941_jj.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, boundingBox, 0, 2, 0, 0, 5, 0, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, boundingBox, 4, 2, 0, 4, 5, 0, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, boundingBox, 0, 2, 4, 0, 5, 4, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, boundingBox, 4, 2, 4, 4, 5, 4, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, boundingBox, 0, 6, 0, 4, 6, 4, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            for (int i = 0; i <= 4; ++i) {
                for (int j = 0; j <= 4; ++j) {
                    this.replaceAirAndLiquidDownwardsRandomBlocks(world, Blocks.field_196653_dH.func_176223_P(), i, -1, j, boundingBox, random);
                }
            }
            this.fillWithWater(world, boundingBox, 0, 0, 0, 4, 6, 4);
            return true;
        }
    }

    public static class MushroomRoom
    extends Piece {
        public MushroomRoom(int p_i50264_1_, MutableBoundingBox p_i50264_2_, Direction p_i50264_3_) {
            super(StructurePieces.JUNGLE_FORTRESS_MUSHROOM_ROOM, p_i50264_1_);
            this.func_186164_a(p_i50264_3_);
            this.field_74887_e = p_i50264_2_;
        }

        public MushroomRoom(TemplateManager p_i50265_1_, CompoundNBT p_i50265_2_) {
            super(StructurePieces.JUNGLE_FORTRESS_MUSHROOM_ROOM, p_i50265_2_);
        }

        public void func_74861_a(StructurePiece componentIn, List<StructurePiece> listIn, Random rand) {
            this.getNextComponentNormal((Start)componentIn, listIn, rand, 5, 3, true);
            this.getNextComponentNormal((Start)componentIn, listIn, rand, 5, 11, true);
        }

        public static MushroomRoom createPiece(List<StructurePiece> structurePieceList, Random random, int x, int y, int z, Direction direction, int depth) {
            MutableBoundingBox mutableBoundingBox = MutableBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)-5, (int)-3, (int)0, (int)13, (int)14, (int)13, (Direction)direction);
            return MushroomRoom.isAboveGround(mutableBoundingBox) && StructurePiece.func_74883_a(structurePieceList, (MutableBoundingBox)mutableBoundingBox) == null ? new MushroomRoom(depth, mutableBoundingBox, direction) : null;
        }

        public boolean func_230383_a_(ISeedReader world, StructureManager structureAccessor, ChunkGenerator generator, Random random, MutableBoundingBox boundingBox, ChunkPos chunkPos, BlockPos blockPos) {
            this.fillWithRandomBlocks(world, boundingBox, 0, 3, 0, 12, 4, 12, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, boundingBox, 0, 5, 0, 12, 13, 12, Blocks.field_201941_jj.func_176223_P(), Blocks.field_201941_jj.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, boundingBox, 0, 5, 0, 1, 12, 12, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, boundingBox, 11, 5, 0, 12, 12, 12, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, boundingBox, 2, 5, 11, 4, 12, 12, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, boundingBox, 8, 5, 11, 10, 12, 12, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, boundingBox, 5, 9, 11, 7, 12, 12, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, boundingBox, 2, 5, 0, 4, 12, 1, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, boundingBox, 8, 5, 0, 10, 12, 1, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, boundingBox, 5, 9, 0, 7, 12, 1, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, boundingBox, 2, 11, 2, 10, 12, 10, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            BlockState iblockstate = this.getStoneVariantBlockState((BlockState)((BlockState)Blocks.field_150386_bk.func_176223_P().func_206870_a((Property)FourWayBlock.field_196414_y, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)FourWayBlock.field_196411_b, (Comparable)Boolean.valueOf(true)), random);
            BlockState iblockstate1 = this.getStoneVariantBlockState((BlockState)((BlockState)Blocks.field_150386_bk.func_176223_P().func_206870_a((Property)FourWayBlock.field_196409_a, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)FourWayBlock.field_196413_c, (Comparable)Boolean.valueOf(true)), random);
            BlockState iblockstate2 = (BlockState)iblockstate1.func_206870_a((Property)FourWayBlock.field_196414_y, (Comparable)Boolean.valueOf(true));
            BlockState iblockstate3 = (BlockState)iblockstate1.func_206870_a((Property)FourWayBlock.field_196411_b, (Comparable)Boolean.valueOf(true));
            for (int i = 1; i <= 11; i += 2) {
                this.fillWithRandomBlocks(world, boundingBox, i, 10, 0, i, 11, 0, iblockstate, iblockstate, false, random);
                this.fillWithRandomBlocks(world, boundingBox, i, 10, 12, i, 11, 12, iblockstate, iblockstate, false, random);
                this.fillWithRandomBlocks(world, boundingBox, 0, 10, i, 0, 11, i, iblockstate1, iblockstate1, false, random);
                this.fillWithRandomBlocks(world, boundingBox, 12, 10, i, 12, 11, i, iblockstate1, iblockstate1, false, random);
                this.func_175811_a((IWorld)world, this.getStoneVariantBlockState(Blocks.field_196653_dH.func_176223_P(), random), i, 13, 0, boundingBox);
                this.func_175811_a((IWorld)world, this.getStoneVariantBlockState(Blocks.field_196653_dH.func_176223_P(), random), i, 13, 12, boundingBox);
                this.func_175811_a((IWorld)world, this.getStoneVariantBlockState(Blocks.field_196653_dH.func_176223_P(), random), 0, 13, i, boundingBox);
                this.func_175811_a((IWorld)world, this.getStoneVariantBlockState(Blocks.field_196653_dH.func_176223_P(), random), 12, 13, i, boundingBox);
                this.func_175811_a((IWorld)world, iblockstate, i + 1, 13, 0, boundingBox);
                this.func_175811_a((IWorld)world, iblockstate, i + 1, 13, 12, boundingBox);
                this.func_175811_a((IWorld)world, iblockstate1, 0, 13, i + 1, boundingBox);
                this.func_175811_a((IWorld)world, iblockstate1, 12, 13, i + 1, boundingBox);
            }
            this.func_175811_a((IWorld)world, this.getStoneVariantBlockState((BlockState)((BlockState)Blocks.field_150386_bk.func_176223_P().func_206870_a((Property)FourWayBlock.field_196409_a, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)FourWayBlock.field_196411_b, (Comparable)Boolean.valueOf(true)), random), 0, 13, 0, boundingBox);
            this.func_175811_a((IWorld)world, this.getStoneVariantBlockState((BlockState)((BlockState)Blocks.field_150386_bk.func_176223_P().func_206870_a((Property)FourWayBlock.field_196413_c, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)FourWayBlock.field_196411_b, (Comparable)Boolean.valueOf(true)), random), 0, 13, 12, boundingBox);
            this.func_175811_a((IWorld)world, this.getStoneVariantBlockState((BlockState)((BlockState)Blocks.field_150386_bk.func_176223_P().func_206870_a((Property)FourWayBlock.field_196413_c, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)FourWayBlock.field_196414_y, (Comparable)Boolean.valueOf(true)), random), 12, 13, 12, boundingBox);
            this.func_175811_a((IWorld)world, this.getStoneVariantBlockState((BlockState)((BlockState)Blocks.field_150386_bk.func_176223_P().func_206870_a((Property)FourWayBlock.field_196409_a, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)FourWayBlock.field_196414_y, (Comparable)Boolean.valueOf(true)), random), 12, 13, 0, boundingBox);
            for (int j1 = 3; j1 <= 9; j1 += 2) {
                this.fillWithRandomBlocks(world, boundingBox, 1, 7, j1, 1, 8, j1, iblockstate2, iblockstate2, false, random);
                this.fillWithRandomBlocks(world, boundingBox, 11, 7, j1, 11, 8, j1, iblockstate3, iblockstate3, false, random);
            }
            BlockState iblockstate4 = this.getStoneVariantBlockState((BlockState)Blocks.field_150387_bl.func_176223_P().func_206870_a((Property)StairsBlock.field_176309_a, (Comparable)Direction.NORTH), random);
            for (int j = 0; j <= 6; ++j) {
                int k = j + 4;
                for (int l = 5; l <= 7; ++l) {
                    this.func_175811_a((IWorld)world, iblockstate4, l, 5 + j, k, boundingBox);
                }
                if (k >= 5 && k <= 8) {
                    this.fillWithRandomBlocks(world, boundingBox, 5, 5, k, 7, j + 4, k, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
                } else if (k >= 9 && k <= 10) {
                    this.fillWithRandomBlocks(world, boundingBox, 5, 8, k, 7, j + 4, k, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
                }
                if (j < 1) continue;
                this.fillWithRandomBlocks(world, boundingBox, 5, 6 + j, k, 7, 9 + j, k, Blocks.field_201941_jj.func_176223_P(), Blocks.field_201941_jj.func_176223_P(), false, random);
            }
            for (int k1 = 5; k1 <= 7; ++k1) {
                this.func_175811_a((IWorld)world, iblockstate4, k1, 12, 11, boundingBox);
            }
            this.fillWithRandomBlocks(world, boundingBox, 5, 6, 7, 5, 7, 7, iblockstate, iblockstate, false, random);
            this.fillWithRandomBlocks(world, boundingBox, 7, 6, 7, 7, 7, 7, iblockstate, iblockstate, false, random);
            this.fillWithRandomBlocks(world, boundingBox, 5, 13, 12, 7, 13, 12, Blocks.field_201941_jj.func_176223_P(), Blocks.field_201941_jj.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, boundingBox, 2, 5, 2, 3, 5, 3, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, boundingBox, 2, 5, 9, 3, 5, 10, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, boundingBox, 2, 5, 4, 2, 5, 8, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, boundingBox, 9, 5, 2, 10, 5, 3, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, boundingBox, 9, 5, 9, 10, 5, 10, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, boundingBox, 10, 5, 4, 10, 5, 8, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            BlockState iblockstate5 = (BlockState)iblockstate4.func_206870_a((Property)StairsBlock.field_176309_a, (Comparable)Direction.EAST);
            BlockState iblockstate6 = (BlockState)iblockstate4.func_206870_a((Property)StairsBlock.field_176309_a, (Comparable)Direction.WEST);
            this.func_175811_a((IWorld)world, iblockstate6, 4, 5, 2, boundingBox);
            this.func_175811_a((IWorld)world, iblockstate6, 4, 5, 3, boundingBox);
            this.func_175811_a((IWorld)world, iblockstate6, 4, 5, 9, boundingBox);
            this.func_175811_a((IWorld)world, iblockstate6, 4, 5, 10, boundingBox);
            this.func_175811_a((IWorld)world, iblockstate5, 8, 5, 2, boundingBox);
            this.func_175811_a((IWorld)world, iblockstate5, 8, 5, 3, boundingBox);
            this.func_175811_a((IWorld)world, iblockstate5, 8, 5, 9, boundingBox);
            this.func_175811_a((IWorld)world, iblockstate5, 8, 5, 10, boundingBox);
            this.fillWithRandomBlocks(world, boundingBox, 3, 4, 4, 4, 4, 8, Blocks.field_150425_aM.func_176223_P(), Blocks.field_150425_aM.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, boundingBox, 8, 4, 4, 9, 4, 8, Blocks.field_150425_aM.func_176223_P(), Blocks.field_150425_aM.func_176223_P(), false, random);
            if (this.func_74862_a(5) >= world.func_201672_e().func_181545_F()) {
                this.fillWithRandomBlocks(world, boundingBox, 3, 5, 4, 4, 5, 8, Blocks.field_150388_bm.func_176223_P(), Blocks.field_150388_bm.func_176223_P(), false, random);
                this.fillWithRandomBlocks(world, boundingBox, 8, 5, 4, 9, 5, 8, Blocks.field_150388_bm.func_176223_P(), Blocks.field_150388_bm.func_176223_P(), false, random);
            }
            this.fillWithRandomBlocks(world, boundingBox, 4, 2, 0, 8, 2, 12, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, boundingBox, 0, 2, 4, 12, 2, 8, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, boundingBox, 4, 0, 0, 8, 1, 3, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, boundingBox, 4, 0, 9, 8, 1, 12, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, boundingBox, 0, 0, 4, 3, 1, 8, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            this.fillWithRandomBlocks(world, boundingBox, 9, 0, 4, 12, 1, 8, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            for (int l1 = 4; l1 <= 8; ++l1) {
                for (int i1 = 0; i1 <= 2; ++i1) {
                    this.replaceAirAndLiquidDownwardsRandomBlocks(world, Blocks.field_196653_dH.func_176223_P(), l1, -1, i1, boundingBox, random);
                    this.replaceAirAndLiquidDownwardsRandomBlocks(world, Blocks.field_196653_dH.func_176223_P(), l1, -1, 12 - i1, boundingBox, random);
                }
            }
            for (int i2 = 0; i2 <= 2; ++i2) {
                for (int j2 = 4; j2 <= 8; ++j2) {
                    this.replaceAirAndLiquidDownwardsRandomBlocks(world, Blocks.field_196653_dH.func_176223_P(), i2, -1, j2, boundingBox, random);
                    this.replaceAirAndLiquidDownwardsRandomBlocks(world, Blocks.field_196653_dH.func_176223_P(), 12 - i2, -1, j2, boundingBox, random);
                }
            }
            this.fillWithWater(world, boundingBox, 0, 0, 0, 12, 13, 12);
            return true;
        }
    }

    public static class Start
    extends Crossing3 {
        public PieceWeight fortressPieceWeight;
        public List<PieceWeight> primaryWeights;
        public List<PieceWeight> secondaryWeights;
        public List<StructurePiece> pendingChildren = Lists.newArrayList();

        public Start(Random random, int x, int z) {
            super(random, x, z);
            this.primaryWeights = Lists.newArrayList();
            for (PieceWeight structurenetherbridgepieces$pieceweight : PRIMARY_COMPONENTS) {
                structurenetherbridgepieces$pieceweight.placeCount = 0;
                this.primaryWeights.add(structurenetherbridgepieces$pieceweight);
            }
            this.secondaryWeights = Lists.newArrayList();
            for (PieceWeight structurenetherbridgepieces$pieceweight1 : SECONDARY_COMPONENTS) {
                structurenetherbridgepieces$pieceweight1.placeCount = 0;
                this.secondaryWeights.add(structurenetherbridgepieces$pieceweight1);
            }
        }

        public Start(TemplateManager p_i50253_1_, CompoundNBT p_i50253_2_) {
            super(StructurePieces.JUNGLE_FORTRESS_START, p_i50253_2_);
        }
    }

    public static class End
    extends Piece {
        private final int fillSeed;

        public End(int p_i45621_1_, Random p_i45621_2_, MutableBoundingBox p_i45621_3_, Direction p_i45621_4_) {
            super(StructurePieces.JUNGLE_FORTRESS_END, p_i45621_1_);
            this.func_186164_a(p_i45621_4_);
            this.field_74887_e = p_i45621_3_;
            this.fillSeed = p_i45621_2_.nextInt();
        }

        public End(TemplateManager p_i50285_1_, CompoundNBT p_i50285_2_) {
            super(StructurePieces.JUNGLE_FORTRESS_END, p_i50285_2_);
            this.fillSeed = p_i50285_2_.func_74762_e("Seed");
        }

        public static End createPiece(List<StructurePiece> structurePieceList, Random random, int x, int y, int z, Direction direction, int depth) {
            MutableBoundingBox mutableBoundingBox = MutableBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)-1, (int)-3, (int)0, (int)5, (int)10, (int)8, (Direction)direction);
            return End.isAboveGround(mutableBoundingBox) && StructurePiece.func_74883_a(structurePieceList, (MutableBoundingBox)mutableBoundingBox) == null ? new End(depth, random, mutableBoundingBox, direction) : null;
        }

        @Override
        protected void func_143011_b(CompoundNBT tagCompound) {
            super.func_143011_b(tagCompound);
            tagCompound.func_74768_a("Seed", this.fillSeed);
        }

        public boolean func_230383_a_(ISeedReader world, StructureManager structureAccessor, ChunkGenerator generator, Random random, MutableBoundingBox boundingBox, ChunkPos chunkPos, BlockPos blockPos) {
            Random seededRandom = new Random(this.fillSeed);
            for (int i = 0; i <= 4; ++i) {
                for (int j = 3; j <= 4; ++j) {
                    int k = seededRandom.nextInt(8);
                    this.fillWithRandomBlocks(world, boundingBox, i, j, 0, i, j, k, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
                }
            }
            int l = seededRandom.nextInt(8);
            this.fillWithRandomBlocks(world, boundingBox, 0, 5, 0, 0, 5, l, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            l = seededRandom.nextInt(8);
            this.fillWithRandomBlocks(world, boundingBox, 4, 5, 0, 4, 5, l, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            for (l = 0; l <= 4; ++l) {
                int i1 = seededRandom.nextInt(5);
                this.fillWithRandomBlocks(world, boundingBox, l, 2, 0, l, 2, i1, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
            }
            for (l = 0; l <= 4; ++l) {
                for (int j1 = 0; j1 <= 1; ++j1) {
                    int k1 = seededRandom.nextInt(3);
                    this.fillWithRandomBlocks(world, boundingBox, l, j1, 0, l, j1, k1, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false, random);
                }
            }
            this.fillWithWater(world, boundingBox, 0, 0, 0, 7, 5, 7);
            return true;
        }
    }
}

