/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.combustivefishing.common.item;

import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.BucketItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import top.theillusivec4.combustivefishing.common.entity.AbstractLavaFishEntity;

public class LavaFishBucketItem
extends BucketItem {
    private final Supplier<? extends EntityType<?>> fishTypeSupplier;

    public LavaFishBucketItem(Supplier<? extends EntityType<?>> fishTypeIn, Supplier<? extends Fluid> fluidIn) {
        super(fluidIn, new Item.Properties().func_200917_a(1).func_200916_a(ItemGroup.field_78026_f));
        this.fishTypeSupplier = fishTypeIn;
        this.setRegistryName(fishTypeIn.get().getRegistryName() + "_bucket");
    }

    public void func_203792_a(World worldIn, ItemStack p_203792_2_, BlockPos pos) {
        if (!worldIn.field_72995_K) {
            this.placeFish(worldIn, p_203792_2_, pos);
        }
    }

    protected void func_203791_b(@Nullable PlayerEntity player, IWorld worldIn, @Nonnull BlockPos pos) {
        worldIn.func_184133_a(player, pos, SoundEvents.field_203819_X, SoundCategory.NEUTRAL, 1.0f, 0.5f);
    }

    private void placeFish(World worldIn, ItemStack stack, BlockPos pos) {
        Entity entity = this.getFishType().func_220331_a(worldIn, stack, null, pos, SpawnReason.BUCKET, true, false);
        if (entity != null) {
            ((AbstractLavaFishEntity)entity).setFromBucket(true);
        }
    }

    protected EntityType<?> getFishType() {
        return this.fishTypeSupplier.get();
    }
}

