/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden;

import java.util.UUID;
import net.minecraft.client.world.DimensionRenderInfo;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IDataProvider;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.commons.lang3.tuple.Pair;
import quek.undergarden.UndergardenConfig;
import quek.undergarden.client.ClientStuff;
import quek.undergarden.client.UndergardenDimensionRenderInfo;
import quek.undergarden.data.UndergardenBlockStates;
import quek.undergarden.data.UndergardenItemModels;
import quek.undergarden.data.UndergardenLang;
import quek.undergarden.data.UndergardenLootTables;
import quek.undergarden.data.UndergardenRecipes;
import quek.undergarden.registry.UndergardenBiomes;
import quek.undergarden.registry.UndergardenBlocks;
import quek.undergarden.registry.UndergardenDimensions;
import quek.undergarden.registry.UndergardenEffects;
import quek.undergarden.registry.UndergardenEntities;
import quek.undergarden.registry.UndergardenFeatures;
import quek.undergarden.registry.UndergardenFluids;
import quek.undergarden.registry.UndergardenItems;
import quek.undergarden.registry.UndergardenParticles;
import quek.undergarden.registry.UndergardenTEs;
import quek.undergarden.registry.UndergardenWorldCarvers;

@Mod(value="undergarden")
public class UndergardenMod {
    public static final String MODID = "undergarden";

    public UndergardenMod() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(this::setup);
        bus.addListener(this::clientSetup);
        bus.addListener(this::gatherData);
        UndergardenEntities.ENTITIES.register(bus);
        UndergardenBlocks.BLOCKS.register(bus);
        UndergardenItems.ITEMS.register(bus);
        UndergardenBiomes.BIOMES.register(bus);
        UndergardenFeatures.FEATURES.register(bus);
        UndergardenWorldCarvers.CARVERS.register(bus);
        UndergardenEffects.EFFECTS.register(bus);
        UndergardenFluids.FLUIDS.register(bus);
        UndergardenParticles.PARTICLES.register(bus);
        UndergardenTEs.TEs.register(bus);
        Pair specPairCommon = new ForgeConfigSpec.Builder().configure(UndergardenConfig.CommonConfig::new);
        Pair specPairClient = new ForgeConfigSpec.Builder().configure(UndergardenConfig.ClientConfig::new);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (ForgeConfigSpec)specPairCommon.getRight());
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (ForgeConfigSpec)specPairClient.getRight());
    }

    public void setup(FMLCommonSetupEvent event) {
        UndergardenBiomes.addBiomeTypes();
        UndergardenBiomes.addBiomeFeatures();
        UndergardenEntities.spawnPlacements();
        UndergardenEntities.entityAttributes();
    }

    public void clientSetup(FMLClientSetupEvent event) {
        ClientStuff.registerBlockRenderers();
        ClientStuff.registerEntityRenderers();
        ClientStuff.registerBlockColors();
        ClientStuff.registerItemColors();
        UndergardenDimensionRenderInfo dimensionRenderInfo = new UndergardenDimensionRenderInfo();
        DimensionRenderInfo.field_239208_a_.put(UndergardenDimensions.undergarden, (Object)dimensionRenderInfo);
    }

    public void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        if (event.includeClient()) {
            generator.func_200390_a((IDataProvider)new UndergardenBlockStates(generator, event.getExistingFileHelper()));
            generator.func_200390_a((IDataProvider)new UndergardenItemModels(generator, event.getExistingFileHelper()));
            generator.func_200390_a((IDataProvider)new UndergardenLang(generator));
        }
        if (event.includeServer()) {
            generator.func_200390_a((IDataProvider)new UndergardenRecipes(generator));
            generator.func_200390_a((IDataProvider)new UndergardenLootTables(generator));
        }
    }

    @Mod.EventBusSubscriber(modid="undergarden")
    public static class ForgeEventBus {
        @SubscribeEvent
        @OnlyIn(value=Dist.CLIENT)
        public static void memeEvent(RenderPlayerEvent event) {
            if (event.getEntity() instanceof PlayerEntity && UUID.fromString("353a859b-ba16-4e6a-8f63-9a8c79ab0071").equals(event.getEntity().func_110124_au())) {
                event.getMatrixStack().func_227862_a_(0.5f, 0.5f, 0.5f);
            }
            if (event.getEntity() instanceof PlayerEntity && UUID.fromString("cf1f2cfc-1a85-40a6-aaf4-a17355ac6579").equals(event.getEntity().func_110124_au())) {
                event.getMatrixStack().func_227862_a_(1.0f, 0.5f, 1.0f);
            }
            if (event.getEntity() instanceof PlayerEntity && UUID.fromString("925e5f40-b7d2-4614-8491-c1bc13d8223d").equals(event.getEntity().func_110124_au())) {
                event.getMatrixStack().func_227862_a_(1.5f, 1.0f, 1.5f);
            }
        }
    }
}

