/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.block.world;

import java.util.function.Supplier;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import quek.undergarden.registry.UndergardenBlocks;
import quek.undergarden.registry.UndergardenEntities;
import quek.undergarden.registry.UndergardenFluids;

public class UndergardenFluidBlock
extends FlowingFluidBlock {
    public UndergardenFluidBlock(Supplier<? extends FlowingFluid> supplier, AbstractBlock.Properties properties) {
        super(supplier, properties.func_200942_a().func_200943_b(100.0f).func_222380_e());
    }

    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entityIn) {
        LivingEntity livingEntity;
        if ((this.getFluid() == UndergardenFluids.virulent_mix_source.get() || this.getFluid() == UndergardenFluids.virulent_mix_flowing.get()) && entityIn.func_70089_S() && entityIn instanceof LivingEntity && (livingEntity = (LivingEntity)entityIn).func_70668_bt() != UndergardenEntities.ROTSPAWN) {
            livingEntity.func_195064_c(new EffectInstance(Effects.field_76436_u, 600, 0));
        }
    }

    public void func_220082_b(BlockState state, World worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (this.reactWithNeighbors(worldIn, pos, state)) {
            worldIn.func_205219_F_().func_205360_a(pos, (Object)state.func_204520_s().func_206886_c(), this.getFluid().func_205569_a((IWorldReader)worldIn));
        }
    }

    private boolean reactWithNeighbors(World worldIn, BlockPos pos, BlockState state) {
        if (super.getFluid().func_207185_a((ITag)FluidTags.field_206960_b)) {
            boolean flag = worldIn.func_180495_p(pos.func_177977_b()).func_203425_a(Blocks.field_235336_cN_);
            for (Direction direction : Direction.values()) {
                if (direction == Direction.DOWN) continue;
                BlockPos blockpos = pos.func_177972_a(direction);
                if (worldIn.func_204610_c(blockpos).func_206884_a((ITag)FluidTags.field_206959_a)) {
                    Block block = worldIn.func_204610_c(pos).func_206889_d() ? Blocks.field_150343_Z : (Block)UndergardenBlocks.depthrock.get();
                    worldIn.func_175656_a(pos, ForgeEventFactory.fireFluidPlaceBlockEvent((IWorld)worldIn, (BlockPos)pos, (BlockPos)pos, (BlockState)block.func_176223_P()));
                    this.triggerMixEffects((IWorld)worldIn, pos);
                    return false;
                }
                if (!flag || !worldIn.func_180495_p(blockpos).func_203425_a(Blocks.field_205164_gk)) continue;
                worldIn.func_175656_a(pos, ForgeEventFactory.fireFluidPlaceBlockEvent((IWorld)worldIn, (BlockPos)pos, (BlockPos)pos, (BlockState)Blocks.field_235337_cO_.func_176223_P()));
                this.triggerMixEffects((IWorld)worldIn, pos);
                return false;
            }
        }
        return true;
    }

    private void triggerMixEffects(IWorld worldIn, BlockPos pos) {
        worldIn.func_217379_c(1501, pos, 0);
    }
}

