/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.block.world;

import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class UndergardenLeavesBlock
extends LeavesBlock {
    public static final IntegerProperty DISTANCE = BlockStateProperties.field_208514_aa;
    public static final BooleanProperty PERSISTENT = BlockStateProperties.field_208515_s;

    public UndergardenLeavesBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151584_j).func_200943_b(0.2f).func_200947_a(SoundType.field_185850_c).func_226896_b_());
    }

    public boolean isFlammable(BlockState state, IBlockReader world, BlockPos pos, Direction face) {
        return true;
    }

    public int getFlammability(BlockState state, IBlockReader world, BlockPos pos, Direction face) {
        return 300;
    }

    public VoxelShape func_230335_e_(BlockState p_230335_1_, IBlockReader p_230335_2_, BlockPos p_230335_3_) {
        return VoxelShapes.func_197880_a();
    }

    public boolean func_149653_t(BlockState state) {
        return (Integer)state.func_177229_b((Property)DISTANCE) == 7 && (Boolean)state.func_177229_b((Property)PERSISTENT) == false;
    }

    public void func_225542_b_(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
        if (!((Boolean)state.func_177229_b((Property)PERSISTENT)).booleanValue() && (Integer)state.func_177229_b((Property)DISTANCE) == 7) {
            UndergardenLeavesBlock.func_220075_c((BlockState)state, (World)worldIn, (BlockPos)pos);
            worldIn.func_217377_a(pos, false);
        }
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        worldIn.func_180501_a(pos, UndergardenLeavesBlock.updateDistance(state, (IWorld)worldIn, pos), 3);
    }

    public int func_200011_d(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return 1;
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        int i = UndergardenLeavesBlock.getDistance(facingState) + 1;
        if (i != 1 || (Integer)stateIn.func_177229_b((Property)DISTANCE) != i) {
            worldIn.func_205220_G_().func_205360_a(currentPos, (Object)this, 1);
        }
        return stateIn;
    }

    private static BlockState updateDistance(BlockState state, IWorld worldIn, BlockPos pos) {
        int i = 7;
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        for (Direction direction : Direction.values()) {
            blockpos$mutable.func_239622_a_((Vector3i)pos, direction);
            i = Math.min(i, UndergardenLeavesBlock.getDistance(worldIn.func_180495_p((BlockPos)blockpos$mutable)) + 1);
            if (i == 1) break;
        }
        return (BlockState)state.func_206870_a((Property)DISTANCE, (Comparable)Integer.valueOf(i));
    }

    private static int getDistance(BlockState neighbor) {
        if (BlockTags.field_200031_h.func_230235_a_((Object)neighbor.func_177230_c())) {
            return 0;
        }
        return neighbor.func_177230_c() instanceof LeavesBlock ? (Integer)neighbor.func_177229_b((Property)DISTANCE) : 7;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        BlockPos blockpos;
        BlockState blockstate;
        if (!(!worldIn.func_175727_C(pos.func_177984_a()) || rand.nextInt(15) != 1 || (blockstate = worldIn.func_180495_p(blockpos = pos.func_177977_b())).func_200132_m() && blockstate.func_224755_d((IBlockReader)worldIn, blockpos, Direction.UP))) {
            double d0 = (double)pos.func_177958_n() + rand.nextDouble();
            double d1 = (double)pos.func_177956_o() - 0.05;
            double d2 = (double)pos.func_177952_p() + rand.nextDouble();
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197618_k, d0, d1, d2, 0.0, 0.0, 0.0);
        }
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{DISTANCE, PERSISTENT});
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return UndergardenLeavesBlock.updateDistance((BlockState)this.func_176223_P().func_206870_a((Property)PERSISTENT, (Comparable)Boolean.valueOf(true)), (IWorld)context.func_195991_k(), context.func_195995_a());
    }
}

