/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.block.world;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.StemBlock;
import net.minecraft.block.StemGrownBlock;
import net.minecraft.block.material.Material;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import quek.undergarden.block.world.UndergardenCropsBlock;
import quek.undergarden.registry.UndergardenBlocks;
import quek.undergarden.registry.UndergardenItems;

public class UndergardenStemBlock
extends StemBlock
implements IGrowable {
    public static final IntegerProperty AGE = BlockStateProperties.field_208170_W;
    protected static final VoxelShape[] SHAPES = new VoxelShape[]{Block.func_208617_a((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)2.0, (double)9.0), Block.func_208617_a((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)4.0, (double)9.0), Block.func_208617_a((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)6.0, (double)9.0), Block.func_208617_a((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)8.0, (double)9.0), Block.func_208617_a((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)10.0, (double)9.0), Block.func_208617_a((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)12.0, (double)9.0), Block.func_208617_a((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)14.0, (double)9.0), Block.func_208617_a((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0)};
    private final StemGrownBlock crop;

    public UndergardenStemBlock(StemGrownBlock crop) {
        super(crop, AbstractBlock.Properties.func_200945_a((Material)Material.field_151585_k).func_200942_a().func_200944_c().func_200943_b(0.0f).func_200947_a(SoundType.field_222473_t).func_222380_e());
        this.crop = crop;
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{AGE});
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPES[(Integer)state.func_177229_b((Property)AGE)];
    }

    public boolean func_200014_a_(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return state.func_177230_c() == Blocks.field_150458_ak || state.func_177230_c() == UndergardenBlocks.deepsoil_farmland.get();
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        BlockPos blockpos = pos.func_177977_b();
        return this.func_200014_a_(worldIn.func_180495_p(blockpos), (IBlockReader)worldIn, blockpos);
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        float f;
        if (!worldIn.isAreaLoaded(pos, 1)) {
            return;
        }
        if (worldIn.func_226659_b_(pos, 0) >= 0 && ForgeHooks.onCropsGrowPre((World)worldIn, (BlockPos)pos, (BlockState)state, (rand.nextInt((int)(25.0f / (f = UndergardenCropsBlock.getGrowthChance((Block)this, (IBlockReader)worldIn, pos))) + 1) == 0 ? 1 : 0) != 0)) {
            int i = (Integer)state.func_177229_b((Property)AGE);
            if (i < 7) {
                worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)AGE, (Comparable)Integer.valueOf(i + 1)), 2);
            } else {
                Direction direction = Direction.Plane.HORIZONTAL.func_179518_a(rand);
                BlockPos blockpos = pos.func_177972_a(direction);
                BlockState soil = worldIn.func_180495_p(blockpos.func_177977_b());
                Block block = soil.func_177230_c();
                if (worldIn.func_175623_d(blockpos) && (soil.canSustainPlant((IBlockReader)worldIn, blockpos.func_177977_b(), Direction.UP, (IPlantable)this) || block == Blocks.field_150458_ak || block == UndergardenBlocks.deepsoil_farmland.get())) {
                    worldIn.func_175656_a(blockpos, this.crop.func_176223_P());
                    worldIn.func_175656_a(pos, (BlockState)this.crop.func_196523_e().func_176223_P().func_206870_a((Property)HorizontalBlock.field_185512_D, (Comparable)direction));
                }
            }
            ForgeHooks.onCropsGrowPost((World)worldIn, (BlockPos)pos, (BlockState)state);
        }
    }

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    protected Item func_176481_j() {
        return (Item)UndergardenItems.gloomgourd_seeds.get();
    }

    public ItemStack func_185473_a(IBlockReader worldIn, BlockPos pos, BlockState state) {
        Item item = this.func_176481_j();
        return item == null ? ItemStack.field_190927_a : new ItemStack((IItemProvider)item);
    }

    public boolean func_176473_a(IBlockReader worldIn, BlockPos pos, BlockState state, boolean isClient) {
        return (Integer)state.func_177229_b((Property)AGE) != 7;
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, BlockState state) {
        return true;
    }

    public void func_225535_a_(ServerWorld p_225535_1_, Random rand, BlockPos pos, BlockState p_225535_4_) {
        int i = Math.min(7, (Integer)p_225535_4_.func_177229_b((Property)AGE) + MathHelper.func_76136_a((Random)p_225535_1_.field_73012_v, (int)2, (int)5));
        BlockState blockstate = (BlockState)p_225535_4_.func_206870_a((Property)AGE, (Comparable)Integer.valueOf(i));
        p_225535_1_.func_180501_a(pos, blockstate, 2);
        if (i == 7) {
            blockstate.func_227033_a_(p_225535_1_, pos, p_225535_1_.field_73012_v);
        }
    }
}

