/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.client;

import java.awt.Color;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.client.renderer.entity.SpriteRenderer;
import net.minecraft.entity.EntityType;
import net.minecraft.item.BlockItem;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.biome.BiomeColors;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import quek.undergarden.client.render.entity.BlisterbomberRender;
import quek.undergarden.client.render.entity.BruteRender;
import quek.undergarden.client.render.entity.DwellerRender;
import quek.undergarden.client.render.entity.GloomperRender;
import quek.undergarden.client.render.entity.GwiblingRender;
import quek.undergarden.client.render.entity.MasticatorRender;
import quek.undergarden.client.render.entity.RotDwellerRender;
import quek.undergarden.client.render.entity.RotbeastRender;
import quek.undergarden.client.render.entity.RotlingRender;
import quek.undergarden.client.render.entity.RotwalkerRender;
import quek.undergarden.client.render.entity.ScintlingRender;
import quek.undergarden.client.render.entity.StonebornRender;
import quek.undergarden.registry.UndergardenBlocks;
import quek.undergarden.registry.UndergardenEntities;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(modid="undergarden", value={Dist.CLIENT})
public class ClientStuff {
    private static final Minecraft CLIENT = Minecraft.func_71410_x();

    private static void render(Supplier<? extends Block> block, RenderType render) {
        RenderTypeLookup.setRenderLayer((Block)block.get(), (RenderType)render);
    }

    public static void registerBlockRenderers() {
        RenderType cutout = RenderType.func_228643_e_();
        RenderType mipped = RenderType.func_228641_d_();
        RenderType translucent = RenderType.func_228645_f_();
        ClientStuff.render(UndergardenBlocks.deepturf_block, mipped);
        ClientStuff.render(UndergardenBlocks.tall_deepturf, cutout);
        ClientStuff.render(UndergardenBlocks.shimmerweed, cutout);
        ClientStuff.render(UndergardenBlocks.smogstem_sapling, cutout);
        ClientStuff.render(UndergardenBlocks.wigglewood_sapling, cutout);
        ClientStuff.render(UndergardenBlocks.indigo_mushroom, cutout);
        ClientStuff.render(UndergardenBlocks.veil_mushroom, cutout);
        ClientStuff.render(UndergardenBlocks.ink_mushroom, cutout);
        ClientStuff.render(UndergardenBlocks.blood_mushroom, cutout);
        ClientStuff.render(UndergardenBlocks.underbean_bush, cutout);
        ClientStuff.render(UndergardenBlocks.smogstem_torch, cutout);
        ClientStuff.render(UndergardenBlocks.smogstem_wall_torch, cutout);
        ClientStuff.render(UndergardenBlocks.ditchbulb_plant, cutout);
        ClientStuff.render(UndergardenBlocks.double_deepturf, cutout);
        ClientStuff.render(UndergardenBlocks.double_shimmerweed, cutout);
        ClientStuff.render(UndergardenBlocks.cloggrum_bars, cutout);
        ClientStuff.render(UndergardenBlocks.glowing_kelp, cutout);
        ClientStuff.render(UndergardenBlocks.glowing_kelp_plant, cutout);
        ClientStuff.render(UndergardenBlocks.glowing_sea_grass, cutout);
        ClientStuff.render(UndergardenBlocks.undergarden_portal, translucent);
        ClientStuff.render(UndergardenBlocks.goo, translucent);
        ClientStuff.render(UndergardenBlocks.smogstem_door, cutout);
        ClientStuff.render(UndergardenBlocks.wigglewood_door, cutout);
        ClientStuff.render(UndergardenBlocks.smogstem_trapdoor, cutout);
        ClientStuff.render(UndergardenBlocks.wigglewood_trapdoor, cutout);
        ClientStuff.render(UndergardenBlocks.ashen_tall_deepturf, cutout);
        ClientStuff.render(UndergardenBlocks.blisterberry_bush, cutout);
        ClientStuff.render(UndergardenBlocks.gloomgourd_stem, cutout);
        ClientStuff.render(UndergardenBlocks.gloomgourd_stem_attached, cutout);
        ClientStuff.render(UndergardenBlocks.shard_torch, cutout);
        ClientStuff.render(UndergardenBlocks.shard_wall_torch, cutout);
        ClientStuff.render(UndergardenBlocks.droopvine_top, cutout);
        ClientStuff.render(UndergardenBlocks.droopvine, cutout);
        ClientStuff.render(UndergardenBlocks.virulent_mix, translucent);
    }

    public static void registerEntityRenderers() {
        ItemRenderer itemRenderer = Minecraft.func_71410_x().func_175599_af();
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)UndergardenEntities.SLINGSHOT_AMMO.get()), entity -> new SpriteRenderer(entity, itemRenderer));
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)UndergardenEntities.GOO_BALL.get()), entity -> new SpriteRenderer(entity, itemRenderer));
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)UndergardenEntities.ROTTEN_BLISTERBERRY.get()), entity -> new SpriteRenderer(entity, itemRenderer));
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)UndergardenEntities.BLISTERBOMB.get()), entity -> new SpriteRenderer(entity, itemRenderer));
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)UndergardenEntities.ROTLING.get()), RotlingRender::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)UndergardenEntities.ROTWALKER.get()), RotwalkerRender::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)UndergardenEntities.ROTBEAST.get()), RotbeastRender::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)UndergardenEntities.DWELLER.get()), DwellerRender::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)UndergardenEntities.ROTDWELLER.get()), RotDwellerRender::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)UndergardenEntities.GWIBLING.get()), GwiblingRender::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)UndergardenEntities.BRUTE.get()), BruteRender::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)UndergardenEntities.SCINTLING.get()), ScintlingRender::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)UndergardenEntities.BLISTERBOMBER.get()), BlisterbomberRender::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)UndergardenEntities.GLOOMPER.get()), GloomperRender::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)UndergardenEntities.STONEBORN.get()), StonebornRender::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)UndergardenEntities.MASTICATOR.get()), MasticatorRender::new);
    }

    public static void registerBlockColors() {
        BlockColors colors = Minecraft.func_71410_x().func_184125_al();
        colors.func_186722_a((state, world, pos, tint) -> world != null && pos != null ? BiomeColors.func_228358_a_((IBlockDisplayReader)world, (BlockPos)pos) : new Color(91, 117, 91).getRGB(), new Block[]{(Block)UndergardenBlocks.deepturf_block.get(), (Block)UndergardenBlocks.tall_deepturf.get(), (Block)UndergardenBlocks.shimmerweed.get(), (Block)UndergardenBlocks.double_deepturf.get(), (Block)UndergardenBlocks.double_shimmerweed.get(), (Block)UndergardenBlocks.gloomgourd_stem.get(), (Block)UndergardenBlocks.gloomgourd_stem_attached.get()});
    }

    public static void registerItemColors() {
        BlockColors bColors = Minecraft.func_71410_x().func_184125_al();
        ItemColors iColors = Minecraft.func_71410_x().getItemColors();
        iColors.func_199877_a((stack, tint) -> bColors.func_228054_a_(((BlockItem)stack.func_77973_b()).func_179223_d().func_176223_P(), null, null, 0), new IItemProvider[]{(IItemProvider)UndergardenBlocks.deepturf_block.get(), (IItemProvider)UndergardenBlocks.tall_deepturf.get(), (IItemProvider)UndergardenBlocks.shimmerweed.get(), (IItemProvider)UndergardenBlocks.double_shimmerweed.get(), (IItemProvider)UndergardenBlocks.double_deepturf.get()});
        iColors.func_199877_a((stack, tint) -> {
            if (tint == 0) {
                return new Color(91, 117, 91).getRGB();
            }
            return -1;
        }, new IItemProvider[]{(IItemProvider)UndergardenBlocks.shimmerweed.get(), (IItemProvider)UndergardenBlocks.double_shimmerweed.get()});
    }
}

