/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.data.provider;

import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.FenceBlock;
import net.minecraft.block.FourWayBlock;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.StairsBlock;
import net.minecraft.block.TrapDoorBlock;
import net.minecraft.data.DataGenerator;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ExistingFileHelper;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import quek.undergarden.data.provider.UndergardenBlockModelProvider;

public abstract class UndergardenBlockStateProvider
extends BlockStateProvider {
    private static UndergardenBlockModelProvider provider;

    public UndergardenBlockStateProvider(DataGenerator generator, ExistingFileHelper fileHelper) {
        super(generator, "undergarden", fileHelper);
        provider = new UndergardenBlockModelProvider(generator, fileHelper){

            public String func_200397_b() {
                return UndergardenBlockStateProvider.this.func_200397_b();
            }

            protected void registerModels() {
            }
        };
    }

    public UndergardenBlockModelProvider models() {
        return provider;
    }

    protected ResourceLocation texture(String name) {
        return this.modLoc("block/" + name);
    }

    protected String blockName(Supplier<? extends Block> block) {
        return block.get().getRegistryName().func_110623_a();
    }

    public void normalBlock(Supplier<? extends Block> block) {
        this.simpleBlock(block.get());
    }

    public void woodBlock(Supplier<? extends RotatedPillarBlock> block, String name) {
        this.axisBlock(block.get(), this.texture(name));
    }

    private void crossBlock(Supplier<? extends Block> block, ModelFile model) {
        this.getVariantBuilder(block.get()).forAllStates(state -> ConfiguredModel.builder().modelFile(model).build());
    }

    public void torchBlock(Supplier<? extends Block> block, Supplier<? extends Block> wall) {
        ModelBuilder torch = this.models().torch(this.blockName(block), this.texture(this.blockName(block)));
        ModelBuilder torchwall = this.models().torchWall(this.blockName(wall), this.texture(this.blockName(block)));
        this.simpleBlock(block.get(), (ModelFile)torch);
        this.getVariantBuilder(wall.get()).forAllStates(arg_0 -> UndergardenBlockStateProvider.lambda$torchBlock$1((ModelFile)torchwall, arg_0));
    }

    public void crossBlock(Supplier<? extends Block> block) {
        this.crossBlock(block, (ModelFile)this.models().cross(this.blockName(block), this.texture(this.blockName(block))));
    }

    public void stairs(Supplier<? extends StairsBlock> block, String name) {
        this.stairsBlock(block.get(), this.texture(name));
    }

    public void slab(Supplier<? extends SlabBlock> block, Supplier<? extends Block> fullBlock) {
        this.slabBlock(block.get(), this.texture(this.blockName(fullBlock)), this.texture(this.blockName(fullBlock)));
    }

    public void fence(Supplier<? extends FenceBlock> block, String name) {
        this.fenceBlock(block.get(), this.texture(name));
        this.fenceColumn(block, name);
    }

    private void fenceColumn(Supplier<? extends FenceBlock> block, String side) {
        String baseName = block.get().getRegistryName().toString();
        this.fourWayBlock((FourWayBlock)block.get(), (ModelFile)this.models().fencePost(baseName + "_post", this.texture(side)), (ModelFile)this.models().fenceSide(baseName + "_side", this.texture(side)));
    }

    public void door(Supplier<? extends DoorBlock> block, String name) {
        this.doorBlock(block.get(), this.texture(name + "_door_bottom"), this.texture(name + "_door_top"));
    }

    public void trapdoor(Supplier<? extends TrapDoorBlock> block, String name) {
        this.trapdoorBlock(block.get(), this.texture(name + "_trapdoor"), true);
    }

    private static /* synthetic */ ConfiguredModel[] lambda$torchBlock$1(ModelFile torchwall, BlockState state) {
        return ConfiguredModel.builder().modelFile(torchwall).rotationY(((int)((Direction)state.func_177229_b((Property)BlockStateProperties.field_208157_J)).func_185119_l() + 90) % 360).build();
    }
}

