/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.entity;

import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IAngerable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.DamageSource;
import net.minecraft.util.RangedInteger;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.TickRangeConverter;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.Difficulty;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import quek.undergarden.registry.UndergardenBlocks;
import quek.undergarden.registry.UndergardenSoundEvents;

public class BruteEntity
extends MonsterEntity
implements IAngerable {
    private static final UUID field_234344_b_ = UUID.fromString("49455A49-7EC5-45BA-B886-3B90B23A1718");
    private static final AttributeModifier field_234349_c_ = new AttributeModifier(field_234344_b_, "Attacking speed boost", 0.05, AttributeModifier.Operation.ADDITION);
    private static final RangedInteger field_234350_d_ = TickRangeConverter.func_233037_a_((int)0, (int)1);
    private int angerLevel;
    private static final RangedInteger field_234346_bv_ = TickRangeConverter.func_233037_a_((int)20, (int)39);
    private int field_234347_bw_;
    private UUID field_234348_bx_;
    private static final RangedInteger field_241403_bz_ = TickRangeConverter.func_233037_a_((int)4, (int)6);
    private int field_241401_bA_;

    public BruteEntity(EntityType<? extends BruteEntity> type, World worldIn) {
        super(type, worldIn);
    }

    protected boolean func_225511_J_() {
        return false;
    }

    public int func_230256_F__() {
        return this.field_234347_bw_;
    }

    public void func_230260_a__(int p_230260_1_) {
        this.field_234347_bw_ = p_230260_1_;
    }

    @Nullable
    public UUID func_230257_G__() {
        return this.field_234348_bx_;
    }

    public void func_230259_a_(@Nullable UUID p_230259_1_) {
        this.field_234348_bx_ = p_230259_1_;
    }

    public void func_230258_H__() {
        this.func_230260_a__(field_234346_bv_.func_233018_a_(this.field_70146_Z));
    }

    public void func_70604_c(@Nullable LivingEntity livingBase) {
        super.func_70604_c(livingBase);
        if (livingBase != null) {
            this.field_234348_bx_ = livingBase.func_110124_au();
        }
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, false));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByAggressorGoal(this));
        this.field_70715_bh.func_75776_a(2, (Goal)new TargetAggressorGoal(this));
        this.field_70714_bg.func_75776_a(5, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtGoal((MobEntity)this, BruteEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookRandomlyGoal((MobEntity)this));
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 20.0).func_233815_a_(Attributes.field_233821_d_, 0.23).func_233815_a_(Attributes.field_233823_f_, 3.0);
    }

    public static boolean canBruteSpawn(EntityType<? extends MonsterEntity> animal, IWorld worldIn, SpawnReason reason, BlockPos pos, Random random) {
        return worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() == UndergardenBlocks.deepturf_block.get();
    }

    protected void func_70619_bc() {
        ModifiableAttributeInstance modifiableattributeinstance = this.func_110148_a(Attributes.field_233821_d_);
        if (this.func_233678_J__()) {
            if (!this.func_70631_g_() && !modifiableattributeinstance.func_180374_a(field_234349_c_)) {
                modifiableattributeinstance.func_233767_b_(field_234349_c_);
            }
            this.func_241409_eY_();
        } else if (modifiableattributeinstance.func_180374_a(field_234349_c_)) {
            modifiableattributeinstance.func_111124_b(field_234349_c_);
        }
        this.func_241359_a_((ServerWorld)this.field_70170_p, true);
        if (this.func_70638_az() != null) {
            this.func_241410_eZ_();
        }
        if (this.func_233678_J__()) {
            this.field_70718_bc = this.field_70173_aa;
        }
        super.func_70619_bc();
    }

    private void func_241409_eY_() {
        if (this.angerLevel > 0) {
            --this.angerLevel;
            if (this.angerLevel == 0) {
                this.angrySound();
            }
        }
    }

    private void angrySound() {
        this.func_184185_a(UndergardenSoundEvents.BRUTE_ANGRY, this.func_70599_aP() * 2.0f, this.func_70647_i() * 1.8f);
    }

    private void func_241410_eZ_() {
        if (this.field_241401_bA_ > 0) {
            --this.field_241401_bA_;
        } else {
            if (this.func_70635_at().func_75522_a((Entity)this.func_70638_az())) {
                this.func_241411_fa_();
            }
            this.field_241401_bA_ = field_241403_bz_.func_233018_a_(this.field_70146_Z);
        }
    }

    private void func_241411_fa_() {
        double d0 = this.func_233637_b_(Attributes.field_233821_d_);
        AxisAlignedBB axisalignedbb = AxisAlignedBB.func_241549_a_((Vector3d)this.func_213303_ch()).func_72314_b(d0, 10.0, d0);
        this.field_70170_p.func_225317_b(BruteEntity.class, axisalignedbb).stream().filter(p_241408_1_ -> p_241408_1_ != this).filter(p_241407_0_ -> p_241407_0_.func_70638_az() == null).filter(p_241406_1_ -> !p_241406_1_.func_184191_r((Entity)this.func_70638_az())).forEach(p_241405_1_ -> p_241405_1_.func_70624_b(this.func_70638_az()));
    }

    public void func_70624_b(@Nullable LivingEntity entitylivingbaseIn) {
        if (this.func_70638_az() == null && entitylivingbaseIn != null) {
            this.angerLevel = field_234350_d_.func_233018_a_(this.field_70146_Z);
            this.field_241401_bA_ = field_241403_bz_.func_233018_a_(this.field_70146_Z);
        }
        if (entitylivingbaseIn instanceof PlayerEntity) {
            this.func_230246_e_((PlayerEntity)entitylivingbaseIn);
        }
        super.func_70624_b(entitylivingbaseIn);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        this.func_233682_c_(compound);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.func_241358_a_((ServerWorld)this.field_70170_p, compound);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        return !this.func_180431_b(source) && super.func_70097_a(source, amount);
    }

    private boolean func_226547_i_(LivingEntity p_226547_1_) {
        this.angerLevel = this.func_223336_ef();
        this.func_70604_c(p_226547_1_);
        return true;
    }

    private int func_223336_ef() {
        return 400 + this.field_70146_Z.nextInt(400);
    }

    private boolean isAngry() {
        return this.angerLevel > 0;
    }

    protected SoundEvent func_184639_G() {
        return UndergardenSoundEvents.BRUTE_LIVING;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return UndergardenSoundEvents.BRUTE_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return UndergardenSoundEvents.BRUTE_DEATH;
    }

    static class TargetAggressorGoal
    extends NearestAttackableTargetGoal<PlayerEntity> {
        public TargetAggressorGoal(BruteEntity brute) {
            super((MobEntity)brute, PlayerEntity.class, true);
        }

        public boolean func_75250_a() {
            return ((BruteEntity)this.field_75299_d).isAngry() && super.func_75250_a();
        }
    }

    static class HurtByAggressorGoal
    extends HurtByTargetGoal {
        public HurtByAggressorGoal(BruteEntity brute) {
            super((CreatureEntity)brute, new Class[0]);
        }

        protected void func_220793_a(MobEntity mobIn, LivingEntity targetIn) {
            if (targetIn.field_70170_p.func_175659_aa() != Difficulty.PEACEFUL && mobIn instanceof BruteEntity && this.field_75299_d.func_70685_l((Entity)targetIn) && ((BruteEntity)mobIn).func_226547_i_(targetIn)) {
                mobIn.func_70624_b(targetIn);
            }
        }
    }
}

