/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.entity.stoneborn;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IAngerable;
import net.minecraft.entity.INPC;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.merchant.IMerchant;
import net.minecraft.entity.merchant.villager.VillagerTrades;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.MerchantOffer;
import net.minecraft.item.MerchantOffers;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Difficulty;
import net.minecraft.world.Explosion;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;
import quek.undergarden.entity.rotspawn.AbstractRotspawnEntity;
import quek.undergarden.registry.UndergardenBlocks;
import quek.undergarden.registry.UndergardenEntities;
import quek.undergarden.registry.UndergardenItems;
import quek.undergarden.registry.UndergardenSoundEvents;

public class StonebornEntity
extends MonsterEntity
implements IAngerable,
INPC,
IMerchant {
    private static final DataParameter<Boolean> isChild = EntityDataManager.func_187226_a(StonebornEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final UUID BABY_SPEED_MODIFIER_IDENTIFIER = UUID.fromString("766bfa64-11f3-11ea-8d71-362b9e155667");
    private static final AttributeModifier BABY_SPEED_MODIFIER = new AttributeModifier(BABY_SPEED_MODIFIER_IDENTIFIER, "Baby speed boost", (double)0.2f, AttributeModifier.Operation.MULTIPLY_BASE);
    private int timeInOverworld = 0;
    private UUID uuid;
    @Nullable
    private PlayerEntity customer;
    @Nullable
    protected MerchantOffers offers;
    public static final Int2ObjectMap<VillagerTrades.ITrade[]> stonebornTrades = StonebornEntity.gatAsIntMap((ImmutableMap<Integer, VillagerTrades.ITrade[]>)ImmutableMap.of((Object)1, (Object)new VillagerTrades.ITrade[]{new ItemsForRegaliumTrade((Item)UndergardenItems.blisterbomb.get(), 5, 1, 3, 1), new ItemsForRegaliumTrade((Item)UndergardenItems.underbeans.get(), 1, 24, 64, 1), new ItemsForRegaliumTrade(Items.field_151133_ar, 20, 1, 1, 5), new ItemsForRegaliumTrade(Items.field_151097_aZ, 10, 1, 1, 5), new ItemsForRegaliumTrade(Items.field_151145_ak, 5, 1, 4, 5), new RegaliumForItemsTrade((IItemProvider)Items.field_151042_j, 4, 1, 24, 3), new RegaliumForItemsTrade((IItemProvider)Items.field_151043_k, 5, 1, 24, 3), new RegaliumForItemsTrade((IItemProvider)Items.field_151045_i, 10, 1, 24, 3), new RegaliumForItemsTrade((IItemProvider)Items.field_234759_km_, 20, 1, 24, 3), new RegaliumForItemsTrade((IItemProvider)Items.field_151137_ax, 16, 1, 24, 3), new RegaliumForItemsTrade((IItemProvider)Items.field_196128_bn, 3, 3, 24, 3)}));

    public StonebornEntity(EntityType<? extends StonebornEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70138_W = 1.0f;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new TradeWithPlayerGoal(this));
        this.field_70714_bg.func_75776_a(0, (Goal)new LookAtCustomerGoal(this));
        this.field_70714_bg.func_75776_a(1, (Goal)new TemptGoal((CreatureEntity)this, 1.0, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)UndergardenBlocks.regalium_block.get(), (IItemProvider)UndergardenItems.regalium_ingot.get(), (IItemProvider)UndergardenItems.regalium_nugget.get()}), false));
        this.field_70714_bg.func_75776_a(1, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 0.3));
        this.field_70714_bg.func_75776_a(2, (Goal)new LookAtGoal((MobEntity)this, LivingEntity.class, 32.0f));
        this.field_70714_bg.func_75776_a(2, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(0, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, true));
        this.field_70715_bh.func_75776_a(2, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]).func_220794_a(new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, AbstractRotspawnEntity.class, true));
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return AgeableEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 50.0).func_233815_a_(Attributes.field_233826_i_, 10.0).func_233815_a_(Attributes.field_233821_d_, 0.3).func_233815_a_(Attributes.field_233820_c_, 0.9).func_233815_a_(Attributes.field_233823_f_, 10.0);
    }

    public static boolean canStonebornSpawn(EntityType<? extends MonsterEntity> type, IWorld worldIn, SpawnReason reason, BlockPos pos, Random randomIn) {
        return worldIn.func_175659_aa() != Difficulty.PEACEFUL && StonebornEntity.func_223315_a(type, (IWorld)worldIn, (SpawnReason)reason, (BlockPos)pos, (Random)randomIn);
    }

    public void func_70074_a(LivingEntity entityLivingIn) {
        super.func_70074_a(entityLivingIn);
        if (entityLivingIn.func_70668_bt() == UndergardenEntities.ROTSPAWN || entityLivingIn instanceof PlayerEntity) {
            this.func_184185_a(UndergardenSoundEvents.STONEBORN_CHUCKLE, 1.0f, 1.0f);
        }
    }

    public boolean func_70648_aU() {
        return true;
    }

    protected SoundEvent func_184639_G() {
        if (this.func_213398_dR()) {
            return UndergardenSoundEvents.STONEBORN_ANGRY;
        }
        if (this.hasCustomer()) {
            return UndergardenSoundEvents.STONEBORN_SPEAKING;
        }
        if (this.customer != null && (this.customer.func_184614_ca().func_77973_b() == UndergardenItems.regalium_ingot.get() || this.customer.func_184614_ca().func_77973_b() == UndergardenItems.regalium_nugget.get() || this.customer.func_184614_ca().func_77973_b() == ((Block)UndergardenBlocks.regalium_block.get()).func_199767_j() || this.customer.func_184592_cb().func_77973_b() == UndergardenItems.regalium_ingot.get() || this.customer.func_184592_cb().func_77973_b() == UndergardenItems.regalium_nugget.get() || this.customer.func_184592_cb().func_77973_b() == ((Block)UndergardenBlocks.regalium_block.get()).func_199767_j())) {
            return UndergardenSoundEvents.STONEBORN_AWE;
        }
        if (this.inOverworld()) {
            return UndergardenSoundEvents.STONEBORN_CONFUSED;
        }
        return null;
    }

    public SoundEvent func_213714_ea() {
        return UndergardenSoundEvents.STONEBORN_PLEASED;
    }

    protected SoundEvent getVillagerYesNoSound(boolean getYesSound) {
        return getYesSound ? UndergardenSoundEvents.STONEBORN_PLEASED : UndergardenSoundEvents.STONEBORN_CONFUSED;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return UndergardenSoundEvents.STONEBORN_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return UndergardenSoundEvents.STONEBORN_DEATH;
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a(UndergardenSoundEvents.STONEBORN_STEP, 1.0f, 1.0f);
    }

    protected boolean func_225511_J_() {
        return false;
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return !this.func_104002_bU();
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        if (this.func_70631_g_()) {
            compound.func_74757_a("IsBaby", true);
        }
        compound.func_74768_a("TimeInOverworld", this.timeInOverworld);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.func_82227_f(compound.func_74767_n("IsBaby"));
        this.timeInOverworld = compound.func_74762_e("TimeInOverworld");
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(isChild, (Object)false);
    }

    public void func_184206_a(DataParameter<?> key) {
        super.func_184206_a(key);
        if (isChild.equals(key)) {
            this.func_213323_x_();
        }
    }

    public void func_82227_f(boolean childStoneborn) {
        this.func_184212_Q().func_187227_b(isChild, (Object)childStoneborn);
        if (!this.field_70170_p.field_72995_K) {
            ModifiableAttributeInstance modifiableattributeinstance = this.func_110148_a(Attributes.field_233821_d_);
            modifiableattributeinstance.func_111124_b(BABY_SPEED_MODIFIER);
            if (childStoneborn) {
                modifiableattributeinstance.func_233767_b_(BABY_SPEED_MODIFIER);
            }
        }
    }

    public boolean func_70631_g_() {
        return (Boolean)this.func_184212_Q().func_187225_a(isChild);
    }

    public boolean inOverworld() {
        return !this.field_70170_p.func_230315_m_().func_241509_i_() && !this.func_175446_cd();
    }

    protected void func_70619_bc() {
        if (this.inOverworld()) {
            ++this.timeInOverworld;
            this.func_195064_c(new EffectInstance(Effects.field_76431_k, 200, 0));
        } else {
            this.timeInOverworld = 0;
        }
        if (this.timeInOverworld > 300) {
            this.remove(false);
            Explosion.Mode explosion$mode = ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)this) ? Explosion.Mode.DESTROY : Explosion.Mode.NONE;
            this.field_70170_p.func_217385_a((Entity)this, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 3.0f, explosion$mode);
        }
        if (!this.func_213398_dR() && this.field_70170_p.func_82737_E() % 40L == 0L) {
            this.func_70691_i(1.0f);
        }
    }

    public float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return this.func_70631_g_() ? sizeIn.field_220316_b * 0.9f : 2.3f;
    }

    public int func_230256_F__() {
        return 0;
    }

    public void func_230260_a__(int i) {
    }

    @Nullable
    public UUID func_230257_G__() {
        return this.uuid;
    }

    public void func_230259_a_(@Nullable UUID uuid) {
        this.uuid = uuid;
    }

    public void func_230258_H__() {
    }

    public ActionResultType func_230254_b_(PlayerEntity p_230254_1_, Hand p_230254_2_) {
        ItemStack itemstack = p_230254_1_.func_184586_b(p_230254_2_);
        if (!this.func_213398_dR() && itemstack.func_77973_b() != UndergardenItems.stoneborn_spawn_egg.get() && this.func_70089_S() && !this.hasCustomer() && !this.func_70631_g_()) {
            if (p_230254_2_ == Hand.MAIN_HAND) {
                p_230254_1_.func_195066_a(Stats.field_188074_H);
            }
            if (this.func_213706_dY().isEmpty()) {
                return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
            }
            if (!this.field_70170_p.field_72995_K) {
                this.func_70932_a_(p_230254_1_);
                this.func_213707_a(p_230254_1_, this.func_145748_c_(), 1);
            }
            return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
        }
        return super.func_230254_b_(p_230254_1_, p_230254_2_);
    }

    public boolean hasCustomer() {
        return this.customer != null;
    }

    public void func_70932_a_(@Nullable PlayerEntity playerEntity) {
        this.customer = playerEntity;
    }

    @Nullable
    public PlayerEntity func_70931_l_() {
        return this.customer;
    }

    public MerchantOffers func_213706_dY() {
        if (this.offers == null) {
            this.offers = new MerchantOffers();
            this.populateTradeData();
        }
        return this.offers;
    }

    private static Int2ObjectMap<VillagerTrades.ITrade[]> gatAsIntMap(ImmutableMap<Integer, VillagerTrades.ITrade[]> p_221238_0_) {
        return new Int2ObjectOpenHashMap(p_221238_0_);
    }

    protected void populateTradeData() {
        VillagerTrades.ITrade[] trades = (VillagerTrades.ITrade[])stonebornTrades.get(1);
        if (trades != null) {
            MerchantOffers merchantoffers = this.func_213706_dY();
            this.addTrades(merchantoffers, trades, 5);
            int i = this.field_70146_Z.nextInt(trades.length);
            VillagerTrades.ITrade villagertrades$itrade = trades[i];
            MerchantOffer merchantoffer = villagertrades$itrade.func_221182_a((Entity)this, this.field_70146_Z);
            if (merchantoffer != null) {
                merchantoffers.add((Object)merchantoffer);
            }
        }
    }

    protected void addTrades(MerchantOffers givenMerchantOffers, VillagerTrades.ITrade[] newTrades, int maxNumbers) {
        HashSet set = Sets.newHashSet();
        if (newTrades.length > maxNumbers) {
            while (set.size() < maxNumbers) {
                set.add(this.field_70146_Z.nextInt(newTrades.length));
            }
        } else {
            for (int i = 0; i < newTrades.length; ++i) {
                set.add(i);
            }
        }
        for (Integer integer : set) {
            VillagerTrades.ITrade villagertrades$itrade = newTrades[integer];
            MerchantOffer merchantoffer = villagertrades$itrade.func_221182_a((Entity)this, this.field_70146_Z);
            if (merchantoffer == null) continue;
            givenMerchantOffers.add((Object)merchantoffer);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_213703_a(MerchantOffers offers) {
    }

    public void func_213704_a(MerchantOffer offer) {
        offer.func_222219_j();
        this.field_70757_a = -this.func_70627_aG();
        this.onVillagerTrade(offer);
        if (this.customer instanceof ServerPlayerEntity) {
            // empty if block
        }
    }

    protected void onVillagerTrade(MerchantOffer offer) {
        if (offer.func_222221_q()) {
            int i = 3 + this.field_70146_Z.nextInt(4);
            this.field_70170_p.func_217376_c((Entity)new ExperienceOrbEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_() + 0.5, this.func_226281_cx_(), i));
        }
    }

    public void func_110297_a_(ItemStack stack) {
        if (!this.field_70170_p.field_72995_K && this.field_70757_a > -this.func_70627_aG() + 20) {
            this.field_70757_a = -this.func_70627_aG();
            this.func_184185_a(this.getVillagerYesNoSound(!stack.func_190926_b()), this.func_70599_aP(), this.func_70647_i());
        }
    }

    public World func_190670_t_() {
        return this.field_70170_p;
    }

    public int func_213708_dV() {
        return 0;
    }

    public void func_213702_q(int i) {
    }

    public boolean func_213705_dZ() {
        return false;
    }

    public static class LookAtCustomerGoal
    extends LookAtGoal {
        private final StonebornEntity stoneborn;

        public LookAtCustomerGoal(StonebornEntity stonebornEntity) {
            super((MobEntity)stonebornEntity, PlayerEntity.class, 8.0f);
            this.stoneborn = stonebornEntity;
        }

        public boolean func_75250_a() {
            if (this.stoneborn.hasCustomer()) {
                this.field_75334_a = this.stoneborn.func_70931_l_();
                return true;
            }
            return false;
        }
    }

    public static class TradeWithPlayerGoal
    extends Goal {
        private final StonebornEntity stoneborn;

        public TradeWithPlayerGoal(StonebornEntity stonebornEntity) {
            this.stoneborn = stonebornEntity;
            this.func_220684_a(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            if (!this.stoneborn.func_70089_S()) {
                return false;
            }
            if (this.stoneborn.func_70090_H()) {
                return false;
            }
            if (!this.stoneborn.func_233570_aj_()) {
                return false;
            }
            if (this.stoneborn.field_70133_I) {
                return false;
            }
            PlayerEntity playerEntity = this.stoneborn.func_70931_l_();
            if (playerEntity == null) {
                return false;
            }
            if (this.stoneborn.func_70068_e((Entity)playerEntity) > 16.0) {
                return false;
            }
            return playerEntity.field_71070_bA != null;
        }

        public void func_75249_e() {
            this.stoneborn.func_70661_as().func_75499_g();
        }

        public void func_75251_c() {
            this.stoneborn.func_70932_a_(null);
        }
    }

    static class RegaliumForItemsTrade
    implements VillagerTrades.ITrade {
        private final Item tradeItem;
        private final int regaliumCount;
        private final int count;
        private final int maxUses;
        private final int xpValue;
        private final float priceMultiplier;

        public RegaliumForItemsTrade(IItemProvider itemProvider, int regalium, int tradeItemCount, int maxUses, int xpValue) {
            this.tradeItem = itemProvider.func_199767_j();
            this.regaliumCount = regalium;
            this.count = tradeItemCount;
            this.maxUses = maxUses;
            this.xpValue = xpValue;
            this.priceMultiplier = 0.05f;
        }

        public MerchantOffer func_221182_a(Entity p_221182_1_, Random p_221182_2_) {
            return new MerchantOffer(new ItemStack((IItemProvider)this.tradeItem, this.count), new ItemStack((IItemProvider)UndergardenItems.regalium_nugget.get(), this.regaliumCount), this.maxUses, this.xpValue, this.priceMultiplier);
        }
    }

    static class ItemsForRegaliumTrade
    implements VillagerTrades.ITrade {
        private final ItemStack tradeItem;
        private final int regaliumCount;
        private final int tradeItemCount;
        private final int maxUses;
        private final int xpValue;
        private final float priceMultiplier;

        public ItemsForRegaliumTrade(Block tradeItem, int regalium, int tradeItemCount, int maxUses, int xpValue) {
            this(new ItemStack((IItemProvider)tradeItem), regalium, tradeItemCount, maxUses, xpValue);
        }

        public ItemsForRegaliumTrade(Item tradeItem, int regalium, int tradeItemCount, int xpValue) {
            this(new ItemStack((IItemProvider)tradeItem), regalium, tradeItemCount, 12, xpValue);
        }

        public ItemsForRegaliumTrade(Item tradeItem, int regalium, int tradeItemCount, int maxUses, int xpValue) {
            this(new ItemStack((IItemProvider)tradeItem), regalium, tradeItemCount, maxUses, xpValue);
        }

        public ItemsForRegaliumTrade(ItemStack tradeItem, int regalium, int tradeItemCount, int maxUses, int xpValue) {
            this(tradeItem, regalium, tradeItemCount, maxUses, xpValue, 0.05f);
        }

        public ItemsForRegaliumTrade(ItemStack tradeItem, int regalium, int tradeItemCount, int maxUses, int xpValue, float p_i50532_6_) {
            this.tradeItem = tradeItem;
            this.regaliumCount = regalium;
            this.tradeItemCount = tradeItemCount;
            this.maxUses = maxUses;
            this.xpValue = xpValue;
            this.priceMultiplier = p_i50532_6_;
        }

        public MerchantOffer func_221182_a(Entity p_221182_1_, Random p_221182_2_) {
            return new MerchantOffer(new ItemStack((IItemProvider)UndergardenItems.regalium_nugget.get(), this.regaliumCount), new ItemStack((IItemProvider)this.tradeItem.func_77973_b(), this.tradeItemCount), this.maxUses, this.xpValue, this.priceMultiplier);
        }
    }
}

