/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.item.tool;

import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.item.ShootableItem;
import net.minecraft.item.UseAction;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ArrowLooseEvent;
import net.minecraftforge.event.entity.player.ArrowNockEvent;
import net.minecraftforge.eventbus.api.Event;
import quek.undergarden.entity.projectile.SlingshotAmmoEntity;
import quek.undergarden.item.DepthrockPebbleItem;
import quek.undergarden.registry.UndergardenItemGroups;
import quek.undergarden.registry.UndergardenItems;
import quek.undergarden.registry.UndergardenTags;

public class SlingshotItem
extends ShootableItem {
    public static final Predicate<ItemStack> SLINGSHOT_AMMO = stack -> stack.func_77973_b() == UndergardenItems.depthrock_pebble.get();

    public SlingshotItem() {
        super(new Item.Properties().func_200917_a(1).func_200918_c(192).func_200916_a(UndergardenItemGroups.GROUP).func_208103_a(Rarity.UNCOMMON));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.slingshot").func_240701_a_(new TextFormatting[]{TextFormatting.GRAY}));
    }

    public Predicate<ItemStack> func_220004_b() {
        return SLINGSHOT_AMMO;
    }

    public int func_230305_d_() {
        return 10;
    }

    public void func_77615_a(ItemStack stack, World worldIn, LivingEntity entityLiving, int timeLeft) {
        if (entityLiving instanceof PlayerEntity) {
            PlayerEntity playerentity = (PlayerEntity)entityLiving;
            boolean flag = playerentity.field_71075_bZ.field_75098_d || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185312_x, (ItemStack)stack) > 0;
            ItemStack itemstack = playerentity.func_213356_f(stack);
            int i = this.func_77626_a(stack) - timeLeft;
            if ((i = SlingshotItem.onArrowLoose(stack, worldIn, playerentity, i, !itemstack.func_190926_b() || flag)) < 0) {
                return;
            }
            if (!itemstack.func_190926_b() || flag) {
                float f;
                if (itemstack.func_190926_b()) {
                    itemstack = new ItemStack((IItemProvider)UndergardenItems.depthrock_pebble.get());
                }
                if (!((double)(f = SlingshotItem.getArrowVelocity(i)) < 0.1)) {
                    boolean flag1;
                    boolean bl = flag1 = playerentity.field_71075_bZ.field_75098_d || itemstack.func_77973_b() instanceof DepthrockPebbleItem && ((DepthrockPebbleItem)itemstack.func_77973_b()).isInfinite(itemstack, stack, playerentity);
                    if (!worldIn.field_72995_K) {
                        SlingshotAmmoEntity ammoEntity = new SlingshotAmmoEntity(worldIn, entityLiving);
                        ammoEntity = this.ammo(ammoEntity);
                        ammoEntity.func_234612_a_((Entity)playerentity, playerentity.field_70125_A, playerentity.field_70177_z, 0.0f, f * 3.0f, 1.0f);
                        stack.func_222118_a(1, (LivingEntity)playerentity, p_220009_1_ -> p_220009_1_.func_213334_d(playerentity.func_184600_cs()));
                        worldIn.func_217376_c((Entity)ammoEntity);
                    }
                    worldIn.func_184148_a(null, playerentity.func_226277_ct_(), playerentity.func_226278_cu_(), playerentity.func_226281_cx_(), SoundEvents.field_187737_v, SoundCategory.PLAYERS, 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f) + f * 0.5f);
                    if (!flag1 && !playerentity.field_71075_bZ.field_75098_d) {
                        itemstack.func_190918_g(1);
                        if (itemstack.func_190926_b()) {
                            playerentity.field_71071_by.func_184437_d(itemstack);
                        }
                    }
                    playerentity.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
                }
            }
        }
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack itemstack;
        boolean flag = !playerIn.func_213356_f(itemstack = playerIn.func_184586_b(handIn)).func_190926_b();
        ActionResult<ItemStack> ret = SlingshotItem.onArrowNock(itemstack, worldIn, playerIn, handIn, flag);
        if (ret != null) {
            return ret;
        }
        if (!playerIn.field_71075_bZ.field_75098_d && !flag) {
            return ActionResult.func_226251_d_((Object)itemstack);
        }
        playerIn.func_184598_c(handIn);
        return ActionResult.func_226249_b_((Object)itemstack);
    }

    public static ActionResult<ItemStack> onArrowNock(ItemStack item, World world, PlayerEntity player, Hand hand, boolean hasAmmo) {
        ArrowNockEvent event = new ArrowNockEvent(player, item, hand, world, hasAmmo);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return new ActionResult(ActionResultType.FAIL, (Object)item);
        }
        return event.getAction();
    }

    public static int onArrowLoose(ItemStack stack, World world, PlayerEntity player, int charge, boolean hasAmmo) {
        ArrowLooseEvent event = new ArrowLooseEvent(player, stack, world, charge, hasAmmo);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return -1;
        }
        return event.getCharge();
    }

    public static float getArrowVelocity(int charge) {
        float f = (float)charge / 5.0f;
        if ((f = (f * f + f * 2.0f) / 3.0f) > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    public int func_77626_a(ItemStack stack) {
        return 36000;
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.BOW;
    }

    public SlingshotAmmoEntity ammo(SlingshotAmmoEntity ammoEntity) {
        return ammoEntity;
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return UndergardenTags.Items.SMOGSTEM_PLANKS.func_230235_a_((Object)repair.func_77973_b()) || super.func_82789_a(toRepair, repair);
    }
}

