/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.registry;

import java.util.function.Supplier;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import quek.undergarden.registry.UndergardenItems;

public enum UndergardenArmorMaterials implements IArmorMaterial
{
    CLOGGRUM("cloggrum", 10, new int[]{3, 6, 6, 3}, 10, SoundEvents.field_187725_r, 1.0f, () -> Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)UndergardenItems.cloggrum_ingot.get()})),
    FROSTSTEEL("froststeel", 20, new int[]{2, 5, 6, 2}, 15, SoundEvents.field_187722_q, 4.0f, () -> Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)UndergardenItems.froststeel_ingot.get()})),
    UTHERIC("utheric", 36, new int[]{3, 6, 8, 3}, 13, SoundEvents.field_187716_o, 3.0f, () -> Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)UndergardenItems.utherium_ingot.get()})),
    MASTICATED("masticated", 17, new int[]{6, 6, 6, 6}, 5, SoundEvents.field_187716_o, 0.0f, () -> Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)UndergardenItems.masticator_scales.get()}));

    private static final int[] durability_arr;
    private final String armorName;
    private final int durabilityFactor;
    private final int[] damageReduction;
    private final int enchantability;
    private final SoundEvent equipSound;
    private final float armorToughness;
    private final Supplier<Ingredient> repairMaterial;

    private UndergardenArmorMaterials(String name, int durability, int[] reduction, int enchant, SoundEvent sound, float toughness, Supplier<Ingredient> material) {
        this.armorName = name;
        this.durabilityFactor = durability;
        this.damageReduction = reduction;
        this.enchantability = enchant;
        this.equipSound = sound;
        this.armorToughness = toughness;
        this.repairMaterial = material;
    }

    public int func_200896_a(EquipmentSlotType slotIn) {
        return durability_arr[slotIn.func_188454_b()] * this.durabilityFactor;
    }

    public int func_200902_b(EquipmentSlotType slotIn) {
        return this.damageReduction[slotIn.func_188454_b()];
    }

    public int func_200900_a() {
        return this.enchantability;
    }

    public SoundEvent func_200899_b() {
        return this.equipSound;
    }

    public Ingredient func_200898_c() {
        return this.repairMaterial.get();
    }

    public String func_200897_d() {
        return this.armorName;
    }

    public float func_200901_e() {
        return this.armorToughness;
    }

    public float func_230304_f_() {
        return 0.0f;
    }

    static {
        durability_arr = new int[]{13, 15, 16, 11};
    }
}

