/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.registry;

import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import quek.undergarden.biome.BarrenAbyssBiome;
import quek.undergarden.biome.DenseForestBiome;
import quek.undergarden.biome.ForgottenFieldBiome;
import quek.undergarden.biome.OthersideBiome;
import quek.undergarden.biome.SmogSpiresBiome;
import quek.undergarden.biome.SmogstemForestBiome;
import quek.undergarden.biome.UndergardenBiome;
import quek.undergarden.biome.WigglewoodForestBiome;

public class UndergardenBiomes {
    public static final DeferredRegister<Biome> BIOMES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BIOMES, (String)"undergarden");
    public static final RegistryObject<Biome> FORGOTTEN_FIELD = BIOMES.register("forgotten_field", ForgottenFieldBiome::new);
    public static final RegistryObject<Biome> SMOGSTEM_FOREST = BIOMES.register("smogstem_forest", SmogstemForestBiome::new);
    public static final RegistryObject<Biome> WIGGLEWOOD_FOREST = BIOMES.register("wigglewood_forest", WigglewoodForestBiome::new);
    public static final RegistryObject<Biome> DENSE_FOREST = BIOMES.register("dense_forest", DenseForestBiome::new);
    public static final RegistryObject<Biome> BARREN_ABYSS = BIOMES.register("barren_abyss", BarrenAbyssBiome::new);
    public static final RegistryObject<Biome> SMOG_SPIRES = BIOMES.register("smog_spires", SmogSpiresBiome::new);
    public static final RegistryObject<Biome> OTHERSIDE = BIOMES.register("otherside", OthersideBiome::new);

    public static void addBiomeTypes() {
        BiomeDictionary.addTypes((Biome)((Biome)FORGOTTEN_FIELD.get()), (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.PLAINS});
        BiomeDictionary.addTypes((Biome)((Biome)SMOGSTEM_FOREST.get()), (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.FOREST});
        BiomeDictionary.addTypes((Biome)((Biome)WIGGLEWOOD_FOREST.get()), (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.FOREST});
        BiomeDictionary.addTypes((Biome)((Biome)DENSE_FOREST.get()), (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.FOREST});
        BiomeDictionary.addTypes((Biome)((Biome)BARREN_ABYSS.get()), (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.DEAD});
        BiomeDictionary.addTypes((Biome)((Biome)SMOG_SPIRES.get()), (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.DEAD});
        BiomeDictionary.addTypes((Biome)((Biome)OTHERSIDE.get()), (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.VOID});
    }

    public static void addBiomeFeatures() {
        for (Biome biome : ForgeRegistries.BIOMES.getValues()) {
            if (!(biome instanceof UndergardenBiome)) continue;
            ((UndergardenBiome)biome).addFeatures();
        }
    }
}

