/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.world;

import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.pattern.BlockPattern;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.ColumnPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.server.TicketType;
import net.minecraftforge.common.util.ITeleporter;
import quek.undergarden.block.UndergardenPortalBlock;
import quek.undergarden.registry.UndergardenBlocks;

public class UndergardenTeleporter
implements ITeleporter {
    protected final Map<ColumnPos, PortalPosition> destinationCoordinateCache = Maps.newHashMapWithExpectedSize((int)4096);
    private final Object2LongMap<ColumnPos> columnMap = new Object2LongOpenHashMap();

    public boolean placeInPortal(ServerWorld world, Entity entity, float yaw) {
        Vector3d Vector3d2 = entity.func_181014_aG();
        Direction direction = entity.func_181012_aH();
        BlockPattern.PortalInfo pattern = this.placeInExistingPortal(world, new BlockPos(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_()), entity.func_213322_ci(), direction, Vector3d2.field_72450_a, Vector3d2.field_72448_b, entity instanceof PlayerEntity);
        if (pattern == null) {
            return false;
        }
        Vector3d position = pattern.field_222505_a;
        Vector3d motion = pattern.field_222506_b;
        entity.func_213317_d(motion);
        entity.field_70177_z = yaw + (float)pattern.field_222507_c;
        entity.func_225653_b_(position.field_72450_a, position.field_72448_b, position.field_72449_c);
        return true;
    }

    @Nullable
    public BlockPattern.PortalInfo placeInExistingPortal(ServerWorld world, BlockPos pos, Vector3d motion, Direction direction, double x, double y, boolean isPlayer) {
        boolean isFrame = true;
        BlockPos blockpos = null;
        ColumnPos columnpos = new ColumnPos(pos);
        if (!isPlayer && this.columnMap.containsKey((Object)columnpos)) {
            return null;
        }
        PortalPosition position = this.destinationCoordinateCache.get(columnpos);
        if (position != null) {
            blockpos = position.pos;
            position.lastUpdateTime = world.func_82737_E();
            isFrame = false;
        } else {
            double d0 = Double.MAX_VALUE;
            for (int eX = -128; eX <= 128; ++eX) {
                for (int eZ = -128; eZ <= 128; ++eZ) {
                    BlockPos blockpos1 = pos.func_177982_a(eX, world.func_217301_I() - 1 - pos.func_177956_o(), eZ);
                    while (blockpos1.func_177956_o() >= 0) {
                        BlockPos blockpos2 = blockpos1.func_177977_b();
                        if (world.func_180495_p(blockpos1).func_177230_c() == UndergardenBlocks.undergarden_portal.get()) {
                            blockpos2 = blockpos1.func_177977_b();
                            while (world.func_180495_p(blockpos2).func_177230_c() == UndergardenBlocks.undergarden_portal.get()) {
                                blockpos1 = blockpos2;
                                blockpos2 = blockpos2.func_177977_b();
                            }
                            double distance = blockpos1.func_177951_i((Vector3i)pos);
                            if (d0 < 0.0 || distance < d0) {
                                d0 = distance;
                                blockpos = blockpos1;
                            }
                        }
                        blockpos1 = blockpos2;
                    }
                }
            }
        }
        if (blockpos == null) {
            long factor = world.func_82737_E() + 300L;
            this.columnMap.put((Object)columnpos, factor);
            return null;
        }
        if (isFrame) {
            this.destinationCoordinateCache.put(columnpos, new PortalPosition(blockpos, world.func_82737_E()));
            world.func_72863_F().func_217228_a(TicketType.field_219493_f, new ChunkPos(blockpos), 3, (Object)new BlockPos(columnpos.field_219439_a, blockpos.func_177956_o(), columnpos.field_219440_b));
        }
        BlockPattern.PatternHelper helper = UndergardenPortalBlock.createPatternHelper((IWorld)world, blockpos);
        return helper.func_222504_a(direction, blockpos, y, motion, x);
    }

    public boolean makePortal(ServerWorld world, Entity entityIn) {
        Random random = new Random(world.func_72905_C());
        double d0 = -1.0;
        int j = MathHelper.func_76128_c((double)entityIn.func_226277_ct_());
        int k = MathHelper.func_76128_c((double)entityIn.func_226278_cu_());
        int l = MathHelper.func_76128_c((double)entityIn.func_226281_cx_());
        int i1 = j;
        int j1 = k;
        int k1 = l;
        int l1 = 0;
        int i2 = random.nextInt(4);
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        for (int j2 = j - 16; j2 <= j + 16; ++j2) {
            double d1 = (double)j2 + 0.5 - entityIn.func_226277_ct_();
            for (int l2 = l - 16; l2 <= l + 16; ++l2) {
                double d2 = (double)l2 + 0.5 - entityIn.func_226281_cx_();
                block2: for (int j3 = world.func_217301_I() - 1; j3 >= 0; --j3) {
                    if (!world.func_175623_d((BlockPos)blockpos$mutable.func_181079_c(j2, j3, l2))) continue;
                    while (j3 > 0 && world.func_175623_d((BlockPos)blockpos$mutable.func_181079_c(j2, j3 - 1, l2))) {
                        --j3;
                    }
                    for (int k3 = i2; k3 < i2 + 4; ++k3) {
                        int l3 = k3 % 2;
                        int i4 = 1 - l3;
                        if (k3 % 4 >= 2) {
                            l3 = -l3;
                            i4 = -i4;
                        }
                        for (int j4 = 0; j4 < 3; ++j4) {
                            for (int k4 = 0; k4 < 4; ++k4) {
                                for (int l4 = -1; l4 < 4; ++l4) {
                                    int i5 = j2 + (k4 - 1) * l3 + j4 * i4;
                                    int j5 = j3 + l4;
                                    int k5 = l2 + (k4 - 1) * i4 - j4 * l3;
                                    blockpos$mutable.func_181079_c(i5, j5, k5);
                                    if (l4 < 0 && !world.func_180495_p((BlockPos)blockpos$mutable).func_185904_a().func_76220_a() || l4 >= 0 && !world.func_175623_d((BlockPos)blockpos$mutable)) continue block2;
                                }
                            }
                        }
                        double d5 = (double)j3 + 0.5 - entityIn.func_226278_cu_();
                        double d7 = d1 * d1 + d5 * d5 + d2 * d2;
                        if (!(d0 < 0.0) && !(d7 < d0)) continue;
                        d0 = d7;
                        i1 = j2;
                        j1 = j3;
                        k1 = l2;
                        l1 = k3 % 4;
                    }
                }
            }
        }
        if (d0 < 0.0) {
            for (int l5 = j - 16; l5 <= j + 16; ++l5) {
                double d3 = (double)l5 + 0.5 - entityIn.func_226277_ct_();
                for (int j6 = l - 16; j6 <= l + 16; ++j6) {
                    double d4 = (double)j6 + 0.5 - entityIn.func_226281_cx_();
                    block10: for (int i7 = world.func_217301_I() - 1; i7 >= 0; --i7) {
                        if (!world.func_175623_d((BlockPos)blockpos$mutable.func_181079_c(l5, i7, j6))) continue;
                        while (i7 > 0 && world.func_175623_d((BlockPos)blockpos$mutable.func_181079_c(l5, i7 - 1, j6))) {
                            --i7;
                        }
                        for (int l7 = i2; l7 < i2 + 2; ++l7) {
                            int l8 = l7 % 2;
                            int k9 = 1 - l8;
                            for (int i10 = 0; i10 < 4; ++i10) {
                                for (int k10 = -1; k10 < 4; ++k10) {
                                    int i11 = l5 + (i10 - 1) * l8;
                                    int j11 = i7 + k10;
                                    int k11 = j6 + (i10 - 1) * k9;
                                    blockpos$mutable.func_181079_c(i11, j11, k11);
                                    if (k10 < 0 && !world.func_180495_p((BlockPos)blockpos$mutable).func_185904_a().func_76220_a() || k10 >= 0 && !world.func_175623_d((BlockPos)blockpos$mutable)) continue block10;
                                }
                            }
                            double d6 = (double)i7 + 0.5 - entityIn.func_226278_cu_();
                            double d8 = d3 * d3 + d6 * d6 + d4 * d4;
                            if (!(d0 < 0.0) && !(d8 < d0)) continue;
                            d0 = d8;
                            i1 = l5;
                            j1 = i7;
                            k1 = j6;
                            l1 = l7 % 2;
                        }
                    }
                }
            }
        }
        int i6 = i1;
        int k2 = j1;
        int k6 = k1;
        int l6 = l1 % 2;
        int i3 = 1 - l6;
        if (l1 % 4 >= 2) {
            l6 = -l6;
            i3 = -i3;
        }
        if (d0 < 0.0) {
            k2 = j1 = MathHelper.func_76125_a((int)j1, (int)70, (int)(world.func_217301_I() - 10));
            for (int j7 = -1; j7 <= 1; ++j7) {
                for (int i8 = 1; i8 < 3; ++i8) {
                    for (int i9 = -1; i9 < 3; ++i9) {
                        int l9 = i6 + (i8 - 1) * l6 + j7 * i3;
                        int j10 = k2 + i9;
                        int l10 = k6 + (i8 - 1) * i3 - j7 * l6;
                        boolean flag = i9 < 0;
                        blockpos$mutable.func_181079_c(l9, j10, l10);
                        world.func_175656_a((BlockPos)blockpos$mutable, flag ? Blocks.field_196696_di.func_176223_P() : Blocks.field_150350_a.func_176223_P());
                    }
                }
            }
        }
        for (int k7 = -1; k7 < 3; ++k7) {
            for (int j8 = -1; j8 < 4; ++j8) {
                if (k7 != -1 && k7 != 2 && j8 != -1 && j8 != 3) continue;
                blockpos$mutable.func_181079_c(i6 + k7 * l6, k2 + j8, k6 + k7 * i3);
                world.func_180501_a((BlockPos)blockpos$mutable, Blocks.field_196696_di.func_176223_P(), 3);
            }
        }
        BlockState blockstate = (BlockState)((Block)UndergardenBlocks.undergarden_portal.get()).func_176223_P().func_206870_a(UndergardenPortalBlock.AXIS, (Comparable)(l6 == 0 ? Direction.Axis.Z : Direction.Axis.X));
        for (int k8 = 0; k8 < 2; ++k8) {
            for (int j9 = 0; j9 < 3; ++j9) {
                blockpos$mutable.func_181079_c(i6 + k8 * l6, k2 + j9, k6 + k8 * i3);
                world.func_180501_a((BlockPos)blockpos$mutable, blockstate, 18);
            }
        }
        return true;
    }

    public Entity placeEntity(Entity entity, ServerWorld currentWorld, ServerWorld destWorld, float yaw, Function<Boolean, Entity> repositionEntity) {
        if (entity instanceof ServerPlayerEntity) {
            float f1;
            ServerPlayerEntity player = (ServerPlayerEntity)entity;
            double d0 = player.func_226277_ct_();
            double d1 = player.func_226278_cu_();
            double d2 = player.func_226281_cx_();
            float f = player.field_70125_A;
            float f2 = f1 = player.field_70177_z;
            currentWorld.func_217381_Z().func_76320_a("moving");
            player.func_70012_b(d0, d1, d2, f1, f);
            currentWorld.func_217381_Z().func_76319_b();
            currentWorld.func_217381_Z().func_76320_a("placing");
            double d7 = Math.min(-2.9999872E7, destWorld.func_175723_af().func_177726_b() + 16.0);
            double d4 = Math.min(-2.9999872E7, destWorld.func_175723_af().func_177736_c() + 16.0);
            double d5 = Math.min(2.9999872E7, destWorld.func_175723_af().func_177728_d() - 16.0);
            double d6 = Math.min(2.9999872E7, destWorld.func_175723_af().func_177733_e() - 16.0);
            d0 = MathHelper.func_151237_a((double)d0, (double)d7, (double)d5);
            d2 = MathHelper.func_151237_a((double)d2, (double)d4, (double)d6);
            player.func_70012_b(d0, d1, d2, f1, f);
            if (!this.placeInPortal(destWorld, (Entity)player, f2)) {
                this.makePortal(destWorld, (Entity)player);
                this.placeInPortal(destWorld, (Entity)player, f2);
            }
            currentWorld.func_217381_Z().func_76319_b();
            player.func_70029_a((World)destWorld);
            destWorld.func_217447_b(player);
            player.func_213846_b(currentWorld);
            player.field_71135_a.func_147364_a(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), f1, f);
            return player;
        }
        Vector3d vec3d = entity.func_213322_ci();
        double d0 = entity.func_226277_ct_();
        double d1 = entity.func_226281_cx_();
        double d3 = Math.min(-2.9999872E7, destWorld.func_175723_af().func_177726_b() + 16.0);
        double d4 = Math.min(-2.9999872E7, destWorld.func_175723_af().func_177736_c() + 16.0);
        double d5 = Math.min(2.9999872E7, destWorld.func_175723_af().func_177728_d() - 16.0);
        double d6 = Math.min(2.9999872E7, destWorld.func_175723_af().func_177733_e() - 16.0);
        d0 = MathHelper.func_151237_a((double)d0, (double)d3, (double)d5);
        d1 = MathHelper.func_151237_a((double)d1, (double)d4, (double)d6);
        Vector3d vec3d1 = entity.func_181014_aG();
        BlockPos blockpos = new BlockPos(d0, entity.func_226278_cu_(), d1);
        BlockPattern.PortalInfo blockpattern$portalinfo = this.placeInExistingPortal(destWorld, blockpos, vec3d, entity.func_181012_aH(), vec3d1.field_72450_a, vec3d1.field_72448_b, entity instanceof PlayerEntity);
        if (blockpattern$portalinfo == null) {
            return null;
        }
        blockpos = new BlockPos(blockpattern$portalinfo.field_222505_a);
        vec3d = blockpattern$portalinfo.field_222506_b;
        float f = blockpattern$portalinfo.field_222507_c;
        entity.field_70170_p.func_217381_Z().func_219895_b("reloading");
        Entity newEntity = entity.func_200600_R().func_200721_a((World)destWorld);
        if (newEntity != null) {
            newEntity.func_180432_n(entity);
            newEntity.func_174828_a(blockpos, newEntity.field_70177_z + f, newEntity.field_70125_A);
            newEntity.func_213317_d(vec3d);
            destWorld.func_217460_e(newEntity);
        }
        return newEntity;
    }

    static class PortalPosition {
        public final BlockPos pos;
        public long lastUpdateTime;

        public PortalPosition(BlockPos pos, long time) {
            this.pos = pos;
            this.lastUpdateTime = time;
        }

        public int hashCode() {
            return Objects.hash(this.pos, this.lastUpdateTime);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof PortalPosition) {
                PortalPosition other = (PortalPosition)obj;
                return this.pos.equals((Object)other.pos) && this.lastUpdateTime == other.lastUpdateTime;
            }
            return false;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[pos=" + this.pos + ", lastUpdateTime=" + this.lastUpdateTime + "]";
        }
    }
}

