/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.naturallychargedcreepers.config;

import net.minecraftforge.common.ForgeConfigSpec;

public class ConfigHandler {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final General GENERAL = new General(BUILDER);
    public static final ForgeConfigSpec spec = BUILDER.build();

    public static class General {
        public final ForgeConfigSpec.ConfigValue<Boolean> onWorldSpawn;
        public final ForgeConfigSpec.ConfigValue<Boolean> onEggSpawn;
        public final ForgeConfigSpec.ConfigValue<Boolean> preventFireDamage;
        public final ForgeConfigSpec.ConfigValue<Double> isChargedChance;

        public General(ForgeConfigSpec.Builder builder) {
            builder.push("General");
            this.onWorldSpawn = builder.comment("If enabled, allows naturally spawned creepers in the world to have a chance to be charged.").define("onWorldSpawn", true);
            this.onEggSpawn = builder.comment("If enabled, allows creepers which were spawned by an egg to have a chance to be charged.").define("onEggSpawn", true);
            this.preventFireDamage = builder.comment("If enabled, prevents fire damage to the naturally charged creepers (on first charge).").define("preventFireDamage", true);
            this.isChargedChance = builder.comment("The chance of a creeper being naturally charged.").defineInRange("ischargedchance", 0.1, 0.0, 1.0);
            builder.pop();
        }
    }
}

