/*
 * Decompiled with CFR 0.152.
 */
package com.markus1002.autumnity.common.world.biome;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.markus1002.autumnity.core.registry.AutumnityBlocks;
import com.markus1002.autumnity.core.registry.AutumnityFeatures;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SweetBerryBushBlock;
import net.minecraft.state.Property;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.DefaultBiomeFeatures;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.blockplacer.BlockPlacer;
import net.minecraft.world.gen.blockplacer.DoublePlantBlockPlacer;
import net.minecraft.world.gen.blockplacer.SimpleBlockPlacer;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.SimpleBlockStateProvider;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.BlockClusterFeatureConfig;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.MultipleRandomFeatureConfig;
import net.minecraft.world.gen.feature.MultipleWithChanceRandomFeatureConfig;
import net.minecraft.world.gen.placement.AtSurfaceWithExtraConfig;
import net.minecraft.world.gen.placement.FrequencyConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.NoiseDependant;
import net.minecraft.world.gen.placement.Placement;

public class AutumnityBiomeFeatures {
    private static final BlockState MAPLE_LOG = ((Block)AutumnityBlocks.MAPLE_LOG.get()).func_176223_P();
    private static final BlockState MAPLE_LEAVES = ((Block)AutumnityBlocks.MAPLE_LEAVES.get()).func_176223_P();
    private static final BlockState YELLOW_MAPLE_LEAVES = ((Block)AutumnityBlocks.YELLOW_MAPLE_LEAVES.get()).func_176223_P();
    private static final BlockState ORANGE_MAPLE_LEAVES = ((Block)AutumnityBlocks.ORANGE_MAPLE_LEAVES.get()).func_176223_P();
    private static final BlockState RED_MAPLE_LEAVES = ((Block)AutumnityBlocks.RED_MAPLE_LEAVES.get()).func_176223_P();
    private static final BlockState TALL_FOUL_BERRY_BUSH = (BlockState)((Block)AutumnityBlocks.TALL_FOUL_BERRY_BUSH.get()).func_176223_P().func_206870_a((Property)SweetBerryBushBlock.field_220125_a, (Comparable)Integer.valueOf(3));
    private static final BlockState AUTUMN_CROCUS = ((Block)AutumnityBlocks.AUTUMN_CROCUS.get()).func_176223_P();
    private static final BlockState ROSE_BUSH = Blocks.field_196802_gf.func_176223_P();
    private static final BlockState OXEYE_DAISY = Blocks.field_196616_bl.func_176223_P();
    private static final BlockState CORNFLOWER = Blocks.field_222387_by.func_176223_P();
    public static final BaseTreeFeatureConfig MAPLE_TREE_CONFIG = new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(MAPLE_LOG), (BlockStateProvider)new SimpleBlockStateProvider(MAPLE_LEAVES), null, null, null).func_236700_a_().func_225568_b_();
    public static final BaseTreeFeatureConfig YELLOW_MAPLE_TREE_CONFIG = new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(MAPLE_LOG), (BlockStateProvider)new SimpleBlockStateProvider(YELLOW_MAPLE_LEAVES), null, null, null).func_236700_a_().func_225568_b_();
    public static final BaseTreeFeatureConfig ORANGE_MAPLE_TREE_CONFIG = new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(MAPLE_LOG), (BlockStateProvider)new SimpleBlockStateProvider(ORANGE_MAPLE_LEAVES), null, null, null).func_236700_a_().func_225568_b_();
    public static final BaseTreeFeatureConfig RED_MAPLE_TREE_CONFIG = new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(MAPLE_LOG), (BlockStateProvider)new SimpleBlockStateProvider(RED_MAPLE_LEAVES), null, null, null).func_236700_a_().func_225568_b_();
    public static final BlockClusterFeatureConfig TALL_FOUL_BERRY_BUSH_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(TALL_FOUL_BERRY_BUSH), (BlockPlacer)new DoublePlantBlockPlacer()).func_227315_a_(64).func_227316_a_((Set)ImmutableSet.of((Object)Blocks.field_196658_i)).func_227317_b_().func_227322_d_();
    public static final BlockClusterFeatureConfig AUTUMN_CROCUS_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(AUTUMN_CROCUS), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(64).func_227322_d_();
    public static final BlockClusterFeatureConfig ROSE_BUSH_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(ROSE_BUSH), (BlockPlacer)new DoublePlantBlockPlacer()).func_227315_a_(64).func_227317_b_().func_227322_d_();
    public static final BlockClusterFeatureConfig OXEYE_DAISY_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(OXEYE_DAISY), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(64).func_227322_d_();
    public static final BlockClusterFeatureConfig CORNFLOWER_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(CORNFLOWER), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(64).func_227322_d_();

    public static void addMapleFeatures(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_202292_al.func_225566_b_((IFeatureConfig)new MultipleRandomFeatureConfig((List)ImmutableList.of((Object)Feature.field_202319_S.func_225566_b_((IFeatureConfig)DefaultBiomeFeatures.field_226768_ac_).func_227227_a_(0.025f), (Object)Feature.field_202318_R.func_225566_b_((IFeatureConfig)DefaultBiomeFeatures.field_226767_ab_).func_227227_a_(0.05f), (Object)AutumnityFeatures.MAPLE_TREE.func_225566_b_((IFeatureConfig)RED_MAPLE_TREE_CONFIG).func_227227_a_(0.3f), (Object)AutumnityFeatures.FALLEN_LEAVES_MAPLE_TREE.func_225566_b_((IFeatureConfig)ORANGE_MAPLE_TREE_CONFIG).func_227227_a_(0.4f), (Object)AutumnityFeatures.FALLEN_LEAVES_MAPLE_TREE.func_225566_b_((IFeatureConfig)YELLOW_MAPLE_TREE_CONFIG).func_227227_a_(0.2f)), AutumnityFeatures.MAPLE_TREE.func_225566_b_((IFeatureConfig)MAPLE_TREE_CONFIG))).func_227228_a_(Placement.field_215027_m.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(10, 0.1f, 1))));
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_202291_ak.func_225566_b_((IFeatureConfig)new MultipleWithChanceRandomFeatureConfig((List)ImmutableList.of((Object)Feature.field_227248_z_.func_225566_b_((IFeatureConfig)ROSE_BUSH_CONFIG), (Object)Feature.field_227247_y_.func_225566_b_((IFeatureConfig)AUTUMN_CROCUS_CONFIG)), 0)).func_227228_a_(Placement.field_215017_c.func_227446_a_((IPlacementConfig)new FrequencyConfig(4))));
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)DefaultBiomeFeatures.field_226828_w_).func_227228_a_(Placement.field_215018_d.func_227446_a_((IPlacementConfig)new FrequencyConfig(1))));
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, AutumnityFeatures.FALLEN_LEAVES.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215018_d.func_227446_a_((IPlacementConfig)new FrequencyConfig(32))));
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)TALL_FOUL_BERRY_BUSH_CONFIG).func_227228_a_(Placement.field_215018_d.func_227446_a_((IPlacementConfig)new FrequencyConfig(1))));
    }

    public static void addPumpkinFieldsFeatures(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_202292_al.func_225566_b_((IFeatureConfig)new MultipleRandomFeatureConfig((List)ImmutableList.of((Object)Feature.field_202319_S.func_225566_b_((IFeatureConfig)DefaultBiomeFeatures.field_226768_ac_).func_227227_a_(0.025f), (Object)Feature.field_202318_R.func_225566_b_((IFeatureConfig)DefaultBiomeFeatures.field_226767_ab_).func_227227_a_(0.05f), (Object)AutumnityFeatures.MAPLE_TREE.func_225566_b_((IFeatureConfig)RED_MAPLE_TREE_CONFIG).func_227227_a_(0.3f), (Object)AutumnityFeatures.MAPLE_TREE.func_225566_b_((IFeatureConfig)ORANGE_MAPLE_TREE_CONFIG).func_227227_a_(0.4f), (Object)AutumnityFeatures.MAPLE_TREE.func_225566_b_((IFeatureConfig)YELLOW_MAPLE_TREE_CONFIG).func_227227_a_(0.2f)), AutumnityFeatures.MAPLE_TREE.func_225566_b_((IFeatureConfig)MAPLE_TREE_CONFIG))).func_227228_a_(Placement.field_215027_m.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(1, 0.2f, 1))));
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_202291_ak.func_225566_b_((IFeatureConfig)new MultipleWithChanceRandomFeatureConfig((List)ImmutableList.of((Object)Feature.field_227247_y_.func_225566_b_((IFeatureConfig)OXEYE_DAISY_CONFIG), (Object)Feature.field_227247_y_.func_225566_b_((IFeatureConfig)CORNFLOWER_CONFIG), (Object)Feature.field_227247_y_.func_225566_b_((IFeatureConfig)AUTUMN_CROCUS_CONFIG)), 0)).func_227228_a_(Placement.field_215020_f.func_227446_a_((IPlacementConfig)new NoiseDependant(-0.8, 15, 4))));
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)DefaultBiomeFeatures.field_226826_u_).func_227228_a_(Placement.field_215021_g.func_227446_a_((IPlacementConfig)new NoiseDependant(-0.8, 5, 10))));
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, AutumnityFeatures.PUMPKIN_FIELDS_PUMPKIN.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215018_d.func_227446_a_((IPlacementConfig)new FrequencyConfig(5))));
    }
}

