/*
 * Decompiled with CFR 0.152.
 */
package com.markus1002.autumnity.core;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class Config {
    static final ForgeConfigSpec COMMON_SPEC;
    public static final Common COMMON;

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
    }

    public static class Common {
        public final ForgeConfigSpec.ConfigValue<List<String>> snailSpawnBiomes;
        public final ForgeConfigSpec.ConfigValue<List<String>> mapleTreeBiomes;
        public final ForgeConfigSpec.ConfigValue<Integer> mapleForestWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> pumpkinFieldsWeight;

        Common(ForgeConfigSpec.Builder builder) {
            builder.push("snail");
            this.snailSpawnBiomes = builder.comment("A list of biomes where snails can spawn. The list doesn't include maple forests.").define("Snail Spawn Biomes", (Object)Lists.newArrayList());
            builder.pop();
            builder.push("biomes");
            this.mapleTreeBiomes = builder.comment("A list of biomes where maple trees can naturally generate. The list doesn't include maple forests.").define("Maple Tree Biomes", (Object)Lists.newArrayList((Object[])new String[]{"minecraft:forest", "minecraft:wooded_hills", "minecraft:flower_forest"}));
            this.mapleForestWeight = builder.comment("The greater the number the more common the biome is.").define("Maple Forest Weight", (Object)6);
            this.pumpkinFieldsWeight = builder.comment("The greater the number the more common the biome is.").define("Pumpkin Fields Weight", (Object)1);
            builder.pop();
        }
    }
}

