/*
 * Decompiled with CFR 0.152.
 */
package snownee.fruits;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ComposterBlock;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.FenceBlock;
import net.minecraft.block.FenceGateBlock;
import net.minecraft.block.FlowerPotBlock;
import net.minecraft.block.PressurePlateBlock;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.block.SaplingBlock;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.StairsBlock;
import net.minecraft.block.TrapDoorBlock;
import net.minecraft.block.WoodButtonBlock;
import net.minecraft.block.trees.Tree;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.item.AxeItem;
import net.minecraft.item.Food;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.Rarity;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.SimpleBlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.WeightedBlockStateProvider;
import net.minecraft.world.gen.feature.AbstractFeatureSizeType;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.TwoLayerFeature;
import net.minecraft.world.gen.foliageplacer.FoliagePlacer;
import net.minecraft.world.gen.foliageplacer.FoliagePlacerType;
import net.minecraft.world.gen.placement.AtSurfaceWithExtraConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraft.world.gen.treedecorator.BeehiveTreeDecorator;
import net.minecraft.world.gen.treedecorator.TreeDecoratorType;
import net.minecraft.world.gen.trunkplacer.AbstractTrunkPlacer;
import net.minecraft.world.gen.trunkplacer.StraightTrunkPlacer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import snownee.fruits.FruitType;
import snownee.fruits.FruitsMod;
import snownee.fruits.block.FruitLeavesBlock;
import snownee.fruits.block.trees.FruitTree;
import snownee.fruits.cherry.CherryModule;
import snownee.fruits.cherry.FruitTypeExtension;
import snownee.fruits.tile.FruitTreeTile;
import snownee.fruits.world.gen.foliageplacer.FruitBlobFoliagePlacer;
import snownee.fruits.world.gen.treedecorator.CarpetTreeDecorator;
import snownee.kiwi.AbstractModule;
import snownee.kiwi.KiwiModule;
import snownee.kiwi.Name;
import snownee.kiwi.NoItem;
import snownee.kiwi.RenderLayer;
import snownee.kiwi.block.ModBlock;
import snownee.kiwi.item.ModItem;

@KiwiModule
@KiwiModule.Subscriber(value={KiwiModule.Subscriber.Bus.MOD})
public final class CoreModule
extends AbstractModule {
    public static final Item MANDARIN = new ModItem(CoreModule.itemProp().func_200916_a(ItemGroup.field_78039_h).func_221540_a(Foods.MANDARIN));
    public static final Item LIME = new ModItem(CoreModule.itemProp().func_200916_a(ItemGroup.field_78039_h).func_221540_a(Foods.LIME));
    public static final Item CITRON = new ModItem(CoreModule.itemProp().func_200916_a(ItemGroup.field_78039_h).func_221540_a(Foods.CITRON));
    public static final Item POMELO = new ModItem(CoreModule.itemProp().func_200916_a(ItemGroup.field_78039_h).func_221540_a(Foods.POMELO));
    public static final Item ORANGE = new ModItem(CoreModule.itemProp().func_200916_a(ItemGroup.field_78039_h).func_221540_a(Foods.ORANGE));
    public static final Item LEMON = new ModItem(CoreModule.itemProp().func_200916_a(ItemGroup.field_78039_h).func_221540_a(Foods.LEMON));
    public static final Item GRAPEFRUIT = new ModItem(CoreModule.itemProp().func_200916_a(ItemGroup.field_78039_h).func_221540_a(Foods.GRAPEFRUIT));
    public static final Item EMPOWERED_CITRON = new ModItem(CoreModule.itemProp().func_208103_a(Rarity.RARE).func_221540_a(Foods.EMPOWERED_CITRON)){

        public boolean func_77636_d(ItemStack stack) {
            return true;
        }
    };
    @KiwiModule.Group(value="decorations")
    @RenderLayer(value=RenderLayer.Layer.CUTOUT)
    public static final FruitLeavesBlock MANDARIN_LEAVES = new FruitLeavesBlock(() -> FruitType.MANDARIN, CoreModule.blockProp((AbstractBlock)Blocks.field_196642_W));
    @KiwiModule.Group(value="decorations")
    @RenderLayer(value=RenderLayer.Layer.CUTOUT)
    public static final FruitLeavesBlock LIME_LEAVES = new FruitLeavesBlock(() -> FruitType.LIME, CoreModule.blockProp((AbstractBlock)Blocks.field_196642_W));
    @KiwiModule.Group(value="decorations")
    @RenderLayer(value=RenderLayer.Layer.CUTOUT)
    public static final FruitLeavesBlock CITRON_LEAVES = new FruitLeavesBlock(() -> FruitType.CITRON, CoreModule.blockProp((AbstractBlock)Blocks.field_196642_W));
    @KiwiModule.Group(value="decorations")
    @RenderLayer(value=RenderLayer.Layer.CUTOUT)
    public static final FruitLeavesBlock POMELO_LEAVES = new FruitLeavesBlock(() -> FruitType.POMELO, CoreModule.blockProp((AbstractBlock)Blocks.field_196642_W));
    @KiwiModule.Group(value="decorations")
    @RenderLayer(value=RenderLayer.Layer.CUTOUT)
    public static final FruitLeavesBlock ORANGE_LEAVES = new FruitLeavesBlock(() -> FruitType.ORANGE, CoreModule.blockProp((AbstractBlock)Blocks.field_196642_W));
    @KiwiModule.Group(value="decorations")
    @RenderLayer(value=RenderLayer.Layer.CUTOUT)
    public static final FruitLeavesBlock LEMON_LEAVES = new FruitLeavesBlock(() -> FruitType.LEMON, CoreModule.blockProp((AbstractBlock)Blocks.field_196642_W));
    @KiwiModule.Group(value="decorations")
    @RenderLayer(value=RenderLayer.Layer.CUTOUT)
    public static final FruitLeavesBlock GRAPEFRUIT_LEAVES = new FruitLeavesBlock(() -> FruitType.GRAPEFRUIT, CoreModule.blockProp((AbstractBlock)Blocks.field_196642_W));
    @KiwiModule.Group(value="decorations")
    @RenderLayer(value=RenderLayer.Layer.CUTOUT)
    public static final FruitLeavesBlock APPLE_LEAVES = new FruitLeavesBlock(() -> FruitType.APPLE, CoreModule.blockProp((AbstractBlock)Blocks.field_196642_W));
    @KiwiModule.Group(value="building_blocks")
    public static final RotatedPillarBlock CITRUS_LOG = new RotatedPillarBlock(CoreModule.blockProp((AbstractBlock)Blocks.field_196620_N));
    @KiwiModule.Group(value="building_blocks")
    public static final Block CITRUS_WOOD = new RotatedPillarBlock(CoreModule.blockProp((AbstractBlock)Blocks.field_196634_T));
    @KiwiModule.Group(value="building_blocks")
    public static final Block STRIPPED_CITRUS_LOG = new RotatedPillarBlock(CoreModule.blockProp((AbstractBlock)Blocks.field_203207_U));
    @KiwiModule.Group(value="building_blocks")
    public static final Block STRIPPED_CITRUS_WOOD = new RotatedPillarBlock(CoreModule.blockProp((AbstractBlock)Blocks.field_209392_ae));
    @KiwiModule.Group(value="building_blocks")
    public static final Block CITRUS_PLANKS = new ModBlock(CoreModule.blockProp((AbstractBlock)Blocks.field_196668_q));
    @KiwiModule.Group(value="building_blocks")
    public static final SlabBlock CITRUS_SLAB = new SlabBlock(CoreModule.blockProp((AbstractBlock)Blocks.field_196630_bt));
    @KiwiModule.Group(value="building_blocks")
    public static final StairsBlock CITRUS_STAIRS = new StairsBlock(() -> CITRUS_PLANKS.func_176223_P(), CoreModule.blockProp((AbstractBlock)Blocks.field_150481_bH));
    @KiwiModule.Group(value="decorations")
    public static final FenceBlock CITRUS_FENCE = new FenceBlock(CoreModule.blockProp((AbstractBlock)Blocks.field_180403_aR));
    @KiwiModule.Group(value="redstone")
    public static final FenceGateBlock CITRUS_FENCE_GATE = new FenceGateBlock(CoreModule.blockProp((AbstractBlock)Blocks.field_180386_br));
    @KiwiModule.Group(value="redstone")
    public static final TrapDoorBlock CITRUS_TRAPDOOR = new TrapDoorBlock(CoreModule.blockProp((AbstractBlock)Blocks.field_196644_cZ));
    @KiwiModule.Group(value="redstone")
    @RenderLayer(value=RenderLayer.Layer.CUTOUT)
    public static final DoorBlock CITRUS_DOOR = new DoorBlock(CoreModule.blockProp((AbstractBlock)Blocks.field_180411_ar));
    @KiwiModule.Group(value="redstone")
    public static final WoodButtonBlock CITRUS_BUTTON = new WoodButtonBlock(CoreModule.blockProp((AbstractBlock)Blocks.field_196644_cZ));
    @KiwiModule.Group(value="redstone")
    public static final PressurePlateBlock CITRUS_PRESSURE_PLATE = new PressurePlateBlock(PressurePlateBlock.Sensitivity.EVERYTHING, CoreModule.blockProp((AbstractBlock)Blocks.field_180411_ar));
    @KiwiModule.Group(value="decorations")
    @RenderLayer(value=RenderLayer.Layer.CUTOUT)
    public static final SaplingBlock MANDARIN_SAPLING = new SaplingBlock((Tree)new FruitTree(() -> FruitType.MANDARIN), CoreModule.blockProp((AbstractBlock)Blocks.field_196674_t));
    @KiwiModule.Group(value="decorations")
    @RenderLayer(value=RenderLayer.Layer.CUTOUT)
    public static final SaplingBlock LIME_SAPLING = new SaplingBlock((Tree)new FruitTree(() -> FruitType.LIME), CoreModule.blockProp((AbstractBlock)Blocks.field_196674_t));
    @KiwiModule.Group(value="decorations")
    @RenderLayer(value=RenderLayer.Layer.CUTOUT)
    public static final SaplingBlock CITRON_SAPLING = new SaplingBlock((Tree)new FruitTree(() -> FruitType.CITRON), CoreModule.blockProp((AbstractBlock)Blocks.field_196674_t));
    @KiwiModule.Group(value="decorations")
    @RenderLayer(value=RenderLayer.Layer.CUTOUT)
    public static final SaplingBlock POMELO_SAPLING = new SaplingBlock((Tree)new FruitTree(() -> FruitType.POMELO), CoreModule.blockProp((AbstractBlock)Blocks.field_196674_t));
    @KiwiModule.Group(value="decorations")
    @RenderLayer(value=RenderLayer.Layer.CUTOUT)
    public static final SaplingBlock ORANGE_SAPLING = new SaplingBlock((Tree)new FruitTree(() -> FruitType.ORANGE), CoreModule.blockProp((AbstractBlock)Blocks.field_196674_t));
    @KiwiModule.Group(value="decorations")
    @RenderLayer(value=RenderLayer.Layer.CUTOUT)
    public static final SaplingBlock LEMON_SAPLING = new SaplingBlock((Tree)new FruitTree(() -> FruitType.LEMON), CoreModule.blockProp((AbstractBlock)Blocks.field_196674_t));
    @KiwiModule.Group(value="decorations")
    @RenderLayer(value=RenderLayer.Layer.CUTOUT)
    public static final SaplingBlock GRAPEFRUIT_SAPLING = new SaplingBlock((Tree)new FruitTree(() -> FruitType.GRAPEFRUIT), CoreModule.blockProp((AbstractBlock)Blocks.field_196674_t));
    @KiwiModule.Group(value="decorations")
    @RenderLayer(value=RenderLayer.Layer.CUTOUT)
    public static final SaplingBlock APPLE_SAPLING = new SaplingBlock((Tree)new FruitTree(() -> FruitType.APPLE), CoreModule.blockProp((AbstractBlock)Blocks.field_196674_t));
    @RenderLayer(value=RenderLayer.Layer.CUTOUT)
    @NoItem
    public static final FlowerPotBlock POTTED_MANDARIN = new FlowerPotBlock(() -> (FlowerPotBlock)Blocks.field_150457_bL, () -> MANDARIN_SAPLING, CoreModule.blockProp((AbstractBlock)Blocks.field_196752_ev));
    @RenderLayer(value=RenderLayer.Layer.CUTOUT)
    @NoItem
    public static final FlowerPotBlock POTTED_LIME = new FlowerPotBlock(() -> (FlowerPotBlock)Blocks.field_150457_bL, () -> LIME_SAPLING, CoreModule.blockProp((AbstractBlock)Blocks.field_196752_ev));
    @RenderLayer(value=RenderLayer.Layer.CUTOUT)
    @NoItem
    public static final FlowerPotBlock POTTED_CITRON = new FlowerPotBlock(() -> (FlowerPotBlock)Blocks.field_150457_bL, () -> CITRON_SAPLING, CoreModule.blockProp((AbstractBlock)Blocks.field_196752_ev));
    @RenderLayer(value=RenderLayer.Layer.CUTOUT)
    @NoItem
    public static final FlowerPotBlock POTTED_POMELO = new FlowerPotBlock(() -> (FlowerPotBlock)Blocks.field_150457_bL, () -> POMELO_SAPLING, CoreModule.blockProp((AbstractBlock)Blocks.field_196752_ev));
    @RenderLayer(value=RenderLayer.Layer.CUTOUT)
    @NoItem
    public static final FlowerPotBlock POTTED_ORANGE = new FlowerPotBlock(() -> (FlowerPotBlock)Blocks.field_150457_bL, () -> ORANGE_SAPLING, CoreModule.blockProp((AbstractBlock)Blocks.field_196752_ev));
    @RenderLayer(value=RenderLayer.Layer.CUTOUT)
    @NoItem
    public static final FlowerPotBlock POTTED_LEMON = new FlowerPotBlock(() -> (FlowerPotBlock)Blocks.field_150457_bL, () -> LEMON_SAPLING, CoreModule.blockProp((AbstractBlock)Blocks.field_196752_ev));
    @RenderLayer(value=RenderLayer.Layer.CUTOUT)
    @NoItem
    public static final FlowerPotBlock POTTED_GRAPEFRUIT = new FlowerPotBlock(() -> (FlowerPotBlock)Blocks.field_150457_bL, () -> GRAPEFRUIT_SAPLING, CoreModule.blockProp((AbstractBlock)Blocks.field_196752_ev));
    @RenderLayer(value=RenderLayer.Layer.CUTOUT)
    @NoItem
    public static final FlowerPotBlock POTTED_APPLE = new FlowerPotBlock(() -> (FlowerPotBlock)Blocks.field_150457_bL, () -> APPLE_SAPLING, CoreModule.blockProp((AbstractBlock)Blocks.field_196752_ev));
    public static final Set<Block> ALL_LEAVES = Collections.synchronizedSet(Sets.newHashSet(Arrays.asList(MANDARIN_LEAVES, LIME_LEAVES, CITRON_LEAVES, POMELO_LEAVES, ORANGE_LEAVES, LEMON_LEAVES, GRAPEFRUIT_LEAVES, APPLE_LEAVES)));
    public static final TileEntityType<FruitTreeTile> FRUIT_TREE = new TileEntityType(FruitTreeTile::new, ALL_LEAVES, null);
    @Name(value="carpet")
    public static final TreeDecoratorType<CarpetTreeDecorator> CARPET_DECORATOR = new TreeDecoratorType(CarpetTreeDecorator.CODEC);
    @Name(value="blob")
    public static final FoliagePlacerType<FruitBlobFoliagePlacer> BLOB_PLACER = new FoliagePlacerType(FruitBlobFoliagePlacer.CODEC);

    protected void init(FMLCommonSetupEvent event) {
        try {
            FlowerPotBlock pot = (FlowerPotBlock)Blocks.field_150457_bL;
            pot.addPlant(MANDARIN_SAPLING.getRegistryName(), () -> POTTED_MANDARIN);
            pot.addPlant(LIME_SAPLING.getRegistryName(), () -> POTTED_LIME);
            pot.addPlant(CITRON_SAPLING.getRegistryName(), () -> POTTED_CITRON);
            pot.addPlant(POMELO_SAPLING.getRegistryName(), () -> POTTED_POMELO);
            pot.addPlant(ORANGE_SAPLING.getRegistryName(), () -> POTTED_ORANGE);
            pot.addPlant(LEMON_SAPLING.getRegistryName(), () -> POTTED_LEMON);
            pot.addPlant(GRAPEFRUIT_SAPLING.getRegistryName(), () -> POTTED_GRAPEFRUIT);
            pot.addPlant(APPLE_SAPLING.getRegistryName(), () -> POTTED_APPLE);
            if (AxeItem.field_203176_a instanceof ImmutableMap) {
                AxeItem.field_203176_a = Collections.synchronizedMap(Maps.newHashMap((Map)AxeItem.field_203176_a));
            }
            AxeItem.field_203176_a.put(CITRUS_LOG, STRIPPED_CITRUS_LOG);
            AxeItem.field_203176_a.put(CITRUS_WOOD, STRIPPED_CITRUS_WOOD);
            for (FruitType type : FruitType.values()) {
                ComposterBlock.field_220299_b.put((Object)type.fruit, 0.5f);
                ComposterBlock.field_220299_b.put((Object)type.leaves.func_199767_j(), 0.3f);
                ComposterBlock.field_220299_b.put((Object)type.sapling.get().func_199767_j(), 0.3f);
            }
        }
        catch (Exception e) {
            FruitsMod.logger.catching((Throwable)e);
        }
    }

    protected void postInit() {
        List<FruitType> types = Arrays.asList(FruitType.CITRON, FruitType.LIME, FruitType.MANDARIN);
        block9: for (Biome biome : Biome.field_201870_ab) {
            Biome.RainType rainType = biome.func_201851_b();
            if (rainType != Biome.RainType.RAIN) continue;
            Biome.Category category = biome.func_201856_r();
            int count = 0;
            float chance = 0.0f;
            switch (category) {
                case JUNGLE: {
                    ++count;
                    break;
                }
                case FOREST: {
                    chance += 0.05f;
                    break;
                }
                case PLAINS: {
                    chance += 0.02f;
                    break;
                }
                default: {
                    continue block9;
                }
            }
            Biome.TempCategory temp = biome.func_150561_m();
            switch (temp) {
                case WARM: {
                    chance += 0.05f;
                    break;
                }
                case MEDIUM: {
                    break;
                }
                default: {
                    continue block9;
                }
            }
            if (count > 0 || chance > 0.0f) {
                for (FruitType type : types) {
                    ConfiguredFeature cf = CoreModule.buildTreeFeature(type, true, null);
                    cf = cf.func_227228_a_(Placement.field_215027_m.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(count, chance, 1)));
                    biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, cf);
                }
            }
            if (!(chance > 0.0f) || FruitTypeExtension.CHERRY == null) continue;
            ConfiguredFeature cf = CoreModule.buildTreeFeature(FruitTypeExtension.CHERRY, true, (BlockStateProvider)new SimpleBlockStateProvider(CherryModule.CHERRY_CARPET.func_176223_P()));
            cf = cf.func_227228_a_(Placement.field_215027_m.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(count, chance / 2.0f, 1)));
            biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, cf);
        }
    }

    public static ConfiguredFeature<BaseTreeFeatureConfig, ?> buildTreeFeature(FruitType type, boolean worldGen, BlockStateProvider carpetProvider) {
        SimpleBlockStateProvider leavesProvider;
        ImmutableList decorators;
        if (worldGen) {
            decorators = carpetProvider == null ? ImmutableList.of((Object)new BeehiveTreeDecorator(0.05f)) : ImmutableList.of((Object)new BeehiveTreeDecorator(0.05f), (Object)((Object)new CarpetTreeDecorator(carpetProvider)));
            leavesProvider = new WeightedBlockStateProvider().func_227407_a_(type.leaves.func_176223_P(), 2).func_227407_a_((BlockState)type.leaves.func_176223_P().func_206870_a((Property)FruitLeavesBlock.AGE, (Comparable)Integer.valueOf(2)), 1);
        } else {
            decorators = ImmutableList.of();
            leavesProvider = new SimpleBlockStateProvider(type.leaves.func_176223_P());
        }
        return Feature.field_236291_c_.func_225566_b_((IFeatureConfig)new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(type.log.func_176223_P()), (BlockStateProvider)leavesProvider, (FoliagePlacer)new FruitBlobFoliagePlacer(2, 0, 0, 0, 3), (AbstractTrunkPlacer)new StraightTrunkPlacer(4, 2, 0), (AbstractFeatureSizeType)new TwoLayerFeature(1, 0, 1)).func_236700_a_().func_236703_a_((List)decorators).func_225568_b_());
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void handleBlockColor(ColorHandlerEvent.Block event) {
        BlockState oakLeaves = Blocks.field_196642_W.func_176223_P();
        BlockColors blockColors = event.getBlockColors();
        blockColors.func_186722_a((state, world, pos, i) -> {
            if (i == 0) {
                return blockColors.func_228054_a_(oakLeaves, world, pos, i);
            }
            if (i == 1) {
                Block block = state.func_177230_c();
                if (block == CITRON_LEAVES) {
                    return 14535768;
                }
                if (block == GRAPEFRUIT_LEAVES) {
                    return 16011307;
                }
                if (block == LEMON_LEAVES) {
                    return 15452747;
                }
                if (block == LIME_LEAVES) {
                    return 13294198;
                }
                if (block == MANDARIN_LEAVES) {
                    return 15763993;
                }
                if (block == ORANGE_LEAVES) {
                    return 15763993;
                }
                if (block == POMELO_LEAVES) {
                    return 16250494;
                }
                if (block == APPLE_LEAVES) {
                    return 16522282;
                }
            }
            return -1;
        }, new Block[]{MANDARIN_LEAVES, LIME_LEAVES, CITRON_LEAVES, POMELO_LEAVES, ORANGE_LEAVES, LEMON_LEAVES, GRAPEFRUIT_LEAVES, APPLE_LEAVES});
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void handleItemColor(ColorHandlerEvent.Item event) {
        ItemStack oakLeaves = new ItemStack((IItemProvider)Items.field_221634_ae);
        ItemColors itemColors = event.getItemColors();
        itemColors.func_199877_a((stack, i) -> itemColors.func_186728_a(oakLeaves, i), new IItemProvider[]{MANDARIN_LEAVES, LIME_LEAVES, CITRON_LEAVES, POMELO_LEAVES, ORANGE_LEAVES, LEMON_LEAVES, GRAPEFRUIT_LEAVES, APPLE_LEAVES});
    }

    public static final class Foods {
        public static final Food MANDARIN = new Food.Builder().func_221456_a(3).func_221454_a(0.3f).func_221453_d();
        public static final Food LIME = new Food.Builder().func_221456_a(3).func_221454_a(0.3f).func_221453_d();
        public static final Food CITRON = new Food.Builder().func_221456_a(3).func_221454_a(0.3f).func_221453_d();
        public static final Food POMELO = new Food.Builder().func_221456_a(5).func_221454_a(0.3f).func_221453_d();
        public static final Food ORANGE = new Food.Builder().func_221456_a(3).func_221454_a(0.5f).func_221453_d();
        public static final Food LEMON = new Food.Builder().func_221456_a(4).func_221454_a(0.3f).func_221457_c().func_221453_d();
        public static final Food GRAPEFRUIT = new Food.Builder().func_221456_a(6).func_221454_a(0.4f).func_221453_d();
        public static final Food EMPOWERED_CITRON = new Food.Builder().func_221456_a(3).func_221454_a(5.0f).func_221453_d();
    }
}

