/*
 * Decompiled with CFR 0.152.
 */
package snownee.fruits;

import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Either;
import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.DoublePlantBlock;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.passive.BeeEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.state.Property;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;
import snownee.fruits.FruitType;
import snownee.fruits.FruitsMod;
import snownee.fruits.block.FruitLeavesBlock;
import snownee.fruits.hybridization.HybridingContext;
import snownee.fruits.hybridization.Hybridization;
import snownee.kiwi.KiwiModule;
import snownee.kiwi.LoadingContext;
import snownee.kiwi.util.NBTHelper;
import snownee.kiwi.util.Util;

public final class Hook {
    private Hook() {
    }

    public static boolean safeSetBlock(World world, BlockPos pos, BlockState state) {
        BlockState old = world.func_180495_p(pos);
        if (old == state || old.hasTileEntity() || old.func_185905_o() == PushReaction.BLOCK || old.func_177230_c() == Blocks.field_150343_Z || old.func_177230_c().func_203417_a((ITag)BlockTags.field_219755_X)) {
            return false;
        }
        return world.func_175656_a(pos, state);
    }

    public static boolean canPollinate(BlockState state) {
        if (state.func_235714_a_((ITag)BlockTags.field_226148_H_)) {
            if (state.func_177230_c() == Blocks.field_196800_gd) {
                return state.func_177229_b((Property)DoublePlantBlock.field_176492_b) == DoubleBlockHalf.UPPER;
            }
            return true;
        }
        if (state.func_235714_a_((ITag)BlockTags.field_219746_E)) {
            return true;
        }
        if (Hybridization.INSTANCE != null && state.func_177230_c() instanceof FruitLeavesBlock) {
            if (!((FruitLeavesBlock)state.func_177230_c()).canGrow(state)) {
                return false;
            }
            return (Integer)state.func_177229_b((Property)FruitLeavesBlock.AGE) == 2;
        }
        return false;
    }

    public static void onPollinateComplete(BeeEntity bee) {
        String id;
        BlockState state = bee.field_70170_p.func_180495_p(bee.field_226368_bH_);
        Block block = state.func_177230_c();
        FruitType type = block instanceof FruitLeavesBlock ? ((FruitLeavesBlock)block).type.get() : null;
        NBTHelper data = NBTHelper.of((CompoundNBT)bee.getPersistentData());
        int count = data.getInt("FruitsCount");
        ListNBT list = data.getTagList("FruitsList", 8);
        if (list == null) {
            list = new ListNBT();
            data.setTag("FruitsList", (INBT)list);
        }
        String string = id = type != null ? type.name() : "_" + Util.trimRL((ResourceLocation)block.getRegistryName());
        if (!list.stream().anyMatch(e -> e.func_150285_a_().equals(id))) {
            StringNBT stringNBT = StringNBT.func_229705_a_((String)id);
            if (list.size() < 5) {
                list.add((Object)stringNBT);
            } else {
                list.set(count % 5, (INBT)stringNBT);
            }
            data.setInt("FruitsCount", count + 1);
        }
        if (list.size() > 1) {
            HashSet ingredients = Sets.newHashSet();
            list.forEach(e -> {
                String _id = e.func_150285_a_();
                if (_id.startsWith("_")) {
                    Block _block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(_id.substring(1)));
                    ingredients.add(Either.right((Object)_block));
                } else {
                    FruitType _type = FruitType.parse(_id);
                    ingredients.add(Either.left((Object)((Object)_type)));
                }
            });
            bee.field_70170_p.func_199532_z().func_215371_a(Hybridization.RECIPE_TYPE, (IInventory)new HybridingContext(ingredients), bee.field_70170_p).ifPresent(recipe -> {
                boolean isMisc;
                Block newBlock = recipe.getResultAsBlock(ingredients);
                boolean isLeaves = newBlock instanceof FruitLeavesBlock;
                boolean isFlower = !isLeaves && newBlock.func_203417_a((ITag)BlockTags.field_226149_I_);
                boolean bl = isMisc = !isLeaves && !isFlower;
                if (!isMisc && isLeaves != block instanceof FruitLeavesBlock) {
                    return;
                }
                BlockPos root = bee.field_226368_bH_;
                if (block.func_203417_a((ITag)BlockTags.field_226148_H_) && state.func_235901_b_((Property)DoublePlantBlock.field_176492_b) && state.func_177229_b((Property)DoublePlantBlock.field_176492_b) == DoubleBlockHalf.UPPER) {
                    root = root.func_177977_b();
                } else if (isMisc && !newBlock.func_181623_g() && !(block instanceof FruitLeavesBlock)) {
                    root = root.func_177977_b();
                }
                BlockState newState = newBlock.func_176223_P();
                boolean isBigFlower = false;
                if (isLeaves) {
                    newState = (BlockState)newState.func_206870_a((Property)FruitLeavesBlock.AGE, (Comparable)Integer.valueOf(2));
                    newState = (BlockState)newState.func_206870_a((Property)LeavesBlock.field_208494_a, state.func_177229_b((Property)LeavesBlock.field_208494_a));
                } else if (isFlower && newBlock.func_203417_a((ITag)BlockTags.field_226148_H_) && newState.func_235901_b_((Property)DoublePlantBlock.field_176492_b)) {
                    newState = (BlockState)newState.func_206870_a((Property)DoublePlantBlock.field_176492_b, (Comparable)DoubleBlockHalf.LOWER);
                    isBigFlower = true;
                }
                boolean success = Hook.safeSetBlock(bee.field_70170_p, root, newState);
                if (success && isBigFlower) {
                    newState = (BlockState)newState.func_206870_a((Property)DoublePlantBlock.field_176492_b, (Comparable)DoubleBlockHalf.UPPER);
                    Hook.safeSetBlock(bee.field_70170_p, root.func_177984_a(), newState);
                }
                if (success) {
                    data.remove("FruitsList");
                    data.setInt("FruitsCount", 0);
                }
            });
        }
    }

    @KiwiModule.LoadingCondition(value={"hybridization"})
    public static boolean shouldLoadHybridization(LoadingContext ctx) {
        return FruitsMod.mixin;
    }
}

