/*
 * Decompiled with CFR 0.152.
 */
package snownee.fruits.plugin.jei;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.datafixers.util.Either;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.passive.BeeEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import snownee.fruits.CoreModule;
import snownee.fruits.FruitType;
import snownee.fruits.hybridization.HybridingRecipe;
import snownee.fruits.plugin.jei.JEIPlugin;

public class HybridingCategory
implements IRecipeCategory<HybridingRecipe> {
    private final String localizedName;
    private final IDrawable icon;
    private final IDrawable background;
    private final IGuiHelper guiHelper;
    private final BeeEntity bee;
    private final IDrawable x;
    private final IDrawable line;
    public static final int width = 116;
    public static final int height = 54;

    public HybridingCategory(IGuiHelper guiHelper) {
        this.guiHelper = guiHelper;
        this.localizedName = I18n.func_135052_a((String)"gui.fruittrees.jei.category.hybriding", (Object[])new Object[0]);
        this.icon = guiHelper.createDrawableIngredient((Object)CoreModule.GRAPEFRUIT.func_190903_i());
        this.background = guiHelper.createBlankDrawable(116, 54);
        float f = (float)Math.atan(25.0);
        float f1 = (float)Math.atan(-0.25);
        this.bee = (BeeEntity)EntityType.field_226289_e_.func_200721_a((World)Minecraft.func_71410_x().field_71441_e);
        this.bee.field_70761_aq = 180.0f + f * 20.0f;
        this.bee.field_70177_z = 180.0f + f * 40.0f;
        this.bee.field_70125_A = -f1 * 20.0f;
        this.bee.field_70759_as = this.bee.field_70177_z;
        this.bee.field_70758_at = this.bee.field_70177_z;
        Minecraft.func_71410_x().func_175598_ae();
        this.x = guiHelper.drawableBuilder(new ResourceLocation("fruittrees", "textures/gui/jei.png"), 0, 0, 10, 11).setTextureSize(64, 64).build();
        this.line = guiHelper.drawableBuilder(new ResourceLocation("fruittrees", "textures/gui/jei.png"), 12, 4, 31, 3).setTextureSize(64, 64).build();
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public String getTitle() {
        return this.localizedName;
    }

    public void draw(HybridingRecipe recipe, MatrixStack matrix, double mouseX, double mouseY) {
        float f1 = (float)Math.atan(-0.25);
        this.x.draw(matrix, 18, 22);
        this.line.draw(matrix, 54, 26);
        matrix.func_227860_a_();
        matrix.func_227861_a_(70.0, 24.0, 1050.0);
        matrix.func_227862_a_(1.0f, 1.0f, -1.0f);
        MatrixStack matrixstack = new MatrixStack();
        matrixstack.func_227861_a_(0.0, 0.0, 1000.0);
        matrixstack.func_227862_a_(20.0f, 20.0f, 20.0f);
        Quaternion quaternion = Vector3f.field_229183_f_.func_229187_a_(180.0f);
        Quaternion quaternion1 = Vector3f.field_229179_b_.func_229187_a_(f1 * 20.0f);
        quaternion.func_195890_a(quaternion1);
        matrixstack.func_227863_a_(quaternion);
        Minecraft mc = Minecraft.func_71410_x();
        EntityRendererManager entityrenderermanager = mc.func_175598_ae();
        quaternion1.func_195892_e();
        entityrenderermanager.func_229089_a_(quaternion1);
        entityrenderermanager.func_178633_a(false);
        IRenderTypeBuffer.Impl irendertypebuffer$impl = mc.func_228019_au_().func_228487_b_();
        this.bee.field_70173_aa = mc.field_71439_g.field_70173_aa;
        entityrenderermanager.func_229084_a_((Entity)this.bee, 0.0, 0.0, 0.0, mc.func_184121_ak(), 1.0f, matrixstack, (IRenderTypeBuffer)irendertypebuffer$impl, 0xF000F0);
        irendertypebuffer$impl.func_228461_a_();
        entityrenderermanager.func_178633_a(true);
        matrix.func_227865_b_();
    }

    public ResourceLocation getUid() {
        return JEIPlugin.UID;
    }

    public void setIngredients(HybridingRecipe recipe, IIngredients ingredients) {
        Either<FruitType, Block> result = recipe.getResult((Set<Either<FruitType, Block>>)recipe.ingredients);
        ImmutableList.Builder outputs = ImmutableList.builder();
        result.ifLeft(t -> outputs.add((Object[])new ItemStack[]{t.sapling.get().func_199767_j().func_190903_i(), t.fruit.func_199767_j().func_190903_i()})).ifRight(b -> outputs.add((Object)b.func_199767_j().func_190903_i()));
        ingredients.setOutputLists(VanillaTypes.ITEM, Collections.singletonList(outputs.build()));
        List inputs = recipe.ingredients.stream().map(HybridingCategory::asItem).collect(Collectors.toList());
        ingredients.setInputs(VanillaTypes.ITEM, inputs);
    }

    public static ItemStack asItem(Either<FruitType, Block> either) {
        Optional left = either.left();
        if (left.isPresent()) {
            return ((FruitType)((Object)left.get())).leaves.func_199767_j().func_190903_i();
        }
        return ((Block)either.right().get()).func_199767_j().func_190903_i();
    }

    public void setRecipe(IRecipeLayout layout, HybridingRecipe recipe, IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = layout.getItemStacks();
        guiItemStacks.init(0, false, 94, 18);
        guiItemStacks.set(0, (List)ingredients.getOutputs(VanillaTypes.ITEM).get(0));
        guiItemStacks.setBackground(0, (IDrawable)this.guiHelper.getSlotDrawable());
        guiItemStacks.addTooltipCallback((slot, input, stack, tooltip) -> {
            if (tooltip.isEmpty()) {
                return;
            }
            if (input) {
                if (stack.func_77973_b().func_206844_a((ITag)ItemTags.field_206963_E)) {
                    TranslationTextComponent line = new TranslationTextComponent("gui.fruittrees.jei.tip.flowering", new Object[]{tooltip.get(0)});
                    tooltip.set(0, line);
                }
            } else {
                boolean showAdvanced;
                boolean bl = showAdvanced = Minecraft.func_71410_x().field_71474_y.field_82882_x || Screen.func_231173_s_();
                if (showAdvanced) {
                    TranslationTextComponent recipeId = new TranslationTextComponent("jei.tooltip.recipe.id", new Object[]{recipe.func_199560_c()});
                    tooltip.add(recipeId.func_240699_a_(TextFormatting.DARK_GRAY));
                }
            }
        });
        int size = recipe.ingredients.size();
        int x = 0;
        int y = size > 2 ? 5 : 18;
        for (int i = 0; i < size; ++i) {
            guiItemStacks.init(1 + i, true, x, y);
            guiItemStacks.set(1 + i, (List)ingredients.getInputs(VanillaTypes.ITEM).get(i));
            guiItemStacks.setBackground(1 + i, (IDrawable)this.guiHelper.getSlotDrawable());
            if (i == 1) {
                x = 0;
                y += 28;
                continue;
            }
            x += 28;
        }
        if (size == 3) {
            guiItemStacks.init(4, true, 28, y);
            guiItemStacks.set(4, (ItemStack)null);
            guiItemStacks.setBackground(4, (IDrawable)this.guiHelper.getSlotDrawable());
        }
    }

    public Class<? extends HybridingRecipe> getRecipeClass() {
        return HybridingRecipe.class;
    }
}

