/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.blaze3d.platform;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import net.optifine.Config;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.Version;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWErrorCallback;
import org.lwjgl.glfw.GLFWErrorCallbackI;
import org.lwjgl.glfw.GLFWVidMode;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLCapabilities;
import oshi.SystemInfo;
import oshi.hardware.Processor;

public class GLX {
    private static final Logger LOGGER = LogManager.getLogger();
    private static String capsString = "";
    private static String cpuInfo;
    private static final Map<Integer, String> LOOKUP_MAP;

    public static String getOpenGLVersionString() {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        return GLFW.glfwGetCurrentContext() == 0L ? "NO CONTEXT" : dgl.B(7937) + " GL version " + dgl.B(7938) + ", " + dgl.B(7936);
    }

    public static int _getRefreshRate(dgy p__getRefreshRate_0_) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        long i2 = GLFW.glfwGetWindowMonitor((long)p__getRefreshRate_0_.i());
        if (i2 == 0L) {
            i2 = GLFW.glfwGetPrimaryMonitor();
        }
        GLFWVidMode glfwvidmode = i2 == 0L ? null : GLFW.glfwGetVideoMode((long)i2);
        return glfwvidmode == null ? 0 : glfwvidmode.refreshRate();
    }

    public static String _getLWJGLVersion() {
        RenderSystem.assertThread(RenderSystem::isInInitPhase);
        return Version.getVersion();
    }

    public static LongSupplier _initGlfw() {
        RenderSystem.assertThread(RenderSystem::isInInitPhase);
        dgy.a((p_229879_0_, p_229879_1_) -> {
            throw new IllegalStateException(String.format("GLFW error before init: [0x%X]%s", p_229879_0_, p_229879_1_));
        });
        ArrayList list = Lists.newArrayList();
        GLFWErrorCallback glfwerrorcallback = GLFW.glfwSetErrorCallback((p_229880_1_, p_229880_2_) -> list.add(String.format("GLFW error during init: [0x%X]%s", p_229880_1_, p_229880_2_)));
        if (!GLFW.glfwInit()) {
            throw new IllegalStateException("Failed to initialize GLFW, errors: " + Joiner.on((String)",").join((Iterable)list));
        }
        LongSupplier longsupplier = () -> (long)(GLFW.glfwGetTime() * 1.0E9);
        for (String s2 : list) {
            LOGGER.error("GLFW error collected during initialization: {}", (Object)s2);
        }
        RenderSystem.setErrorCallback((GLFWErrorCallbackI)glfwerrorcallback);
        return longsupplier;
    }

    public static void _setGlfwErrorCallback(GLFWErrorCallbackI p__setGlfwErrorCallback_0_) {
        RenderSystem.assertThread(RenderSystem::isInInitPhase);
        GLFWErrorCallback glfwerrorcallback = GLFW.glfwSetErrorCallback((GLFWErrorCallbackI)p__setGlfwErrorCallback_0_);
        if (glfwerrorcallback != null) {
            glfwerrorcallback.free();
        }
    }

    public static boolean _shouldClose(dgy p__shouldClose_0_) {
        return GLFW.glfwWindowShouldClose((long)p__shouldClose_0_.i());
    }

    public static void _setupNvFogDistance() {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        if (GL.getCapabilities().GL_NV_fog_distance) {
            if (Config.isFogFancy()) {
                dgl.l(34138, 34139);
            }
            if (Config.isFogFast()) {
                dgl.l(34138, 34140);
            }
        }
    }

    public static void _init(int p__init_0_, boolean p__init_1_) {
        RenderSystem.assertThread(RenderSystem::isInInitPhase);
        GLCapabilities glcapabilities = GL.getCapabilities();
        capsString = "Using framebuffer using " + dgl.a(glcapabilities);
        try {
            Processor[] aprocessor = new SystemInfo().getHardware().getProcessors();
            cpuInfo = String.format("%dx %s", aprocessor.length, aprocessor[0]).replaceAll("\\s+", " ");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        dgk.a(p__init_0_, p__init_1_);
    }

    public static String _getCapsString() {
        return capsString;
    }

    public static String _getCpuInfo() {
        return cpuInfo == null ? "<unknown>" : cpuInfo;
    }

    public static void _renderCrosshair(int p__renderCrosshair_0_, boolean p__renderCrosshair_1_, boolean p__renderCrosshair_2_, boolean p__renderCrosshair_3_) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        dgl.J();
        dgl.a(false);
        dhn tessellator = RenderSystem.renderThreadTesselator();
        dhg bufferbuilder = tessellator.c();
        GL11.glLineWidth((float)4.0f);
        bufferbuilder.a(1, dhj.l);
        if (p__renderCrosshair_1_) {
            bufferbuilder.a(0.0, 0.0, 0.0).a(0, 0, 0, 255).d();
            bufferbuilder.a(p__renderCrosshair_0_, 0.0, 0.0).a(0, 0, 0, 255).d();
        }
        if (p__renderCrosshair_2_) {
            bufferbuilder.a(0.0, 0.0, 0.0).a(0, 0, 0, 255).d();
            bufferbuilder.a(0.0, p__renderCrosshair_0_, 0.0).a(0, 0, 0, 255).d();
        }
        if (p__renderCrosshair_3_) {
            bufferbuilder.a(0.0, 0.0, 0.0).a(0, 0, 0, 255).d();
            bufferbuilder.a(0.0, 0.0, p__renderCrosshair_0_).a(0, 0, 0, 255).d();
        }
        tessellator.b();
        GL11.glLineWidth((float)2.0f);
        bufferbuilder.a(1, dhj.l);
        if (p__renderCrosshair_1_) {
            bufferbuilder.a(0.0, 0.0, 0.0).a(255, 0, 0, 255).d();
            bufferbuilder.a(p__renderCrosshair_0_, 0.0, 0.0).a(255, 0, 0, 255).d();
        }
        if (p__renderCrosshair_2_) {
            bufferbuilder.a(0.0, 0.0, 0.0).a(0, 255, 0, 255).d();
            bufferbuilder.a(0.0, p__renderCrosshair_0_, 0.0).a(0, 255, 0, 255).d();
        }
        if (p__renderCrosshair_3_) {
            bufferbuilder.a(0.0, 0.0, 0.0).a(127, 127, 255, 255).d();
            bufferbuilder.a(0.0, 0.0, p__renderCrosshair_0_).a(127, 127, 255, 255).d();
        }
        tessellator.b();
        GL11.glLineWidth((float)1.0f);
        dgl.a(true);
        dgl.I();
    }

    public static String getErrorString(int p_getErrorString_0_) {
        return LOOKUP_MAP.get(p_getErrorString_0_);
    }

    public static <T> T make(Supplier<T> p_make_0_) {
        return p_make_0_.get();
    }

    public static <T> T make(T p_make_0_, Consumer<T> p_make_1_) {
        p_make_1_.accept(p_make_0_);
        return p_make_0_;
    }

    public static boolean isUsingFBOs() {
        return true;
    }

    public static boolean useVbo() {
        return true;
    }

    static {
        LOOKUP_MAP = GLX.make(Maps.newHashMap(), p_229878_0_ -> {
            p_229878_0_.put(0, "No error");
            p_229878_0_.put(1280, "Enum parameter is invalid for this function");
            p_229878_0_.put(1281, "Parameter is invalid for this function");
            p_229878_0_.put(1282, "Current state is invalid for this function");
            p_229878_0_.put(1283, "Stack overflow");
            p_229878_0_.put(1284, "Stack underflow");
            p_229878_0_.put(1285, "Out of memory");
            p_229878_0_.put(1286, "Operation on incomplete framebuffer");
            p_229878_0_.put(1286, "Operation on incomplete framebuffer");
        });
    }
}

