/*
 * Decompiled with CFR 0.152.
 */
import com.google.common.base.Charsets;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.channels.Channels;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Base64;
import java.util.EnumSet;
import java.util.Set;
import javax.annotation.Nullable;
import net.optifine.Config;
import net.optifine.util.NativeMemory;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.stb.STBIWriteCallback;
import org.lwjgl.stb.STBImage;
import org.lwjgl.stb.STBImageResize;
import org.lwjgl.stb.STBImageWrite;
import org.lwjgl.stb.STBTTFontinfo;
import org.lwjgl.stb.STBTruetype;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public final class dgs
implements AutoCloseable {
    private static final Logger a = LogManager.getLogger();
    private static final Set<StandardOpenOption> b = EnumSet.of(StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
    private final a c;
    private final int d;
    private final int e;
    private final boolean f;
    private long g;
    private final long h;

    public dgs(int widthIn, int heightIn, boolean clear) {
        this(dgs$a.a, widthIn, heightIn, clear);
    }

    public dgs(a pixelFormatIn, int widthIn, int heightIn, boolean initialize) {
        this.c = pixelFormatIn;
        this.d = widthIn;
        this.e = heightIn;
        this.h = (long)widthIn * (long)heightIn * (long)pixelFormatIn.a();
        this.f = false;
        this.g = initialize ? MemoryUtil.nmemCalloc((long)1L, (long)this.h) : MemoryUtil.nmemAlloc((long)this.h);
        this.h();
        NativeMemory.imageAllocated(this);
    }

    private dgs(a pixelFormatIn, int widthIn, int heightIn, boolean stbiPointerIn, long pointer) {
        this.c = pixelFormatIn;
        this.d = widthIn;
        this.e = heightIn;
        this.f = stbiPointerIn;
        this.g = pointer;
        this.h = widthIn * heightIn * pixelFormatIn.a();
    }

    public String toString() {
        return "NativeImage[" + (Object)((Object)this.c) + " " + this.d + "x" + this.e + "@" + this.g + (this.f ? "S" : "N") + "]";
    }

    public static dgs a(InputStream inputStreamIn) throws IOException {
        return dgs.a(dgs$a.a, inputStreamIn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static dgs a(@Nullable a pixelFormatIn, InputStream inputStreamIn) throws IOException {
        dgs nativeimage;
        ByteBuffer bytebuffer = null;
        try {
            bytebuffer = dgw.a((InputStream)inputStreamIn);
            ((Buffer)bytebuffer).rewind();
            nativeimage = dgs.a(pixelFormatIn, bytebuffer);
        }
        finally {
            MemoryUtil.memFree((Buffer)bytebuffer);
            IOUtils.closeQuietly((InputStream)inputStreamIn);
        }
        return nativeimage;
    }

    public static dgs a(ByteBuffer byteBufferIn) throws IOException {
        return dgs.a(dgs$a.a, byteBufferIn);
    }

    public static dgs a(@Nullable a pixelFormatIn, ByteBuffer byteBufferIn) throws IOException {
        dgs nativeimage;
        if (pixelFormatIn != null && !pixelFormatIn.i()) {
            throw new UnsupportedOperationException("Don't know how to read format " + (Object)((Object)pixelFormatIn));
        }
        if (MemoryUtil.memAddress((ByteBuffer)byteBufferIn) == 0L) {
            throw new IllegalArgumentException("Invalid buffer");
        }
        try (MemoryStack memorystack = MemoryStack.stackPush();){
            IntBuffer intbuffer = memorystack.mallocInt(1);
            IntBuffer intbuffer1 = memorystack.mallocInt(1);
            IntBuffer intbuffer2 = memorystack.mallocInt(1);
            ByteBuffer bytebuffer = STBImage.stbi_load_from_memory((ByteBuffer)byteBufferIn, (IntBuffer)intbuffer, (IntBuffer)intbuffer1, (IntBuffer)intbuffer2, (int)(pixelFormatIn == null ? 0 : pixelFormatIn.e));
            if (bytebuffer == null) {
                throw new IOException("Could not load image: " + STBImage.stbi_failure_reason());
            }
            nativeimage = new dgs(pixelFormatIn == null ? dgs$a.b(intbuffer2.get(0)) : pixelFormatIn, intbuffer.get(0), intbuffer1.get(0), true, MemoryUtil.memAddress((ByteBuffer)bytebuffer));
            NativeMemory.imageAllocated(nativeimage);
        }
        return nativeimage;
    }

    public static void a(boolean clamp) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        if (clamp) {
            dgl.b(3553, 10242, 33071);
            dgl.b(3553, 10243, 33071);
        } else {
            dgl.b(3553, 10242, 10497);
            dgl.b(3553, 10243, 10497);
        }
    }

    public static void a(boolean linear, boolean mipmap) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        if (linear) {
            dgl.b(3553, 10241, mipmap ? 9987 : 9729);
            dgl.b(3553, 10240, 9729);
        } else {
            int mipmapType = Config.getMipmapType();
            dgl.b(3553, 10241, mipmap ? mipmapType : 9728);
            dgl.b(3553, 10240, 9728);
        }
    }

    private void h() {
        if (this.g == 0L) {
            throw new IllegalStateException("Image is not allocated.");
        }
    }

    @Override
    public void close() {
        if (this.g != 0L) {
            if (this.f) {
                STBImage.nstbi_image_free((long)this.g);
            } else {
                MemoryUtil.nmemFree((long)this.g);
            }
            NativeMemory.imageFreed(this);
        }
        this.g = 0L;
    }

    public int a() {
        return this.d;
    }

    public int b() {
        return this.e;
    }

    public a c() {
        return this.c;
    }

    public int a(int x2, int y) {
        if (this.c != dgs$a.a) {
            throw new IllegalArgumentException(String.format("getPixelRGBA only works on RGBA images; have %s", new Object[]{this.c}));
        }
        if (x2 >= 0 && y >= 0 && x2 < this.d && y < this.e) {
            this.h();
            long i2 = (x2 + y * this.d) * 4;
            return MemoryUtil.memGetInt((long)(this.g + i2));
        }
        throw new IllegalArgumentException(String.format("(%s, %s) outside of image bounds (%s, %s)", x2, y, this.d, this.e));
    }

    public void a(int x2, int y, int value) {
        if (this.c != dgs$a.a) {
            throw new IllegalArgumentException(String.format("getPixelRGBA only works on RGBA images; have %s", new Object[]{this.c}));
        }
        if (x2 < 0 || y < 0 || x2 >= this.d || y >= this.e) {
            throw new IllegalArgumentException(String.format("(%s, %s) outside of image bounds (%s, %s)", x2, y, this.d, this.e));
        }
        this.h();
        long i2 = (x2 + y * this.d) * 4;
        MemoryUtil.memPutInt((long)(this.g + i2), (int)value);
    }

    public byte b(int x2, int y) {
        if (!this.c.g()) {
            throw new IllegalArgumentException(String.format("no luminance or alpha in %s", new Object[]{this.c}));
        }
        if (x2 >= 0 && y >= 0 && x2 < this.d && y < this.e) {
            int i2 = (x2 + y * this.d) * this.c.a() + this.c.h() / 8;
            return MemoryUtil.memGetByte((long)(this.g + (long)i2));
        }
        throw new IllegalArgumentException(String.format("(%s, %s) outside of image bounds (%s, %s)", x2, y, this.d, this.e));
    }

    @Deprecated
    public int[] d() {
        if (this.c != dgs$a.a) {
            throw new UnsupportedOperationException("can only call makePixelArray for RGBA images.");
        }
        this.h();
        int[] aint = new int[this.a() * this.b()];
        for (int i2 = 0; i2 < this.b(); ++i2) {
            for (int j2 = 0; j2 < this.a(); ++j2) {
                int l1;
                int k2 = this.a(j2, i2);
                int l2 = dgs.a(k2);
                int i1 = dgs.d(k2);
                int j1 = dgs.c(k2);
                int k1 = dgs.b(k2);
                aint[j2 + i2 * this.a()] = l1 = l2 << 24 | k1 << 16 | j1 << 8 | i1;
            }
        }
        return aint;
    }

    public void a(int level, int xOffset, int yOffset, boolean autoClose) {
        this.a(level, xOffset, yOffset, 0, 0, this.d, this.e, false, autoClose);
    }

    public void a(int level, int xOffset, int yOffset, int unpackSkipPixels, int unpackSkipRows, int widthIn, int heightIn, boolean mipmap, boolean autoClose) {
        this.a(level, xOffset, yOffset, unpackSkipPixels, unpackSkipRows, widthIn, heightIn, false, false, mipmap, autoClose);
    }

    public void a(int level, int xOffset, int yOffset, int unpackSkipPixels, int unpackSkipRows, int widthIn, int heightIn, boolean blur, boolean clamp, boolean mipmap, boolean autoClose) {
        if (!RenderSystem.isOnRenderThreadOrInit()) {
            RenderSystem.recordRenderCall(() -> this.b(level, xOffset, yOffset, unpackSkipPixels, unpackSkipRows, widthIn, heightIn, blur, clamp, mipmap, autoClose));
        } else {
            this.b(level, xOffset, yOffset, unpackSkipPixels, unpackSkipRows, widthIn, heightIn, blur, clamp, mipmap, autoClose);
        }
    }

    private void b(int level, int xOffset, int yOffset, int unpackSkipPixels, int unpackSkipRows, int widthIn, int heightIn, boolean blur, boolean clamp, boolean mipmap, boolean autoClose) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        this.h();
        dgs.a(blur, mipmap);
        dgs.a(clamp);
        if (widthIn == this.a()) {
            dgl.n(3314, 0);
        } else {
            dgl.n(3314, this.a());
        }
        dgl.n(3316, unpackSkipPixels);
        dgl.n(3315, unpackSkipRows);
        this.c.c();
        dgl.a(3553, level, xOffset, yOffset, widthIn, heightIn, this.c.d(), 5121, this.g);
        if (autoClose) {
            this.close();
        }
    }

    public void a(int level, boolean opaque) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        this.h();
        this.c.b();
        dgl.a(3553, level, this.c.d(), 5121, this.g);
        if (opaque && this.c.e()) {
            for (int i2 = 0; i2 < this.b(); ++i2) {
                for (int j2 = 0; j2 < this.a(); ++j2) {
                    this.a(j2, i2, this.a(j2, i2) | 255 << this.c.f());
                }
            }
        }
    }

    public void a(File fileIn) throws IOException {
        this.a(fileIn.toPath());
    }

    public void a(STBTTFontinfo info, int glyphIndex, int widthIn, int heightIn, float scaleX, float scaleY, float shiftX, float shiftY, int x2, int y) {
        if (x2 >= 0 && x2 + widthIn <= this.a() && y >= 0 && y + heightIn <= this.b()) {
            if (this.c.a() != 1) {
                throw new IllegalArgumentException("Can only write fonts into 1-component images.");
            }
        } else {
            throw new IllegalArgumentException(String.format("Out of bounds: start: (%s, %s) (size: %sx%s); size: %sx%s", x2, y, widthIn, heightIn, this.a(), this.b()));
        }
        STBTruetype.nstbtt_MakeGlyphBitmapSubpixel((long)info.address(), (long)(this.g + (long)x2 + (long)(y * this.a())), (int)widthIn, (int)heightIn, (int)this.a(), (float)scaleX, (float)scaleY, (float)shiftX, (float)shiftY, (int)glyphIndex);
    }

    public void a(Path pathIn) throws IOException {
        if (!this.c.i()) {
            throw new UnsupportedOperationException("Don't know how to write format " + (Object)((Object)this.c));
        }
        this.h();
        try (SeekableByteChannel writablebytechannel = Files.newByteChannel(pathIn, b, new FileAttribute[0]);){
            if (!this.a(writablebytechannel)) {
                throw new IOException("Could not write image to the PNG file \"" + pathIn.toAbsolutePath() + "\": " + STBImage.stbi_failure_reason());
            }
        }
    }

    public byte[] e() throws IOException {
        byte[] abyte;
        try (ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream();
             WritableByteChannel writablebytechannel = Channels.newChannel(bytearrayoutputstream);){
            if (!this.a(writablebytechannel)) {
                throw new IOException("Could not write image to byte array: " + STBImage.stbi_failure_reason());
            }
            abyte = bytearrayoutputstream.toByteArray();
        }
        return abyte;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean a(WritableByteChannel channelIn) throws IOException {
        boolean flag;
        c nativeimage$writecallback = new c(channelIn);
        try {
            int i2 = Math.min(this.b(), Integer.MAX_VALUE / this.a() / this.c.a());
            if (i2 < this.b()) {
                a.warn("Dropping image height from {} to {} to fit the size into 32-bit signed int", (Object)this.b(), (Object)i2);
            }
            if (STBImageWrite.nstbi_write_png_to_func((long)nativeimage$writecallback.address(), (long)0L, (int)this.a(), (int)i2, (int)this.c.a(), (long)this.g, (int)0) != 0) {
                nativeimage$writecallback.a();
                boolean bl = true;
                return bl;
            }
            flag = false;
        }
        finally {
            nativeimage$writecallback.free();
        }
        return flag;
    }

    public void a(dgs from) {
        if (from.c() != this.c) {
            throw new UnsupportedOperationException("Image formats don't match.");
        }
        int i2 = this.c.a();
        this.h();
        from.h();
        if (this.d == from.d) {
            MemoryUtil.memCopy((long)from.g, (long)this.g, (long)Math.min(this.h, from.h));
        } else {
            int j2 = Math.min(this.a(), from.a());
            int k2 = Math.min(this.b(), from.b());
            for (int l2 = 0; l2 < k2; ++l2) {
                int i1 = l2 * from.a() * i2;
                int j1 = l2 * this.a() * i2;
                MemoryUtil.memCopy((long)(from.g + (long)i1), (long)(this.g + (long)j1), (long)((long)j2 * (long)i2));
            }
        }
    }

    public void a(int x2, int y, int widthIn, int heightIn, int value) {
        for (int i2 = y; i2 < y + heightIn; ++i2) {
            for (int j2 = x2; j2 < x2 + widthIn; ++j2) {
                this.a(j2, i2, value);
            }
        }
    }

    public void a(int xFrom, int yFrom, int xToDelta, int yToDelta, int widthIn, int heightIn, boolean mirrorX, boolean mirrorY) {
        for (int i2 = 0; i2 < heightIn; ++i2) {
            for (int j2 = 0; j2 < widthIn; ++j2) {
                int k2 = mirrorX ? widthIn - 1 - j2 : j2;
                int l2 = mirrorY ? heightIn - 1 - i2 : i2;
                int i1 = this.a(xFrom + j2, yFrom + i2);
                this.a(xFrom + xToDelta + k2, yFrom + yToDelta + l2, i1);
            }
        }
    }

    public void f() {
        this.h();
        try (MemoryStack memorystack = MemoryStack.stackPush();){
            int i2 = this.c.a();
            int j2 = this.a() * i2;
            long k2 = memorystack.nmalloc(j2);
            for (int l2 = 0; l2 < this.b() / 2; ++l2) {
                int i1 = l2 * this.a() * i2;
                int j1 = (this.b() - 1 - l2) * this.a() * i2;
                MemoryUtil.memCopy((long)(this.g + (long)i1), (long)k2, (long)j2);
                MemoryUtil.memCopy((long)(this.g + (long)j1), (long)(this.g + (long)i1), (long)j2);
                MemoryUtil.memCopy((long)k2, (long)(this.g + (long)j1), (long)j2);
            }
        }
    }

    public void a(int xIn, int yIn, int widthIn, int heightIn, dgs imageIn) {
        this.h();
        if (imageIn.c() != this.c) {
            throw new UnsupportedOperationException("resizeSubRectTo only works for images of the same format.");
        }
        int i2 = this.c.a();
        STBImageResize.nstbir_resize_uint8((long)(this.g + (long)((xIn + yIn * this.a()) * i2)), (int)widthIn, (int)heightIn, (int)(this.a() * i2), (long)imageIn.g, (int)imageIn.a(), (int)imageIn.b(), (int)0, (int)i2);
    }

    public void g() {
        dgh.a((long)this.g);
    }

    public static dgs a(String stringIn) throws IOException {
        dgs nativeimage;
        byte[] abyte = Base64.getDecoder().decode(stringIn.replaceAll("\n", "").getBytes(Charsets.UTF_8));
        try (MemoryStack memorystack = MemoryStack.stackPush();){
            ByteBuffer bytebuffer = memorystack.malloc(abyte.length);
            bytebuffer.put(abyte);
            ((Buffer)bytebuffer).rewind();
            nativeimage = dgs.a(bytebuffer);
        }
        return nativeimage;
    }

    public static int a(int col) {
        return col >> 24 & 0xFF;
    }

    public static int b(int col) {
        return col >> 0 & 0xFF;
    }

    public static int c(int col) {
        return col >> 8 & 0xFF;
    }

    public static int d(int col) {
        return col >> 16 & 0xFF;
    }

    public static int a(int alpha, int blue, int green, int red) {
        return (alpha & 0xFF) << 24 | (blue & 0xFF) << 16 | (green & 0xFF) << 8 | (red & 0xFF) << 0;
    }

    public IntBuffer getBufferRGBA() {
        if (this.c != dgs$a.a) {
            throw new IllegalArgumentException(String.format("getBuffer only works on RGBA images; have %s", new Object[]{this.c}));
        }
        this.h();
        return MemoryUtil.memIntBuffer((long)this.g, (int)((int)this.h));
    }

    public void fillRGBA(int rgba) {
        if (this.c != dgs$a.a) {
            throw new IllegalArgumentException(String.format("getBuffer only works on RGBA images; have %s", new Object[]{this.c}));
        }
        this.h();
        MemoryUtil.memSet((long)this.g, (int)rgba, (long)this.h);
    }

    public long getSize() {
        return this.h;
    }

    static class c
    extends STBIWriteCallback {
        private final WritableByteChannel a;
        @Nullable
        private IOException b;

        private c(WritableByteChannel byteChannelIn) {
            this.a = byteChannelIn;
        }

        public void invoke(long p_invoke_1_, long p_invoke_3_, int p_invoke_5_) {
            ByteBuffer bytebuffer = dgs$c.getData((long)p_invoke_3_, (int)p_invoke_5_);
            try {
                this.a.write(bytebuffer);
            }
            catch (IOException ioexception) {
                this.b = ioexception;
            }
        }

        public void a() throws IOException {
            if (this.b != null) {
                throw this.b;
            }
        }
    }

    public static enum b {
        a(6408),
        b(6407),
        c(6410),
        d(6409),
        e(32841);

        private final int f;

        private b(int glFormatIn) {
            this.f = glFormatIn;
        }

        int a() {
            return this.f;
        }
    }

    public static enum a {
        a(4, 6408, true, true, true, false, true, 0, 8, 16, 255, 24, true),
        b(3, 6407, true, true, true, false, false, 0, 8, 16, 255, 255, true),
        c(2, 6410, false, false, false, true, true, 255, 255, 255, 0, 8, true),
        d(1, 6409, false, false, false, true, false, 0, 0, 0, 0, 255, true);

        private final int e;
        private final int f;
        private final boolean g;
        private final boolean h;
        private final boolean i;
        private final boolean j;
        private final boolean k;
        private final int l;
        private final int m;
        private final int n;
        private final int o;
        private final int p;
        private final boolean q;

        private a(int channelsIn, int glFormatIn, boolean redIn, boolean greenIn, boolean blueIn, boolean luminanceIn, boolean alphaIn, int offsetRedIn, int offsetGreenIn, int offsetBlueIn, int offsetLuminanceIn, int offsetAlphaIn, boolean standardIn) {
            this.e = channelsIn;
            this.f = glFormatIn;
            this.g = redIn;
            this.h = greenIn;
            this.i = blueIn;
            this.j = luminanceIn;
            this.k = alphaIn;
            this.l = offsetRedIn;
            this.m = offsetGreenIn;
            this.n = offsetBlueIn;
            this.o = offsetLuminanceIn;
            this.p = offsetAlphaIn;
            this.q = standardIn;
        }

        public int a() {
            return this.e;
        }

        public void b() {
            RenderSystem.assertThread(RenderSystem::isOnRenderThread);
            dgl.n(3333, this.a());
        }

        public void c() {
            RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
            dgl.n(3317, this.a());
        }

        public int d() {
            return this.f;
        }

        public boolean e() {
            return this.k;
        }

        public int f() {
            return this.p;
        }

        public boolean g() {
            return this.j || this.k;
        }

        public int h() {
            return this.j ? this.o : this.p;
        }

        public boolean i() {
            return this.q;
        }

        private static a b(int channelsIn) {
            switch (channelsIn) {
                case 1: {
                    return d;
                }
                case 2: {
                    return c;
                }
                case 3: {
                    return b;
                }
            }
            return a;
        }
    }
}

