/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.particle;

import com.google.common.base.Charsets;
import com.google.common.collect.EvictingQueue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.client.particle.AshParticle;
import net.minecraft.client.particle.BarrierParticle;
import net.minecraft.client.particle.BreakingParticle;
import net.minecraft.client.particle.BubbleColumnUpParticle;
import net.minecraft.client.particle.BubbleParticle;
import net.minecraft.client.particle.BubblePopParticle;
import net.minecraft.client.particle.CampfireParticle;
import net.minecraft.client.particle.CloudParticle;
import net.minecraft.client.particle.CritParticle;
import net.minecraft.client.particle.CurrentDownParticle;
import net.minecraft.client.particle.DiggingParticle;
import net.minecraft.client.particle.DragonBreathParticle;
import net.minecraft.client.particle.DripParticle;
import net.minecraft.client.particle.EmitterParticle;
import net.minecraft.client.particle.EnchantmentTableParticle;
import net.minecraft.client.particle.EndRodParticle;
import net.minecraft.client.particle.FallingDustParticle;
import net.minecraft.client.particle.FireworkParticle;
import net.minecraft.client.particle.FlameParticle;
import net.minecraft.client.particle.HeartParticle;
import net.minecraft.client.particle.HugeExplosionParticle;
import net.minecraft.client.particle.IAnimatedSprite;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.IParticleRenderType;
import net.minecraft.client.particle.LargeExplosionParticle;
import net.minecraft.client.particle.LargeSmokeParticle;
import net.minecraft.client.particle.LavaParticle;
import net.minecraft.client.particle.MobAppearanceParticle;
import net.minecraft.client.particle.NoteParticle;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.particle.PoofParticle;
import net.minecraft.client.particle.PortalParticle;
import net.minecraft.client.particle.RainParticle;
import net.minecraft.client.particle.RedstoneParticle;
import net.minecraft.client.particle.ReversePortalParticle;
import net.minecraft.client.particle.SmokeParticle;
import net.minecraft.client.particle.SoulParticle;
import net.minecraft.client.particle.SpellParticle;
import net.minecraft.client.particle.SpitParticle;
import net.minecraft.client.particle.SplashParticle;
import net.minecraft.client.particle.SquidInkParticle;
import net.minecraft.client.particle.SuspendedTownParticle;
import net.minecraft.client.particle.SweepAttackParticle;
import net.minecraft.client.particle.TexturesParticle;
import net.minecraft.client.particle.TotemOfUndyingParticle;
import net.minecraft.client.particle.UnderwaterParticle;
import net.minecraft.client.particle.WaterWakeParticle;
import net.minecraft.client.particle.WhiteAshParticle;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.MissingTextureSprite;
import net.minecraft.client.renderer.texture.Texture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.entity.Entity;
import net.minecraft.fluid.FluidState;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IBlockReader;
import net.optifine.Config;
import net.optifine.reflect.Reflector;

public class ParticleManager
implements IFutureReloadListener {
    private static final List<IParticleRenderType> field_215241_b = ImmutableList.of((Object)IParticleRenderType.field_217601_a, (Object)IParticleRenderType.field_217602_b, (Object)IParticleRenderType.field_217604_d, (Object)IParticleRenderType.field_217603_c, (Object)IParticleRenderType.field_217605_e);
    protected ClientWorld field_78878_a;
    private final Map<IParticleRenderType, Queue<Particle>> field_78876_b = Maps.newIdentityHashMap();
    private final Queue<EmitterParticle> field_178933_d = Queues.newArrayDeque();
    private final TextureManager field_78877_c;
    private final Random field_78875_d = new Random();
    private final Map<ResourceLocation, IParticleFactory<?>> field_178932_g = new HashMap();
    private final Queue<Particle> field_187241_h = Queues.newArrayDeque();
    private final Map<ResourceLocation, AnimatedSpriteImpl> field_215242_i = Maps.newHashMap();
    private final AtlasTexture field_215243_j = new AtlasTexture(AtlasTexture.field_215262_g);

    public ParticleManager(ClientWorld worldIn, TextureManager rendererIn) {
        rendererIn.func_229263_a_(this.field_215243_j.func_229223_g_(), (Texture)this.field_215243_j);
        this.field_78878_a = worldIn;
        this.field_78877_c = rendererIn;
        this.func_178930_c();
    }

    private void func_178930_c() {
        this.func_215234_a((ParticleType)ParticleTypes.field_197608_a, SpellParticle.AmbientMobFactory::new);
        this.func_215234_a((ParticleType)ParticleTypes.field_197609_b, HeartParticle.AngryVillagerFactory::new);
        this.func_199283_a((ParticleType)ParticleTypes.field_197610_c, (IParticleFactory)new BarrierParticle.Factory());
        this.func_199283_a(ParticleTypes.field_197611_d, (IParticleFactory)new DiggingParticle.Factory());
        this.func_215234_a((ParticleType)ParticleTypes.field_197612_e, BubbleParticle.Factory::new);
        this.func_215234_a((ParticleType)ParticleTypes.field_203220_f, BubbleColumnUpParticle.Factory::new);
        this.func_215234_a((ParticleType)ParticleTypes.field_203217_T, BubblePopParticle.Factory::new);
        this.func_215234_a((ParticleType)ParticleTypes.field_218417_ae, CampfireParticle.CozySmokeFactory::new);
        this.func_215234_a((ParticleType)ParticleTypes.field_218418_af, CampfireParticle.SignalSmokeFactory::new);
        this.func_215234_a((ParticleType)ParticleTypes.field_197613_f, CloudParticle.Factory::new);
        this.func_215234_a((ParticleType)ParticleTypes.field_218420_D, SuspendedTownParticle.ComposterFactory::new);
        this.func_215234_a((ParticleType)ParticleTypes.field_197614_g, CritParticle.Factory::new);
        this.func_215234_a((ParticleType)ParticleTypes.field_203218_U, CurrentDownParticle.Factory::new);
        this.func_215234_a((ParticleType)ParticleTypes.field_197615_h, CritParticle.DamageIndicatorFactory::new);
        this.func_215234_a((ParticleType)ParticleTypes.field_197616_i, DragonBreathParticle.Factory::new);
        this.func_215234_a((ParticleType)ParticleTypes.field_206864_X, SuspendedTownParticle.DolphinSpeedFactory::new);
        this.func_215234_a((ParticleType)ParticleTypes.field_197617_j, DripParticle.DrippingLavaFactory::new);
        this.func_215234_a((ParticleType)ParticleTypes.field_218423_k, DripParticle.FallingLavaFactory::new);
        this.func_215234_a((ParticleType)ParticleTypes.field_218424_l, DripParticle.LandingLavaFactory::new);
        this.func_215234_a((ParticleType)ParticleTypes.field_197618_k, DripParticle.DrippingWaterFactory::new);
        this.func_215234_a((ParticleType)ParticleTypes.field_218425_n, DripParticle.FallingWaterFactory::new);
        this.func_215234_a(ParticleTypes.field_197619_l, RedstoneParticle.Factory::new);
        this.func_215234_a((ParticleType)ParticleTypes.field_197620_m, SpellParticle.Factory::new);
        this.func_199283_a((ParticleType)ParticleTypes.field_197621_n, (IParticleFactory)new MobAppearanceParticle.Factory());
        this.func_215234_a((ParticleType)ParticleTypes.field_197622_o, CritParticle.MagicFactory::new);
        this.func_215234_a((ParticleType)ParticleTypes.field_197623_p, EnchantmentTableParticle.EnchantmentTable::new);
        this.func_215234_a((ParticleType)ParticleTypes.field_197624_q, EndRodParticle.Factory::new);
        this.func_215234_a((ParticleType)ParticleTypes.field_197625_r, SpellParticle.MobFactory::new);
        this.func_199283_a((ParticleType)ParticleTypes.field_197626_s, (IParticleFactory)new HugeExplosionParticle.Factory());
        this.func_215234_a((ParticleType)ParticleTypes.field_197627_t, LargeExplosionParticle.Factory::new);
        this.func_215234_a(ParticleTypes.field_197628_u, FallingDustParticle.Factory::new);
        this.func_215234_a((ParticleType)ParticleTypes.field_197629_v, FireworkParticle.SparkFactory::new);
        this.func_215234_a((ParticleType)ParticleTypes.field_197630_w, WaterWakeParticle.Factory::new);
        this.func_215234_a((ParticleType)ParticleTypes.field_197631_x, FlameParticle.Factory::new);
        this.func_215234_a((ParticleType)ParticleTypes.field_239812_C_, SoulParticle.Factory::new);
        this.func_215234_a((ParticleType)ParticleTypes.field_239811_B_, FlameParticle.Factory::new);
        this.func_215234_a((ParticleType)ParticleTypes.field_218419_B, FireworkParticle.OverlayFactory::new);
        this.func_215234_a((ParticleType)ParticleTypes.field_197632_y, SuspendedTownParticle.HappyVillagerFactory::new);
        this.func_215234_a((ParticleType)ParticleTypes.field_197633_z, HeartParticle.Factory::new);
        this.func_215234_a((ParticleType)ParticleTypes.field_197590_A, SpellParticle.InstantFactory::new);
        this.func_199283_a(ParticleTypes.field_197591_B, (IParticleFactory)new BreakingParticle.Factory());
        this.func_199283_a((ParticleType)ParticleTypes.field_197592_C, (IParticleFactory)new BreakingParticle.SlimeFactory());
        this.func_199283_a((ParticleType)ParticleTypes.field_197593_D, (IParticleFactory)new BreakingParticle.SnowballFactory());
        this.func_215234_a((ParticleType)ParticleTypes.field_197594_E, LargeSmokeParticle.Factory::new);
        this.func_215234_a((ParticleType)ParticleTypes.field_197595_F, LavaParticle.Factory::new);
        this.func_215234_a((ParticleType)ParticleTypes.field_197596_G, SuspendedTownParticle.Factory::new);
        this.func_215234_a((ParticleType)ParticleTypes.field_205167_W, EnchantmentTableParticle.NautilusFactory::new);
        this.func_215234_a((ParticleType)ParticleTypes.field_197597_H, NoteParticle.Factory::new);
        this.func_215234_a((ParticleType)ParticleTypes.field_197598_I, PoofParticle.Factory::new);
        this.func_215234_a((ParticleType)ParticleTypes.field_197599_J, PortalParticle.Factory::new);
        this.func_215234_a((ParticleType)ParticleTypes.field_197600_K, RainParticle.Factory::new);
        this.func_215234_a((ParticleType)ParticleTypes.field_197601_L, SmokeParticle.Factory::new);
        this.func_215234_a((ParticleType)ParticleTypes.field_218421_R, CloudParticle.SneezeFactory::new);
        this.func_215234_a((ParticleType)ParticleTypes.field_197602_M, SpitParticle.Factory::new);
        this.func_215234_a((ParticleType)ParticleTypes.field_197603_N, SweepAttackParticle.Factory::new);
        this.func_215234_a((ParticleType)ParticleTypes.field_197604_O, TotemOfUndyingParticle.Factory::new);
        this.func_215234_a((ParticleType)ParticleTypes.field_203219_V, SquidInkParticle.Factory::new);
        this.func_215234_a((ParticleType)ParticleTypes.field_197605_P, UnderwaterParticle.UnderwaterFactory::new);
        this.func_215234_a((ParticleType)ParticleTypes.field_218422_X, SplashParticle.Factory::new);
        this.func_215234_a((ParticleType)ParticleTypes.field_197607_R, SpellParticle.WitchFactory::new);
        this.func_215234_a((ParticleType)ParticleTypes.field_229427_ag_, DripParticle.DrippingHoneyFactory::new);
        this.func_215234_a((ParticleType)ParticleTypes.field_229428_ah_, DripParticle.FallingHoneyFactory::new);
        this.func_215234_a((ParticleType)ParticleTypes.field_229429_ai_, DripParticle.LandingHoneyFactory::new);
        this.func_215234_a((ParticleType)ParticleTypes.field_229430_aj_, DripParticle.FallingNectarFactory::new);
        this.func_215234_a((ParticleType)ParticleTypes.field_239813_am_, AshParticle.Factory::new);
        this.func_215234_a((ParticleType)ParticleTypes.field_239814_an_, UnderwaterParticle.CrimsonSporeFactory::new);
        this.func_215234_a((ParticleType)ParticleTypes.field_239815_ao_, UnderwaterParticle.WarpedSporeFactory::new);
        this.func_215234_a((ParticleType)ParticleTypes.field_239816_ap_, DripParticle.DrippingObsidianTearFactory::new);
        this.func_215234_a((ParticleType)ParticleTypes.field_239817_aq_, DripParticle.FallingObsidianTearFactory::new);
        this.func_215234_a((ParticleType)ParticleTypes.field_239818_ar_, DripParticle.LandingObsidianTearFactory::new);
        this.func_215234_a((ParticleType)ParticleTypes.field_239819_as_, ReversePortalParticle.Factory::new);
        this.func_215234_a((ParticleType)ParticleTypes.field_239820_at_, WhiteAshParticle.Factory::new);
    }

    private <T extends IParticleData> void func_199283_a(ParticleType<T> particleTypeIn, IParticleFactory<T> particleFactoryIn) {
        this.field_178932_g.put(Registry.field_212632_u.func_177774_c(particleTypeIn), particleFactoryIn);
    }

    private <T extends IParticleData> void func_215234_a(ParticleType<T> particleTypeIn, IParticleMetaFactory<T> particleMetaFactoryIn) {
        AnimatedSpriteImpl particlemanager$animatedspriteimpl = new AnimatedSpriteImpl(this, null);
        this.field_215242_i.put(Registry.field_212632_u.func_177774_c(particleTypeIn), particlemanager$animatedspriteimpl);
        this.field_178932_g.put(Registry.field_212632_u.func_177774_c(particleTypeIn), particleMetaFactoryIn.create((IAnimatedSprite)particlemanager$animatedspriteimpl));
    }

    public CompletableFuture<Void> func_215226_a(IFutureReloadListener.IStage stage, IResourceManager resourceManager, IProfiler preparationsProfiler, IProfiler reloadProfiler, Executor backgroundExecutor, Executor gameExecutor) {
        ConcurrentMap map = Maps.newConcurrentMap();
        CompletableFuture[] completablefuture = (CompletableFuture[])Registry.field_212632_u.func_148742_b().stream().map(p_215228_4_ -> CompletableFuture.runAsync(() -> this.func_215236_a(resourceManager, p_215228_4_, map), backgroundExecutor)).toArray(CompletableFuture[]::new);
        return ((CompletableFuture)((CompletableFuture)CompletableFuture.allOf(completablefuture).thenApplyAsync(p_228344_4_ -> {
            preparationsProfiler.func_219894_a();
            preparationsProfiler.func_76320_a("stitching");
            AtlasTexture.SheetData atlastexture$sheetdata = this.field_215243_j.func_229220_a_(resourceManager, map.values().stream().flatMap(Collection::stream), preparationsProfiler, 0);
            preparationsProfiler.func_76319_b();
            preparationsProfiler.func_219897_b();
            return atlastexture$sheetdata;
        }, backgroundExecutor)).thenCompose(arg_0 -> ((IFutureReloadListener.IStage)stage).func_216872_a(arg_0))).thenAcceptAsync(p_215229_3_ -> {
            this.field_78876_b.clear();
            reloadProfiler.func_219894_a();
            reloadProfiler.func_76320_a("upload");
            this.field_215243_j.func_215260_a(p_215229_3_);
            reloadProfiler.func_219895_b("bindSpriteSets");
            TextureAtlasSprite textureatlassprite = this.field_215243_j.func_195424_a(MissingTextureSprite.func_195675_b());
            map.forEach((p_215227_2_, p_215227_3_) -> {
                ImmutableList immutablelist = p_215227_3_.isEmpty() ? ImmutableList.of((Object)textureatlassprite) : (ImmutableList)p_215227_3_.stream().map(arg_0 -> ((AtlasTexture)this.field_215243_j).func_195424_a(arg_0)).collect(ImmutableList.toImmutableList());
                ((AnimatedSpriteImpl)this.field_215242_i.get(p_215227_2_)).func_217592_a((List)immutablelist);
            });
            reloadProfiler.func_76319_b();
            reloadProfiler.func_219897_b();
        }, gameExecutor);
    }

    public void func_215232_a() {
        this.field_215243_j.func_195419_g();
    }

    private void func_215236_a(IResourceManager manager, ResourceLocation particleId, Map<ResourceLocation, List<ResourceLocation>> textures) {
        ResourceLocation resourcelocation = new ResourceLocation(particleId.func_110624_b(), "particles/" + particleId.func_110623_a() + ".json");
        try (IResource iresource = manager.func_199002_a(resourcelocation);
             InputStreamReader reader = new InputStreamReader(iresource.func_199027_b(), Charsets.UTF_8);){
            TexturesParticle texturesparticle = TexturesParticle.func_217595_a((JsonObject)JSONUtils.func_212743_a((Reader)reader));
            List list = texturesparticle.func_217596_a();
            boolean flag = this.field_215242_i.containsKey(particleId);
            if (list == null) {
                if (flag) {
                    throw new IllegalStateException("Missing texture list for particle " + particleId);
                }
            } else {
                if (!flag) {
                    throw new IllegalStateException("Redundant texture list for particle " + particleId);
                }
                textures.put(particleId, list.stream().map(p_228349_0_ -> new ResourceLocation(p_228349_0_.func_110624_b(), "particle/" + p_228349_0_.func_110623_a())).collect(Collectors.toList()));
            }
        }
        catch (IOException ioexception) {
            throw new IllegalStateException("Failed to load description for particle " + particleId, ioexception);
        }
    }

    public void func_199282_a(Entity entityIn, IParticleData particleData) {
        this.field_178933_d.add(new EmitterParticle(this.field_78878_a, entityIn, particleData));
    }

    public void func_199281_a(Entity entityIn, IParticleData dataIn, int lifetimeIn) {
        this.field_178933_d.add(new EmitterParticle(this.field_78878_a, entityIn, dataIn, lifetimeIn));
    }

    @Nullable
    public Particle func_199280_a(IParticleData particleData, double x2, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        Particle particle = this.func_199927_b(particleData, x2, y, z, xSpeed, ySpeed, zSpeed);
        if (particle != null) {
            this.func_78873_a(particle);
            return particle;
        }
        return null;
    }

    @Nullable
    private <T extends IParticleData> Particle func_199927_b(T particleData, double x2, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        IParticleFactory iparticlefactory = (IParticleFactory)this.field_178932_g.get(Registry.field_212632_u.func_177774_c((Object)particleData.func_197554_b()));
        return iparticlefactory == null ? null : iparticlefactory.func_199234_a(particleData, this.field_78878_a, x2, y, z, xSpeed, ySpeed, zSpeed);
    }

    public void func_78873_a(Particle effect) {
        if (effect == null) {
            return;
        }
        if (effect instanceof FireworkParticle.Spark && !Config.isFireworkParticles()) {
            return;
        }
        this.field_187241_h.add(effect);
    }

    public void func_78868_a() {
        this.field_78876_b.forEach((p_228347_1_, p_228347_2_) -> {
            this.field_78878_a.func_217381_Z().func_76320_a(p_228347_1_.toString());
            this.func_187240_a((Collection)p_228347_2_);
            this.field_78878_a.func_217381_Z().func_76319_b();
        });
        if (!this.field_178933_d.isEmpty()) {
            ArrayList list = Lists.newArrayList();
            for (EmitterParticle emitterparticle : this.field_178933_d) {
                emitterparticle.func_189213_a();
                if (emitterparticle.func_187113_k()) continue;
                list.add(emitterparticle);
            }
            this.field_178933_d.removeAll(list);
        }
        if (!this.field_187241_h.isEmpty()) {
            Particle particle;
            while ((particle = (Particle)this.field_187241_h.poll()) != null) {
                Queue queue = this.field_78876_b.computeIfAbsent(particle.func_217558_b(), p_228346_0_ -> EvictingQueue.create((int)16384));
                if (particle instanceof BarrierParticle && this.reuseBarrierParticle(particle, queue)) continue;
                queue.add(particle);
            }
        }
    }

    private void func_187240_a(Collection<Particle> particlesIn) {
        if (!particlesIn.isEmpty()) {
            long timeStartMs = System.currentTimeMillis();
            int countLeft = particlesIn.size();
            Iterator<Particle> iterator = particlesIn.iterator();
            while (iterator.hasNext()) {
                Particle particle = iterator.next();
                this.func_178923_d(particle);
                if (!particle.func_187113_k()) {
                    iterator.remove();
                }
                --countLeft;
                if (System.currentTimeMillis() <= timeStartMs + 20L) continue;
                break;
            }
            if (countLeft > 0) {
                Iterator<Particle> it = particlesIn.iterator();
                for (int countToRemove = countLeft; it.hasNext() && countToRemove > 0; --countToRemove) {
                    Particle particle = it.next();
                    particle.func_187112_i();
                    it.remove();
                }
            }
        }
    }

    private void func_178923_d(Particle particle) {
        try {
            particle.func_189213_a();
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Ticking Particle");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Particle being ticked");
            crashreportcategory.func_189529_a("Particle", () -> ((Particle)particle).toString());
            crashreportcategory.func_189529_a("Particle Type", particle.func_217558_b()::toString);
            throw new ReportedException(crashreport);
        }
    }

    public void func_228345_a_(MatrixStack matrixStackIn, IRenderTypeBuffer.Impl bufferIn, LightTexture lightTextureIn, ActiveRenderInfo activeRenderInfoIn, float partialTicks) {
        lightTextureIn.func_205109_c();
        Runnable enable = () -> {
            RenderSystem.enableAlphaTest();
            RenderSystem.defaultAlphaFunc();
            RenderSystem.enableDepthTest();
            RenderSystem.enableFog();
            if (Reflector.ForgeHooksClient.exists()) {
                RenderSystem.activeTexture((int)33986);
                RenderSystem.enableTexture();
                RenderSystem.activeTexture((int)33984);
            }
        };
        FluidState cameraFluidState = activeRenderInfoIn.func_216771_k();
        boolean isEyeInWater = cameraFluidState.func_206884_a((ITag)FluidTags.field_206959_a);
        RenderSystem.pushMatrix();
        RenderSystem.multMatrix((Matrix4f)matrixStackIn.func_227866_c_().func_227870_a_());
        Collection<Object> renderTypes = field_215241_b;
        if (Reflector.ForgeHooksClient.exists()) {
            renderTypes = this.field_78876_b.keySet();
        }
        for (IParticleRenderType iparticlerendertype : renderTypes) {
            if (iparticlerendertype == IParticleRenderType.field_217606_f) continue;
            enable.run();
            Iterable iterable = (Iterable)this.field_78876_b.get(iparticlerendertype);
            if (iterable == null) continue;
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferbuilder = tessellator.func_178180_c();
            iparticlerendertype.func_217600_a(bufferbuilder, this.field_78877_c);
            for (Particle particle : iterable) {
                try {
                    if (!isEyeInWater && particle instanceof UnderwaterParticle && particle.field_187129_i == 0.0 && particle.field_187130_j == 0.0 && particle.field_187131_k == 0.0) continue;
                    particle.func_225606_a_((IVertexBuilder)bufferbuilder, activeRenderInfoIn, partialTicks);
                }
                catch (Throwable throwable) {
                    CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Rendering Particle");
                    CrashReportCategory crashreportcategory = crashreport.func_85058_a("Particle being rendered");
                    crashreportcategory.func_189529_a("Particle", () -> ((Particle)particle).toString());
                    crashreportcategory.func_189529_a("Particle Type", iparticlerendertype::toString);
                    throw new ReportedException(crashreport);
                }
            }
            iparticlerendertype.func_217599_a(tessellator);
        }
        RenderSystem.popMatrix();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.depthFunc((int)515);
        RenderSystem.disableBlend();
        RenderSystem.defaultAlphaFunc();
        lightTextureIn.func_205108_b();
        RenderSystem.disableFog();
        RenderSystem.enableDepthTest();
    }

    public void func_78870_a(@Nullable ClientWorld worldIn) {
        this.field_78878_a = worldIn;
        this.field_78876_b.clear();
        this.field_178933_d.clear();
    }

    public void func_180533_a(BlockPos pos, BlockState state) {
        boolean notAir;
        if (Reflector.IForgeBlockState_addDestroyEffects.exists() && Reflector.IForgeBlockState_isAir2.exists()) {
            Block block = state.func_177230_c();
            notAir = !Reflector.callBoolean(state, Reflector.IForgeBlockState_isAir2, this.field_78878_a, pos) && !Reflector.callBoolean(state, Reflector.IForgeBlockState_addDestroyEffects, this.field_78878_a, pos, this);
        } else {
            boolean bl = notAir = !state.func_196958_f();
        }
        if (notAir) {
            VoxelShape voxelshape = state.func_196954_c((IBlockReader)this.field_78878_a, pos);
            double d0 = 0.25;
            voxelshape.func_197755_b((p_228348_3_, p_228348_5_, p_228348_7_, p_228348_9_, p_228348_11_, p_228348_13_) -> {
                double d1 = Math.min(1.0, p_228348_9_ - p_228348_3_);
                double d2 = Math.min(1.0, p_228348_11_ - p_228348_5_);
                double d3 = Math.min(1.0, p_228348_13_ - p_228348_7_);
                int i2 = Math.max(2, MathHelper.func_76143_f((double)(d1 / 0.25)));
                int j2 = Math.max(2, MathHelper.func_76143_f((double)(d2 / 0.25)));
                int k2 = Math.max(2, MathHelper.func_76143_f((double)(d3 / 0.25)));
                for (int l2 = 0; l2 < i2; ++l2) {
                    for (int i1 = 0; i1 < j2; ++i1) {
                        for (int j1 = 0; j1 < k2; ++j1) {
                            double d4 = ((double)l2 + 0.5) / (double)i2;
                            double d5 = ((double)i1 + 0.5) / (double)j2;
                            double d6 = ((double)j1 + 0.5) / (double)k2;
                            double d7 = d4 * d1 + p_228348_3_;
                            double d8 = d5 * d2 + p_228348_5_;
                            double d9 = d6 * d3 + p_228348_7_;
                            this.func_78873_a((Particle)new DiggingParticle(this.field_78878_a, (double)pos.func_177958_n() + d7, (double)pos.func_177956_o() + d8, (double)pos.func_177952_p() + d9, d4 - 0.5, d5 - 0.5, d6 - 0.5, state).func_174846_a(pos));
                        }
                    }
                }
            });
        }
    }

    public void func_180532_a(BlockPos pos, Direction side) {
        BlockState blockstate = this.field_78878_a.func_180495_p(pos);
        if (blockstate.func_185901_i() != BlockRenderType.INVISIBLE) {
            int i2 = pos.func_177958_n();
            int j2 = pos.func_177956_o();
            int k2 = pos.func_177952_p();
            float f2 = 0.1f;
            AxisAlignedBB axisalignedbb = blockstate.func_196954_c((IBlockReader)this.field_78878_a, pos).func_197752_a();
            double d0 = (double)i2 + this.field_78875_d.nextDouble() * (axisalignedbb.field_72336_d - axisalignedbb.field_72340_a - (double)0.2f) + (double)0.1f + axisalignedbb.field_72340_a;
            double d1 = (double)j2 + this.field_78875_d.nextDouble() * (axisalignedbb.field_72337_e - axisalignedbb.field_72338_b - (double)0.2f) + (double)0.1f + axisalignedbb.field_72338_b;
            double d2 = (double)k2 + this.field_78875_d.nextDouble() * (axisalignedbb.field_72334_f - axisalignedbb.field_72339_c - (double)0.2f) + (double)0.1f + axisalignedbb.field_72339_c;
            if (side == Direction.DOWN) {
                d1 = (double)j2 + axisalignedbb.field_72338_b - (double)0.1f;
            }
            if (side == Direction.UP) {
                d1 = (double)j2 + axisalignedbb.field_72337_e + (double)0.1f;
            }
            if (side == Direction.NORTH) {
                d2 = (double)k2 + axisalignedbb.field_72339_c - (double)0.1f;
            }
            if (side == Direction.SOUTH) {
                d2 = (double)k2 + axisalignedbb.field_72334_f + (double)0.1f;
            }
            if (side == Direction.WEST) {
                d0 = (double)i2 + axisalignedbb.field_72340_a - (double)0.1f;
            }
            if (side == Direction.EAST) {
                d0 = (double)i2 + axisalignedbb.field_72336_d + (double)0.1f;
            }
            this.func_78873_a(new DiggingParticle(this.field_78878_a, d0, d1, d2, 0.0, 0.0, 0.0, blockstate).func_174846_a(pos).func_70543_e(0.2f).func_70541_f(0.6f));
        }
    }

    public String func_78869_b() {
        return String.valueOf(this.field_78876_b.values().stream().mapToInt(Collection::size).sum());
    }

    private boolean reuseBarrierParticle(Particle entityfx, Queue<Particle> deque) {
        for (Particle efx : deque) {
            if (!(efx instanceof BarrierParticle) || entityfx.field_187123_c != efx.field_187123_c || entityfx.field_187124_d != efx.field_187124_d || entityfx.field_187125_e != efx.field_187125_e) continue;
            efx.field_70546_d = 0;
            return true;
        }
        return false;
    }

    public void addBlockHitEffects(BlockPos pos, BlockRayTraceResult target) {
        BlockState state = this.field_78878_a.func_180495_p(pos);
        if (state == null) {
            return;
        }
        boolean addHitEffects = Reflector.callBoolean(state, Reflector.IForgeBlockState_addHitEffects, this.field_78878_a, target, this);
        if (!addHitEffects) {
            Direction face = target.func_216354_b();
            this.func_180532_a(pos, face);
        }
    }
}

