/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.BitSet;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockModelRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.RegionRenderCacheBuilder;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.optifine.BetterSnow;
import net.optifine.Config;
import net.optifine.CustomColors;
import net.optifine.EmissiveTextures;
import net.optifine.model.BlockModelCustomizer;
import net.optifine.model.ListQuadsOverlay;
import net.optifine.reflect.Reflector;
import net.optifine.reflect.ReflectorForge;
import net.optifine.render.LightCacheOF;
import net.optifine.render.RenderEnv;
import net.optifine.render.RenderTypes;
import net.optifine.shaders.SVertexBuilder;
import net.optifine.shaders.Shaders;
import net.optifine.util.BlockUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class BlockModelRenderer {
    private final BlockColors field_187499_a;
    private static final ThreadLocal<Cache> field_210267_b = ThreadLocal.withInitial(() -> new Cache(null));
    private static float aoLightValueOpaque = 0.2f;
    private static boolean separateAoLightValue = false;
    private static final LightCacheOF LIGHT_CACHE_OF = new LightCacheOF();
    private static final RenderType[] OVERLAY_LAYERS = new RenderType[]{RenderTypes.CUTOUT, RenderTypes.CUTOUT_MIPPED, RenderTypes.TRANSLUCENT};
    private boolean forgeModelData = Reflector.ForgeHooksClient.exists();

    public BlockModelRenderer(BlockColors blockColorsIn) {
        this.field_187499_a = blockColorsIn;
    }

    public boolean func_228802_a_(IBlockDisplayReader worldIn, IBakedModel modelIn, BlockState stateIn, BlockPos posIn, MatrixStack matrixIn, IVertexBuilder buffer, boolean checkSides, Random randomIn, long rand, int combinedOverlayIn) {
        return this.renderModel(worldIn, modelIn, stateIn, posIn, matrixIn, buffer, checkSides, randomIn, rand, combinedOverlayIn, (IModelData)EmptyModelData.INSTANCE);
    }

    public boolean renderModel(IBlockDisplayReader worldIn, IBakedModel modelIn, BlockState stateIn, BlockPos posIn, MatrixStack matrixIn, IVertexBuilder buffer, boolean checkSides, Random randomIn, long rand, int combinedOverlayIn, IModelData modelData) {
        boolean flag;
        boolean bl = flag = Minecraft.func_71379_u() && ReflectorForge.getLightValue((BlockState)stateIn, (IBlockDisplayReader)worldIn, (BlockPos)posIn) == 0 && modelIn.func_177555_b();
        if (this.forgeModelData) {
            modelData = modelIn.getModelData(worldIn, posIn, stateIn, modelData);
        }
        Vector3d vector3d = stateIn.func_191059_e((IBlockReader)worldIn, posIn);
        matrixIn.func_227861_a_(vector3d.field_72450_a, vector3d.field_72448_b, vector3d.field_72449_c);
        try {
            boolean rendered;
            if (Config.isShaders()) {
                SVertexBuilder.pushEntity((BlockState)stateIn, (IVertexBuilder)buffer);
            }
            if (!Config.isAlternateBlocks()) {
                rand = 0L;
            }
            RenderEnv renderEnv = buffer.getRenderEnv(stateIn, posIn);
            modelIn = BlockModelCustomizer.getRenderModel((IBakedModel)modelIn, (BlockState)stateIn, (RenderEnv)renderEnv);
            boolean bl2 = rendered = flag ? this.renderModelSmooth(worldIn, modelIn, stateIn, posIn, matrixIn, buffer, checkSides, randomIn, rand, combinedOverlayIn, modelData) : this.renderModelFlat(worldIn, modelIn, stateIn, posIn, matrixIn, buffer, checkSides, randomIn, rand, combinedOverlayIn, modelData);
            if (rendered) {
                this.renderOverlayModels(worldIn, modelIn, stateIn, posIn, matrixIn, buffer, combinedOverlayIn, checkSides, randomIn, rand, renderEnv, flag, vector3d);
            }
            if (Config.isShaders()) {
                SVertexBuilder.popEntity((IVertexBuilder)buffer);
            }
            return rendered;
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Tesselating block model");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Block model being tesselated");
            CrashReportCategory.func_175750_a((CrashReportCategory)crashreportcategory, (BlockPos)posIn, (BlockState)stateIn);
            crashreportcategory.func_71507_a("Using AO", (Object)flag);
            throw new ReportedException(crashreport);
        }
    }

    public boolean func_228805_b_(IBlockDisplayReader worldIn, IBakedModel modelIn, BlockState stateIn, BlockPos posIn, MatrixStack matrixStackIn, IVertexBuilder buffer, boolean checkSides, Random randomIn, long rand, int combinedOverlayIn) {
        return this.renderModelSmooth(worldIn, modelIn, stateIn, posIn, matrixStackIn, buffer, checkSides, randomIn, rand, combinedOverlayIn, (IModelData)EmptyModelData.INSTANCE);
    }

    public boolean renderModelSmooth(IBlockDisplayReader worldIn, IBakedModel modelIn, BlockState stateIn, BlockPos posIn, MatrixStack matrixStackIn, IVertexBuilder buffer, boolean checkSides, Random randomIn, long rand, int combinedOverlayIn, IModelData modelData) {
        List list1;
        boolean flag = false;
        RenderEnv renderEnv = buffer.getRenderEnv(stateIn, posIn);
        RenderType layer = buffer.getBlockLayer();
        for (Direction direction : Direction.field_199792_n) {
            if (checkSides && !BlockUtils.shouldSideBeRendered((BlockState)stateIn, (IBlockReader)worldIn, (BlockPos)posIn, (Direction)direction, (RenderEnv)renderEnv)) continue;
            randomIn.setSeed(rand);
            List list = this.forgeModelData ? modelIn.getQuads(stateIn, direction, randomIn, modelData) : modelIn.func_200117_a(stateIn, direction, randomIn);
            list = BlockModelCustomizer.getRenderQuads((List)list, (IBlockDisplayReader)worldIn, (BlockState)stateIn, (BlockPos)posIn, (Direction)direction, (RenderType)layer, (long)rand, (RenderEnv)renderEnv);
            this.renderQuadsSmooth(worldIn, stateIn, posIn, matrixStackIn, buffer, list, combinedOverlayIn, renderEnv);
            flag = true;
        }
        randomIn.setSeed(rand);
        List list = list1 = this.forgeModelData ? modelIn.getQuads(stateIn, (Direction)null, randomIn, modelData) : modelIn.func_200117_a(stateIn, (Direction)null, randomIn);
        if (!list1.isEmpty()) {
            list1 = BlockModelCustomizer.getRenderQuads((List)list1, (IBlockDisplayReader)worldIn, (BlockState)stateIn, (BlockPos)posIn, null, (RenderType)layer, (long)rand, (RenderEnv)renderEnv);
            this.renderQuadsSmooth(worldIn, stateIn, posIn, matrixStackIn, buffer, list1, combinedOverlayIn, renderEnv);
            flag = true;
        }
        return flag;
    }

    public boolean func_228806_c_(IBlockDisplayReader worldIn, IBakedModel modelIn, BlockState stateIn, BlockPos posIn, MatrixStack matrixStackIn, IVertexBuilder buffer, boolean checkSides, Random randomIn, long rand, int combinedOverlayIn) {
        return this.renderModelFlat(worldIn, modelIn, stateIn, posIn, matrixStackIn, buffer, checkSides, randomIn, rand, combinedOverlayIn, (IModelData)EmptyModelData.INSTANCE);
    }

    public boolean renderModelFlat(IBlockDisplayReader worldIn, IBakedModel modelIn, BlockState stateIn, BlockPos posIn, MatrixStack matrixStackIn, IVertexBuilder buffer, boolean checkSides, Random randomIn, long rand, int combinedOverlayIn, IModelData modelData) {
        List list1;
        boolean flag = false;
        RenderEnv renderEnv = buffer.getRenderEnv(stateIn, posIn);
        RenderType layer = buffer.getBlockLayer();
        for (Direction direction : Direction.field_199792_n) {
            if (checkSides && !BlockUtils.shouldSideBeRendered((BlockState)stateIn, (IBlockReader)worldIn, (BlockPos)posIn, (Direction)direction, (RenderEnv)renderEnv)) continue;
            randomIn.setSeed(rand);
            List list = this.forgeModelData ? modelIn.getQuads(stateIn, direction, randomIn, modelData) : modelIn.func_200117_a(stateIn, direction, randomIn);
            int i2 = WorldRenderer.func_228420_a_((IBlockDisplayReader)worldIn, (BlockState)stateIn, (BlockPos)posIn.func_177972_a(direction));
            list = BlockModelCustomizer.getRenderQuads((List)list, (IBlockDisplayReader)worldIn, (BlockState)stateIn, (BlockPos)posIn, (Direction)direction, (RenderType)layer, (long)rand, (RenderEnv)renderEnv);
            this.renderQuadsFlat(worldIn, stateIn, posIn, i2, combinedOverlayIn, false, matrixStackIn, buffer, list, renderEnv);
            flag = true;
        }
        randomIn.setSeed(rand);
        List list = list1 = this.forgeModelData ? modelIn.getQuads(stateIn, (Direction)null, randomIn, modelData) : modelIn.func_200117_a(stateIn, (Direction)null, randomIn);
        if (!list1.isEmpty()) {
            list1 = BlockModelCustomizer.getRenderQuads((List)list1, (IBlockDisplayReader)worldIn, (BlockState)stateIn, (BlockPos)posIn, null, (RenderType)layer, (long)rand, (RenderEnv)renderEnv);
            this.renderQuadsFlat(worldIn, stateIn, posIn, -1, combinedOverlayIn, true, matrixStackIn, buffer, list1, renderEnv);
            flag = true;
        }
        return flag;
    }

    private void renderQuadsSmooth(IBlockDisplayReader blockAccessIn, BlockState stateIn, BlockPos posIn, MatrixStack matrixStackIn, IVertexBuilder buffer, List<BakedQuad> list, int combinedOverlayIn, RenderEnv renderEnv) {
        float[] quadBounds = renderEnv.getQuadBounds();
        BitSet bitSet = renderEnv.getBoundsFlags();
        AmbientOcclusionFace aoFace = renderEnv.getAoFace();
        int listSize = list.size();
        for (int ix = 0; ix < listSize; ++ix) {
            BakedQuad bakedquad = list.get(ix);
            this.func_228801_a_(blockAccessIn, stateIn, posIn, bakedquad.func_178209_a(), bakedquad.func_178210_d(), quadBounds, bitSet);
            aoFace.func_239285_a_(blockAccessIn, stateIn, posIn, bakedquad.func_178210_d(), quadBounds, bitSet, bakedquad.func_239287_f_());
            if (bakedquad.getSprite().isSpriteEmissive) {
                aoFace.setMaxBlockLight();
            }
            this.renderQuadSmooth(blockAccessIn, stateIn, posIn, buffer, matrixStackIn.func_227866_c_(), bakedquad, AmbientOcclusionFace.access$000((AmbientOcclusionFace)aoFace)[0], AmbientOcclusionFace.access$000((AmbientOcclusionFace)aoFace)[1], AmbientOcclusionFace.access$000((AmbientOcclusionFace)aoFace)[2], AmbientOcclusionFace.access$000((AmbientOcclusionFace)aoFace)[3], AmbientOcclusionFace.access$100((AmbientOcclusionFace)aoFace)[0], AmbientOcclusionFace.access$100((AmbientOcclusionFace)aoFace)[1], AmbientOcclusionFace.access$100((AmbientOcclusionFace)aoFace)[2], AmbientOcclusionFace.access$100((AmbientOcclusionFace)aoFace)[3], combinedOverlayIn, renderEnv);
        }
    }

    private void renderQuadSmooth(IBlockDisplayReader blockAccessIn, BlockState stateIn, BlockPos posIn, IVertexBuilder buffer, MatrixStack.Entry matrixEntry, BakedQuad quadIn, float colorMul0, float colorMul1, float colorMul2, float colorMul3, int brightness0, int brightness1, int brightness2, int brightness3, int combinedOverlayIn, RenderEnv renderEnv) {
        float f2;
        float f1;
        float f3;
        int colorMultiplier = CustomColors.getColorMultiplier((BakedQuad)quadIn, (BlockState)stateIn, (IBlockDisplayReader)blockAccessIn, (BlockPos)posIn, (RenderEnv)renderEnv);
        if (quadIn.func_178212_b() || colorMultiplier != -1) {
            int i2 = colorMultiplier != -1 ? colorMultiplier : this.field_187499_a.func_228054_a_(stateIn, blockAccessIn, posIn, quadIn.func_178211_c());
            f3 = (float)(i2 >> 16 & 0xFF) / 255.0f;
            f1 = (float)(i2 >> 8 & 0xFF) / 255.0f;
            f2 = (float)(i2 & 0xFF) / 255.0f;
        } else {
            f3 = 1.0f;
            f1 = 1.0f;
            f2 = 1.0f;
        }
        buffer.func_227890_a_(matrixEntry, quadIn, buffer.getTempFloat4(colorMul0, colorMul1, colorMul2, colorMul3), f3, f1, f2, buffer.getTempInt4(brightness0, brightness1, brightness2, brightness3), combinedOverlayIn, true);
    }

    private void func_228801_a_(IBlockDisplayReader blockReaderIn, BlockState stateIn, BlockPos posIn, int[] vertexData, Direction face, @Nullable float[] quadBounds, BitSet boundsFlags) {
        float f2 = 32.0f;
        float f1 = 32.0f;
        float f22 = 32.0f;
        float f3 = -32.0f;
        float f4 = -32.0f;
        float f5 = -32.0f;
        int step = vertexData.length / 4;
        for (int i2 = 0; i2 < 4; ++i2) {
            float f6 = Float.intBitsToFloat(vertexData[i2 * step]);
            float f7 = Float.intBitsToFloat(vertexData[i2 * step + 1]);
            float f8 = Float.intBitsToFloat(vertexData[i2 * step + 2]);
            f2 = Math.min(f2, f6);
            f1 = Math.min(f1, f7);
            f22 = Math.min(f22, f8);
            f3 = Math.max(f3, f6);
            f4 = Math.max(f4, f7);
            f5 = Math.max(f5, f8);
        }
        if (quadBounds != null) {
            quadBounds[Direction.WEST.func_176745_a()] = f2;
            quadBounds[Direction.EAST.func_176745_a()] = f3;
            quadBounds[Direction.DOWN.func_176745_a()] = f1;
            quadBounds[Direction.UP.func_176745_a()] = f4;
            quadBounds[Direction.NORTH.func_176745_a()] = f22;
            quadBounds[Direction.SOUTH.func_176745_a()] = f5;
            int j2 = Direction.field_199792_n.length;
            quadBounds[Direction.WEST.func_176745_a() + j2] = 1.0f - f2;
            quadBounds[Direction.EAST.func_176745_a() + j2] = 1.0f - f3;
            quadBounds[Direction.DOWN.func_176745_a() + j2] = 1.0f - f1;
            quadBounds[Direction.UP.func_176745_a() + j2] = 1.0f - f4;
            quadBounds[Direction.NORTH.func_176745_a() + j2] = 1.0f - f22;
            quadBounds[Direction.SOUTH.func_176745_a() + j2] = 1.0f - f5;
        }
        float f9 = 1.0E-4f;
        float f10 = 0.9999f;
        switch (1.$SwitchMap$net$minecraft$util$Direction[face.ordinal()]) {
            case 1: {
                boundsFlags.set(1, f2 >= 1.0E-4f || f22 >= 1.0E-4f || f3 <= 0.9999f || f5 <= 0.9999f);
                boundsFlags.set(0, f1 == f4 && (f1 < 1.0E-4f || stateIn.func_235785_r_((IBlockReader)blockReaderIn, posIn)));
                break;
            }
            case 2: {
                boundsFlags.set(1, f2 >= 1.0E-4f || f22 >= 1.0E-4f || f3 <= 0.9999f || f5 <= 0.9999f);
                boundsFlags.set(0, f1 == f4 && (f4 > 0.9999f || stateIn.func_235785_r_((IBlockReader)blockReaderIn, posIn)));
                break;
            }
            case 3: {
                boundsFlags.set(1, f2 >= 1.0E-4f || f1 >= 1.0E-4f || f3 <= 0.9999f || f4 <= 0.9999f);
                boundsFlags.set(0, f22 == f5 && (f22 < 1.0E-4f || stateIn.func_235785_r_((IBlockReader)blockReaderIn, posIn)));
                break;
            }
            case 4: {
                boundsFlags.set(1, f2 >= 1.0E-4f || f1 >= 1.0E-4f || f3 <= 0.9999f || f4 <= 0.9999f);
                boundsFlags.set(0, f22 == f5 && (f5 > 0.9999f || stateIn.func_235785_r_((IBlockReader)blockReaderIn, posIn)));
                break;
            }
            case 5: {
                boundsFlags.set(1, f1 >= 1.0E-4f || f22 >= 1.0E-4f || f4 <= 0.9999f || f5 <= 0.9999f);
                boundsFlags.set(0, f2 == f3 && (f2 < 1.0E-4f || stateIn.func_235785_r_((IBlockReader)blockReaderIn, posIn)));
                break;
            }
            case 6: {
                boundsFlags.set(1, f1 >= 1.0E-4f || f22 >= 1.0E-4f || f4 <= 0.9999f || f5 <= 0.9999f);
                boundsFlags.set(0, f2 == f3 && (f3 > 0.9999f || stateIn.func_235785_r_((IBlockReader)blockReaderIn, posIn)));
            }
        }
    }

    private void renderQuadsFlat(IBlockDisplayReader blockAccessIn, BlockState stateIn, BlockPos posIn, int brightnessIn, int combinedOverlayIn, boolean ownBrightness, MatrixStack matrixStackIn, IVertexBuilder buffer, List<BakedQuad> list, RenderEnv renderEnv) {
        BitSet bitSet = renderEnv.getBoundsFlags();
        int listSize = list.size();
        for (int ix = 0; ix < listSize; ++ix) {
            BakedQuad bakedquad = list.get(ix);
            if (ownBrightness) {
                this.func_228801_a_(blockAccessIn, stateIn, posIn, bakedquad.func_178209_a(), bakedquad.func_178210_d(), (float[])null, bitSet);
                BlockPos blockpos = bitSet.get(0) ? posIn.func_177972_a(bakedquad.func_178210_d()) : posIn;
                brightnessIn = WorldRenderer.func_228420_a_((IBlockDisplayReader)blockAccessIn, (BlockState)stateIn, (BlockPos)blockpos);
            }
            if (bakedquad.getSprite().isSpriteEmissive) {
                brightnessIn = LightTexture.MAX_BRIGHTNESS;
            }
            float f2 = blockAccessIn.func_230487_a_(bakedquad.func_178210_d(), bakedquad.func_239287_f_());
            this.renderQuadSmooth(blockAccessIn, stateIn, posIn, buffer, matrixStackIn.func_227866_c_(), bakedquad, f2, f2, f2, f2, brightnessIn, brightnessIn, brightnessIn, brightnessIn, combinedOverlayIn, renderEnv);
        }
    }

    public void func_228804_a_(MatrixStack.Entry matrixEntry, IVertexBuilder buffer, @Nullable BlockState state, IBakedModel modelIn, float red, float green, float blue, int combinedLightIn, int combinedOverlayIn) {
        this.renderModel(matrixEntry, buffer, state, modelIn, red, green, blue, combinedLightIn, combinedOverlayIn, (IModelData)EmptyModelData.INSTANCE);
    }

    public void renderModel(MatrixStack.Entry matrixEntry, IVertexBuilder buffer, @Nullable BlockState state, IBakedModel modelIn, float red, float green, float blue, int combinedLightIn, int combinedOverlayIn, IModelData modelData) {
        Random random = new Random();
        long i2 = 42L;
        for (Direction direction : Direction.field_199792_n) {
            random.setSeed(42L);
            if (this.forgeModelData) {
                BlockModelRenderer.func_228803_a_((MatrixStack.Entry)matrixEntry, (IVertexBuilder)buffer, (float)red, (float)green, (float)blue, (List)modelIn.getQuads(state, direction, random, modelData), (int)combinedLightIn, (int)combinedOverlayIn);
                continue;
            }
            BlockModelRenderer.func_228803_a_((MatrixStack.Entry)matrixEntry, (IVertexBuilder)buffer, (float)red, (float)green, (float)blue, (List)modelIn.func_200117_a(state, direction, random), (int)combinedLightIn, (int)combinedOverlayIn);
        }
        random.setSeed(42L);
        if (this.forgeModelData) {
            BlockModelRenderer.func_228803_a_((MatrixStack.Entry)matrixEntry, (IVertexBuilder)buffer, (float)red, (float)green, (float)blue, (List)modelIn.getQuads(state, (Direction)null, random, modelData), (int)combinedLightIn, (int)combinedOverlayIn);
        } else {
            BlockModelRenderer.func_228803_a_((MatrixStack.Entry)matrixEntry, (IVertexBuilder)buffer, (float)red, (float)green, (float)blue, (List)modelIn.func_200117_a(state, (Direction)null, random), (int)combinedLightIn, (int)combinedOverlayIn);
        }
    }

    private static void func_228803_a_(MatrixStack.Entry matrixEntry, IVertexBuilder buffer, float red, float green, float blue, List<BakedQuad> listQuads, int combinedLightIn, int combinedOverlayIn) {
        boolean emissive = EmissiveTextures.isActive();
        for (BakedQuad bakedquad : listQuads) {
            float f2;
            float f1;
            float f3;
            if (emissive && (bakedquad = EmissiveTextures.getEmissiveQuad((BakedQuad)bakedquad)) == null) continue;
            if (bakedquad.func_178212_b()) {
                f3 = MathHelper.func_76131_a((float)red, (float)0.0f, (float)1.0f);
                f1 = MathHelper.func_76131_a((float)green, (float)0.0f, (float)1.0f);
                f2 = MathHelper.func_76131_a((float)blue, (float)0.0f, (float)1.0f);
            } else {
                f3 = 1.0f;
                f1 = 1.0f;
                f2 = 1.0f;
            }
            buffer.func_227889_a_(matrixEntry, bakedquad, f3, f1, f2, combinedLightIn, combinedOverlayIn);
        }
    }

    public static void func_211847_a() {
        ((Cache)field_210267_b.get()).func_222895_a();
    }

    public static void func_210266_a() {
        ((Cache)field_210267_b.get()).func_222897_b();
    }

    public static float fixAoLightValue(float val) {
        if (val == 0.2f) {
            return aoLightValueOpaque;
        }
        return val;
    }

    public static void updateAoLightValue() {
        aoLightValueOpaque = 1.0f - Config.getAmbientOcclusionLevel() * 0.8f;
        separateAoLightValue = Config.isShaders() && Shaders.isSeparateAo();
    }

    public static boolean isSeparateAoLightValue() {
        return separateAoLightValue;
    }

    private void renderOverlayModels(IBlockDisplayReader worldIn, IBakedModel modelIn, BlockState stateIn, BlockPos posIn, MatrixStack matrixStackIn, IVertexBuilder buffer, int combinedOverlayIn, boolean checkSides, Random random, long rand, RenderEnv renderEnv, boolean smooth, Vector3d renderOffset) {
        if (renderEnv.isOverlaysRendered()) {
            for (int l2 = 0; l2 < OVERLAY_LAYERS.length; ++l2) {
                RenderType layer = OVERLAY_LAYERS[l2];
                ListQuadsOverlay listQuadsOverlay = renderEnv.getListQuadsOverlay(layer);
                if (listQuadsOverlay.size() <= 0) continue;
                RegionRenderCacheBuilder rrcb = renderEnv.getRegionRenderCacheBuilder();
                if (rrcb != null) {
                    BufferBuilder overlayBuffer = rrcb.func_228366_a_(layer);
                    if (!overlayBuffer.func_227834_j_()) {
                        overlayBuffer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
                    }
                    for (int q2 = 0; q2 < listQuadsOverlay.size(); ++q2) {
                        BakedQuad quad = listQuadsOverlay.getQuad(q2);
                        List listQuadSingle = listQuadsOverlay.getListQuadsSingle(quad);
                        BlockState quadBlockState = listQuadsOverlay.getBlockState(q2);
                        if (quad.getQuadEmissive() != null) {
                            listQuadsOverlay.addQuad(quad.getQuadEmissive(), quadBlockState);
                        }
                        renderEnv.reset(quadBlockState, posIn);
                        if (smooth) {
                            this.renderQuadsSmooth(worldIn, quadBlockState, posIn, matrixStackIn, (IVertexBuilder)overlayBuffer, listQuadSingle, combinedOverlayIn, renderEnv);
                            continue;
                        }
                        int col = WorldRenderer.func_228420_a_((IBlockDisplayReader)worldIn, (BlockState)quadBlockState, (BlockPos)posIn.func_177972_a(quad.func_178210_d()));
                        this.renderQuadsFlat(worldIn, quadBlockState, posIn, col, combinedOverlayIn, false, matrixStackIn, (IVertexBuilder)overlayBuffer, listQuadSingle, renderEnv);
                    }
                }
                listQuadsOverlay.clear();
            }
        }
        if (Config.isBetterSnow() && !renderEnv.isBreakingAnimation() && BetterSnow.shouldRender((IBlockDisplayReader)worldIn, (BlockState)stateIn, (BlockPos)posIn)) {
            IBakedModel modelSnow = BetterSnow.getModelSnowLayer();
            BlockState stateSnow = BetterSnow.getStateSnowLayer();
            matrixStackIn.func_227861_a_(-renderOffset.field_72450_a, -renderOffset.field_72448_b, -renderOffset.field_72449_c);
            this.func_228802_a_(worldIn, modelSnow, stateSnow, posIn, matrixStackIn, buffer, checkSides, random, rand, combinedOverlayIn);
        }
    }

    static /* synthetic */ LightCacheOF access$200() {
        return LIGHT_CACHE_OF;
    }
}

