/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import com.google.gson.JsonSyntaxException;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GLX;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.MapItemRenderer;
import net.minecraft.client.gui.ResourceLoadProgressGui;
import net.minecraft.client.gui.screen.ChatScreen;
import net.minecraft.client.gui.screen.DownloadTerrainScreen;
import net.minecraft.client.gui.screen.MainMenuScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.FirstPersonRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.OverlayRenderer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderTypeBuffers;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.client.shader.ShaderGroup;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemFrameEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.EndermanEntity;
import net.minecraft.entity.monster.SpiderEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effects;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.IResourceManagerReloadListener;
import net.minecraft.server.integrated.IntegratedServer;
import net.minecraft.util.CachedBlockInfo;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.ScreenShotHelper;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.resource.IResourceType;
import net.minecraftforge.resource.VanillaResourceType;
import net.optifine.Config;
import net.optifine.GlErrors;
import net.optifine.Lagometer;
import net.optifine.RandomEntities;
import net.optifine.gui.GuiChatOF;
import net.optifine.reflect.Reflector;
import net.optifine.reflect.ReflectorResolver;
import net.optifine.shaders.Shaders;
import net.optifine.shaders.ShadersRender;
import net.optifine.util.MemoryMonitor;
import net.optifine.util.TimedEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GameRenderer
implements IResourceManagerReloadListener,
AutoCloseable {
    private static final Logger field_147710_q = LogManager.getLogger();
    private final Minecraft field_78531_r;
    private final IResourceManager field_147711_ac;
    private final Random field_78537_ab = new Random();
    private float field_78530_s;
    public final FirstPersonRenderer field_78516_c;
    private final MapItemRenderer field_147709_v;
    private final RenderTypeBuffers field_228374_i_;
    private int field_78529_t;
    private float field_78507_R;
    private float field_78506_S;
    private float field_82831_U;
    private float field_82832_V;
    private boolean field_175074_C = true;
    private boolean field_175073_D = true;
    private long field_184374_E;
    private long field_78508_Y = Util.func_211177_b();
    private final LightTexture field_78513_d;
    private final OverlayTexture field_228375_t_ = new OverlayTexture();
    private boolean field_175078_W;
    private float field_78503_V = 1.0f;
    private float field_228376_w_;
    private float field_228377_x_;
    @Nullable
    private ItemStack field_190566_ab;
    private int field_190567_ac;
    private float field_190568_ad;
    private float field_190569_ae;
    @Nullable
    private ShaderGroup field_147707_d;
    private static final ResourceLocation[] field_147712_ad = new ResourceLocation[]{new ResourceLocation("shaders/post/notch.json"), new ResourceLocation("shaders/post/fxaa.json"), new ResourceLocation("shaders/post/art.json"), new ResourceLocation("shaders/post/bumpy.json"), new ResourceLocation("shaders/post/blobs2.json"), new ResourceLocation("shaders/post/pencil.json"), new ResourceLocation("shaders/post/color_convolve.json"), new ResourceLocation("shaders/post/deconverge.json"), new ResourceLocation("shaders/post/flip.json"), new ResourceLocation("shaders/post/invert.json"), new ResourceLocation("shaders/post/ntsc.json"), new ResourceLocation("shaders/post/outline.json"), new ResourceLocation("shaders/post/phosphor.json"), new ResourceLocation("shaders/post/scan_pincushion.json"), new ResourceLocation("shaders/post/sobel.json"), new ResourceLocation("shaders/post/bits.json"), new ResourceLocation("shaders/post/desaturate.json"), new ResourceLocation("shaders/post/green.json"), new ResourceLocation("shaders/post/blur.json"), new ResourceLocation("shaders/post/wobble.json"), new ResourceLocation("shaders/post/blobs.json"), new ResourceLocation("shaders/post/antialias.json"), new ResourceLocation("shaders/post/creeper.json"), new ResourceLocation("shaders/post/spider.json")};
    public static final int field_147708_e = field_147712_ad.length;
    private int field_147713_ae = field_147708_e;
    private boolean field_175083_ad;
    private final ActiveRenderInfo field_215317_L = new ActiveRenderInfo();
    private boolean initialized = false;
    private World updatedWorld = null;
    private float clipDistance = 128.0f;
    private long lastServerTime = 0L;
    private int lastServerTicks = 0;
    private int serverWaitTime = 0;
    private int serverWaitTimeCurrent = 0;
    private float avgServerTimeDiff = 0.0f;
    private float avgServerTickDiff = 0.0f;
    private ShaderGroup[] fxaaShaders = new ShaderGroup[10];
    private boolean guiLoadingVisible = false;

    public GameRenderer(Minecraft mcIn, IResourceManager resourceManagerIn, RenderTypeBuffers renderTypeBuffersIn) {
        this.field_78531_r = mcIn;
        this.field_147711_ac = resourceManagerIn;
        this.field_78516_c = mcIn.func_175597_ag();
        this.field_147709_v = new MapItemRenderer(mcIn.func_110434_K());
        this.field_78513_d = new LightTexture(this, mcIn);
        this.field_228374_i_ = renderTypeBuffersIn;
        this.field_147707_d = null;
    }

    @Override
    public void close() {
        this.field_78513_d.close();
        this.field_147709_v.close();
        this.field_228375_t_.close();
        this.func_181022_b();
    }

    public void func_181022_b() {
        if (this.field_147707_d != null) {
            this.field_147707_d.close();
        }
        this.field_147707_d = null;
        this.field_147713_ae = field_147708_e;
    }

    public void func_175071_c() {
        this.field_175083_ad = !this.field_175083_ad;
    }

    public void func_175066_a(@Nullable Entity entityIn) {
        if (this.field_147707_d != null) {
            this.field_147707_d.close();
        }
        this.field_147707_d = null;
        if (entityIn instanceof CreeperEntity) {
            this.func_175069_a(new ResourceLocation("shaders/post/creeper.json"));
        } else if (entityIn instanceof SpiderEntity) {
            this.func_175069_a(new ResourceLocation("shaders/post/spider.json"));
        } else if (entityIn instanceof EndermanEntity) {
            this.func_175069_a(new ResourceLocation("shaders/post/invert.json"));
        } else if (Reflector.ForgeHooksClient_loadEntityShader.exists()) {
            Reflector.call(Reflector.ForgeHooksClient_loadEntityShader, entityIn, this);
        }
    }

    private void func_175069_a(ResourceLocation resourceLocationIn) {
        if (!GLX.isUsingFBOs()) {
            return;
        }
        if (this.field_147707_d != null) {
            this.field_147707_d.close();
        }
        try {
            this.field_147707_d = new ShaderGroup(this.field_78531_r.func_110434_K(), this.field_147711_ac, this.field_78531_r.func_147110_a(), resourceLocationIn);
            this.field_147707_d.func_148026_a(this.field_78531_r.func_228018_at_().func_198109_k(), this.field_78531_r.func_228018_at_().func_198091_l());
            this.field_175083_ad = true;
        }
        catch (IOException ioexception) {
            field_147710_q.warn("Failed to load shader: {}", (Object)resourceLocationIn, (Object)ioexception);
            this.field_147713_ae = field_147708_e;
            this.field_175083_ad = false;
        }
        catch (JsonSyntaxException jsonsyntaxexception) {
            field_147710_q.warn("Failed to parse shader: {}", (Object)resourceLocationIn, (Object)jsonsyntaxexception);
            this.field_147713_ae = field_147708_e;
            this.field_175083_ad = false;
        }
    }

    public void func_195410_a(IResourceManager resourceManager) {
        if (this.field_147707_d != null) {
            this.field_147707_d.close();
        }
        this.field_147707_d = null;
        if (this.field_147713_ae == field_147708_e) {
            this.func_175066_a(this.field_78531_r.func_175606_aa());
        } else {
            this.func_175069_a(field_147712_ad[this.field_147713_ae]);
        }
    }

    public void func_78464_a() {
        this.func_78477_e();
        this.field_78513_d.func_205107_a();
        if (this.field_78531_r.func_175606_aa() == null) {
            this.field_78531_r.func_175607_a((Entity)this.field_78531_r.field_71439_g);
        }
        this.field_215317_L.func_216783_a();
        ++this.field_78529_t;
        this.field_78516_c.func_78441_a();
        this.field_78531_r.field_71438_f.func_228436_a_(this.field_215317_L);
        this.field_82832_V = this.field_82831_U;
        if (this.field_78531_r.field_71456_v.func_184046_j().func_184053_e()) {
            this.field_82831_U += 0.05f;
            if (this.field_82831_U > 1.0f) {
                this.field_82831_U = 1.0f;
            }
        } else if (this.field_82831_U > 0.0f) {
            this.field_82831_U -= 0.0125f;
        }
        if (this.field_190567_ac > 0) {
            --this.field_190567_ac;
            if (this.field_190567_ac == 0) {
                this.field_190566_ab = null;
            }
        }
    }

    @Nullable
    public ShaderGroup func_147706_e() {
        return this.field_147707_d;
    }

    public void func_147704_a(int width, int height) {
        if (this.field_147707_d != null) {
            this.field_147707_d.func_148026_a(width, height);
        }
        this.field_78531_r.field_71438_f.func_72720_a(width, height);
    }

    public void func_78473_a(float partialTicks) {
        Entity entity = this.field_78531_r.func_175606_aa();
        if (entity != null && this.field_78531_r.field_71441_e != null) {
            this.field_78531_r.func_213239_aq().func_76320_a("pick");
            this.field_78531_r.field_147125_j = null;
            double d0 = this.field_78531_r.field_71442_b.func_78757_d();
            this.field_78531_r.field_71476_x = entity.func_213324_a(d0, partialTicks, false);
            Vector3d vector3d = entity.func_174824_e(partialTicks);
            boolean flag = false;
            int i2 = 3;
            double d1 = d0;
            if (this.field_78531_r.field_71442_b.func_78749_i()) {
                d0 = d1 = 6.0;
            } else if (d0 > 3.0) {
                flag = true;
            }
            d1 *= d1;
            if (this.field_78531_r.field_71476_x != null) {
                d1 = this.field_78531_r.field_71476_x.func_216347_e().func_72436_e(vector3d);
            }
            Vector3d vector3d1 = entity.func_70676_i(1.0f);
            Vector3d vector3d2 = vector3d.func_72441_c(vector3d1.field_72450_a * d0, vector3d1.field_72448_b * d0, vector3d1.field_72449_c * d0);
            float f2 = 1.0f;
            AxisAlignedBB axisalignedbb = entity.func_174813_aQ().func_216361_a(vector3d1.func_186678_a(d0)).func_72314_b(1.0, 1.0, 1.0);
            EntityRayTraceResult entityraytraceresult = ProjectileHelper.func_221273_a((Entity)entity, (Vector3d)vector3d, (Vector3d)vector3d2, (AxisAlignedBB)axisalignedbb, p_215312_0_ -> !p_215312_0_.func_175149_v() && p_215312_0_.func_70067_L(), (double)d1);
            if (entityraytraceresult != null) {
                Entity entity1 = entityraytraceresult.func_216348_a();
                Vector3d vector3d3 = entityraytraceresult.func_216347_e();
                double d2 = vector3d.func_72436_e(vector3d3);
                if (flag && d2 > 9.0) {
                    this.field_78531_r.field_71476_x = BlockRayTraceResult.func_216352_a((Vector3d)vector3d3, (Direction)Direction.func_210769_a((double)vector3d1.field_72450_a, (double)vector3d1.field_72448_b, (double)vector3d1.field_72449_c), (BlockPos)new BlockPos(vector3d3));
                } else if (d2 < d1 || this.field_78531_r.field_71476_x == null) {
                    this.field_78531_r.field_71476_x = entityraytraceresult;
                    if (entity1 instanceof LivingEntity || entity1 instanceof ItemFrameEntity) {
                        this.field_78531_r.field_147125_j = entity1;
                    }
                }
            }
            this.field_78531_r.func_213239_aq().func_76319_b();
        }
    }

    private void func_78477_e() {
        float f2 = 1.0f;
        if (this.field_78531_r.func_175606_aa() instanceof AbstractClientPlayerEntity) {
            AbstractClientPlayerEntity abstractclientplayerentity = (AbstractClientPlayerEntity)this.field_78531_r.func_175606_aa();
            f2 = abstractclientplayerentity.func_175156_o();
        }
        this.field_78506_S = this.field_78507_R;
        this.field_78507_R += (f2 - this.field_78507_R) * 0.5f;
        if (this.field_78507_R > 1.5f) {
            this.field_78507_R = 1.5f;
        }
        if (this.field_78507_R < 0.1f) {
            this.field_78507_R = 0.1f;
        }
    }

    private double func_215311_a(ActiveRenderInfo activeRenderInfoIn, float partialTicks, boolean useFOVSetting) {
        FluidState fluidstate;
        if (this.field_175078_W) {
            return 90.0;
        }
        double d0 = 70.0;
        if (useFOVSetting) {
            d0 = this.field_78531_r.field_71474_y.field_74334_X;
            if (Config.isDynamicFov()) {
                d0 *= (double)MathHelper.func_219799_g((float)partialTicks, (float)this.field_78506_S, (float)this.field_78507_R);
            }
        }
        boolean zoomActive = false;
        if (this.field_78531_r.field_71462_r == null) {
            zoomActive = this.field_78531_r.field_71474_y.ofKeyBindZoom.func_151470_d();
        }
        if (zoomActive) {
            if (!Config.zoomMode) {
                Config.zoomMode = true;
                Config.zoomSmoothCamera = this.field_78531_r.field_71474_y.field_74326_T;
                this.field_78531_r.field_71474_y.field_74326_T = true;
                this.field_78531_r.field_71438_f.func_174979_m();
            }
            if (Config.zoomMode) {
                d0 /= 4.0;
            }
        } else if (Config.zoomMode) {
            Config.zoomMode = false;
            this.field_78531_r.field_71474_y.field_74326_T = Config.zoomSmoothCamera;
            this.field_78531_r.field_71438_f.func_174979_m();
        }
        if (activeRenderInfoIn.func_216773_g() instanceof LivingEntity && ((LivingEntity)activeRenderInfoIn.func_216773_g()).func_233643_dh_()) {
            float f2 = Math.min((float)((LivingEntity)activeRenderInfoIn.func_216773_g()).field_70725_aQ + partialTicks, 20.0f);
            d0 /= (double)((1.0f - 500.0f / (f2 + 500.0f)) * 2.0f + 1.0f);
        }
        if (!(fluidstate = activeRenderInfoIn.func_216771_k()).func_206888_e()) {
            d0 = d0 * 60.0 / 70.0;
        }
        if (Reflector.ForgeHooksClient_getFOVModifier.exists()) {
            return Reflector.callDouble(Reflector.ForgeHooksClient_getFOVModifier, this, activeRenderInfoIn, Float.valueOf(partialTicks), d0);
        }
        return d0;
    }

    private void func_228380_a_(MatrixStack matrixStackIn, float partialTicks) {
        if (this.field_78531_r.func_175606_aa() instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)this.field_78531_r.func_175606_aa();
            float f2 = (float)livingentity.field_70737_aN - partialTicks;
            if (livingentity.func_233643_dh_()) {
                float f1 = Math.min((float)livingentity.field_70725_aQ + partialTicks, 20.0f);
                matrixStackIn.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(40.0f - 8000.0f / (f1 + 200.0f)));
            }
            if (f2 < 0.0f) {
                return;
            }
            f2 /= (float)livingentity.field_70738_aO;
            f2 = MathHelper.func_76126_a((float)(f2 * f2 * f2 * f2 * (float)Math.PI));
            float f22 = livingentity.field_70739_aP;
            matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-f22));
            matrixStackIn.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(-f2 * 14.0f));
            matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(f22));
        }
    }

    private void func_228383_b_(MatrixStack matrixStackIn, float partialTicks) {
        if (this.field_78531_r.func_175606_aa() instanceof PlayerEntity) {
            PlayerEntity playerentity = (PlayerEntity)this.field_78531_r.func_175606_aa();
            float f2 = playerentity.field_70140_Q - playerentity.field_70141_P;
            float f1 = -(playerentity.field_70140_Q + f2 * partialTicks);
            float f22 = MathHelper.func_219799_g((float)partialTicks, (float)playerentity.field_71107_bF, (float)playerentity.field_71109_bG);
            matrixStackIn.func_227861_a_((double)(MathHelper.func_76126_a((float)(f1 * (float)Math.PI)) * f22 * 0.5f), (double)(-Math.abs(MathHelper.func_76134_b((float)(f1 * (float)Math.PI)) * f22)), 0.0);
            matrixStackIn.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(MathHelper.func_76126_a((float)(f1 * (float)Math.PI)) * f22 * 3.0f));
            matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(Math.abs(MathHelper.func_76134_b((float)(f1 * (float)Math.PI - 0.2f)) * f22) * 5.0f));
        }
    }

    private void func_228381_a_(MatrixStack matrixStackIn, ActiveRenderInfo activeRenderInfoIn, float partialTicks) {
        this.renderHand(matrixStackIn, activeRenderInfoIn, partialTicks, true, true, false);
    }

    public void renderHand(MatrixStack matrixStackIn, ActiveRenderInfo activeRenderInfoIn, float partialTicks, boolean renderItem, boolean renderOverlay, boolean renderTranslucent) {
        if (!this.field_175078_W) {
            Shaders.setRenderingFirstPersonHand(true);
            this.func_228379_a_(this.func_228382_a_(activeRenderInfoIn, partialTicks, false));
            MatrixStack.Entry matrixstack$entry = matrixStackIn.func_227866_c_();
            matrixstack$entry.func_227870_a_().func_226591_a_();
            matrixstack$entry.func_227872_b_().func_226119_c_();
            boolean flag = false;
            if (renderItem) {
                matrixStackIn.func_227860_a_();
                this.func_228380_a_(matrixStackIn, partialTicks);
                if (this.field_78531_r.field_71474_y.field_74336_f) {
                    this.func_228383_b_(matrixStackIn, partialTicks);
                }
                boolean bl = flag = this.field_78531_r.func_175606_aa() instanceof LivingEntity && ((LivingEntity)this.field_78531_r.func_175606_aa()).func_70608_bn();
                if (this.field_78531_r.field_71474_y.field_74320_O == 0 && !flag && !this.field_78531_r.field_71474_y.field_74319_N && this.field_78531_r.field_71442_b.func_178889_l() != GameType.SPECTATOR) {
                    this.field_78513_d.func_205109_c();
                    if (Config.isShaders()) {
                        ShadersRender.renderItemFP((FirstPersonRenderer)this.field_78516_c, (float)partialTicks, (MatrixStack)matrixStackIn, (IRenderTypeBuffer.Impl)this.field_228374_i_.func_228487_b_(), (ClientPlayerEntity)this.field_78531_r.field_71439_g, (int)this.field_78531_r.func_175598_ae().func_229085_a_((Entity)this.field_78531_r.field_71439_g, partialTicks), (boolean)renderTranslucent);
                    } else {
                        this.field_78516_c.func_228396_a_(partialTicks, matrixStackIn, this.field_228374_i_.func_228487_b_(), this.field_78531_r.field_71439_g, this.field_78531_r.func_175598_ae().func_229085_a_((Entity)this.field_78531_r.field_71439_g, partialTicks));
                    }
                    this.field_78513_d.func_205108_b();
                }
                matrixStackIn.func_227865_b_();
            }
            Shaders.setRenderingFirstPersonHand(false);
            if (!renderOverlay) {
                return;
            }
            this.field_78513_d.func_205108_b();
            if (this.field_78531_r.field_71474_y.field_74320_O == 0 && !flag) {
                OverlayRenderer.func_228734_a_((Minecraft)this.field_78531_r, (MatrixStack)matrixStackIn);
                this.func_228380_a_(matrixStackIn, partialTicks);
            }
            if (this.field_78531_r.field_71474_y.field_74336_f) {
                this.func_228383_b_(matrixStackIn, partialTicks);
            }
        }
    }

    public void func_228379_a_(Matrix4f matrixIn) {
        RenderSystem.matrixMode((int)5889);
        RenderSystem.loadIdentity();
        RenderSystem.multMatrix((Matrix4f)matrixIn);
        RenderSystem.matrixMode((int)5888);
    }

    public Matrix4f func_228382_a_(ActiveRenderInfo activeRenderInfoIn, float partialTicks, boolean useFovSetting) {
        MatrixStack matrixstack = new MatrixStack();
        matrixstack.func_227866_c_().func_227870_a_().func_226591_a_();
        if (Config.isShaders() && Shaders.isRenderingFirstPersonHand()) {
            Shaders.applyHandDepth((MatrixStack)matrixstack);
        }
        this.clipDistance = this.field_78530_s * 2.0f;
        if (this.clipDistance < 173.0f) {
            this.clipDistance = 173.0f;
        }
        if (this.field_78503_V != 1.0f) {
            matrixstack.func_227861_a_((double)this.field_228376_w_, (double)(-this.field_228377_x_), 0.0);
            matrixstack.func_227862_a_(this.field_78503_V, this.field_78503_V, 1.0f);
        }
        matrixstack.func_227866_c_().func_227870_a_().func_226595_a_(Matrix4f.func_195876_a((double)this.func_215311_a(activeRenderInfoIn, partialTicks, useFovSetting), (float)((float)this.field_78531_r.func_228018_at_().func_198109_k() / (float)this.field_78531_r.func_228018_at_().func_198091_l()), (float)0.05f, (float)this.clipDistance));
        return matrixstack.func_227866_c_().func_227870_a_();
    }

    public static float func_180438_a(LivingEntity livingEntityIn, float entitylivingbaseIn) {
        int i2 = livingEntityIn.func_70660_b(Effects.field_76439_r).func_76459_b();
        return i2 > 200 ? 1.0f : 0.7f + MathHelper.func_76126_a((float)(((float)i2 - entitylivingbaseIn) * (float)Math.PI * 0.2f)) * 0.3f;
    }

    public void func_195458_a(float partialTicks, long nanoTime, boolean renderWorldIn) {
        this.frameInit();
        if (!(this.field_78531_r.func_195544_aj() || !this.field_78531_r.field_71474_y.field_82881_y || this.field_78531_r.field_71474_y.field_85185_A && this.field_78531_r.field_71417_B.func_198031_d())) {
            if (Util.func_211177_b() - this.field_78508_Y > 500L) {
                this.field_78531_r.func_71385_j(false);
            }
        } else {
            this.field_78508_Y = Util.func_211177_b();
        }
        if (!this.field_78531_r.field_71454_w) {
            int i2 = (int)(this.field_78531_r.field_71417_B.func_198024_e() * (double)this.field_78531_r.func_228018_at_().func_198107_o() / (double)this.field_78531_r.func_228018_at_().func_198105_m());
            int j2 = (int)(this.field_78531_r.field_71417_B.func_198026_f() * (double)this.field_78531_r.func_228018_at_().func_198087_p() / (double)this.field_78531_r.func_228018_at_().func_198083_n());
            if (renderWorldIn && this.field_78531_r.field_71441_e != null && !Config.isReloadingResources()) {
                this.field_78531_r.func_213239_aq().func_76320_a("level");
                this.func_228378_a_(partialTicks, nanoTime, new MatrixStack());
                if (this.field_78531_r.func_71356_B() && this.field_184374_E < Util.func_211177_b() - 1000L) {
                    this.field_184374_E = Util.func_211177_b();
                    if (!this.field_78531_r.func_71401_C().func_184106_y()) {
                        this.func_184373_n();
                    }
                }
                this.field_78531_r.field_71438_f.func_174975_c();
                if (this.field_147707_d != null && this.field_175083_ad) {
                    RenderSystem.disableBlend();
                    RenderSystem.disableDepthTest();
                    RenderSystem.disableAlphaTest();
                    RenderSystem.enableTexture();
                    RenderSystem.matrixMode((int)5890);
                    RenderSystem.pushMatrix();
                    RenderSystem.loadIdentity();
                    this.field_147707_d.func_148018_a(partialTicks);
                    RenderSystem.popMatrix();
                    RenderSystem.enableTexture();
                }
                this.field_78531_r.func_147110_a().func_147610_a(true);
            } else {
                RenderSystem.viewport((int)0, (int)0, (int)this.field_78531_r.func_228018_at_().func_198109_k(), (int)this.field_78531_r.func_228018_at_().func_198091_l());
            }
            MainWindow mainwindow = this.field_78531_r.func_228018_at_();
            RenderSystem.clear((int)256, (boolean)Minecraft.field_142025_a);
            RenderSystem.matrixMode((int)5889);
            RenderSystem.loadIdentity();
            RenderSystem.ortho((double)0.0, (double)((double)mainwindow.func_198109_k() / mainwindow.func_198100_s()), (double)((double)mainwindow.func_198091_l() / mainwindow.func_198100_s()), (double)0.0, (double)1000.0, (double)3000.0);
            RenderSystem.matrixMode((int)5888);
            RenderSystem.loadIdentity();
            RenderSystem.translatef((float)0.0f, (float)0.0f, (float)-2000.0f);
            RenderHelper.func_227784_d_();
            MatrixStack matrixstack = new MatrixStack();
            if (this.field_78513_d.isCustom()) {
                this.field_78513_d.setAllowed(false);
            }
            if (renderWorldIn && this.field_78531_r.field_71441_e != null) {
                this.field_78531_r.func_213239_aq().func_219895_b("gui");
                if (!this.field_78531_r.field_71474_y.field_74319_N || this.field_78531_r.field_71462_r != null) {
                    RenderSystem.defaultAlphaFunc();
                    this.func_190563_a(this.field_78531_r.func_228018_at_().func_198107_o(), this.field_78531_r.func_228018_at_().func_198087_p(), partialTicks);
                    this.field_78531_r.field_71456_v.func_238445_a_(matrixstack, partialTicks);
                    if (this.field_78531_r.field_71474_y.ofShowFps && !this.field_78531_r.field_71474_y.field_74330_P) {
                        Config.drawFps((MatrixStack)matrixstack);
                    }
                    if (this.field_78531_r.field_71474_y.field_74330_P) {
                        Lagometer.showLagometer((MatrixStack)matrixstack, (int)((int)this.field_78531_r.func_228018_at_().func_198100_s()));
                    }
                    RenderSystem.clear((int)256, (boolean)Minecraft.field_142025_a);
                }
                this.field_78531_r.func_213239_aq().func_76319_b();
            }
            if (this.guiLoadingVisible != (this.field_78531_r.field_213279_p != null)) {
                if (this.field_78531_r.field_213279_p != null) {
                    this.field_78531_r.func_110434_K().func_147645_c((ResourceLocation)Config.LOCATION_MOJANG_LOGO);
                    if (this.field_78531_r.field_213279_p instanceof ResourceLoadProgressGui) {
                        ResourceLoadProgressGui rlpg = (ResourceLoadProgressGui)this.field_78531_r.field_213279_p;
                        rlpg.update();
                    }
                }
                boolean bl = this.guiLoadingVisible = this.field_78531_r.field_213279_p != null;
            }
            if (this.field_78531_r.field_213279_p != null) {
                try {
                    this.field_78531_r.field_213279_p.func_230430_a_(matrixstack, i2, j2, this.field_78531_r.func_193989_ak());
                }
                catch (Throwable throwable1) {
                    CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable1, (String)"Rendering overlay");
                    CrashReportCategory crashreportcategory = crashreport.func_85058_a("Overlay render details");
                    crashreportcategory.func_189529_a("Overlay name", () -> this.field_78531_r.field_213279_p.getClass().getCanonicalName());
                    throw new ReportedException(crashreport);
                }
            }
            if (this.field_78531_r.field_71462_r != null) {
                try {
                    if (Reflector.ForgeHooksClient_drawScreen.exists()) {
                        Reflector.callVoid(Reflector.ForgeHooksClient_drawScreen, this.field_78531_r.field_71462_r, matrixstack, i2, j2, Float.valueOf(this.field_78531_r.func_193989_ak()));
                    } else {
                        this.field_78531_r.field_71462_r.func_230430_a_(matrixstack, i2, j2, this.field_78531_r.func_193989_ak());
                    }
                }
                catch (Throwable throwable) {
                    CrashReport crashreport1 = CrashReport.func_85055_a((Throwable)throwable, (String)"Rendering screen");
                    CrashReportCategory crashreportcategory1 = crashreport1.func_85058_a("Screen render details");
                    crashreportcategory1.func_189529_a("Screen name", () -> this.field_78531_r.field_71462_r.getClass().getCanonicalName());
                    crashreportcategory1.func_189529_a("Mouse location", () -> String.format(Locale.ROOT, "Scaled: (%d, %d). Absolute: (%f, %f)", i2, j2, this.field_78531_r.field_71417_B.func_198024_e(), this.field_78531_r.field_71417_B.func_198026_f()));
                    crashreportcategory1.func_189529_a("Screen size", () -> String.format(Locale.ROOT, "Scaled: (%d, %d). Absolute: (%d, %d). Scale factor of %f", this.field_78531_r.func_228018_at_().func_198107_o(), this.field_78531_r.func_228018_at_().func_198087_p(), this.field_78531_r.func_228018_at_().func_198109_k(), this.field_78531_r.func_228018_at_().func_198091_l(), this.field_78531_r.func_228018_at_().func_198100_s()));
                    throw new ReportedException(crashreport1);
                }
            }
            this.field_78513_d.setAllowed(true);
        }
        this.frameFinish();
        this.waitForServerThread();
        MemoryMonitor.update();
        Lagometer.updateLagometer();
        if (this.field_78531_r.field_71474_y.ofProfiler) {
            this.field_78531_r.field_71474_y.field_74329_Q = true;
        }
    }

    private void func_184373_n() {
        if (this.field_78531_r.field_71438_f.func_184382_g() > 10 && this.field_78531_r.field_71438_f.func_184384_n() && !this.field_78531_r.func_71401_C().func_184106_y()) {
            NativeImage nativeimage = ScreenShotHelper.func_198052_a((int)this.field_78531_r.func_228018_at_().func_198109_k(), (int)this.field_78531_r.func_228018_at_().func_198091_l(), (Framebuffer)this.field_78531_r.func_147110_a());
            Util.func_240992_g_().execute(() -> {
                int i2 = nativeimage.func_195702_a();
                int j2 = nativeimage.func_195714_b();
                int k2 = 0;
                int l2 = 0;
                if (i2 > j2) {
                    k2 = (i2 - j2) / 2;
                    i2 = j2;
                } else {
                    l2 = (j2 - i2) / 2;
                    j2 = i2;
                }
                try (NativeImage nativeimage1 = new NativeImage(64, 64, false);){
                    nativeimage.func_195708_a(k2, l2, i2, j2, nativeimage1);
                    nativeimage1.func_209271_a(this.field_78531_r.func_71401_C().func_184109_z());
                }
                catch (IOException ioexception) {
                    field_147710_q.warn("Couldn't save auto screenshot", (Throwable)ioexception);
                }
                finally {
                    nativeimage.close();
                }
            });
        }
    }

    private boolean func_175070_n() {
        boolean flag;
        if (!this.field_175073_D) {
            return false;
        }
        Entity entity = this.field_78531_r.func_175606_aa();
        boolean bl = flag = entity instanceof PlayerEntity && !this.field_78531_r.field_71474_y.field_74319_N;
        if (flag && !((PlayerEntity)entity).field_71075_bZ.field_75099_e) {
            ItemStack itemstack = ((LivingEntity)entity).func_184614_ca();
            RayTraceResult raytraceresult = this.field_78531_r.field_71476_x;
            if (raytraceresult != null && raytraceresult.func_216346_c() == RayTraceResult.Type.BLOCK) {
                BlockPos blockpos = ((BlockRayTraceResult)raytraceresult).func_216350_a();
                BlockState blockstate = this.field_78531_r.field_71441_e.func_180495_p(blockpos);
                if (this.field_78531_r.field_71442_b.func_178889_l() == GameType.SPECTATOR) {
                    flag = blockstate.func_215699_b((World)this.field_78531_r.field_71441_e, blockpos) != null;
                } else {
                    CachedBlockInfo cachedblockinfo = new CachedBlockInfo((IWorldReader)this.field_78531_r.field_71441_e, blockpos, false);
                    flag = !itemstack.func_190926_b() && (itemstack.func_206848_a(this.field_78531_r.field_71441_e.func_205772_D(), cachedblockinfo) || itemstack.func_206847_b(this.field_78531_r.field_71441_e.func_205772_D(), cachedblockinfo));
                }
            }
        }
        return flag;
    }

    public void func_228378_a_(float partialTicks, long finishTimeNano, MatrixStack matrixStackIn) {
        float f2;
        this.field_78513_d.func_205106_a(partialTicks);
        if (this.field_78531_r.func_175606_aa() == null) {
            this.field_78531_r.func_175607_a((Entity)this.field_78531_r.field_71439_g);
        }
        this.func_78473_a(partialTicks);
        if (Config.isShaders()) {
            Shaders.beginRender((Minecraft)this.field_78531_r, (ActiveRenderInfo)this.field_215317_L, (float)partialTicks, (long)finishTimeNano);
        }
        this.field_78531_r.func_213239_aq().func_76320_a("center");
        boolean isShaders = Config.isShaders();
        if (isShaders) {
            Shaders.beginRenderPass(partialTicks, finishTimeNano);
        }
        boolean flag = this.func_175070_n();
        this.field_78531_r.func_213239_aq().func_219895_b("camera");
        ActiveRenderInfo activerenderinfo = this.field_215317_L;
        this.field_78530_s = this.field_78531_r.field_71474_y.field_151451_c * 16;
        if (Config.isFogFancy()) {
            this.field_78530_s *= 0.95f;
        }
        if (Config.isFogFast()) {
            this.field_78530_s *= 0.83f;
        }
        MatrixStack matrixstack = new MatrixStack();
        matrixstack.func_227866_c_().func_227870_a_().func_226595_a_(this.func_228382_a_(activerenderinfo, partialTicks, true));
        MatrixStack matrixStackProjection = matrixstack;
        if (Shaders.isEffectsModelView()) {
            matrixstack = matrixStackIn;
        }
        this.func_228380_a_(matrixstack, partialTicks);
        if (this.field_78531_r.field_71474_y.field_74336_f) {
            this.func_228383_b_(matrixstack, partialTicks);
        }
        if ((f2 = MathHelper.func_219799_g((float)partialTicks, (float)this.field_78531_r.field_71439_g.field_71080_cy, (float)this.field_78531_r.field_71439_g.field_71086_bY)) > 0.0f) {
            int i2 = 20;
            if (this.field_78531_r.field_71439_g.func_70644_a(Effects.field_76431_k)) {
                i2 = 7;
            }
            float f1 = 5.0f / (f2 * f2 + 5.0f) - f2 * 0.04f;
            f1 *= f1;
            Vector3f vector3f = new Vector3f(0.0f, MathHelper.field_180189_a / 2.0f, MathHelper.field_180189_a / 2.0f);
            matrixstack.func_227863_a_(vector3f.func_229187_a_(((float)this.field_78529_t + partialTicks) * (float)i2));
            matrixstack.func_227862_a_(1.0f / f1, 1.0f, 1.0f);
            float f22 = -((float)this.field_78529_t + partialTicks) * (float)i2;
            matrixstack.func_227863_a_(vector3f.func_229187_a_(f22));
        }
        if (Shaders.isEffectsModelView()) {
            matrixstack = matrixStackProjection;
        }
        Matrix4f matrix4f = matrixstack.func_227866_c_().func_227870_a_();
        this.func_228379_a_(matrix4f);
        activerenderinfo.func_216772_a((IBlockReader)this.field_78531_r.field_71441_e, (Entity)(this.field_78531_r.func_175606_aa() == null ? this.field_78531_r.field_71439_g : this.field_78531_r.func_175606_aa()), this.field_78531_r.field_71474_y.field_74320_O > 0, this.field_78531_r.field_71474_y.field_74320_O == 2, partialTicks);
        if (Reflector.ForgeHooksClient_onCameraSetup.exists()) {
            Object cameraSetup = Reflector.ForgeHooksClient_onCameraSetup.call(this, activerenderinfo, Float.valueOf(partialTicks));
            float cameraSetupYaw = Reflector.callFloat(cameraSetup, Reflector.EntityViewRenderEvent_CameraSetup_getYaw, new Object[0]);
            float cameraSetupPitch = Reflector.callFloat(cameraSetup, Reflector.EntityViewRenderEvent_CameraSetup_getPitch, new Object[0]);
            float cameraSetupRoll = Reflector.callFloat(cameraSetup, Reflector.EntityViewRenderEvent_CameraSetup_getRoll, new Object[0]);
            activerenderinfo.setAnglesInternal(cameraSetupYaw, cameraSetupPitch);
            matrixStackIn.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(cameraSetupRoll));
        }
        matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(activerenderinfo.func_216777_e()));
        matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(activerenderinfo.func_216778_f() + 180.0f));
        this.field_78531_r.field_71438_f.func_228426_a_(matrixStackIn, partialTicks, finishTimeNano, flag, activerenderinfo, this, this.field_78513_d, matrix4f);
        if (Reflector.ForgeHooksClient_dispatchRenderLast.exists()) {
            this.field_78531_r.func_213239_aq().func_219895_b("forge_render_last");
            Reflector.callVoid(Reflector.ForgeHooksClient_dispatchRenderLast, this.field_78531_r.field_71438_f, matrixStackIn, Float.valueOf(partialTicks), matrix4f, finishTimeNano);
        }
        this.field_78531_r.func_213239_aq().func_219895_b("hand");
        if (this.field_175074_C && !Shaders.isShadowPass) {
            if (isShaders) {
                ShadersRender.renderHand1((GameRenderer)this, (MatrixStack)matrixStackIn, (ActiveRenderInfo)activerenderinfo, (float)partialTicks);
                Shaders.renderCompositeFinal();
            }
            RenderSystem.clear((int)256, (boolean)Minecraft.field_142025_a);
            if (isShaders) {
                ShadersRender.renderFPOverlay((GameRenderer)this, (MatrixStack)matrixStackIn, (ActiveRenderInfo)activerenderinfo, (float)partialTicks);
            } else {
                this.func_228381_a_(matrixStackIn, activerenderinfo, partialTicks);
            }
        }
        if (isShaders) {
            Shaders.endRender();
        }
        this.field_78531_r.func_213239_aq().func_76319_b();
    }

    public void func_190564_k() {
        this.field_190566_ab = null;
        this.field_147709_v.func_148249_a();
        this.field_215317_L.func_216781_o();
    }

    public MapItemRenderer func_147701_i() {
        return this.field_147709_v;
    }

    private void waitForServerThread() {
        this.serverWaitTimeCurrent = 0;
        if (!Config.isSmoothWorld() || !Config.isSingleProcessor()) {
            this.lastServerTime = 0L;
            this.lastServerTicks = 0;
            return;
        }
        if (!this.field_78531_r.func_71387_A()) {
            return;
        }
        IntegratedServer srv = this.field_78531_r.func_71401_C();
        if (srv == null) {
            return;
        }
        boolean paused = this.field_78531_r.func_147113_T();
        if (paused || this.field_78531_r.field_71462_r instanceof DownloadTerrainScreen) {
            if (this.field_78531_r.field_71462_r instanceof DownloadTerrainScreen) {
                Config.sleep(20L);
            }
            this.lastServerTime = 0L;
            this.lastServerTicks = 0;
            return;
        }
        if (this.serverWaitTime > 0) {
            Lagometer.timerServer.start();
            Config.sleep(this.serverWaitTime);
            Lagometer.timerServer.end();
            this.serverWaitTimeCurrent = this.serverWaitTime;
        }
        long timeNow = System.nanoTime() / 1000000L;
        if (this.lastServerTime == 0L || this.lastServerTicks == 0) {
            this.lastServerTime = timeNow;
            this.lastServerTicks = srv.func_71259_af();
            this.avgServerTickDiff = 1.0f;
            this.avgServerTimeDiff = 50.0f;
            return;
        }
        long timeDiff = timeNow - this.lastServerTime;
        if (timeDiff < 0L) {
            this.lastServerTime = timeNow;
            timeDiff = 0L;
        }
        if (timeDiff < 50L) {
            return;
        }
        this.lastServerTime = timeNow;
        int ticks = srv.func_71259_af();
        int tickDiff = ticks - this.lastServerTicks;
        if (tickDiff < 0) {
            this.lastServerTicks = ticks;
            tickDiff = 0;
        }
        if (tickDiff < 1 && this.serverWaitTime < 100) {
            this.serverWaitTime += 2;
        }
        if (tickDiff > 1 && this.serverWaitTime > 0) {
            --this.serverWaitTime;
        }
        this.lastServerTicks = ticks;
    }

    private void frameInit() {
        ClientWorld world;
        Config.frameStart();
        GlErrors.frameStart();
        if (!this.initialized) {
            ReflectorResolver.resolve();
            if (Config.getBitsOs() == 64 && Config.getBitsJre() == 32) {
                Config.setNotify64BitJava(true);
            }
            this.initialized = true;
        }
        if ((world = this.field_78531_r.field_71441_e) != null) {
            if (Config.getNewRelease() != null) {
                String userEdition = "HD_U".replace("HD_U", "HD Ultra").replace("L", "Light");
                String fullNewVer = userEdition + " " + Config.getNewRelease();
                StringTextComponent msg = new StringTextComponent(I18n.func_135052_a((String)"of.message.newVersion", (Object[])new Object[]{"\u00a7n" + fullNewVer + "\u00a7r"}));
                msg.func_230530_a_(Style.field_240709_b_.func_240715_a_(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://optifine.net/downloads")));
                this.field_78531_r.field_71456_v.func_146158_b().func_146227_a((ITextComponent)msg);
                Config.setNewRelease(null);
            }
            if (Config.isNotify64BitJava()) {
                Config.setNotify64BitJava(false);
                StringTextComponent msg = new StringTextComponent(I18n.func_135052_a((String)"of.message.java64Bit", (Object[])new Object[0]));
                this.field_78531_r.field_71456_v.func_146158_b().func_146227_a((ITextComponent)msg);
            }
        }
        if (this.field_78531_r.field_71462_r instanceof MainMenuScreen) {
            this.updateMainMenu((MainMenuScreen)this.field_78531_r.field_71462_r);
        }
        if (this.updatedWorld != world) {
            RandomEntities.worldChanged((World)this.updatedWorld, (World)world);
            Config.updateThreadPriorities();
            this.lastServerTime = 0L;
            this.lastServerTicks = 0;
            this.updatedWorld = world;
        }
        if (!this.setFxaaShader(Shaders.configAntialiasingLevel)) {
            Shaders.configAntialiasingLevel = 0;
        }
        if (this.field_78531_r.field_71462_r != null && this.field_78531_r.field_71462_r.getClass() == ChatScreen.class) {
            this.field_78531_r.func_147108_a((Screen)new GuiChatOF((ChatScreen)this.field_78531_r.field_71462_r));
        }
    }

    private void frameFinish() {
        int err;
        if (this.field_78531_r.field_71441_e != null && Config.isShowGlErrors() && TimedEvent.isActive("CheckGlErrorFrameFinish", 10000L) && (err = GlStateManager.func_227629_Q_()) != 0 && GlErrors.isEnabled(err)) {
            String text = Config.getGlErrorString(err);
            StringTextComponent msg = new StringTextComponent(I18n.func_135052_a((String)"of.message.openglError", (Object[])new Object[]{err, text}));
            this.field_78531_r.field_71456_v.func_146158_b().func_146227_a((ITextComponent)msg);
        }
    }

    private void updateMainMenu(MainMenuScreen mainGui) {
        try {
            String str = null;
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(new Date());
            int day = calendar.get(5);
            int month = calendar.get(2) + 1;
            if (day == 8 && month == 4) {
                str = "Happy birthday, OptiFine!";
            }
            if (day == 14 && month == 8) {
                str = "Happy birthday, sp614x!";
            }
            if (str == null) {
                return;
            }
            Reflector.setFieldValue(mainGui, Reflector.GuiMainMenu_splashText, str);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public boolean setFxaaShader(int fxaaLevel) {
        if (!GLX.isUsingFBOs()) {
            return false;
        }
        if (this.field_147707_d != null && this.field_147707_d != this.fxaaShaders[2] && this.field_147707_d != this.fxaaShaders[4]) {
            return true;
        }
        if (fxaaLevel == 2 || fxaaLevel == 4) {
            if (this.field_147707_d != null && this.field_147707_d == this.fxaaShaders[fxaaLevel]) {
                return true;
            }
            if (this.field_78531_r.field_71441_e == null) {
                return true;
            }
            this.func_175069_a(new ResourceLocation("shaders/post/fxaa_of_" + fxaaLevel + "x.json"));
            this.fxaaShaders[fxaaLevel] = this.field_147707_d;
            return this.field_175083_ad;
        }
        if (this.field_147707_d == null) {
            return true;
        }
        this.field_147707_d.close();
        this.field_147707_d = null;
        return true;
    }

    public IResourceType getResourceType() {
        return VanillaResourceType.SHADERS;
    }

    public void func_190565_a(ItemStack stack) {
        this.field_190566_ab = stack;
        this.field_190567_ac = 40;
        this.field_190568_ad = this.field_78537_ab.nextFloat() * 2.0f - 1.0f;
        this.field_190569_ae = this.field_78537_ab.nextFloat() * 2.0f - 1.0f;
    }

    private void func_190563_a(int widthsp, int heightScaled, float partialTicks) {
        if (this.field_190566_ab != null && this.field_190567_ac > 0) {
            int i2 = 40 - this.field_190567_ac;
            float f2 = ((float)i2 + partialTicks) / 40.0f;
            float f1 = f2 * f2;
            float f22 = f2 * f1;
            float f3 = 10.25f * f22 * f1 - 24.95f * f1 * f1 + 25.5f * f22 - 13.8f * f1 + 4.0f * f2;
            float f4 = f3 * (float)Math.PI;
            float f5 = this.field_190568_ad * (float)(widthsp / 4);
            float f6 = this.field_190569_ae * (float)(heightScaled / 4);
            RenderSystem.enableAlphaTest();
            RenderSystem.pushMatrix();
            RenderSystem.pushLightingAttributes();
            RenderSystem.enableDepthTest();
            RenderSystem.disableCull();
            MatrixStack matrixstack = new MatrixStack();
            matrixstack.func_227860_a_();
            matrixstack.func_227861_a_((double)((float)(widthsp / 2) + f5 * MathHelper.func_76135_e((float)MathHelper.func_76126_a((float)(f4 * 2.0f)))), (double)((float)(heightScaled / 2) + f6 * MathHelper.func_76135_e((float)MathHelper.func_76126_a((float)(f4 * 2.0f)))), -50.0);
            float f7 = 50.0f + 175.0f * MathHelper.func_76126_a((float)f4);
            matrixstack.func_227862_a_(f7, -f7, f7);
            matrixstack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(900.0f * MathHelper.func_76135_e((float)MathHelper.func_76126_a((float)f4))));
            matrixstack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(6.0f * MathHelper.func_76134_b((float)(f2 * 8.0f))));
            matrixstack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(6.0f * MathHelper.func_76134_b((float)(f2 * 8.0f))));
            IRenderTypeBuffer.Impl irendertypebuffer$impl = this.field_228374_i_.func_228487_b_();
            this.field_78531_r.func_175599_af().func_229110_a_(this.field_190566_ab, ItemCameraTransforms.TransformType.FIXED, 0xF000F0, OverlayTexture.field_229196_a_, matrixstack, (IRenderTypeBuffer)irendertypebuffer$impl);
            matrixstack.func_227865_b_();
            irendertypebuffer$impl.func_228461_a_();
            RenderSystem.popAttributes();
            RenderSystem.popMatrix();
            RenderSystem.enableCull();
            RenderSystem.disableDepthTest();
        }
    }

    public float func_205002_d(float partialTicks) {
        return MathHelper.func_219799_g((float)partialTicks, (float)this.field_82832_V, (float)this.field_82831_U);
    }

    public float func_205001_m() {
        return this.field_78530_s;
    }

    public ActiveRenderInfo func_215316_n() {
        return this.field_215317_L;
    }

    public LightTexture func_228384_l_() {
        return this.field_78513_d;
    }

    public OverlayTexture func_228385_m_() {
        return this.field_228375_t_;
    }
}

