/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.chunk.ChunkRenderDispatcher;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.optifine.Config;
import net.optifine.render.VboRegion;

public class ViewFrustum {
    protected final WorldRenderer field_178169_a;
    protected final World field_178167_b;
    protected int field_178168_c;
    protected int field_178165_d;
    protected int field_178166_e;
    public ChunkRenderDispatcher.ChunkRender[] field_178164_f;
    private Map<ChunkPos, VboRegion[]> mapVboRegions = new HashMap();

    public ViewFrustum(ChunkRenderDispatcher renderDispatcherIn, World worldIn, int countChunksIn, WorldRenderer renderGlobalIn) {
        this.field_178169_a = renderGlobalIn;
        this.field_178167_b = worldIn;
        this.func_178159_a(countChunksIn);
        this.func_228789_a_(renderDispatcherIn);
    }

    protected void func_228789_a_(ChunkRenderDispatcher renderChunkFactory) {
        int l2;
        int i2 = this.field_178165_d * this.field_178168_c * this.field_178166_e;
        this.field_178164_f = new ChunkRenderDispatcher.ChunkRender[i2];
        for (int j2 = 0; j2 < this.field_178165_d; ++j2) {
            for (int k2 = 0; k2 < this.field_178168_c; ++k2) {
                for (l2 = 0; l2 < this.field_178166_e; ++l2) {
                    int i1 = this.func_212478_a(j2, k2, l2);
                    this.field_178164_f[i1] = new ChunkRenderDispatcher.ChunkRender(renderChunkFactory);
                    this.field_178164_f[i1].func_189562_a(j2 * 16, k2 * 16, l2 * 16);
                    if (!Config.isVbo() || !Config.isRenderRegions()) continue;
                    this.updateVboRegion(this.field_178164_f[i1]);
                }
            }
        }
        for (int k3 = 0; k3 < this.field_178164_f.length; ++k3) {
            ChunkRenderDispatcher.ChunkRender renderChunk = this.field_178164_f[k3];
            for (l2 = 0; l2 < Direction.field_199792_n.length; ++l2) {
                Direction facing = Direction.field_199792_n[l2];
                BlockPos posOffset16 = renderChunk.func_181701_a(facing);
                ChunkRenderDispatcher.ChunkRender neighbour = this.func_178161_a(posOffset16);
                renderChunk.setRenderChunkNeighbour(facing, neighbour);
            }
        }
    }

    public void func_178160_a() {
        for (ChunkRenderDispatcher.ChunkRender chunkrenderdispatcher$chunkrender : this.field_178164_f) {
            chunkrenderdispatcher$chunkrender.func_178566_a();
        }
        this.deleteVboRegions();
    }

    private int func_212478_a(int x2, int y, int z) {
        return (z * this.field_178168_c + y) * this.field_178165_d + x2;
    }

    protected void func_178159_a(int renderDistanceChunks) {
        int i2;
        this.field_178165_d = i2 = renderDistanceChunks * 2 + 1;
        this.field_178168_c = 16;
        this.field_178166_e = i2;
    }

    public void func_178163_a(double viewEntityX, double viewEntityZ) {
        int i2 = MathHelper.func_76128_c((double)viewEntityX);
        int j2 = MathHelper.func_76128_c((double)viewEntityZ);
        for (int k2 = 0; k2 < this.field_178165_d; ++k2) {
            int l2 = this.field_178165_d * 16;
            int i1 = i2 - 8 - l2 / 2;
            int j1 = i1 + Math.floorMod(k2 * 16 - i1, l2);
            for (int k1 = 0; k1 < this.field_178166_e; ++k1) {
                int l1 = this.field_178166_e * 16;
                int i22 = j2 - 8 - l1 / 2;
                int j22 = i22 + Math.floorMod(k1 * 16 - i22, l1);
                for (int k22 = 0; k22 < this.field_178168_c; ++k22) {
                    int l22 = k22 * 16;
                    ChunkRenderDispatcher.ChunkRender chunkrenderdispatcher$chunkrender = this.field_178164_f[this.func_212478_a(k2, k22, k1)];
                    chunkrenderdispatcher$chunkrender.func_189562_a(j1, l22, j22);
                }
            }
        }
    }

    public void func_217628_a(int sectionX, int sectionY, int sectionZ, boolean rerenderOnMainThread) {
        int i2 = Math.floorMod(sectionX, this.field_178165_d);
        int j2 = Math.floorMod(sectionY, this.field_178168_c);
        int k2 = Math.floorMod(sectionZ, this.field_178166_e);
        ChunkRenderDispatcher.ChunkRender chunkrenderdispatcher$chunkrender = this.field_178164_f[this.func_212478_a(i2, j2, k2)];
        chunkrenderdispatcher$chunkrender.func_178575_a(rerenderOnMainThread);
    }

    @Nullable
    public ChunkRenderDispatcher.ChunkRender func_178161_a(BlockPos pos) {
        int i2 = pos.func_177958_n() >> 4;
        int j2 = pos.func_177956_o() >> 4;
        int k2 = pos.func_177952_p() >> 4;
        if (j2 >= 0 && j2 < this.field_178168_c) {
            i2 = MathHelper.func_180184_b((int)i2, (int)this.field_178165_d);
            k2 = MathHelper.func_180184_b((int)k2, (int)this.field_178166_e);
            return this.field_178164_f[this.func_212478_a(i2, j2, k2)];
        }
        return null;
    }

    private void updateVboRegion(ChunkRenderDispatcher.ChunkRender renderChunk) {
        int ix;
        BlockPos pos = renderChunk.func_178568_j();
        int rx = pos.func_177958_n() >> 8 << 8;
        int rz = pos.func_177952_p() >> 8 << 8;
        ChunkPos cp = new ChunkPos(rx, rz);
        RenderType[] layers = RenderType.CHUNK_RENDER_TYPES;
        VboRegion[] regions = (VboRegion[])this.mapVboRegions.get(cp);
        if (regions == null) {
            regions = new VboRegion[layers.length];
            for (ix = 0; ix < layers.length; ++ix) {
                regions[ix] = new VboRegion(layers[ix]);
            }
            this.mapVboRegions.put(cp, regions);
        }
        for (ix = 0; ix < layers.length; ++ix) {
            RenderType layer = layers[ix];
            VboRegion vr = regions[ix];
            if (vr == null) continue;
            renderChunk.func_228924_a_(layer).setVboRegion(vr);
        }
    }

    public void deleteVboRegions() {
        Set keys = this.mapVboRegions.keySet();
        for (ChunkPos cp : keys) {
            VboRegion[] vboRegions = (VboRegion[])this.mapVboRegions.get(cp);
            for (int i2 = 0; i2 < vboRegions.length; ++i2) {
                VboRegion vboRegion = vboRegions[i2];
                if (vboRegion != null) {
                    vboRegion.deleteGlBuffers();
                }
                vboRegions[i2] = null;
            }
        }
        this.mapVboRegions.clear();
    }
}

