/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.culling.ClippingHelper;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.world.LightType;
import net.optifine.entity.model.IEntityRenderer;
import net.optifine.reflect.Reflector;
import net.optifine.reflect.ReflectorForge;
import net.optifine.util.Either;

public abstract class EntityRenderer<T extends Entity>
implements IEntityRenderer {
    protected final EntityRendererManager field_76990_c;
    public float field_76989_e;
    protected float field_76987_f = 1.0f;
    private EntityType entityType = null;
    private ResourceLocation locationTextureCustom = null;

    protected EntityRenderer(EntityRendererManager renderManager) {
        this.field_76990_c = renderManager;
    }

    public final int func_229100_c_(T entityIn, float partialTicks) {
        BlockPos blockpos = new BlockPos(entityIn.func_174824_e(partialTicks));
        return LightTexture.func_228451_a_((int)this.func_225624_a_(entityIn, blockpos), (int)this.func_239381_b_(entityIn, blockpos));
    }

    protected int func_239381_b_(T entityIn, BlockPos blockPosIn) {
        return ((Entity)entityIn).field_70170_p.func_226658_a_(LightType.SKY, blockPosIn);
    }

    protected int func_225624_a_(T entityIn, BlockPos partialTicks) {
        return entityIn.func_70027_ad() ? 15 : ((Entity)entityIn).field_70170_p.func_226658_a_(LightType.BLOCK, partialTicks);
    }

    public boolean func_225626_a_(T livingEntityIn, ClippingHelper camera, double camX, double camY, double camZ) {
        if (!livingEntityIn.func_145770_h(camX, camY, camZ)) {
            return false;
        }
        if (((Entity)livingEntityIn).field_70158_ak) {
            return true;
        }
        AxisAlignedBB axisalignedbb = livingEntityIn.func_184177_bl().func_186662_g(0.5);
        if (axisalignedbb.func_181656_b() || axisalignedbb.func_72320_b() == 0.0) {
            axisalignedbb = new AxisAlignedBB(livingEntityIn.func_226277_ct_() - 2.0, livingEntityIn.func_226278_cu_() - 2.0, livingEntityIn.func_226281_cx_() - 2.0, livingEntityIn.func_226277_ct_() + 2.0, livingEntityIn.func_226278_cu_() + 2.0, livingEntityIn.func_226281_cx_() + 2.0);
        }
        return camera.func_228957_a_(axisalignedbb);
    }

    public Vector3d func_225627_b_(T entityIn, float partialTicks) {
        return Vector3d.field_186680_a;
    }

    public void func_225623_a_(T entityIn, float entityYaw, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        if (Reflector.RenderNameplateEvent_Constructor.exists()) {
            Object renderNameplateEvent = Reflector.newInstance(Reflector.RenderNameplateEvent_Constructor, entityIn, entityIn.func_145748_c_(), this, matrixStackIn, bufferIn, packedLightIn);
            Reflector.postForgeBusEvent(renderNameplateEvent);
            Object result = Reflector.call(renderNameplateEvent, Reflector.Event_getResult, new Object[0]);
            if (result != ReflectorForge.EVENT_RESULT_DENY && (result == ReflectorForge.EVENT_RESULT_ALLOW || this.func_177070_b(entityIn))) {
                ITextComponent content = (ITextComponent)Reflector.call(renderNameplateEvent, Reflector.RenderNameplateEvent_getContent, new Object[0]);
                this.func_225629_a_(entityIn, content, matrixStackIn, bufferIn, packedLightIn);
            }
            return;
        }
        if (this.func_177070_b(entityIn)) {
            this.func_225629_a_(entityIn, entityIn.func_145748_c_(), matrixStackIn, bufferIn, packedLightIn);
        }
    }

    protected boolean func_177070_b(T entity) {
        return entity.func_94059_bO() && entity.func_145818_k_();
    }

    public abstract ResourceLocation func_110775_a(T var1);

    public FontRenderer func_76983_a() {
        return this.field_76990_c.func_78716_a();
    }

    protected void func_225629_a_(T entityIn, ITextComponent displayNameIn, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        double d0 = this.field_76990_c.func_229099_b_(entityIn);
        if (!(d0 > 4096.0)) {
            boolean flag = !entityIn.func_226273_bm_();
            float f2 = entityIn.func_213302_cg() + 0.5f;
            int i2 = "deadmau5".equals(displayNameIn.getString()) ? -10 : 0;
            matrixStackIn.func_227860_a_();
            matrixStackIn.func_227861_a_(0.0, (double)f2, 0.0);
            matrixStackIn.func_227863_a_(this.field_76990_c.func_229098_b_());
            matrixStackIn.func_227862_a_(-0.025f, -0.025f, 0.025f);
            Matrix4f matrix4f = matrixStackIn.func_227866_c_().func_227870_a_();
            float f1 = Minecraft.func_71410_x().field_71474_y.func_216840_a(0.25f);
            int j2 = (int)(f1 * 255.0f) << 24;
            FontRenderer fontrenderer = this.func_76983_a();
            float f22 = -fontrenderer.func_238414_a_((ITextProperties)displayNameIn) / 2;
            fontrenderer.func_238416_a_((ITextProperties)displayNameIn, f22, (float)i2, 0x20FFFFFF, false, matrix4f, bufferIn, flag, j2, packedLightIn);
            if (flag) {
                fontrenderer.func_238416_a_((ITextProperties)displayNameIn, f22, (float)i2, -1, false, matrix4f, bufferIn, false, 0, packedLightIn);
            }
            matrixStackIn.func_227865_b_();
        }
    }

    public EntityRendererManager func_177068_d() {
        return this.field_76990_c;
    }

    public Either<EntityType, TileEntityType> getType() {
        if (this.entityType == null) {
            return null;
        }
        return Either.makeLeft(this.entityType);
    }

    public void setType(Either<EntityType, TileEntityType> type) {
        this.entityType = type.getLeft().get();
    }

    public ResourceLocation getLocationTextureCustom() {
        return this.locationTextureCustom;
    }

    public void setLocationTextureCustom(ResourceLocation locationTextureCustom) {
        this.locationTextureCustom = locationTextureCustom;
    }
}

