/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity.layers;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.MooshroomRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.CowModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.entity.passive.MooshroomEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3f;
import net.optifine.Config;

public class MooshroomMushroomLayer<T extends MooshroomEntity>
extends LayerRenderer<T, CowModel<T>> {
    private ModelRenderer modelRendererMushroom;
    private static final ResourceLocation LOCATION_MUSHROOM_RED = new ResourceLocation("textures/entity/cow/red_mushroom.png");
    private static final ResourceLocation LOCATION_MUSHROOM_BROWN = new ResourceLocation("textures/entity/cow/brown_mushroom.png");
    private static boolean hasTextureMushroomRed = false;
    private static boolean hasTextureMushroomBrown = false;

    public MooshroomMushroomLayer(IEntityRenderer<T, CowModel<T>> rendererIn) {
        super(rendererIn);
        MooshroomRenderer mooshroomRenderer = (MooshroomRenderer)rendererIn;
        this.modelRendererMushroom = new ModelRenderer((Model)mooshroomRenderer.func_217764_d());
        this.modelRendererMushroom.func_78787_b(16, 16);
        this.modelRendererMushroom.field_78800_c = -6.0f;
        this.modelRendererMushroom.field_78798_e = -8.0f;
        this.modelRendererMushroom.field_78796_g = MathHelper.PI / 4.0f;
        int[][] faceUvs = new int[6][];
        faceUvs[2] = new int[]{16, 16, 0, 0};
        faceUvs[3] = new int[]{16, 16, 0, 0};
        this.modelRendererMushroom.addBox((int[][])faceUvs, 0.0f, 0.0f, 10.0f, 20.0f, 16.0f, 0.0f, 0.0f);
        int[][] faceUvs2 = new int[6][];
        faceUvs2[4] = new int[]{16, 16, 0, 0};
        faceUvs2[5] = new int[]{16, 16, 0, 0};
        this.modelRendererMushroom.addBox((int[][])faceUvs2, 10.0f, 0.0f, 0.0f, 0.0f, 16.0f, 20.0f, 0.0f);
    }

    public void func_225628_a_(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, T entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (!entitylivingbaseIn.func_70631_g_() && !entitylivingbaseIn.func_82150_aj()) {
            BlockRendererDispatcher blockrendererdispatcher = Minecraft.func_71410_x().func_175602_ab();
            BlockState blockstate = entitylivingbaseIn.func_213444_dV().func_221093_a();
            ResourceLocation locMushroom = this.getCustomMushroom(blockstate);
            IVertexBuilder bufferMushroom = null;
            if (locMushroom != null) {
                bufferMushroom = bufferIn.getBuffer(RenderType.func_228640_c_((ResourceLocation)locMushroom));
            }
            int i2 = LivingRenderer.func_229117_c_(entitylivingbaseIn, (float)0.0f);
            matrixStackIn.func_227860_a_();
            matrixStackIn.func_227861_a_((double)0.2f, (double)-0.35f, 0.5);
            matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-48.0f));
            matrixStackIn.func_227862_a_(-1.0f, -1.0f, 1.0f);
            matrixStackIn.func_227861_a_(-0.5, -0.5, -0.5);
            if (locMushroom != null) {
                this.modelRendererMushroom.func_228308_a_(matrixStackIn, bufferMushroom, packedLightIn, i2);
            } else {
                blockrendererdispatcher.func_228791_a_(blockstate, matrixStackIn, bufferIn, packedLightIn, i2);
            }
            matrixStackIn.func_227865_b_();
            matrixStackIn.func_227860_a_();
            matrixStackIn.func_227861_a_((double)0.2f, (double)-0.35f, 0.5);
            matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(42.0f));
            matrixStackIn.func_227861_a_((double)0.1f, 0.0, (double)-0.6f);
            matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-48.0f));
            matrixStackIn.func_227862_a_(-1.0f, -1.0f, 1.0f);
            matrixStackIn.func_227861_a_(-0.5, -0.5, -0.5);
            if (locMushroom != null) {
                this.modelRendererMushroom.func_228308_a_(matrixStackIn, bufferMushroom, packedLightIn, i2);
            } else {
                blockrendererdispatcher.func_228791_a_(blockstate, matrixStackIn, bufferIn, packedLightIn, i2);
            }
            matrixStackIn.func_227865_b_();
            matrixStackIn.func_227860_a_();
            ((CowModel)this.func_215332_c()).func_205063_a().func_228307_a_(matrixStackIn);
            matrixStackIn.func_227861_a_(0.0, (double)-0.7f, (double)-0.2f);
            matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-78.0f));
            matrixStackIn.func_227862_a_(-1.0f, -1.0f, 1.0f);
            matrixStackIn.func_227861_a_(-0.5, -0.5, -0.5);
            if (locMushroom != null) {
                this.modelRendererMushroom.func_228308_a_(matrixStackIn, bufferMushroom, packedLightIn, i2);
            } else {
                blockrendererdispatcher.func_228791_a_(blockstate, matrixStackIn, bufferIn, packedLightIn, i2);
            }
            matrixStackIn.func_227865_b_();
        }
    }

    private ResourceLocation getCustomMushroom(BlockState iblockstate) {
        Block block = iblockstate.func_177230_c();
        if (block == Blocks.field_150337_Q && hasTextureMushroomRed) {
            return LOCATION_MUSHROOM_RED;
        }
        if (block == Blocks.field_150338_P && hasTextureMushroomBrown) {
            return LOCATION_MUSHROOM_BROWN;
        }
        return null;
    }

    public static void update() {
        hasTextureMushroomRed = Config.hasResource((ResourceLocation)LOCATION_MUSHROOM_RED);
        hasTextureMushroomBrown = Config.hasResource((ResourceLocation)LOCATION_MUSHROOM_BROWN);
    }
}

