/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.texture;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import java.awt.Dimension;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.StitcherException;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.ITickable;
import net.minecraft.client.renderer.texture.MissingTextureSprite;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.texture.PngSizeInfo;
import net.minecraft.client.renderer.texture.Stitcher;
import net.minecraft.client.renderer.texture.Texture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.data.AnimationMetadataSection;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.data.IMetadataSectionSerializer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.MathHelper;
import net.optifine.Config;
import net.optifine.EmissiveTextures;
import net.optifine.SmartAnimations;
import net.optifine.reflect.Reflector;
import net.optifine.shaders.Shaders;
import net.optifine.shaders.ShadersTex;
import net.optifine.util.CounterInt;
import net.optifine.util.TextureUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

/*
 * Exception performing whole class analysis ignored.
 */
public class AtlasTexture
extends Texture
implements ITickable {
    private static final Logger field_147635_d = LogManager.getLogger();
    @Deprecated
    public static final ResourceLocation field_110575_b = PlayerContainer.field_226615_c_;
    @Deprecated
    public static final ResourceLocation field_215262_g = new ResourceLocation("textures/atlas/particles.png");
    private final List<TextureAtlasSprite> field_94258_i = Lists.newArrayList();
    private final Set<ResourceLocation> field_195427_i = Sets.newHashSet();
    private final Map<ResourceLocation, TextureAtlasSprite> field_94252_e = Maps.newHashMap();
    private final ResourceLocation field_229214_j_;
    private final int field_215265_o;
    private Map<ResourceLocation, TextureAtlasSprite> mapRegisteredSprites = new LinkedHashMap();
    private Map<ResourceLocation, TextureAtlasSprite> mapMissingSprites = new LinkedHashMap();
    private TextureAtlasSprite[] iconGrid = null;
    private int iconGridSize = -1;
    private int iconGridCountX = -1;
    private int iconGridCountY = -1;
    private double iconGridSizeU = -1.0;
    private double iconGridSizeV = -1.0;
    private CounterInt counterIndexInMap = new CounterInt(0);
    public int atlasWidth = 0;
    public int atlasHeight = 0;
    private int countAnimationsActive;
    private int frameCountAnimations;
    private boolean terrain;
    private boolean shaders;
    private boolean multiTexture;

    public AtlasTexture(ResourceLocation textureLocationIn) {
        this.field_229214_j_ = textureLocationIn;
        this.field_215265_o = RenderSystem.maxSupportedTextureSize();
        this.terrain = textureLocationIn.equals((Object)field_110575_b);
        this.shaders = Config.isShaders();
        this.multiTexture = Config.isMultiTexture();
        if (this.terrain) {
            Config.setTextureMap((AtlasTexture)this);
        }
    }

    public void func_195413_a(IResourceManager manager) throws IOException {
    }

    public void func_215260_a(SheetData sheetDataIn) {
        List listSprites;
        this.field_195427_i.clear();
        this.field_195427_i.addAll(sheetDataIn.field_217805_a);
        field_147635_d.info("Created: {}x{}x{} {}-atlas", (Object)sheetDataIn.field_217806_b, (Object)sheetDataIn.field_217807_c, (Object)sheetDataIn.field_229224_d_, (Object)this.field_229214_j_);
        TextureUtil.func_225681_a_((int)this.func_110552_b(), (int)sheetDataIn.field_229224_d_, (int)sheetDataIn.field_217806_b, (int)sheetDataIn.field_217807_c);
        this.atlasWidth = sheetDataIn.field_217806_b;
        this.atlasHeight = sheetDataIn.field_217807_c;
        if (this.shaders) {
            ShadersTex.allocateTextureMapNS((int)sheetDataIn.field_229224_d_, (int)sheetDataIn.field_217806_b, (int)sheetDataIn.field_217807_c, (AtlasTexture)this);
        }
        this.func_195419_g();
        for (TextureAtlasSprite textureatlassprite : sheetDataIn.field_217808_d) {
            this.field_94252_e.put(textureatlassprite.func_195668_m(), textureatlassprite);
            try {
                textureatlassprite.func_195663_q();
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Stitching texture atlas");
                CrashReportCategory crashreportcategory = crashreport.func_85058_a("Texture being stitched together");
                crashreportcategory.func_71507_a("Atlas path", (Object)this.field_229214_j_);
                crashreportcategory.func_71507_a("Sprite", (Object)textureatlassprite);
                throw new ReportedException(crashreport);
            }
            if (!textureatlassprite.func_130098_m()) continue;
            textureatlassprite.setAnimationIndex(this.field_94258_i.size());
            this.field_94258_i.add(textureatlassprite);
        }
        TextureUtils.refreshCustomSprites((AtlasTexture)this);
        Config.log("Animated sprites: " + this.field_94258_i.size());
        if (Config.isMultiTexture()) {
            listSprites = sheetDataIn.field_217808_d;
            for (TextureAtlasSprite tas : listSprites) {
                TextureAtlasSprite ss = tas.spriteSingle;
                if (ss == null) continue;
                ss.setAnimationIndex(tas.getAnimationIndex());
                tas.bindSpriteTexture();
                try {
                    ss.func_195663_q();
                }
                catch (Exception e2) {
                    Config.dbg("Error uploading sprite single: " + ss + ", parent: " + tas);
                    e2.printStackTrace();
                }
            }
            GlStateManager.func_227760_t_((int)this.func_110552_b());
        }
        if (Config.isShaders()) {
            listSprites = sheetDataIn.field_217808_d;
            if (Shaders.configNormalMap) {
                GlStateManager.func_227760_t_((int)this.getMultiTexID().norm);
                for (TextureAtlasSprite tas : listSprites) {
                    TextureAtlasSprite spriteNormal = tas.spriteNormal;
                    if (spriteNormal == null) continue;
                    spriteNormal.func_195663_q();
                }
            }
            if (Shaders.configSpecularMap) {
                GlStateManager.func_227760_t_((int)this.getMultiTexID().spec);
                for (TextureAtlasSprite tas : listSprites) {
                    TextureAtlasSprite spriteSpecular = tas.spriteSpecular;
                    if (spriteSpecular == null) continue;
                    spriteSpecular.func_195663_q();
                }
            }
            GlStateManager.func_227760_t_((int)this.func_110552_b());
        }
        Reflector.callVoid(Reflector.ForgeHooksClient_onTextureStitchedPost, this);
        this.updateIconGrid(sheetDataIn.field_217806_b, sheetDataIn.field_217807_c);
        if (Config.equals(System.getProperty("saveTextureMap"), "true")) {
            Config.dbg("Exporting texture map: " + this.field_229214_j_);
            TextureUtils.saveGlTexture("debug/" + this.field_229214_j_.func_110623_a().replaceAll("/", "_"), this.func_110552_b(), sheetDataIn.field_229224_d_, sheetDataIn.field_217806_b, sheetDataIn.field_217807_c);
            if (this.shaders) {
                if (Shaders.configNormalMap) {
                    TextureUtils.saveGlTexture("debug/" + this.field_229214_j_.func_110623_a().replaceAll("/", "_").replace(".png", "_n.png"), this.multiTex.norm, sheetDataIn.field_229224_d_, sheetDataIn.field_217806_b, sheetDataIn.field_217807_c);
                }
                if (Shaders.configSpecularMap) {
                    TextureUtils.saveGlTexture("debug/" + this.field_229214_j_.func_110623_a().replaceAll("/", "_").replace(".png", "_s.png"), this.multiTex.spec, sheetDataIn.field_229224_d_, sheetDataIn.field_217806_b, sheetDataIn.field_217807_c);
                }
                GlStateManager.func_227760_t_((int)this.func_110552_b());
            }
        }
    }

    public SheetData func_229220_a_(IResourceManager resourceManagerIn, Stream<ResourceLocation> resourceLocationsIn, IProfiler profilerIn, int maxMipmapLevelIn) {
        int k1;
        int minSpriteSize;
        this.terrain = this.field_229214_j_.equals((Object)field_110575_b);
        this.shaders = Config.isShaders();
        this.multiTexture = Config.isMultiTexture();
        int mipmapLevels = maxMipmapLevelIn;
        this.mapRegisteredSprites.clear();
        this.mapMissingSprites.clear();
        this.counterIndexInMap.reset();
        profilerIn.func_76320_a("preparing");
        Set set = resourceLocationsIn.peek(p_229222_0_ -> {
            if (p_229222_0_ == null) {
                throw new IllegalArgumentException("Location cannot be null!");
            }
        }).collect(Collectors.toSet());
        Config.dbg("Multitexture: " + Config.isMultiTexture());
        TextureUtils.registerCustomSprites((AtlasTexture)this);
        set.addAll(this.mapRegisteredSprites.keySet());
        Set locsEmissive = AtlasTexture.newHashSet(set, this.mapRegisteredSprites.keySet());
        EmissiveTextures.updateIcons((AtlasTexture)this, (Set)locsEmissive);
        set.addAll(this.mapRegisteredSprites.keySet());
        if (mipmapLevels >= 4) {
            mipmapLevels = this.detectMaxMipmapLevel(set, resourceManagerIn);
            Config.log("Mipmap levels: " + mipmapLevels);
        }
        int i2 = TextureUtils.getGLMaximumTextureSize();
        Stitcher stitcher = new Stitcher(i2, i2, maxMipmapLevelIn);
        int j2 = Integer.MAX_VALUE;
        this.iconGridSize = minSpriteSize = AtlasTexture.getMinSpriteSize((int)mipmapLevels);
        int k2 = 1 << maxMipmapLevelIn;
        profilerIn.func_219895_b("extracting_frames");
        Reflector.callVoid(Reflector.ForgeHooksClient_onTextureStitchedPre, this, set);
        for (TextureAtlasSprite.Info textureatlassprite$info : this.func_215256_a(resourceManagerIn, set)) {
            int ws = textureatlassprite$info.func_229250_b_();
            int hs = textureatlassprite$info.func_229252_c_();
            if (ws < 1 || hs < 1) {
                Config.warn("Invalid sprite size: " + textureatlassprite$info.func_229248_a_());
                continue;
            }
            if (ws < minSpriteSize || mipmapLevels > 0) {
                int ws2;
                int n2 = ws2 = mipmapLevels > 0 ? TextureUtils.scaleToGrid(ws, minSpriteSize) : TextureUtils.scaleToMin(ws, minSpriteSize);
                if (ws2 != ws) {
                    if (!TextureUtils.isPowerOfTwo(ws)) {
                        Config.log("Scaled non power of 2: " + textureatlassprite$info.func_229248_a_() + ", " + ws + " -> " + ws2);
                    } else {
                        Config.log("Scaled too small texture: " + textureatlassprite$info.func_229248_a_() + ", " + ws + " -> " + ws2);
                    }
                    int hs2 = hs * ws2 / ws;
                    textureatlassprite$info.setSpriteWidth(ws2);
                    textureatlassprite$info.setSpriteHeight(hs2);
                    textureatlassprite$info.setScaleFactor((double)ws2 * 1.0 / (double)ws);
                }
            }
            j2 = Math.min(j2, Math.min(textureatlassprite$info.func_229250_b_(), textureatlassprite$info.func_229252_c_()));
            int l2 = Math.min(Integer.lowestOneBit(textureatlassprite$info.func_229250_b_()), Integer.lowestOneBit(textureatlassprite$info.func_229252_c_()));
            if (l2 < k2) {
                field_147635_d.warn("Texture {} with size {}x{} limits mip level from {} to {}", (Object)textureatlassprite$info.func_229248_a_(), (Object)textureatlassprite$info.func_229250_b_(), (Object)textureatlassprite$info.func_229252_c_(), (Object)MathHelper.func_151239_c((int)k2), (Object)MathHelper.func_151239_c((int)l2));
                k2 = l2;
            }
            stitcher.func_229211_a_(textureatlassprite$info);
        }
        int i1 = Math.min(j2, k2);
        int j1 = MathHelper.func_151239_c((int)i1);
        if (j1 < 0) {
            j1 = 0;
        }
        if (j1 < maxMipmapLevelIn) {
            field_147635_d.warn("{}: dropping miplevel from {} to {}, because of minimum power of two: {}", (Object)this.field_229214_j_, (Object)maxMipmapLevelIn, (Object)j1, (Object)i1);
            k1 = j1;
        } else {
            k1 = maxMipmapLevelIn;
        }
        profilerIn.func_219895_b("register");
        TextureAtlasSprite.Info missingInfo = AtlasTexture.fixSpriteSize((TextureAtlasSprite.Info)MissingTextureSprite.func_229177_b_(), (int)minSpriteSize);
        stitcher.func_229211_a_(missingInfo);
        profilerIn.func_219895_b("stitching");
        try {
            stitcher.func_94305_f();
        }
        catch (StitcherException stitcherexception) {
            CrashReport crashreport = CrashReport.func_85055_a((Throwable)stitcherexception, (String)"Stitching");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Stitcher");
            crashreportcategory.func_71507_a("Sprites", (Object)stitcherexception.func_225331_a().stream().map(p_229216_0_ -> String.format("%s[%dx%d]", p_229216_0_.func_229248_a_(), p_229216_0_.func_229250_b_(), p_229216_0_.func_229252_c_())).collect(Collectors.joining(",")));
            crashreportcategory.func_71507_a("Max Texture Size", (Object)i2);
            throw new ReportedException(crashreport);
        }
        profilerIn.func_219895_b("loading");
        List list = this.func_229217_a_(resourceManagerIn, stitcher, k1);
        profilerIn.func_76319_b();
        return new SheetData(set, stitcher.func_110935_a(), stitcher.func_110936_b(), k1, list);
    }

    private Collection<TextureAtlasSprite.Info> func_215256_a(IResourceManager resourceManagerIn, Set<ResourceLocation> spriteLocationsIn) {
        ArrayList list = Lists.newArrayList();
        ConcurrentLinkedQueue<TextureAtlasSprite.Info> concurrentlinkedqueue = new ConcurrentLinkedQueue<TextureAtlasSprite.Info>();
        for (ResourceLocation resourcelocation : spriteLocationsIn) {
            if (MissingTextureSprite.func_195675_b().equals((Object)resourcelocation)) continue;
            list.add(CompletableFuture.runAsync(() -> {
                TextureAtlasSprite.Info textureatlassprite$info;
                ResourceLocation resourcelocation1 = this.func_195420_b(resourcelocation);
                try (IResource iresource = resourceManagerIn.func_199002_a(resourcelocation1);){
                    PngSizeInfo pngsizeinfo = new PngSizeInfo(iresource.toString(), iresource.func_199027_b());
                    AnimationMetadataSection animationmetadatasection = (AnimationMetadataSection)iresource.func_199028_a((IMetadataSectionSerializer)AnimationMetadataSection.field_195817_a);
                    if (animationmetadatasection == null) {
                        animationmetadatasection = AnimationMetadataSection.field_229300_b_;
                    }
                    Pair pair = animationmetadatasection.func_225641_a_(pngsizeinfo.field_188533_a, pngsizeinfo.field_188534_b);
                    textureatlassprite$info = new TextureAtlasSprite.Info(resourcelocation, ((Integer)pair.getFirst()).intValue(), ((Integer)pair.getSecond()).intValue(), animationmetadatasection);
                }
                catch (RuntimeException runtimeexception) {
                    field_147635_d.error("Unable to parse metadata from {} : {}", (Object)resourcelocation1, (Object)runtimeexception);
                    this.onSpriteMissing(resourcelocation);
                    return;
                }
                catch (IOException ioexception) {
                    field_147635_d.error("Using missing texture, unable to load {} : {}", (Object)resourcelocation1, (Object)ioexception);
                    this.onSpriteMissing(resourcelocation);
                    return;
                }
                concurrentlinkedqueue.add(textureatlassprite$info);
            }, Util.func_215072_e()));
        }
        CompletableFuture.allOf(list.toArray(new CompletableFuture[0])).join();
        return concurrentlinkedqueue;
    }

    private List<TextureAtlasSprite> func_229217_a_(IResourceManager resourceManagerIn, Stitcher stitcherIn, int mipmapLevelIn) {
        ConcurrentLinkedQueue concurrentlinkedqueue = new ConcurrentLinkedQueue();
        ArrayList list = Lists.newArrayList();
        stitcherIn.func_229209_a_((p_229215_5_, p_229215_6_, p_229215_7_, p_229215_8_, p_229215_9_) -> {
            if (p_229215_5_.func_229248_a_().equals((Object)MissingTextureSprite.func_229177_b_().func_229248_a_())) {
                MissingTextureSprite missingtexturesprite = new MissingTextureSprite(this, p_229215_5_, mipmapLevelIn, p_229215_6_, p_229215_7_, p_229215_8_, p_229215_9_);
                missingtexturesprite.update(resourceManagerIn);
                concurrentlinkedqueue.add(missingtexturesprite);
            } else {
                list.add(CompletableFuture.runAsync(() -> {
                    TextureAtlasSprite textureatlassprite = this.func_229218_a_(resourceManagerIn, p_229215_5_, p_229215_6_, p_229215_7_, mipmapLevelIn, p_229215_8_, p_229215_9_);
                    if (textureatlassprite != null) {
                        concurrentlinkedqueue.add(textureatlassprite);
                    }
                }, Util.func_215072_e()));
            }
        });
        CompletableFuture.allOf(list.toArray(new CompletableFuture[0])).join();
        return Lists.newArrayList(concurrentlinkedqueue);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private TextureAtlasSprite func_229218_a_(IResourceManager resourceManagerIn, TextureAtlasSprite.Info spriteInfoIn, int widthIn, int heightIn, int mipmapLevelIn, int originX, int originY) {
        ResourceLocation resourcelocation = this.func_195420_b(spriteInfoIn.func_229248_a_());
        try (IResource iresource = resourceManagerIn.func_199002_a(resourcelocation);){
            NativeImage nativeimage = NativeImage.func_195713_a((InputStream)iresource.func_199027_b());
            TextureAtlasSprite textureatlassprite = new TextureAtlasSprite(this, spriteInfoIn, mipmapLevelIn, widthIn, heightIn, originX, originY, nativeimage);
            textureatlassprite.update(resourceManagerIn);
            TextureAtlasSprite textureAtlasSprite = textureatlassprite;
            return textureAtlasSprite;
        }
        catch (RuntimeException runtimeexception) {
            field_147635_d.error("Unable to parse metadata from {}", (Object)resourcelocation, (Object)runtimeexception);
            return null;
        }
        catch (IOException ioexception) {
            field_147635_d.error("Using missing texture, unable to load {}", (Object)resourcelocation, (Object)ioexception);
            return null;
        }
    }

    public ResourceLocation func_195420_b(ResourceLocation location) {
        if (this.isAbsoluteLocation(location)) {
            return new ResourceLocation(location.func_110624_b(), location.func_110623_a() + ".png");
        }
        return new ResourceLocation(location.func_110624_b(), String.format("textures/%s%s", location.func_110623_a(), ".png"));
    }

    public void func_94248_c() {
        boolean hasNormal = false;
        boolean hasSpecular = false;
        if (!this.field_94258_i.isEmpty()) {
            this.func_229148_d_();
        }
        int countActive = 0;
        for (TextureAtlasSprite textureatlassprite : this.field_94258_i) {
            if (!this.isAnimationEnabled(textureatlassprite)) continue;
            textureatlassprite.func_94219_l();
            if (textureatlassprite.isAnimationActive()) {
                ++countActive;
            }
            if (textureatlassprite.spriteNormal != null) {
                hasNormal = true;
            }
            if (textureatlassprite.spriteSpecular == null) continue;
            hasSpecular = true;
        }
        if (Config.isMultiTexture()) {
            for (TextureAtlasSprite ts : this.field_94258_i) {
                TextureAtlasSprite spriteSingle;
                if (!this.isAnimationEnabled(ts) || !ts.isAnimationActive() || (spriteSingle = ts.spriteSingle) == null) continue;
                ts.bindSpriteTexture();
                spriteSingle.func_94219_l();
                if (!spriteSingle.isAnimationActive()) continue;
                ++countActive;
            }
            GlStateManager.func_227760_t_((int)this.func_110552_b());
        }
        if (Config.isShaders()) {
            if (hasNormal) {
                GlStateManager.func_227760_t_((int)this.getMultiTexID().norm);
                for (TextureAtlasSprite textureatlassprite : this.field_94258_i) {
                    if (textureatlassprite.spriteNormal == null || !this.isAnimationEnabled(textureatlassprite) || !textureatlassprite.isAnimationActive()) continue;
                    textureatlassprite.spriteNormal.func_94219_l();
                    if (!textureatlassprite.spriteNormal.isAnimationActive()) continue;
                    ++countActive;
                }
            }
            if (hasSpecular) {
                GlStateManager.func_227760_t_((int)this.getMultiTexID().spec);
                for (TextureAtlasSprite textureatlassprite : this.field_94258_i) {
                    if (textureatlassprite.spriteSpecular == null || !this.isAnimationEnabled(textureatlassprite) || !textureatlassprite.isAnimationActive()) continue;
                    textureatlassprite.spriteSpecular.func_94219_l();
                    if (!textureatlassprite.spriteSpecular.isAnimationActive()) continue;
                    ++countActive;
                }
            }
            if (hasNormal || hasSpecular) {
                GlStateManager.func_227760_t_((int)this.func_110552_b());
            }
        }
        if (this.terrain) {
            int frameCount = Config.getMinecraft().field_71438_f.getFrameCount();
            if (frameCount != this.frameCountAnimations) {
                this.countAnimationsActive = countActive;
                this.frameCountAnimations = frameCount;
            }
            if (SmartAnimations.isActive()) {
                SmartAnimations.resetSpritesRendered((AtlasTexture)this);
            }
        }
    }

    public void func_110550_d() {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> this.func_94248_c());
        } else {
            this.func_94248_c();
        }
    }

    public TextureAtlasSprite func_195424_a(ResourceLocation location) {
        TextureAtlasSprite textureatlassprite = (TextureAtlasSprite)this.field_94252_e.get(location);
        return textureatlassprite == null ? (TextureAtlasSprite)this.field_94252_e.get(MissingTextureSprite.func_195675_b()) : textureatlassprite;
    }

    public void func_195419_g() {
        for (TextureAtlasSprite textureatlassprite : this.field_94252_e.values()) {
            textureatlassprite.close();
        }
        if (this.multiTexture) {
            for (TextureAtlasSprite ts : this.field_94252_e.values()) {
                ts.deleteSpriteTexture();
            }
        }
        this.field_94252_e.clear();
        this.field_94258_i.clear();
    }

    public ResourceLocation func_229223_g_() {
        return this.field_229214_j_;
    }

    public void func_229221_b_(SheetData sheetDataIn) {
        this.func_174937_a(false, sheetDataIn.field_229224_d_ > 0);
    }

    private boolean isAbsoluteLocation(ResourceLocation loc) {
        String path = loc.func_110623_a();
        return this.isAbsoluteLocationPath(path);
    }

    private boolean isAbsoluteLocationPath(String resPath) {
        String path = resPath.toLowerCase();
        return path.startsWith("optifine/");
    }

    public TextureAtlasSprite getRegisteredSprite(String name) {
        ResourceLocation loc = new ResourceLocation(name);
        return this.getRegisteredSprite(loc);
    }

    public TextureAtlasSprite getRegisteredSprite(ResourceLocation loc) {
        return (TextureAtlasSprite)this.mapRegisteredSprites.get(loc);
    }

    public TextureAtlasSprite getUploadedSprite(String name) {
        ResourceLocation loc = new ResourceLocation(name);
        return this.getUploadedSprite(loc);
    }

    public TextureAtlasSprite getUploadedSprite(ResourceLocation loc) {
        return (TextureAtlasSprite)this.field_94252_e.get(loc);
    }

    private boolean isAnimationEnabled(TextureAtlasSprite ts) {
        if (!this.terrain) {
            return true;
        }
        if (ts == TextureUtils.iconWaterStill || ts == TextureUtils.iconWaterFlow) {
            return Config.isAnimatedWater();
        }
        if (ts == TextureUtils.iconLavaStill || ts == TextureUtils.iconLavaFlow) {
            return Config.isAnimatedLava();
        }
        if (ts == TextureUtils.iconFireLayer0 || ts == TextureUtils.iconFireLayer1) {
            return Config.isAnimatedFire();
        }
        if (ts == TextureUtils.iconSoulFireLayer0 || ts == TextureUtils.iconSoulFireLayer1) {
            return Config.isAnimatedFire();
        }
        if (ts == TextureUtils.iconCampFire || ts == TextureUtils.iconCampFireLogLit) {
            return Config.isAnimatedFire();
        }
        if (ts == TextureUtils.iconSoulCampFire || ts == TextureUtils.iconSoulCampFireLogLit) {
            return Config.isAnimatedFire();
        }
        if (ts == TextureUtils.iconPortal) {
            return Config.isAnimatedPortal();
        }
        return Config.isAnimatedTerrain();
    }

    public int getCountRegisteredSprites() {
        return this.counterIndexInMap.getValue();
    }

    private int detectMaxMipmapLevel(Set<ResourceLocation> setSpriteLocations, IResourceManager rm) {
        int minLevel;
        int minSize = this.detectMinimumSpriteSize(setSpriteLocations, rm, 20);
        if (minSize < 16) {
            minSize = 16;
        }
        if ((minSize = MathHelper.func_151236_b((int)minSize)) > 16) {
            Config.log("Sprite size: " + minSize);
        }
        if ((minLevel = MathHelper.func_151239_c((int)minSize)) < 4) {
            minLevel = 4;
        }
        return minLevel;
    }

    private int detectMinimumSpriteSize(Set<ResourceLocation> setSpriteLocations, IResourceManager rm, int percentScale) {
        int count;
        HashMap<Integer, Integer> mapSizeCounts = new HashMap<Integer, Integer>();
        for (ResourceLocation loc : setSpriteLocations) {
            ResourceLocation locComplete = this.func_195420_b(loc);
            try {
                Dimension dim;
                InputStream in;
                IResource res = rm.func_199002_a(locComplete);
                if (res == null || (in = res.func_199027_b()) == null || (dim = TextureUtils.getImageSize(in, "png")) == null) continue;
                int width = dim.width;
                int width2 = MathHelper.func_151236_b((int)width);
                if (!mapSizeCounts.containsKey(width2)) {
                    mapSizeCounts.put(width2, 1);
                    continue;
                }
                count = (Integer)mapSizeCounts.get(width2);
                mapSizeCounts.put(width2, count + 1);
            }
            catch (Exception e2) {}
        }
        int countSprites = 0;
        Set setSizes = mapSizeCounts.keySet();
        TreeSet setSizesSorted = new TreeSet(setSizes);
        Iterator it = setSizesSorted.iterator();
        while (it.hasNext()) {
            int size = (Integer)it.next();
            int count2 = (Integer)mapSizeCounts.get(size);
            countSprites += count2;
        }
        int minSize = 16;
        int countScale = 0;
        int countScaleMax = countSprites * percentScale / 100;
        Iterator it2 = setSizesSorted.iterator();
        while (it2.hasNext()) {
            int size = (Integer)it2.next();
            count = (Integer)mapSizeCounts.get(size);
            countScale += count;
            if (size > minSize) {
                minSize = size;
            }
            if (countScale <= countScaleMax) continue;
            return minSize;
        }
        return minSize;
    }

    private static int getMinSpriteSize(int mipmapLevels) {
        int minSize = 1 << mipmapLevels;
        if (minSize < 8) {
            minSize = 8;
        }
        return minSize;
    }

    private static TextureAtlasSprite.Info fixSpriteSize(TextureAtlasSprite.Info info, int minSpriteSize) {
        if (info.func_229250_b_() >= minSpriteSize && info.func_229252_c_() >= minSpriteSize) {
            return info;
        }
        int widthNew = Math.max(info.func_229250_b_(), minSpriteSize);
        int heightNew = Math.max(info.func_229252_c_(), minSpriteSize);
        TextureAtlasSprite.Info infoNew = new TextureAtlasSprite.Info(info.func_229248_a_(), widthNew, heightNew, info.getSpriteAnimationMetadata());
        return infoNew;
    }

    public boolean isTextureBound() {
        int texId;
        int boundTexId = GlStateManager.getBoundTexture();
        return boundTexId == (texId = this.func_110552_b());
    }

    private void updateIconGrid(int sheetWidth, int sheetHeight) {
        this.iconGridCountX = -1;
        this.iconGridCountY = -1;
        this.iconGrid = null;
        if (this.iconGridSize <= 0) {
            return;
        }
        this.iconGridCountX = sheetWidth / this.iconGridSize;
        this.iconGridCountY = sheetHeight / this.iconGridSize;
        this.iconGrid = new TextureAtlasSprite[this.iconGridCountX * this.iconGridCountY];
        this.iconGridSizeU = 1.0 / (double)this.iconGridCountX;
        this.iconGridSizeV = 1.0 / (double)this.iconGridCountY;
        for (TextureAtlasSprite ts : this.field_94252_e.values()) {
            double deltaU = 0.5 / (double)sheetWidth;
            double deltaV = 0.5 / (double)sheetHeight;
            double uMin = (double)Math.min(ts.func_94209_e(), ts.func_94212_f()) + deltaU;
            double vMin = (double)Math.min(ts.func_94206_g(), ts.func_94210_h()) + deltaV;
            double uMax = (double)Math.max(ts.func_94209_e(), ts.func_94212_f()) - deltaU;
            double vMax = (double)Math.max(ts.func_94206_g(), ts.func_94210_h()) - deltaV;
            int iuMin = (int)(uMin / this.iconGridSizeU);
            int ivMin = (int)(vMin / this.iconGridSizeV);
            int iuMax = (int)(uMax / this.iconGridSizeU);
            int ivMax = (int)(vMax / this.iconGridSizeV);
            for (int iu = iuMin; iu <= iuMax; ++iu) {
                if (iu < 0 || iu >= this.iconGridCountX) {
                    Config.warn("Invalid grid U: " + iu + ", icon: " + ts.func_195668_m());
                    continue;
                }
                for (int iv = ivMin; iv <= ivMax; ++iv) {
                    if (iv < 0 || iv >= this.iconGridCountX) {
                        Config.warn("Invalid grid V: " + iv + ", icon: " + ts.func_195668_m());
                        continue;
                    }
                    int index = iv * this.iconGridCountX + iu;
                    this.iconGrid[index] = ts;
                }
            }
        }
    }

    public TextureAtlasSprite getIconByUV(double u2, double v2) {
        if (this.iconGrid == null) {
            return null;
        }
        int iv = (int)(v2 / this.iconGridSizeV);
        int iu = (int)(u2 / this.iconGridSizeU);
        int index = iv * this.iconGridCountX + iu;
        if (index < 0 || index > this.iconGrid.length) {
            return null;
        }
        return this.iconGrid[index];
    }

    public int getCountAnimations() {
        return this.field_94258_i.size();
    }

    public int getCountAnimationsActive() {
        return this.countAnimationsActive;
    }

    public TextureAtlasSprite registerSprite(ResourceLocation location) {
        if (location == null) {
            throw new IllegalArgumentException("Location cannot be null!");
        }
        TextureAtlasSprite sprite = (TextureAtlasSprite)this.mapRegisteredSprites.get(location);
        if (sprite != null) {
            return sprite;
        }
        this.field_195427_i.add(location);
        sprite = new TextureAtlasSprite(location);
        this.mapRegisteredSprites.put(location, sprite);
        sprite.updateIndexInMap(this.counterIndexInMap);
        return sprite;
    }

    public Collection<TextureAtlasSprite> getRegisteredSprites() {
        return Collections.unmodifiableCollection(this.mapRegisteredSprites.values());
    }

    public boolean isTerrain() {
        return this.terrain;
    }

    public CounterInt getCounterIndexInMap() {
        return this.counterIndexInMap;
    }

    private void onSpriteMissing(ResourceLocation loc) {
        TextureAtlasSprite sprite = (TextureAtlasSprite)this.mapRegisteredSprites.get(loc);
        if (sprite == null) {
            return;
        }
        this.mapMissingSprites.put(loc, sprite);
    }

    private static <T> Set<T> newHashSet(Set<T> set1, Set<T> set2) {
        HashSet<T> set = new HashSet<T>();
        set.addAll(set1);
        set.addAll(set2);
        return set;
    }

    public String toString() {
        return "" + this.field_229214_j_;
    }
}

