/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.texture;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.realmsclient.RealmsMainScreen;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.MainMenuScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.ITickable;
import net.minecraft.client.renderer.texture.MissingTextureSprite;
import net.minecraft.client.renderer.texture.PreloadedTexture;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.client.renderer.texture.Texture;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.optifine.Config;
import net.optifine.CustomGuis;
import net.optifine.EmissiveTextures;
import net.optifine.shaders.ShadersTex;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TextureManager
implements IFutureReloadListener,
ITickable,
AutoCloseable {
    private static final Logger field_147646_a = LogManager.getLogger();
    public static final ResourceLocation field_194008_a = new ResourceLocation("");
    private final Map<ResourceLocation, Texture> field_110585_a = Maps.newHashMap();
    private final Set<ITickable> field_110583_b = Sets.newHashSet();
    private final Map<String, Integer> field_110584_c = Maps.newHashMap();
    private final IResourceManager field_110582_d;
    private Texture boundTexture;
    private ResourceLocation boundTextureLocation;

    public TextureManager(IResourceManager resourceManager) {
        this.field_110582_d = resourceManager;
    }

    public void func_110577_a(ResourceLocation resource) {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> this.func_229269_d_(resource));
        } else {
            this.func_229269_d_(resource);
        }
    }

    private void func_229269_d_(ResourceLocation resource) {
        Texture texture;
        if (Config.isCustomGuis()) {
            resource = CustomGuis.getTextureLocation((ResourceLocation)resource);
        }
        if ((texture = (Texture)this.field_110585_a.get(resource)) == null) {
            texture = new SimpleTexture(resource);
            this.func_229263_a_(resource, texture);
        }
        if (Config.isShaders()) {
            ShadersTex.bindTexture((Texture)texture);
        } else {
            texture.func_229148_d_();
        }
        this.boundTexture = texture;
        this.boundTextureLocation = resource;
    }

    public void func_229263_a_(ResourceLocation textureLocation, Texture textureObj) {
        Texture texture = this.field_110585_a.put(textureLocation, textureObj = this.func_230183_b_(textureLocation, textureObj));
        if (texture != textureObj) {
            if (texture != null && texture != MissingTextureSprite.func_195676_d()) {
                texture.func_147631_c();
                this.field_110583_b.remove(texture);
            }
            if (textureObj instanceof ITickable) {
                this.field_110583_b.add((ITickable)textureObj);
            }
        }
    }

    private Texture func_230183_b_(ResourceLocation p_230183_1_, Texture p_230183_2_) {
        try {
            p_230183_2_.func_195413_a(this.field_110582_d);
            return p_230183_2_;
        }
        catch (IOException ioexception) {
            if (p_230183_1_ != field_194008_a) {
                field_147646_a.warn("Failed to load texture: {}", (Object)p_230183_1_, (Object)ioexception);
            }
            return MissingTextureSprite.func_195676_d();
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Registering texture");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Resource location being registered");
            crashreportcategory.func_71507_a("Resource location", (Object)p_230183_1_);
            crashreportcategory.func_189529_a("Texture object class", () -> p_230183_2_.getClass().getName());
            throw new ReportedException(crashreport);
        }
    }

    @Nullable
    public Texture func_229267_b_(ResourceLocation textureLocation) {
        return (Texture)this.field_110585_a.get(textureLocation);
    }

    public ResourceLocation func_110578_a(String name, DynamicTexture texture) {
        Integer integer = (Integer)this.field_110584_c.get(name);
        integer = integer == null ? Integer.valueOf(1) : Integer.valueOf(integer + 1);
        this.field_110584_c.put(name, integer);
        ResourceLocation resourcelocation = new ResourceLocation(String.format("dynamic/%s_%d", name, integer));
        this.func_229263_a_(resourcelocation, (Texture)texture);
        return resourcelocation;
    }

    public CompletableFuture<Void> func_215268_a(ResourceLocation textureLocation, Executor executor) {
        if (!this.field_110585_a.containsKey(textureLocation)) {
            PreloadedTexture preloadedtexture = new PreloadedTexture(this.field_110582_d, textureLocation, executor);
            this.field_110585_a.put(textureLocation, preloadedtexture);
            return preloadedtexture.func_215248_a().thenRunAsync(() -> this.func_229263_a_(textureLocation, (Texture)preloadedtexture), TextureManager::func_229262_a_);
        }
        return CompletableFuture.completedFuture(null);
    }

    private static void func_229262_a_(Runnable runnableIn) {
        Minecraft.func_71410_x().execute(() -> RenderSystem.recordRenderCall(runnableIn::run));
    }

    public void func_110550_d() {
        for (ITickable itickable : this.field_110583_b) {
            itickable.func_110550_d();
        }
    }

    public void func_147645_c(ResourceLocation textureLocation) {
        Texture texture = this.func_229267_b_(textureLocation);
        if (texture != null) {
            this.field_110585_a.remove(textureLocation);
            TextureUtil.func_225679_a_((int)texture.func_110552_b());
        }
    }

    @Override
    public void close() {
        this.field_110585_a.values().forEach(Texture::func_147631_c);
        this.field_110585_a.clear();
        this.field_110583_b.clear();
        this.field_110584_c.clear();
    }

    public CompletableFuture<Void> func_215226_a(IFutureReloadListener.IStage stage, IResourceManager resourceManager, IProfiler preparationsProfiler, IProfiler reloadProfiler, Executor backgroundExecutor, Executor gameExecutor) {
        Config.dbg("*** Reloading textures ***");
        Config.log("Resource packs: " + Config.getResourcePackNames());
        Iterator it = this.field_110585_a.keySet().iterator();
        while (it.hasNext()) {
            ResourceLocation loc = (ResourceLocation)it.next();
            String path = loc.func_110623_a();
            if (!path.startsWith("optifine/") && !EmissiveTextures.isEmissive((ResourceLocation)loc)) continue;
            Texture tex = (Texture)this.field_110585_a.get(loc);
            if (tex instanceof Texture) {
                Texture at = tex;
                at.func_147631_c();
            }
            it.remove();
        }
        EmissiveTextures.update();
        return ((CompletableFuture)CompletableFuture.allOf(MainMenuScreen.func_213097_a((TextureManager)this, (Executor)backgroundExecutor), this.func_215268_a(Widget.field_230687_i_, backgroundExecutor)).thenCompose(arg_0 -> ((IFutureReloadListener.IStage)stage).func_216872_a(arg_0))).thenAcceptAsync(p_229265_3_ -> {
            MissingTextureSprite.func_195676_d();
            RealmsMainScreen.func_227932_a_((IResourceManager)this.field_110582_d);
            HashSet entries = new HashSet(this.field_110585_a.entrySet());
            Iterator iterator = entries.iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                ResourceLocation resourcelocation = (ResourceLocation)entry.getKey();
                Texture texture = (Texture)entry.getValue();
                if (texture == MissingTextureSprite.func_195676_d() && !resourcelocation.equals((Object)MissingTextureSprite.func_195675_b())) {
                    iterator.remove();
                    continue;
                }
                texture.func_215244_a(this, resourceManager, resourcelocation, gameExecutor);
            }
        }, p_229266_0_ -> RenderSystem.recordRenderCall(p_229266_0_::run));
    }

    public Texture getBoundTexture() {
        return this.boundTexture;
    }

    public ResourceLocation getBoundTextureLocation() {
        return this.boundTextureLocation;
    }
}

