/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.vertex;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.ints.Int2IntArrayMap;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.stream.Collectors;
import net.minecraft.client.renderer.vertex.VertexFormatElement;

public class VertexFormat {
    private final ImmutableList<VertexFormatElement> field_177355_b;
    private final IntList field_177356_c = new IntArrayList();
    private final int field_177353_d;
    private int positionElementOffset = -1;
    private int normalElementOffset = -1;
    private int colorElementOffset = -1;
    private final Int2IntMap uvOffsetsById = new Int2IntArrayMap();

    public VertexFormat(ImmutableList<VertexFormatElement> elementsIn) {
        this.field_177355_b = elementsIn;
        int i2 = 0;
        for (VertexFormatElement vertexformatelement : elementsIn) {
            this.field_177356_c.add(i2);
            VertexFormatElement.Usage usage = vertexformatelement.func_177375_c();
            if (usage == VertexFormatElement.Usage.POSITION) {
                this.positionElementOffset = i2;
            } else if (usage == VertexFormatElement.Usage.NORMAL) {
                this.normalElementOffset = i2;
            } else if (usage == VertexFormatElement.Usage.COLOR) {
                this.colorElementOffset = i2;
            } else if (usage == VertexFormatElement.Usage.UV) {
                this.uvOffsetsById.put(vertexformatelement.func_177369_e(), i2);
            }
            i2 += vertexformatelement.func_177368_f();
        }
        this.field_177353_d = i2;
    }

    public String toString() {
        return "format: " + this.field_177355_b.size() + " elements: " + this.field_177355_b.stream().map(Object::toString).collect(Collectors.joining(" "));
    }

    public int func_181719_f() {
        return this.func_177338_f() / 4;
    }

    public int func_177338_f() {
        return this.field_177353_d;
    }

    public ImmutableList<VertexFormatElement> func_227894_c_() {
        return this.field_177355_b;
    }

    public boolean equals(Object p_equals_1_) {
        if (this == p_equals_1_) {
            return true;
        }
        if (p_equals_1_ != null && this.getClass() == p_equals_1_.getClass()) {
            VertexFormat vertexformat = (VertexFormat)p_equals_1_;
            return this.field_177353_d != vertexformat.field_177353_d ? false : this.field_177355_b.equals((Object)vertexformat.field_177355_b);
        }
        return false;
    }

    public int hashCode() {
        return this.field_177355_b.hashCode();
    }

    public void func_227892_a_(long pointerIn) {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> this.func_227892_a_(pointerIn));
        } else {
            int i2 = this.func_177338_f();
            ImmutableList list = this.func_227894_c_();
            for (int j2 = 0; j2 < list.size(); ++j2) {
                ((VertexFormatElement)list.get(j2)).func_227897_a_(pointerIn + (long)this.field_177356_c.getInt(j2), i2);
            }
        }
    }

    public void func_227895_d_() {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> this.func_227895_d_());
        } else {
            for (VertexFormatElement vertexformatelement : this.func_227894_c_()) {
                vertexformatelement.func_227898_g_();
            }
        }
    }

    public int getOffset(int index) {
        return this.field_177356_c.getInt(index);
    }

    public boolean hasPosition() {
        return this.positionElementOffset >= 0;
    }

    public int getPositionOffset() {
        return this.positionElementOffset;
    }

    public boolean hasNormal() {
        return this.normalElementOffset >= 0;
    }

    public int getNormalOffset() {
        return this.normalElementOffset;
    }

    public boolean hasColor() {
        return this.colorElementOffset >= 0;
    }

    public int getColorOffset() {
        return this.colorElementOffset;
    }

    public boolean hasUV(int id) {
        return this.uvOffsetsById.containsKey(id);
    }

    public int getUvOffsetById(int id) {
        return this.uvOffsetsById.get(id);
    }
}

