/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.play.server;

import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.network.play.IClientPlayNetHandler;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.LongArrayNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.biome.BiomeContainer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkSection;
import net.minecraft.world.gen.Heightmap;
import net.optifine.ChunkDataOF;
import net.optifine.ChunkOF;

public class SChunkDataPacket
implements IPacket<IClientPlayNetHandler> {
    private int field_149284_a;
    private int field_149282_b;
    private int field_186948_c;
    private CompoundNBT field_218711_d;
    @Nullable
    private BiomeContainer field_229738_e_;
    private byte[] field_186949_d;
    private List<CompoundNBT> field_189557_e;
    private boolean field_149279_g;
    private boolean field_241781_i_;
    private Map<String, Object> customData;

    public SChunkDataPacket() {
    }

    public SChunkDataPacket(Chunk chunkIn, int changedSectionFilter, boolean removeOldDataIn) {
        ChunkPos chunkpos = chunkIn.func_76632_l();
        this.field_149284_a = chunkpos.field_77276_a;
        this.field_149282_b = chunkpos.field_77275_b;
        this.field_149279_g = changedSectionFilter == 65535;
        this.field_241781_i_ = removeOldDataIn;
        this.field_218711_d = new CompoundNBT();
        for (Map.Entry entry : chunkIn.func_217311_f()) {
            if (!((Heightmap.Type)entry.getKey()).func_222681_b()) continue;
            this.field_218711_d.func_218657_a(((Heightmap.Type)entry.getKey()).func_203500_b(), (INBT)new LongArrayNBT(((Heightmap)entry.getValue()).func_202269_a()));
        }
        if (this.field_149279_g) {
            this.field_229738_e_ = chunkIn.func_225549_i_().func_227057_b_();
        }
        this.field_186949_d = new byte[this.func_218709_a(chunkIn, changedSectionFilter)];
        this.field_186948_c = this.func_218708_a(new PacketBuffer(this.func_186945_f()), chunkIn, changedSectionFilter);
        this.field_189557_e = Lists.newArrayList();
        for (Map.Entry entry : chunkIn.func_177434_r().entrySet()) {
            BlockPos blockpos = (BlockPos)entry.getKey();
            TileEntity tileentity = (TileEntity)entry.getValue();
            int i2 = blockpos.func_177956_o() >> 4;
            if (!this.func_149274_i() && (changedSectionFilter & 1 << i2) == 0) continue;
            CompoundNBT compoundnbt = tileentity.func_189517_E_();
            this.field_189557_e.add(compoundnbt);
        }
        this.customData = new HashMap();
        ChunkDataOF chunkDataOF = ChunkOF.makeChunkDataOF((Chunk)chunkIn);
        this.customData.put("ChunkDataOF", chunkDataOF);
    }

    public void func_148837_a(PacketBuffer buf) throws IOException {
        int i2;
        this.field_149284_a = buf.readInt();
        this.field_149282_b = buf.readInt();
        this.field_149279_g = buf.readBoolean();
        this.field_241781_i_ = buf.readBoolean();
        this.field_186948_c = buf.func_150792_a();
        this.field_218711_d = buf.func_150793_b();
        if (this.field_149279_g) {
            this.field_229738_e_ = new BiomeContainer(buf);
        }
        if ((i2 = buf.func_150792_a()) > 0x200000) {
            throw new RuntimeException("Chunk Packet trying to allocate too much memory on read.");
        }
        this.field_186949_d = new byte[i2];
        buf.readBytes(this.field_186949_d);
        int j2 = buf.func_150792_a();
        this.field_189557_e = Lists.newArrayList();
        for (int k2 = 0; k2 < j2; ++k2) {
            this.field_189557_e.add(buf.func_150793_b());
        }
    }

    public void func_148840_b(PacketBuffer buf) throws IOException {
        buf.writeInt(this.field_149284_a);
        buf.writeInt(this.field_149282_b);
        buf.writeBoolean(this.field_149279_g);
        buf.writeBoolean(this.field_241781_i_);
        buf.func_150787_b(this.field_186948_c);
        buf.func_150786_a(this.field_218711_d);
        if (this.field_229738_e_ != null) {
            this.field_229738_e_.func_227056_a_(buf);
        }
        buf.func_150787_b(this.field_186949_d.length);
        buf.writeBytes(this.field_186949_d);
        buf.func_150787_b(this.field_189557_e.size());
        for (CompoundNBT compoundnbt : this.field_189557_e) {
            buf.func_150786_a(compoundnbt);
        }
    }

    public void func_148833_a(IClientPlayNetHandler handler) {
        handler.func_147263_a(this);
    }

    public PacketBuffer func_186946_a() {
        return new PacketBuffer(Unpooled.wrappedBuffer((byte[])this.field_186949_d), this.customData);
    }

    private ByteBuf func_186945_f() {
        ByteBuf bytebuf = Unpooled.wrappedBuffer((byte[])this.field_186949_d);
        bytebuf.writerIndex(0);
        return bytebuf;
    }

    public int func_218708_a(PacketBuffer buf, Chunk chunkIn, int writeSkylight) {
        int i2 = 0;
        ChunkSection[] achunksection = chunkIn.func_76587_i();
        int k2 = achunksection.length;
        for (int j2 = 0; j2 < k2; ++j2) {
            ChunkSection chunksection = achunksection[j2];
            if (chunksection == Chunk.field_186036_a || this.func_149274_i() && chunksection.func_76663_a() || (writeSkylight & 1 << j2) == 0) continue;
            i2 |= 1 << j2;
            chunksection.func_222630_b(buf);
        }
        return i2;
    }

    protected int func_218709_a(Chunk chunkIn, int changedSectionsIn) {
        int i2 = 0;
        ChunkSection[] achunksection = chunkIn.func_76587_i();
        int k2 = achunksection.length;
        for (int j2 = 0; j2 < k2; ++j2) {
            ChunkSection chunksection = achunksection[j2];
            if (chunksection == Chunk.field_186036_a || this.func_149274_i() && chunksection.func_76663_a() || (changedSectionsIn & 1 << j2) == 0) continue;
            i2 += chunksection.func_222633_j();
        }
        return i2;
    }

    public int func_149273_e() {
        return this.field_149284_a;
    }

    public int func_149271_f() {
        return this.field_149282_b;
    }

    public int func_149276_g() {
        return this.field_186948_c;
    }

    public boolean func_149274_i() {
        return this.field_149279_g;
    }

    public boolean func_241782_g_() {
        return this.field_241781_i_;
    }

    public CompoundNBT func_218710_g() {
        return this.field_218711_d;
    }

    public List<CompoundNBT> func_189554_f() {
        return this.field_189557_e;
    }

    @Nullable
    public BiomeContainer func_229739_i_() {
        return this.field_229738_e_ == null ? null : this.field_229738_e_.func_227057_b_();
    }
}

