/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.integrated;

import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BooleanSupplier;
import net.minecraft.client.ClientBrandRetriever;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.LanServerPingThread;
import net.minecraft.crash.CrashReport;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.profiler.IProfiler;
import net.minecraft.profiler.Snooper;
import net.minecraft.resources.DataPackRegistries;
import net.minecraft.resources.ResourcePackInfo;
import net.minecraft.resources.ResourcePackList;
import net.minecraft.server.IDynamicRegistries;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.integrated.IntegratedPlayerList;
import net.minecraft.server.management.PlayerList;
import net.minecraft.server.management.PlayerProfileCache;
import net.minecraft.util.CryptManager;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.GameType;
import net.minecraft.world.World;
import net.minecraft.world.chunk.listener.IChunkStatusListenerFactory;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.IServerConfiguration;
import net.minecraft.world.storage.SaveFormat;
import net.optifine.Config;
import net.optifine.reflect.Reflector;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class IntegratedServer
extends MinecraftServer {
    private static final Logger field_147148_h = LogManager.getLogger();
    private final Minecraft field_71349_l;
    private boolean field_71348_o;
    private int field_195580_l = -1;
    private LanServerPingThread field_71345_q;
    private UUID field_211528_n;
    private long ticksSaveLast = 0L;
    public World difficultyUpdateWorld = null;
    public BlockPos difficultyUpdatePos = null;
    public DifficultyInstance difficultyLast = null;

    public IntegratedServer(Thread threadIn, Minecraft mcIn, IDynamicRegistries.Impl regImplIn, SaveFormat.LevelSave levelSaveIn, ResourcePackList<ResourcePackInfo> resPackListIn, DataPackRegistries dataPackRegIn, IServerConfiguration serverConfigIn, MinecraftSessionService sessionServiceIn, GameProfileRepository profileRepositoryIn, PlayerProfileCache profileCacheIn, IChunkStatusListenerFactory listenerFactoryIn) {
        super(threadIn, regImplIn, levelSaveIn, serverConfigIn, resPackListIn, mcIn.func_110437_J(), mcIn.func_184126_aj(), dataPackRegIn, sessionServiceIn, profileRepositoryIn, profileCacheIn, listenerFactoryIn);
        this.func_71224_l(mcIn.func_110432_I().func_111285_a());
        this.func_71204_b(mcIn.func_71355_q());
        this.func_71191_d(256);
        this.func_184105_a((PlayerList)new IntegratedPlayerList(this, this.field_240767_f_, this.field_240766_e_));
        this.field_71349_l = mcIn;
    }

    public boolean func_71197_b() {
        field_147148_h.info("Starting integrated minecraft server version " + SharedConstants.func_215069_a().getName());
        this.func_71229_d(true);
        this.func_71188_g(true);
        this.func_71245_h(true);
        field_147148_h.info("Generating keypair");
        this.func_71253_a(CryptManager.func_75891_b());
        if (Reflector.ServerLifecycleHooks_handleServerAboutToStart.exists() && !Reflector.callBoolean(Reflector.ServerLifecycleHooks_handleServerAboutToStart, this)) {
            return false;
        }
        this.func_240800_l__();
        this.func_71205_p(this.func_71214_G() + " - " + this.func_240793_aU_().func_76065_j());
        if (Reflector.ServerLifecycleHooks_handleServerStarting.exists()) {
            return Reflector.callBoolean(Reflector.ServerLifecycleHooks_handleServerStarting, this);
        }
        return true;
    }

    public void func_71217_p(BooleanSupplier hasTimeLeft) {
        this.onTick();
        boolean flag = this.field_71348_o;
        this.field_71348_o = Minecraft.func_71410_x().func_147114_u() != null && Minecraft.func_71410_x().func_147113_T();
        IProfiler iprofiler = this.func_213185_aS();
        if (!flag && this.field_71348_o) {
            iprofiler.func_76320_a("autoSave");
            field_147148_h.info("Saving and pausing game...");
            this.func_184103_al().func_72389_g();
            this.func_213211_a(false, false, false);
            iprofiler.func_76319_b();
        }
        if (!this.field_71348_o) {
            super.func_71217_p(hasTimeLeft);
            int i2 = Math.max(2, this.field_71349_l.field_71474_y.field_151451_c + -1);
            if (i2 != this.func_184103_al().func_72395_o()) {
                field_147148_h.info("Changing view distance to {}, from {}", (Object)i2, (Object)this.func_184103_al().func_72395_o());
                this.func_184103_al().func_217884_a(i2);
            }
        }
    }

    public boolean func_195569_l() {
        return true;
    }

    public boolean func_195041_r_() {
        return true;
    }

    public File func_71238_n() {
        return this.field_71349_l.field_71412_D;
    }

    public boolean func_71262_S() {
        return false;
    }

    public boolean func_181035_ah() {
        return false;
    }

    public void func_71228_a(CrashReport report) {
        this.field_71349_l.func_71404_a(report);
    }

    public CrashReport func_71230_b(CrashReport report) {
        report = super.func_71230_b(report);
        report.func_85056_g().func_71507_a("Type", (Object)"Integrated Server (map_client.txt)");
        report.func_85056_g().func_189529_a("Is Modded", () -> this.func_230045_q_().orElse("Probably not. Jar signature remains and both client + server brands are untouched."));
        return report;
    }

    public Optional<String> func_230045_q_() {
        String s2 = ClientBrandRetriever.getClientModName();
        if (!s2.equals("vanilla")) {
            return Optional.of("Definitely; Client brand changed to '" + s2 + "'");
        }
        s2 = this.getServerModName();
        if (!"vanilla".equals(s2)) {
            return Optional.of("Definitely; Server brand changed to '" + s2 + "'");
        }
        return Minecraft.class.getSigners() == null ? Optional.of("Very likely; Jar signature invalidated") : Optional.empty();
    }

    public void func_70000_a(Snooper snooper) {
        super.func_70000_a(snooper);
        snooper.func_152768_a("snooper_partner", (Object)this.field_71349_l.func_71378_E().func_80006_f());
    }

    public boolean func_195565_a(GameType gameMode, boolean cheats, int port) {
        try {
            this.func_147137_ag().func_151265_a((InetAddress)null, port);
            field_147148_h.info("Started serving on {}", (Object)port);
            this.field_195580_l = port;
            this.field_71345_q = new LanServerPingThread(this.func_71273_Y(), port + "");
            this.field_71345_q.start();
            this.func_184103_al().func_152604_a(gameMode);
            this.func_184103_al().func_72387_b(cheats);
            int i2 = this.func_211833_a(this.field_71349_l.field_71439_g.func_146103_bH());
            this.field_71349_l.field_71439_g.func_184839_n(i2);
            for (ServerPlayerEntity serverplayerentity : this.func_184103_al().func_181057_v()) {
                this.func_195571_aL().func_197051_a(serverplayerentity);
            }
            return true;
        }
        catch (IOException ioexception) {
            return false;
        }
    }

    public void func_71260_j() {
        super.func_71260_j();
        if (this.field_71345_q != null) {
            this.field_71345_q.interrupt();
            this.field_71345_q = null;
        }
    }

    public void func_71263_m(boolean waitForServer) {
        if (!Reflector.MinecraftForge.exists() || this.func_71278_l()) {
            this.func_213167_f(() -> {
                for (ServerPlayerEntity serverplayerentity : Lists.newArrayList((Iterable)this.func_184103_al().func_181057_v())) {
                    if (serverplayerentity.func_110124_au().equals(this.field_211528_n)) continue;
                    this.func_184103_al().func_72367_e(serverplayerentity);
                }
            });
        }
        super.func_71263_m(waitForServer);
        if (this.field_71345_q != null) {
            this.field_71345_q.interrupt();
            this.field_71345_q = null;
        }
    }

    public boolean func_71344_c() {
        return this.field_195580_l > -1;
    }

    public int func_71215_F() {
        return this.field_195580_l;
    }

    public void func_71235_a(GameType gameMode) {
        super.func_71235_a(gameMode);
        this.func_184103_al().func_152604_a(gameMode);
    }

    public boolean func_82356_Z() {
        return true;
    }

    public int func_110455_j() {
        return 2;
    }

    public int func_223707_k() {
        return 2;
    }

    public void func_211527_b(UUID uuid) {
        this.field_211528_n = uuid;
    }

    public boolean func_213199_b(GameProfile profileIn) {
        return profileIn.getName().equalsIgnoreCase(this.func_71214_G());
    }

    public int func_230512_b_(int distanceIn) {
        return (int)(this.field_71349_l.field_71474_y.field_238329_c_ * (float)distanceIn);
    }

    public boolean func_230540_aS_() {
        return this.field_71349_l.field_71474_y.field_241568_aS_;
    }

    private void onTick() {
        Iterable iws = this.func_212370_w();
        for (ServerWorld ws : iws) {
            this.onTick(ws);
        }
    }

    private void onTick(ServerWorld ws) {
        if (!Config.isTimeDefault()) {
            this.fixWorldTime(ws);
        }
        if (!Config.isWeatherEnabled()) {
            this.fixWorldWeather(ws);
        }
        if (this.difficultyUpdateWorld == ws && this.difficultyUpdatePos != null) {
            this.difficultyLast = ws.func_175649_E(this.difficultyUpdatePos);
            this.difficultyUpdateWorld = null;
            this.difficultyUpdatePos = null;
        }
    }

    public DifficultyInstance getDifficultyAsync(World world, BlockPos blockPos) {
        this.difficultyUpdateWorld = world;
        this.difficultyUpdatePos = blockPos;
        return this.difficultyLast;
    }

    private void fixWorldWeather(ServerWorld ws) {
        if (ws.func_72867_j(1.0f) > 0.0f || ws.func_72911_I()) {
            ws.func_241113_a_(6000, 0, false, false);
        }
    }

    private void fixWorldTime(ServerWorld ws) {
        if (this.func_71265_f() != GameType.CREATIVE) {
            return;
        }
        long time = ws.func_72820_D();
        long timeOfDay = time % 24000L;
        if (Config.isTimeDayOnly()) {
            if (timeOfDay <= 1000L) {
                ws.func_241114_a_(time - timeOfDay + 1001L);
            }
            if (timeOfDay >= 11000L) {
                ws.func_241114_a_(time - timeOfDay + 24001L);
            }
        }
        if (Config.isTimeNightOnly()) {
            if (timeOfDay <= 14000L) {
                ws.func_241114_a_(time - timeOfDay + 14001L);
            }
            if (timeOfDay >= 22000L) {
                ws.func_241114_a_(time - timeOfDay + 24000L + 14001L);
            }
        }
    }

    public boolean func_213211_a(boolean silentIn, boolean flushIn, boolean commandIn) {
        if (silentIn) {
            int ticksSaveInterval;
            int ticks = this.func_71259_af();
            if ((long)ticks < this.ticksSaveLast + (long)(ticksSaveInterval = this.field_71349_l.field_71474_y.ofAutoSaveTicks)) {
                return false;
            }
            this.ticksSaveLast = ticks;
        }
        return super.func_213211_a(silentIn, flushIn, commandIn);
    }
}

